/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import jsbugs.ChartProperties;
import jsbugs.DialogChartFont;
import jsbugs.DialogPanelEvents;
import jsbugs.DialogPanelIGDScheme;
import jsbugs.DialogPanelSurfaces;
import jsbugs.FrameJsbugs;
import jsbugs.PanelCompositeStandard;
import jsbugs.PanelEventsBase;
import jsbugs.PanelIGDScheme;
import jsbugs.PanelSurfaces;
import jsbugs.SBDialog;
import jsbugs.SBPanel;
import jsbugs.SchemeBlock;
import model2.SBdb;
import org.jdesktop.layout.GroupLayout;
import util.SB;

public class DialogSchemeBlock
extends SBDialog {
    private final SchemeBlock block;
    private final DefaultListModel listModel = new DefaultListModel();
    private final DefaultComboBoxModel scaleModel = new DefaultComboBoxModel();
    private final SBdb sbdb;
    private final ChartProperties cp;
    private final ChartProperties cpCopy;
    private JButton jButtonCalcScale;
    private JButton jButtonCancel;
    private JButton jButtonChartProperties;
    private JButton jButtonHelp;
    private JButton jButtonMoveDown;
    private JButton jButtonMoveUp;
    private JButton jButtonOK;
    private JButton jButtonPanelProperties;
    private JButton jButtonRemove;
    private JComboBox jComboBoxScale;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JList jListPanels;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JTextField jTextFieldBase;
    private JTextField jTextFieldTop;

    public DialogSchemeBlock(Frame parent, boolean modal, SchemeBlock block, SBdb sbdb, ChartProperties cp) {
        super(parent, modal);
        this.block = block;
        this.sbdb = sbdb;
        this.cp = cp;
        this.cpCopy = new ChartProperties(cp);
        this.initComponents();
        this.init();
    }

    private void init() {
        this.jTextFieldTop.setText((double)this.block.prop.min > 999.99 ? SB.floatString((float)this.block.prop.min, (int)0) : "" + this.block.prop.min);
        this.jTextFieldBase.setText((double)this.block.prop.max > 999.99 ? SB.floatString((float)this.block.prop.max, (int)0) : "" + this.block.prop.max);
        SchemeBlock.fillScaleCombo(this.scaleModel);
        if (this.scaleModel.getIndexOf(Float.valueOf(this.block.prop.scale)) >= 0) {
            this.scaleModel.setSelectedItem(Float.valueOf(this.block.prop.scale));
        } else {
            this.scaleModel.addElement(Float.valueOf(this.block.prop.scale));
            this.scaleModel.setSelectedItem(Float.valueOf(this.block.prop.scale));
        }
        this.listModel.clear();
        for (SBPanel panel : this.block.panels) {
            this.listModel.addElement(panel);
        }
        this.jListPanels.setModel(this.listModel);
        this.jListPanels.updateUI();
        this.setTitle("Scheme Chart Properties");
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jListPanels = new JList();
        this.jButtonRemove = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonMoveUp = new JButton();
        this.jButtonMoveDown = new JButton();
        this.jButtonHelp = new JButton();
        this.jLabel1 = new JLabel();
        this.jTextFieldTop = new JTextField();
        this.jTextFieldBase = new JTextField();
        this.jLabel2 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jComboBoxScale = new JComboBox();
        this.jLabel4 = new JLabel();
        this.jButtonCalcScale = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jLabel7 = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.jButtonChartProperties = new JButton();
        this.jButtonPanelProperties = new JButton();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jListPanels.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.jListPanels.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jListPanels.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.jListPanels);
        this.jButtonRemove.setText("Remove");
        this.jButtonRemove.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSchemeBlock.this.jButtonRemoveActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSchemeBlock.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSchemeBlock.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonMoveUp.setText("Move up");
        this.jButtonMoveUp.setToolTipText("<html>Moves panel <strong>left</strong> on plot");
        this.jButtonMoveUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSchemeBlock.this.jButtonMoveUpActionPerformed(evt);
            }
        });
        this.jButtonMoveDown.setText("Move down");
        this.jButtonMoveDown.setToolTipText("<html>Moves panel <strong>right</strong> on plot");
        this.jButtonMoveDown.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonMoveDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSchemeBlock.this.jButtonMoveDownActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSchemeBlock.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Top:");
        this.jTextFieldTop.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogSchemeBlock.this.jTextFieldTopKeyTyped(evt);
            }
        });
        this.jTextFieldBase.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogSchemeBlock.this.jTextFieldBaseKeyTyped(evt);
            }
        });
        this.jLabel2.setText("Base:");
        this.jLabel5.setText("Ma");
        this.jLabel6.setText("Ma");
        this.jLabel3.setText("Scale:");
        this.jComboBoxScale.setEditable(true);
        this.jComboBoxScale.setModel(this.scaleModel);
        this.jLabel4.setText("mm/Ma");
        this.jButtonCalcScale.setText("Set scale for 500mm plot");
        this.jButtonCalcScale.setToolTipText("Set scale for 500mm length plot");
        this.jButtonCalcScale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSchemeBlock.this.jButtonCalcScaleActionPerformed(evt);
            }
        });
        this.jLabel7.setText("Panels:");
        this.jButtonChartProperties.setText("Options...");
        this.jButtonChartProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSchemeBlock.this.jButtonChartPropertiesActionPerformed(evt);
            }
        });
        this.jButtonPanelProperties.setText("Properties...");
        this.jButtonPanelProperties.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonPanelProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSchemeBlock.this.jButtonPanelPropertiesActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jSeparator1, -1, 374, Short.MAX_VALUE).add((Component)this.jLabel7).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jScrollPane1, -1, 283, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jButtonChartProperties, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonPanelProperties, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonRemove, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonMoveDown, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonMoveUp, -1, -1, Short.MAX_VALUE))).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabel2).add((Component)this.jLabel1).add((Component)this.jLabel3)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jComboBoxScale, 0, -1, Short.MAX_VALUE).add((Component)this.jTextFieldBase).add((Component)this.jTextFieldTop)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel5).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel4).add(18, 18, 18).add((Component)this.jButtonCalcScale, -1, 162, Short.MAX_VALUE)).add((Component)this.jLabel6))).add((Component)this.jSeparator2, -1, 374, Short.MAX_VALUE).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jTextFieldTop, -2, -1, -2).add((Component)this.jLabel5)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jTextFieldBase, -2, -1, -2).add((Component)this.jLabel2).add((Component)this.jLabel6)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.jComboBoxScale, -2, -1, -2).add((Component)this.jLabel4).add((Component)this.jButtonCalcScale, -1, -1, Short.MAX_VALUE)).addPreferredGap(1).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((Component)this.jLabel7).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonMoveUp).addPreferredGap(0).add((Component)this.jButtonMoveDown).addPreferredGap(0).add((Component)this.jButtonRemove).addPreferredGap(0).add((Component)this.jButtonPanelProperties).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jButtonChartProperties)).add((Component)this.jScrollPane1, -2, 175, -2)).addPreferredGap(0, 19, Short.MAX_VALUE).add((Component)this.jSeparator2, -2, 10, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonHelp).add((Component)this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jButtonCalcScaleActionPerformed(ActionEvent evt) {
        try {
            float minAge = Float.parseFloat(this.jTextFieldTop.getText());
            float maxAge = Float.parseFloat(this.jTextFieldBase.getText());
            if (maxAge < minAge) {
                JOptionPane.showMessageDialog(this, "Maximum age greater than minimum", this.getTitle(), 2);
                return;
            }
            float scale = 500.0f / (maxAge - minAge);
            this.scaleModel.addElement(Float.valueOf(scale));
            this.scaleModel.setSelectedItem(Float.valueOf(scale));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        try {
            float minAge = Float.parseFloat(this.jTextFieldTop.getText());
            float maxAge = Float.parseFloat(this.jTextFieldBase.getText());
            float scale = ((Float)this.scaleModel.getSelectedItem()).floatValue();
            if (maxAge < minAge) {
                JOptionPane.showMessageDialog(this, "Maximum age greater than minimum", this.getTitle(), 2);
                return;
            }
            if (scale <= 0.0f) {
                JOptionPane.showMessageDialog(this, "Invalid scale", this.getTitle(), 2);
                this.jComboBoxScale.requestFocusInWindow();
                return;
            }
            this.block.prop.min = minAge;
            this.block.prop.max = maxAge;
            this.block.prop.scale = scale;
            this.cp.copy(this.cpCopy);
            this.setOK();
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonRemoveActionPerformed(ActionEvent evt) {
        SBPanel selection = (SBPanel)this.jListPanels.getSelectedValue();
        if (selection == null) {
            JOptionPane.showMessageDialog(this, "Select a panel", this.getTitle(), 1);
            return;
        }
        if (JOptionPane.showConfirmDialog(this, "Remove panel: " + selection + "?", this.getTitle(), 0, 3) == 0) {
            this.block.removePanel(selection);
            this.listModel.remove(this.jListPanels.getSelectedIndex());
            this.jListPanels.repaint();
        }
    }

    private void jTextFieldBaseKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldBase, (int)5, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldTopKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldTop, (int)5, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonMoveUpActionPerformed(ActionEvent evt) {
        int index = this.jListPanels.getSelectedIndex();
        if (this.block.panels.size() > 1 && index > 0) {
            SBPanel selection = (SBPanel)this.jListPanels.getSelectedValue();
            this.block.removePanel(selection);
            this.listModel.remove(index);
            this.block.panels.add(--index, selection);
            this.listModel.add(index, selection);
            this.jListPanels.repaint();
            this.jListPanels.setSelectedValue(selection, true);
        }
    }

    private void jButtonMoveDownActionPerformed(ActionEvent evt) {
        int index = this.jListPanels.getSelectedIndex();
        if (index >= 0 && index + 1 < this.block.panels.size()) {
            SBPanel selection = (SBPanel)this.jListPanels.getSelectedValue();
            this.block.removePanel(selection);
            this.listModel.remove(index);
            this.block.panels.add(++index, selection);
            this.listModel.add(index, selection);
            this.jListPanels.repaint();
            this.jListPanels.setSelectedValue(selection, true);
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogschemeblock.html");
    }

    private void jButtonPanelPropertiesActionPerformed(ActionEvent evt) {
        SBPanel selection = (SBPanel)this.jListPanels.getSelectedValue();
        if (selection == null) {
            JOptionPane.showMessageDialog(this, "Select a panel", this.getTitle(), 2);
            return;
        }
        SBDialog dialog = null;
        if (selection instanceof PanelCompositeStandard) {
            dialog = new DialogPanelEvents((Dialog)this, true, (PanelEventsBase)((PanelCompositeStandard)selection), this.sbdb);
        } else if (selection instanceof PanelIGDScheme) {
            dialog = new DialogPanelIGDScheme((Dialog)this, true, (PanelIGDScheme)selection);
        } else if (selection instanceof PanelSurfaces) {
            dialog = new DialogPanelSurfaces((Dialog)this, true, (PanelSurfaces)selection);
        }
        if (dialog != null) {
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        } else {
            JOptionPane.showMessageDialog(this, "No properties available", this.getTitle(), 2);
        }
    }

    private void jButtonChartPropertiesActionPerformed(ActionEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        DialogChartFont dialog = new DialogChartFont(this, true, this.cpCopy);
        dialog.setLocationRelativeTo(this);
        this.setCursor(Cursor.getDefaultCursor());
        dialog.setVisible(true);
    }
}

