/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.border.BevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import jsbugs.DialogInterval;
import jsbugs.DialogSQPick;
import jsbugs.DialogSearchUnit;
import jsbugs.DialogSelectScheme;
import jsbugs.FrameJsbugs;
import jsbugs.SQPickTableModel;
import jsbugs.ZonesTableModel;
import model2.IGDInterval;
import model2.IGDIntervalZone;
import model2.IGDScheme;
import model2.IGDUnit;
import model2.InterpHdr;
import model2.Lastval;
import model2.SBdb;
import model2.SQPick;
import model2.Surface;
import model2.Well;
import model2.WellInterp;
import org.jdesktop.layout.GroupLayout;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.SbugsFileFilter;
import util.TableSorter;

public class DialogSchemeUsage
extends JDialog {
    DefaultListModel wellModel = new DefaultListModel();
    DefaultListModel versionModel = new DefaultListModel();
    AbstractTableModel model = new ZonesTableModel();
    TableSorter sorter;
    IGDScheme scheme;
    JTable jTableUsage;
    private JButton jButtonClose;
    private JButton jButtonDeleteInterval;
    private JButton jButtonFind;
    private JButton jButtonHelp;
    private JButton jButtonReassign;
    private JButton jButtonReassign1;
    private JButton jButtonSaveAs;
    private JButton jButtonSelectAll;
    private JButton jButtonShow;
    private JButton jButtonShowInterval;
    private JButton jButtonShowZones;
    private JList jListVersion;
    private JList jListWell;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPaneVersions;
    private JScrollPane jScrollPaneWell;
    private JSeparator jSeparator1;

    public DialogSchemeUsage(Frame parent, boolean modal, IGDScheme scheme) throws SQLException, SBException {
        super(parent, modal);
        this.initComponents();
        this.scheme = scheme;
        this.init();
    }

    public DialogSchemeUsage(JDialog parent, boolean modal, IGDScheme scheme) throws SQLException, SBException {
        super((Dialog)parent, modal);
        this.initComponents();
        this.scheme = scheme;
        this.init();
    }

    private void init() throws SQLException, SBException {
        this.setTitle("Stratigraphic Scheme Usage : " + this.scheme);
        this.getRootPane().setDefaultButton(this.jButtonClose);
        this.model = this.scheme.getIGDType() == 10 ? new SQPickTableModel() : new ZonesTableModel();
        this.sorter = new TableSorter((TableModel)this.model);
        this.jTableUsage = new JTable((TableModel)this.sorter);
        if (this.scheme.getIGDType() == 10) {
            ((SQPickTableModel)this.model).setupTable(this.jTableUsage, null);
        } else {
            ((ZonesTableModel)this.model).setupTable(this.jTableUsage, null);
        }
        this.jScrollPane1.setViewportView(this.jTableUsage);
        this.jTableUsage.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DialogSchemeUsage.this.mClicked(evt);
            }
        });
        JLabel wellColumnLabel = new JLabel("Well");
        wellColumnLabel.setHorizontalAlignment(0);
        wellColumnLabel.setBorder(new BevelBorder(0));
        this.jScrollPaneWell.setColumnHeaderView(wellColumnLabel);
        JLabel versionColumnLabel = new JLabel("Version");
        versionColumnLabel.setHorizontalAlignment(0);
        versionColumnLabel.setBorder(new BevelBorder(0));
        this.jScrollPaneVersions.setColumnHeaderView(versionColumnLabel);
        this.jButtonShow.setVisible(false);
        this.jButtonShowZones.setVisible(false);
        this.initWells();
    }

    private void initWells() throws SQLException, SBException {
        this.wellModel.clear();
        List wells = this.scheme.getWellOccs();
        for (Well well : wells) {
            this.wellModel.addElement(well);
        }
    }

    private void mClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonShowIntervalActionPerformed(null);
        }
    }

    private void initComponents() {
        this.jButtonShow = new JButton();
        this.jButtonSelectAll = new JButton();
        this.jButtonReassign = new JButton();
        this.jButtonSaveAs = new JButton();
        this.jButtonShowZones = new JButton();
        this.jButtonShowInterval = new JButton();
        this.jButtonDeleteInterval = new JButton();
        this.jButtonClose = new JButton();
        this.jButtonHelp = new JButton();
        this.jScrollPaneWell = new JScrollPane();
        this.jListWell = new JList();
        this.jScrollPaneVersions = new JScrollPane();
        this.jListVersion = new JList();
        this.jButtonReassign1 = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jButtonFind = new JButton();
        this.jSeparator1 = new JSeparator();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(800, 300));
        this.jButtonShow.setText("Show >");
        this.jButtonShow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSchemeUsage.this.jButtonShowActionPerformed(evt);
            }
        });
        this.jButtonSelectAll.setText("Select all");
        this.jButtonSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSchemeUsage.this.jButtonSelectAllActionPerformed(evt);
            }
        });
        this.jButtonReassign.setText("Reassign...");
        this.jButtonReassign.setToolTipText("<html>Reassign all units in selected wells<br>\n to matching units from another scheme</html>");
        this.jButtonReassign.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonReassign.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSchemeUsage.this.jButtonReassignActionPerformed(evt);
            }
        });
        this.jButtonSaveAs.setText("Save as...");
        this.jButtonSaveAs.setToolTipText("Save list of wells to CSV file");
        this.jButtonSaveAs.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonSaveAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSchemeUsage.this.jButtonSaveAsActionPerformed(evt);
            }
        });
        this.jButtonShowZones.setText("Show >");
        this.jButtonShowZones.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSchemeUsage.this.jButtonShowZonesActionPerformed(evt);
            }
        });
        this.jButtonShowInterval.setText("Show...");
        this.jButtonShowInterval.setToolTipText("Show interval dialog for this unit");
        this.jButtonShowInterval.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSchemeUsage.this.jButtonShowIntervalActionPerformed(evt);
            }
        });
        this.jButtonDeleteInterval.setText("Delete");
        this.jButtonDeleteInterval.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSchemeUsage.this.jButtonDeleteIntervalActionPerformed(evt);
            }
        });
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSchemeUsage.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSchemeUsage.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jListWell.setModel(this.wellModel);
        this.jListWell.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DialogSchemeUsage.this.jListWellMouseClicked(evt);
            }
        });
        this.jListWell.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                DialogSchemeUsage.this.jListWellValueChanged(evt);
            }
        });
        this.jScrollPaneWell.setViewportView(this.jListWell);
        this.jListVersion.setModel(this.versionModel);
        this.jListVersion.setSelectionMode(0);
        this.jListVersion.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DialogSchemeUsage.this.jListVersionMouseClicked(evt);
            }
        });
        this.jListVersion.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                DialogSchemeUsage.this.jListVersionValueChanged(evt);
            }
        });
        this.jScrollPaneVersions.setViewportView(this.jListVersion);
        this.jButtonReassign1.setText("Reassign...");
        this.jButtonReassign1.setToolTipText("<html>Reassign all units in selected version<br>\n to matching units from another scheme</html>");
        this.jButtonReassign1.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonReassign1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSchemeUsage.this.jButtonReassign1ActionPerformed(evt);
            }
        });
        this.jButtonFind.setText("Find...");
        this.jButtonFind.setToolTipText("Find schemes containing selected unit(s)");
        this.jButtonFind.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSchemeUsage.this.jButtonFindActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPaneWell, -2, 162, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jButtonShow, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonSaveAs, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonSelectAll, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonReassign)).addPreferredGap(0).add((Component)this.jScrollPaneVersions, -2, 156, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jButtonShowZones).add((Component)this.jButtonReassign1)).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 454, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jButtonShowInterval).add((Component)this.jButtonHelp, -2, 71, -2).add((Component)this.jButtonClose, -2, 71, -2).add((Component)this.jButtonFind).add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (Component)this.jSeparator1).add(1, (Component)this.jButtonDeleteInterval, -1, 71, Short.MAX_VALUE))).addContainerGap()));
        layout.linkSize(new Component[]{this.jScrollPaneVersions, this.jScrollPaneWell}, 1);
        layout.linkSize(new Component[]{this.jButtonReassign1, this.jButtonShowZones}, 1);
        layout.linkSize(new Component[]{this.jButtonDeleteInterval, this.jButtonFind, this.jButtonShowInterval, this.jSeparator1}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(13, 13, 13).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 478, Short.MAX_VALUE).add((Component)this.jScrollPaneVersions, -1, 478, Short.MAX_VALUE).add((Component)this.jScrollPaneWell, -1, 478, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonShowInterval).addPreferredGap(0).add((Component)this.jButtonDeleteInterval).addPreferredGap(1).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((Component)this.jButtonFind).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonClose)).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonShowZones).addPreferredGap(0).add((Component)this.jButtonReassign1)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonShow).addPreferredGap(0).add((Component)this.jButtonSelectAll).addPreferredGap(0).add((Component)this.jButtonReassign).addPreferredGap(0).add((Component)this.jButtonSaveAs))).add(0, 368, Short.MAX_VALUE))).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogschemeusage.html");
    }

    private void jButtonShowActionPerformed(ActionEvent evt) {
        if (this.jListWell.getSelectedIndex() < 0 || this.jListWell.getSelectedIndices().length > 1) {
            this.versionModel.removeAllElements();
            this.jListVersion.repaint();
            return;
        }
        try {
            InterpHdr previousSelection = null;
            if (this.jListVersion.getSelectedIndex() >= 0 && this.jListVersion.getSelectedIndices().length == 1) {
                previousSelection = ((WellInterp)this.jListVersion.getSelectedValue()).getHeader();
            }
            this.versionModel.clear();
            Well well = (Well)this.jListWell.getSelectedValue();
            List versions = this.scheme.getWellInterps(well);
            WellInterp toSelect = null;
            for (WellInterp interp : versions) {
                this.versionModel.addElement(interp);
                if (interp.getHeader() != previousSelection) continue;
                toSelect = interp;
            }
            this.jListVersion.repaint();
            if (toSelect != null) {
                this.jListVersion.setSelectedValue(toSelect, true);
            }
        }
        catch (SQLException se) {
            SB.showStackError((String)"SQL Error", (SQLException)se);
        }
        catch (SBException se) {
            SB.showStackError((String)"Error", (Exception)((Object)se));
        }
    }

    private void jListWellMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonShowActionPerformed(null);
        }
    }

    private void jButtonSelectAllActionPerformed(ActionEvent evt) {
        this.jListWell.setSelectionInterval(0, this.wellModel.getSize() - 1);
    }

    private void jButtonShowZonesActionPerformed(ActionEvent evt) {
        boolean clearTable = false;
        if (this.jListWell.getSelectedIndex() < 0 || this.jListWell.getSelectedIndices().length > 1) {
            clearTable = true;
        }
        if (this.jListVersion.getSelectedIndex() < 0 || this.jListVersion.getSelectedIndices().length > 1) {
            clearTable = true;
        }
        if (clearTable) {
            if (this.scheme.getIGDType() == 10) {
                if (((SQPickTableModel)this.model).picks != null) {
                    ((SQPickTableModel)this.model).picks.clear();
                }
            } else if (((ZonesTableModel)this.model).zones != null) {
                ((ZonesTableModel)this.model).zones.clear();
            }
            this.sorter.reallocateIndexes();
            this.sorter.fireTableDataChanged();
            return;
        }
        try {
            WellInterp interp = (WellInterp)this.jListVersion.getSelectedValue();
            Well well = (Well)this.jListWell.getSelectedValue();
            well.getSamples();
            if (this.scheme.getIGDType() == 10) {
                if (interp.getSQPicks().isEmpty()) {
                    interp.loadSQPicks(well);
                }
                ((SQPickTableModel)this.model).picks = interp.getSQPicks(this.scheme.getID());
            } else {
                if (interp.getIGDList(this.scheme.getIGDType(), this.scheme.getID()).isEmpty()) {
                    interp.loadZones(this.scheme.getIGDType(), well);
                }
                ((ZonesTableModel)this.model).zones = interp.getIGDList(this.scheme.getIGDType(), this.scheme.getID());
            }
            this.sorter.reallocateIndexes();
            this.sorter.fireTableDataChanged();
        }
        catch (SQLException se) {
            JOptionPane.showMessageDialog(null, "Error: " + se.getMessage() + "\nSQL: " + SB.sql, "SQL Error", 0);
            se.printStackTrace();
        }
        catch (SBException se) {
            SB.showStackError((String)"Error", (Exception)((Object)se));
        }
    }

    private void jListVersionMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonShowZonesActionPerformed(null);
        }
    }

    private void jButtonShowIntervalActionPerformed(ActionEvent evt) {
        if (this.jTableUsage.getSelectedRowCount() != 1) {
            String type = this.scheme.getIGDType() == 10 ? "pick" : "interval";
            JOptionPane.showMessageDialog(this, "Select one " + type, this.getTitle(), 1);
            return;
        }
        Object obj = this.scheme.getIGDType() == 10 ? ((SQPickTableModel)this.model).picks.get(this.sorter.getIndexOf(this.jTableUsage.getSelectedRow())) : ((ZonesTableModel)this.model).zones.get(this.sorter.getIndexOf(this.jTableUsage.getSelectedRow()));
        try {
            JDialog dialog;
            WellInterp wellInterp = (WellInterp)this.jListVersion.getSelectedValue();
            if (wellInterp == null) {
                JOptionPane.showMessageDialog(this, "Select a Version", this.getTitle(), 1);
                return;
            }
            Well well = (Well)this.jListWell.getSelectedValue();
            if (well == null) {
                JOptionPane.showMessageDialog(this, "Select a Well", this.getTitle(), 1);
                return;
            }
            if (obj instanceof SQPick) {
                dialog = new DialogSQPick(this, true, this.scheme.getDatabase(), this.scheme, well, wellInterp, well.getWellUnits(), (SQPick)obj, null, null);
            } else {
                IGDIntervalZone zone = (IGDIntervalZone)obj;
                dialog = new DialogInterval(this, true, zone.getIGDType(), this.scheme.getDatabase(), well, wellInterp, well.getWellUnits(), zone);
            }
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            int index = -1;
            if (obj instanceof SQPick) {
                ((SQPickTableModel)this.model).picks = wellInterp.getSQPicks(this.scheme.getID());
                int i = ((SQPickTableModel)this.model).picks.indexOf(((DialogSQPick)dialog).getPick());
                if (i >= 0) {
                    index = this.sorter.getIndexOf(i);
                }
            } else {
                ((ZonesTableModel)this.model).zones = wellInterp.getIGDList(this.scheme.getIGDType(), this.scheme.getID());
                int i = ((ZonesTableModel)this.model).zones.indexOf(((DialogInterval)dialog).zone);
                if (i >= 0) {
                    index = this.sorter.getIndexOf(i);
                }
            }
            this.sorter.reallocateIndexes();
            this.sorter.fireTableDataChanged();
            if (index >= 0) {
                this.jTableUsage.getSelectionModel().setSelectionInterval(index, index);
            } else {
                this.jTableUsage.clearSelection();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Error opening dialog: " + e.getMessage(), this.getTitle(), 0);
        }
    }

    private void jButtonDeleteIntervalActionPerformed(ActionEvent evt) {
        try {
            WellInterp wellInterp = (WellInterp)this.jListVersion.getSelectedValue();
            if (wellInterp == null) {
                JOptionPane.showMessageDialog(this, "Select a Version", this.getTitle(), 1);
                return;
            }
            Well well = (Well)this.jListWell.getSelectedValue();
            if (well == null) {
                JOptionPane.showMessageDialog(this, "Select a Well", this.getTitle(), 1);
                return;
            }
            int nRows = this.jTableUsage.getSelectedRowCount();
            String type = this.scheme.getIGDType() == 10 ? "pick" : "interval";
            String msg = "Really delete ";
            msg = nRows == 1 ? msg + "this " + type + "?" : msg + "these " + nRows + " " + type + "s?";
            if (JOptionPane.showConfirmDialog(this, msg, this.getTitle(), 0, 3) != 0) {
                return;
            }
            if (this.scheme.getIGDType() == 10) {
                LinkedList<SQPick> toKill = new LinkedList<SQPick>();
                for (int row : this.jTableUsage.getSelectedRows()) {
                    toKill.add(((SQPickTableModel)this.model).picks.get(this.sorter.getIndexOf(row)));
                }
                for (SQPick pick : toKill) {
                    wellInterp.deleteSQPick(pick, well.getWellID());
                    ((SQPickTableModel)this.model).picks.remove(pick);
                    this.scheme.getDatabase().commit();
                }
            } else {
                LinkedList<IGDIntervalZone> toKill = new LinkedList<IGDIntervalZone>();
                for (int row : this.jTableUsage.getSelectedRows()) {
                    toKill.add(((ZonesTableModel)this.model).zones.get(this.sorter.getIndexOf(row)));
                }
                for (IGDIntervalZone zone : toKill) {
                    wellInterp.deleteZone(well, zone);
                    ((ZonesTableModel)this.model).zones.remove(zone);
                    this.scheme.getDatabase().commit();
                }
            }
            this.sorter.reallocateIndexes();
            this.sorter.fireTableDataChanged();
            this.jTableUsage.clearSelection();
            System.out.println("wellinterp hasChanged: " + wellInterp.hasChanged());
            System.out.println("observers of wellInterp: " + wellInterp.countObservers());
            well.getAddInterp(wellInterp.getHeader()).notifyObservers((Object)this.scheme.getIGDType());
            wellInterp.notifyObservers((Object)this.scheme.getIGDType());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error deleting: " + e.getMessage(), this.getTitle(), 0);
            e.printStackTrace();
            this.scheme.getDatabase().doRollback();
        }
    }

    private void jButtonSaveAsActionPerformed(ActionEvent evt) {
        SBdb db = this.scheme.getDatabase();
        File setDir = null;
        try {
            setDir = new File(Lastval.getString((SBdb)db, (String)"JLISTFILE"));
        }
        catch (SQLException ex) {
            // empty catch block
        }
        JFileChooser jFileChooser1 = new JFileChooser();
        jFileChooser1.setCurrentDirectory(setDir);
        SbugsFileFilter filter = new SbugsFileFilter();
        filter.addExtension("csv");
        filter.setDescription("CSV files");
        jFileChooser1.addChoosableFileFilter((FileFilter)filter);
        SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yyyy");
        Date date = new Date();
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (0 == jFileChooser1.showSaveDialog(this)) {
            try {
                String fileName = jFileChooser1.getSelectedFile().getPath();
                if (!fileName.toLowerCase().endsWith(".csv")) {
                    fileName = fileName + ".csv";
                }
                FileWriter out = new FileWriter(fileName);
                out.write("StrataBugs output: " + df.format(date) + "\r\n");
                out.write("Well Code,Well Name\r\n");
                for (int i = 0; i < this.wellModel.size(); ++i) {
                    Well well = (Well)this.wellModel.get(i);
                    out.write(well.getWellCode() + "," + well.getWellName() + "\r\n");
                }
                out.close();
                if (JOptionPane.showConfirmDialog(this, "File '" + fileName + "' written", "File Saved", 2) == 0) {
                    Lastval.putString((SBdb)db, (String)"JLISTFILE", (String)fileName);
                    db.commit();
                }
            }
            catch (SQLException se) {
                JOptionPane.showMessageDialog(null, "Error: " + se.getMessage() + "\nSQL: " + SB.sql, "SQL Error", 0);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "File error: " + ex.getMessage());
            }
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void jButtonReassignActionPerformed(ActionEvent evt) {
        this.reassign(null);
    }

    private void jButtonReassign1ActionPerformed(ActionEvent evt) {
        if (this.jListVersion.getSelectedValue() == null) {
            JOptionPane.showMessageDialog(this, "Select a version", this.getTitle(), 2);
            return;
        }
        WellInterp wellInterp = (WellInterp)this.jListVersion.getSelectedValue();
        this.reassign(wellInterp);
    }

    private void jListWellValueChanged(ListSelectionEvent evt) {
        this.jButtonShowActionPerformed(null);
    }

    private void jListVersionValueChanged(ListSelectionEvent evt) {
        this.jButtonShowZonesActionPerformed(null);
    }

    private void jButtonFindActionPerformed(ActionEvent evt) {
        if (this.model instanceof ZonesTableModel) {
            ZonesTableModel zm = (ZonesTableModel)this.model;
            if (this.jTableUsage.getSelectedRowCount() == 0) {
                JOptionPane.showMessageDialog(this, "No intervals selected", this.getTitle(), 2);
                return;
            }
            int[] rows = this.jTableUsage.getSelectedRows();
            String unit = "";
            for (int i = 0; i < rows.length; ++i) {
                IGDIntervalZone zone = zm.zones.get(this.sorter.getIndexOf(rows[i]));
                if (!unit.toUpperCase().contains(zone.getUppInf().toUpperCase())) {
                    if (!unit.isEmpty()) {
                        unit = unit + ";";
                    }
                    unit = unit + zone.getUppInf();
                }
                if (zone.getLowInf() == null || zone.getLowInf().isEmpty() || unit.toUpperCase().contains(zone.getLowInf().toUpperCase())) continue;
                if (!unit.isEmpty()) {
                    unit = unit + ";";
                }
                unit = unit + zone.getLowInf();
            }
            DialogSearchUnit dialog = new DialogSearchUnit(this, true, this.scheme.getDatabase(), unit);
            dialog.setLocationRelativeTo(this);
            dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
            dialog.setVisible(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reassign(WellInterp restrictToInterp) {
        block52: {
            if (this.jListWell.getSelectedIndex() < 0) {
                JOptionPane.showMessageDialog(this, "You need to select well(s) to reassign", "Select Wells", 1);
                return;
            }
            SBdb db = this.scheme.getDatabase();
            String joptTitle = "Reassign Scheme";
            try {
                DialogSelectScheme dialog = new DialogSelectScheme(this, true, this.scheme.getDatabase(), this.scheme.getIGDType(), null);
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
                if (dialog.selection == null) break block52;
                int nIntervals = 0;
                int nNotAssigned = 0;
                FileWriter out = null;
                IGDScheme newScheme = dialog.selection;
                boolean reassignAll = false;
                if (newScheme.getID() == this.scheme.getID()) {
                    JOptionPane.showMessageDialog(this, "New scheme is the same as current scheme", "Select Wells", 1);
                    return;
                }
                if (JOptionPane.showConfirmDialog(this, "Do you want to create a log file?", joptTitle, 0) == 0) {
                    JFileChooser jFileChooser1 = new JFileChooser();
                    jFileChooser1.setCurrentDirectory(null);
                    SbugsFileFilter filter = new SbugsFileFilter();
                    filter.addExtension("log");
                    filter.setDescription("Log files");
                    jFileChooser1.addChoosableFileFilter((FileFilter)filter);
                    if (0 == jFileChooser1.showSaveDialog(this)) {
                        String fileName = jFileChooser1.getSelectedFile().getPath();
                        if (fileName.indexOf(".") < 0) {
                            fileName = fileName + ".log";
                        }
                        out = new FileWriter(fileName);
                        SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yyyy");
                        Date date = new Date();
                        out.write("\nStrataBugs " + IGDInterval.getIGDName((int)this.scheme.getIGDType()) + " Scheme units reassignment\n");
                        out.write("From scheme: " + this.scheme + ",scheme ID: " + this.scheme.getID() + "\n");
                        out.write("To scheme: " + newScheme + ",scheme ID: " + newScheme.getID() + "\n");
                        out.write("By user: " + db.getUser().getName() + "," + db.getUser().getAbr() + ", on " + df.format(date) + "\n\n");
                    }
                }
                this.scheme.loadUnits();
                newScheme.loadUnits();
                if (this.scheme.getIGDType() == 10) {
                    this.scheme.getSurfaces();
                    newScheme.getSurfaces();
                }
                int[] selectedWells = this.jListWell.getSelectedIndices();
                this.clearPanelDisplay();
                this.versionModel.clear();
                this.jListVersion.repaint();
                class WellException {
                    Well well;
                    WellInterp interp;
                    Exception e;

                    WellException(Well w, WellInterp i, Exception e) {
                        this.well = w;
                        this.interp = i;
                        this.e = e;
                    }

                    public String toString() {
                        return this.well.toString() + " (" + this.interp.toString() + ") " + this.e.toString();
                    }
                }
                LinkedList<WellException> exceptions = new LinkedList<WellException>();
                this.setCursor(Cursor.getPredefinedCursor(3));
                for (int i = 0; i < selectedWells.length; ++i) {
                    Well well = (Well)this.jListWell.getModel().getElementAt(selectedWells[i]);
                    if (out != null) {
                        out.write("Well: " + well.getWellName() + " (" + well.getWellCode() + ")\n");
                    }
                    well.getSamples();
                    List versions = this.scheme.getWellInterps(well);
                    Iterator it = versions.iterator();
                    while (it.hasNext()) {
                        SQPick updateArg = null;
                        WellInterp interp = (WellInterp)it.next();
                        if (restrictToInterp != null && restrictToInterp.getHeader().getInterpID() != interp.getHeader().getInterpID()) continue;
                        if (out != null) {
                            out.write("\tVersion: " + interp.toString() + "\n");
                        }
                        if (this.scheme.getIGDType() == 10) {
                            int newSurfaceID;
                            SQPick pick;
                            if (interp.getSQPicks() == null || interp.getSQPicks().isEmpty()) {
                                interp.loadSQPicks(well);
                            }
                            List picks = interp.getSQPicks(this.scheme.getID());
                            List newPicks = interp.getSQPicks(newScheme.getID());
                            if (!newPicks.isEmpty() && JOptionPane.showConfirmDialog(this, "Warning: picks already exist in version '" + interp + "' for the scheme '" + newScheme + "'.\nContinue with this version?", joptTitle, 0, 3) != 0) continue;
                            Iterator itPick = picks.iterator();
                            int nRejections = 0;
                            while (itPick.hasNext()) {
                                pick = (SQPick)itPick.next();
                                newSurfaceID = this.getReplacementSurface(this.scheme, newScheme, pick.getSurfaceID(), pick.getInfName());
                                if (newSurfaceID != 0) continue;
                                ++nRejections;
                            }
                            if (nRejections > 0 && JOptionPane.showConfirmDialog(this, nRejections + " surfaces in " + well.getWellName() + "/" + interp.toString() + " cannot be reassigned (no matching surfaces found).\nDo you want to reassign the remaining surfaces?", joptTitle, 0) != 0) continue;
                            itPick = picks.listIterator(0);
                            while (itPick.hasNext()) {
                                pick = (SQPick)itPick.next();
                                newSurfaceID = this.getReplacementSurface(this.scheme, newScheme, pick.getSurfaceID(), pick.getInfName());
                                if (newSurfaceID > 0) {
                                    if (out != null) {
                                        out.write("\t\t");
                                        out.write(pick.getSample().toString() + "\t");
                                        out.write(pick.getSurface().getName() + "\t");
                                        this.writeLogIDs(out, pick.getSurfaceID(), newSurfaceID);
                                        out.write("\n");
                                    }
                                    interp.deleteSQPick(pick, well.getWellID());
                                    updateArg = interp.addSQPick(well, pick.getSample(), newScheme.getSurface(newSurfaceID), pick.getInfName(), pick.isQuestionable(), pick.getBnd());
                                    ++nIntervals;
                                    continue;
                                }
                                ++nNotAssigned;
                            }
                        } else {
                            if (interp.getIGDList(this.scheme.getIGDType()) == null || interp.getIGDList(this.scheme.getIGDType()).isEmpty()) {
                                interp.loadZones(this.scheme.getIGDType(), well);
                            }
                            List zones = interp.getIGDList(this.scheme.getIGDType(), this.scheme.getID());
                            List newZones = interp.getIGDList(newScheme.getIGDType(), newScheme.getID());
                            if (!newZones.isEmpty() && JOptionPane.showConfirmDialog(this, "Warning: intervals already exist in version '" + interp + "' for the scheme '" + newScheme + "'.\nContinue with this version?", well.getWellName() + "/" + interp.toString(), 0, 3) != 0) continue;
                            for (IGDIntervalZone zone : zones) {
                                boolean doReassign = true;
                                int newUppZone = this.getReplacementUnit(this.scheme, newScheme, zone.getUppZone(), zone.getUppInf());
                                int newLowZone = this.getReplacementUnit(this.scheme, newScheme, zone.getLowZone(), zone.getLowInf());
                                if ((newUppZone == 0 || newLowZone == 0 && zone.getLowZone() > 0) && !reassignAll) {
                                    String zoneString = zone.toString();
                                    if (zone.getUppZone() > 0) {
                                        IGDUnit unit = this.scheme.findUnit(zone.getUppZone());
                                        zoneString = zoneString + " (" + (unit != null ? unit.toString() : "ID=" + zone.getUppZone());
                                        if (zone.getLowZone() > 0 && zone.getLowZone() != zone.getUppZone()) {
                                            unit = this.scheme.findUnit(zone.getUppZone());
                                            zoneString = zoneString + " - " + (unit != null ? unit.toString() : "ID=" + zone.getLowZone());
                                        }
                                        zoneString = zoneString + ")";
                                    }
                                    Object[] buttons = new String[]{"Yes", "Yes for All", "No", "Cancel"};
                                    int opt = JOptionPane.showOptionDialog(this, "The interval '" + zoneString + "' is not found it the new scheme. Reassign as informal?", well.getWellName() + "/" + interp.toString(), 1, 3, null, buttons, null);
                                    if (opt == 3 || opt == -1) {
                                        db.doRollback();
                                        if (out != null) {
                                            out.write("\n\nOperation CANCELLED");
                                        }
                                        JOptionPane.showMessageDialog(this, "Close StrataBugs and reopen the control panel to flush partially changed data", this.getTitle(), 1);
                                        out.close();
                                        break;
                                    }
                                    if (opt == 2) {
                                        doReassign = false;
                                    } else if (opt == 1) {
                                        reassignAll = true;
                                        doReassign = true;
                                    }
                                }
                                if (doReassign) {
                                    if (out != null) {
                                        out.write("\t\t");
                                        if (zone.getTopSample() != null) {
                                            out.write(zone.getTopSample().toString() + "\t");
                                        }
                                        if (zone.getBaseSample() != null) {
                                            out.write(" - " + zone.getBaseSample().toString() + "\t");
                                        }
                                        out.write(zone.getUppInf());
                                        this.writeLogIDs(out, zone.getUppZone(), newUppZone);
                                        if (zone.getLowZone() > 0) {
                                            out.write("\t" + zone.getLowInf());
                                            this.writeLogIDs(out, zone.getLowZone(), newLowZone);
                                        }
                                        out.write("\n");
                                    }
                                    try {
                                        IGDIntervalZone.Builder builder = IGDIntervalZone.Builder.copyOf((IGDIntervalZone)zone, (int)newScheme.getID());
                                        builder.uppZone(newUppZone);
                                        builder.lowZone(newLowZone);
                                        interp.updateZone(zone, builder, well);
                                        interp.setChanged(zone);
                                        updateArg = zone;
                                        ++nIntervals;
                                    }
                                    catch (SBException sbe) {
                                        exceptions.add(new WellException(well, interp, (Exception)((Object)sbe)));
                                    }
                                    catch (InvalidFieldException sbe) {
                                        exceptions.add(new WellException(well, interp, (Exception)((Object)sbe)));
                                    }
                                    continue;
                                }
                                ++nNotAssigned;
                            }
                        }
                        if (updateArg == null) continue;
                        interp.notifyObservers(updateArg);
                    }
                }
                this.setCursor(Cursor.getDefaultCursor());
                String type = this.scheme.getIGDType() == 10 ? "pick" : "interval";
                String type2 = this.scheme.getIGDType() == 10 ? "surface" : "unit";
                String msg = "" + nIntervals + " " + type + (nIntervals == 1 ? "" : "s") + " updated. " + (nNotAssigned > 0 ? "\n" + nNotAssigned + (nNotAssigned == 1 ? " was" : " were") + " not updated because the " + type2 + " did not exist in the new scheme.\n" : "");
                if (exceptions.size() > 0) {
                    msg = msg + "\nThe following exceptions were caught:";
                    for (WellException e : exceptions) {
                        msg = msg + "\n" + ((Object)e).toString();
                    }
                    msg = msg + "\n\nYou should manually reassign these intervals by editing the well data.";
                }
                JOptionPane.showMessageDialog(this, msg, this.getTitle(), 1);
                db.getDatabase().commit();
                this.initWells();
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ex) {
                SB.showStackError((String)"File error", (Exception)ex);
                db.doRollback();
            }
            catch (SQLException se) {
                se.printStackTrace();
                JOptionPane.showMessageDialog(null, "Error: " + se.getMessage() + "\nSQL: " + SB.sql, "SQL Error", 0);
                db.doRollback();
            }
            catch (SBException se) {
                SB.showStackError((String)"StrataBugs error", (Exception)((Object)se));
                db.doRollback();
            }
            catch (InvalidFieldException ex) {
                ex.printStackTrace();
                db.doRollback();
                JOptionPane.showMessageDialog(this, "Can't save reassigned intervals due to error: " + ex.toString() + "\nNone of the intervals have been reassigned.", this.getTitle(), 0);
            }
            catch (Exception ex) {
                SB.showStackError((String)"Error", (Exception)ex);
                db.doRollback();
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private void clearPanelDisplay() {
        if (this.scheme.getIGDType() == 10) {
            ((SQPickTableModel)this.model).picks = null;
        } else {
            ((ZonesTableModel)this.model).zones = null;
        }
        this.sorter.reallocateIndexes();
        this.sorter.fireTableDataChanged();
    }

    void writeLogIDs(FileWriter out, int ID, int newID) throws IOException {
        if (ID > 0) {
            out.write(", ID=" + ID + " -> " + newID);
        } else {
            out.write(", (no Formal term) ");
            if (newID > 0) {
                out.write(" -> " + newID);
            }
        }
    }

    int getReplacementUnit(IGDScheme scheme, IGDScheme newScheme, int oldUnitID, String informalTerm) throws SBException, SQLException {
        IGDUnit oldUnit = scheme.findUnit(oldUnitID);
        IGDUnit newUnit = null;
        if (oldUnit == null) {
            if (informalTerm != null) {
                newUnit = newScheme.findUnit(informalTerm);
                if (newUnit == null) {
                    return 0;
                }
                return newUnit.getUnitID();
            }
            return -1;
        }
        newUnit = newScheme.findUnit(oldUnit.getName());
        if (newUnit == null) {
            if (informalTerm != null) {
                newUnit = newScheme.findUnit(informalTerm);
                if (newUnit == null) {
                    return 0;
                }
                return newUnit.getUnitID();
            }
            return 0;
        }
        return newUnit.getUnitID();
    }

    int getReplacementSurface(IGDScheme scheme, IGDScheme newScheme, int oldSurfaceID, String informalTerm) throws SBException, SQLException {
        Surface oldSurface = scheme.getSurface(oldSurfaceID);
        if (oldSurface == null) {
            return 0;
        }
        Surface newSurface = newScheme.findSurface(oldSurface.getName(), oldSurface.getType());
        if (newSurface == null && (newSurface = newScheme.findSurface(informalTerm, oldSurface.getType())) == null) {
            return 0;
        }
        return newSurface.getSurfaceID();
    }
}

