/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.TableModel;
import jsbugs.TableModelSearchUnit;
import jsbugs.UnitSearchResult;
import model2.SBdb;
import util.SB;
import util.TableSorter;

public class DialogSearchUnit
extends JDialog {
    TableModelSearchUnit model = new TableModelSearchUnit();
    TableSorter sorter = new TableSorter((TableModel)this.model);
    SBdb db;
    private JButton jButtonClose;
    private JButton jButtonSearch;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JTable jTableSearchUnit;
    private JTextField jTextFieldUnitName;

    public DialogSearchUnit(Frame parent, boolean modal, SBdb db, String searchTerm) {
        super(parent, modal);
        this.db = db;
        this.initComponents();
        this.init(searchTerm);
    }

    public DialogSearchUnit(JDialog parent, boolean modal, SBdb db, String searchTerm) {
        super((Dialog)parent, modal);
        this.db = db;
        this.initComponents();
        this.init(searchTerm);
    }

    private void init(String searchTerm) {
        this.setTitle("Unit: Search");
        this.model.setupTable(this.jTableSearchUnit);
        this.sorter.addMouseListenerToHeaderInTable(this.jTableSearchUnit);
        if (searchTerm != null) {
            this.jTextFieldUnitName.setText(searchTerm);
            this.doSearch(searchTerm);
        }
        if (this.jTextFieldUnitName.getText().endsWith("%")) {
            this.jTextFieldUnitName.setCaretPosition(this.jTextFieldUnitName.getText().length() - 1);
        } else {
            this.jTextFieldUnitName.setCaretPosition(this.jTextFieldUnitName.getText().length());
        }
        this.getRootPane().setDefaultButton(this.jButtonSearch);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldUnitName = new JTextField();
        this.jButtonSearch = new JButton();
        this.jButtonClose = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTableSearchUnit = new JTable();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(445, 337));
        this.jLabel1.setText("Find Unit: ");
        this.jTextFieldUnitName.setText("%");
        this.jTextFieldUnitName.setToolTipText("Enter a search term, or multiple terms separated by \";\". Wildards are _ and %");
        this.jButtonSearch.setText("Search");
        this.jButtonSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSearchUnit.this.jButtonSearchActionPerformed(evt);
            }
        });
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSearchUnit.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jTableSearchUnit.setModel((TableModel)this.sorter);
        this.jScrollPane1.setViewportView(this.jTableSearchUnit);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 595, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldUnitName, -2, 214, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSearch).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonClose))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(19, 19, 19).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldUnitName, -2, -1, -2).addComponent(this.jButtonSearch)).addGap(18, 18, 18).addComponent(this.jScrollPane1, -1, 253, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonClose).addContainerGap()));
        this.pack();
    }

    private void jButtonSearchActionPerformed(ActionEvent evt) {
        String searchTerm = this.jTextFieldUnitName.getText();
        if (searchTerm.isEmpty() || searchTerm.equals("%")) {
            JOptionPane.showMessageDialog(this, "No search term specified", this.getTitle(), 2);
            return;
        }
        this.doSearch(searchTerm);
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void doSearch(String searchTerm) {
        String[] terms = searchTerm.split(";");
        this.model.entries = new LinkedList();
        try {
            Statement stmt = this.db.getDatabase().createStatement();
            for (String term : terms) {
                String sql = "SELECT sch_id, name, u_age, l_age, red, green, blue FROM " + this.db.DBTableName("IGD_DICT") + " WHERE ucase(name) like " + SB.DBString((String)term.toUpperCase()) + " ORDER BY sch_id, u_age DESC";
                ResultSet rs = stmt.executeQuery(this.db.modQuery(sql));
                while (rs.next()) {
                    UnitSearchResult item = new UnitSearchResult();
                    item.scheme = this.db.getIGDScheme(rs.getInt("sch_id"));
                    item.unitName = rs.getString("name");
                    item.uAge = rs.getDouble("u_age");
                    item.lAge = rs.getDouble("l_age");
                    item.colour = new Color(rs.getInt("red"), rs.getInt("green"), rs.getInt("blue"));
                    this.model.entries.add(item);
                }
            }
            if (this.model.entries.isEmpty()) {
                String msg = "No exact matching units found";
                if (searchTerm.contains("%")) {
                    msg = msg.replace(" exact", "");
                }
                JOptionPane.showMessageDialog(this, msg, this.getTitle(), 1);
            }
            this.sorter.reallocateIndexes();
            this.sorter.fireTableDataChanged();
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            JOptionPane.showMessageDialog(this, sqle.toString(), this.getTitle(), 0);
        }
    }
}

