/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import jsbugs.DialogMergeAnalysts;
import jsbugs.DialogUserData;
import jsbugs.DialogUserdef;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelUserdef;
import model2.SBdb;
import model2.Userdef;
import org.jdesktop.layout.GroupLayout;
import util.ColorRenderer;
import util.SB;
import util.TableSorter;

public class DialogSelectAnalyst
extends JDialog {
    SBdb sbdb;
    boolean allUsers = true;
    Userdef selectedUser = null;
    boolean isSelectable;
    TableModelUserdef model = new TableModelUserdef();
    TableSorter sorter = new TableSorter((TableModel)this.model);
    Object parent;
    private ButtonGroup buttonGroupUsers;
    private JButton jButtonAdd;
    private JButton jButtonCancel;
    private JButton jButtonDelete;
    private JButton jButtonEdit;
    private JButton jButtonHelp;
    private JButton jButtonMerge;
    private JButton jButtonOK;
    private JButton jButtonShowData;
    private JRadioButton jRadioButtonAllPersonell;
    private JRadioButton jRadioButtonSBUsers;
    private JScrollPane jScrollPane1;
    private JTable jTableUsers;

    public DialogSelectAnalyst(Frame parent, boolean modal, SBdb sbdb, boolean isSelectable) throws SQLException {
        super(parent, modal);
        this.sbdb = sbdb;
        this.parent = parent;
        this.initComponents();
        this.init(isSelectable);
    }

    public DialogSelectAnalyst(JDialog parent, boolean modal, SBdb sbdb) throws SQLException {
        super((Dialog)parent, modal);
        this.sbdb = sbdb;
        this.parent = parent;
        this.setLocation(parent.getLocation().x + 25, parent.getLocation().y + 25);
        this.initComponents();
        this.init(true);
    }

    private void init(boolean isSelectable) throws SQLException {
        this.isSelectable = isSelectable;
        this.loadUsers(true);
        if (!isSelectable) {
            this.jButtonOK.setVisible(false);
            this.jButtonCancel.setText("Close");
            this.getRootPane().setDefaultButton(this.jButtonCancel);
            this.setTitle("Personnel");
        } else {
            this.setTitle("Analyst : Select");
            this.getRootPane().setDefaultButton(this.jButtonOK);
            this.jButtonMerge.setEnabled(false);
        }
        this.sorter.addMouseListenerToHeaderInTable(this.jTableUsers);
        SB.setTableHeaderBold((JTable)this.jTableUsers);
        for (int i = 0; i < this.model.maxColumn; ++i) {
            this.jTableUsers.getColumnModel().getColumn(i).setHeaderValue(TableModelUserdef.columnHeaders[i]);
            this.jTableUsers.getColumnModel().getColumn(i).setPreferredWidth(TableModelUserdef.columnWidths[i]);
        }
        this.jTableUsers.setDefaultRenderer(Color.class, (TableCellRenderer)new ColorRenderer(true));
        this.jTableUsers.setSelectionMode(0);
    }

    private void loadUsers(boolean allUsers) throws SQLException {
        this.allUsers = allUsers;
        this.model.users = new LinkedList<Userdef>();
        Collection c = this.sbdb.getUsers();
        for (Userdef u : c) {
            if (!allUsers && u.getPriv() <= 0) continue;
            this.model.users.add(u);
        }
        Collections.sort(this.model.users);
        this.sorter.reallocateIndexes();
        this.sorter.sort((Object)this);
        this.sorter.fireTableDataChanged();
    }

    private void initComponents() {
        this.buttonGroupUsers = new ButtonGroup();
        this.jRadioButtonAllPersonell = new JRadioButton();
        this.jRadioButtonSBUsers = new JRadioButton();
        this.jButtonAdd = new JButton();
        this.jButtonEdit = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonShowData = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonOK = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTableUsers = new JTable();
        this.jButtonMerge = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(450, 350));
        this.setModal(true);
        this.buttonGroupUsers.add(this.jRadioButtonAllPersonell);
        this.jRadioButtonAllPersonell.setSelected(true);
        this.jRadioButtonAllPersonell.setText("All personnel");
        this.jRadioButtonAllPersonell.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonAllPersonell.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButtonAllPersonell.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectAnalyst.this.jRadioButtonAllPersonellActionPerformed(evt);
            }
        });
        this.buttonGroupUsers.add(this.jRadioButtonSBUsers);
        this.jRadioButtonSBUsers.setText("Registered users only");
        this.jRadioButtonSBUsers.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonSBUsers.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButtonSBUsers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectAnalyst.this.jRadioButtonSBUsersActionPerformed(evt);
            }
        });
        this.jButtonAdd.setText("Add..");
        this.jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectAnalyst.this.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText("Edit...");
        this.jButtonEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectAnalyst.this.jButtonEditActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectAnalyst.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonShowData.setText("Show data...");
        this.jButtonShowData.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonShowData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectAnalyst.this.jButtonShowDataActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectAnalyst.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectAnalyst.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectAnalyst.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jTableUsers.setModel((TableModel)this.sorter);
        this.jTableUsers.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DialogSelectAnalyst.this.jTableUsersMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableUsers);
        this.jButtonMerge.setText("Merge...");
        this.jButtonMerge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectAnalyst.this.jButtonMergeActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jRadioButtonSBUsers).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jRadioButtonAllPersonell).add((Component)this.jScrollPane1, -1, 439, Short.MAX_VALUE)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jButtonShowData, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonEdit, -1, 87, Short.MAX_VALUE).add((Component)this.jButtonAdd, -1, 87, Short.MAX_VALUE).add((Component)this.jButtonCancel, -1, 87, Short.MAX_VALUE).add((Component)this.jButtonHelp, -1, 87, Short.MAX_VALUE).add((Component)this.jButtonOK, -1, 87, Short.MAX_VALUE).add((Component)this.jButtonDelete, -1, 87, Short.MAX_VALUE).add((Component)this.jButtonMerge, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jRadioButtonAllPersonell).addPreferredGap(0).add((Component)this.jRadioButtonSBUsers, -2, 15, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonAdd).addPreferredGap(0).add((Component)this.jButtonEdit).addPreferredGap(0).add((Component)this.jButtonDelete).addPreferredGap(0).add((Component)this.jButtonShowData).addPreferredGap(0).add((Component)this.jButtonMerge).addPreferredGap(0, 91, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel)).add((Component)this.jScrollPane1, -1, 311, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void jTableUsersMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            if (this.isSelectable) {
                this.jButtonOKActionPerformed(null);
            } else {
                this.jButtonEditActionPerformed(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.jTableUsers.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select a name from the list", "Warning", 2);
            return;
        }
        Userdef selected = this.model.users.get(this.sorter.getIndexOf(this.jTableUsers.getSelectedRow()));
        if (this.sbdb.getUser().getUsrID() == selected.getUsrID()) {
            JOptionPane.showMessageDialog(this, "Cannot delete current user", "Warning", 2);
            return;
        }
        if ((this.sbdb.getUser().getPriv() & 0x40) == 0 && selected.getPriv() > 0) {
            JOptionPane.showMessageDialog(this, "You do not have the privilege to modify this user's details", "Warning", 2);
            return;
        }
        Cursor c = this.getCursor();
        try {
            Userdef user = this.model.users.get(this.sorter.getIndexOf(this.jTableUsers.getSelectedRow()));
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (user.hasAnalyses()) {
                JOptionPane.showMessageDialog(this, "Cannot delete user/identity that has analyses.", "Warning", 2);
                return;
            }
            if (user.hasIGD()) {
                JOptionPane.showMessageDialog(this, "Cannot delete user/identity that has references to interpreted data", "Warning", 2);
                return;
            }
            int nAudit = user.getCountAudit();
            if (JOptionPane.showConfirmDialog(this, "Really delete person: " + user + " ?\nWarning: user ID is recorded in " + nAudit + " created/modified/updated records.", "Confirm User Delete", 0, 3) != 0) {
                return;
            }
            this.sbdb.deleteUser(user.getAbr());
            this.loadUsers(this.allUsers);
            this.sbdb.commit();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, "Error: " + ex.getMessage() + "\nSQL: " + SB.sql, "SQL Error", 0);
            this.sbdb.doRollback();
        }
        finally {
            this.setCursor(c);
        }
    }

    private void jRadioButtonAllPersonellActionPerformed(ActionEvent evt) {
        if (!this.allUsers) {
            try {
                this.loadUsers(true);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void jRadioButtonSBUsersActionPerformed(ActionEvent evt) {
        if (this.allUsers) {
            try {
                this.loadUsers(false);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void jButtonShowDataActionPerformed(ActionEvent evt) {
        if (this.jTableUsers.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "No item selected", this.getTitle(), 2);
            return;
        }
        try {
            Userdef user = this.model.users.get(this.sorter.getIndexOf(this.jTableUsers.getSelectedRow()));
            DialogUserData dialog = new DialogUserData(this, true, user);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, "Error: " + ex.getMessage() + "\nSQL: " + SB.sql, "SQL Error", 0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, "Error: " + ex.getMessage(), "Error", 0);
        }
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        if (this.jTableUsers.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "No item selected", this.getTitle(), 2);
            return;
        }
        Userdef user = this.model.users.get(this.sorter.getIndexOf(this.jTableUsers.getSelectedRow()));
        if (user.getPriv() > 0 && (this.sbdb.getUser().getPriv() & 0x40) == 0 && this.sbdb.getUser().getUsrID() != user.getUsrID()) {
            JOptionPane.showMessageDialog(this, "You have user privileges only: you can only edit your own or non-users' details", this.getTitle(), 2);
            return;
        }
        DialogUserdef dialog = new DialogUserdef(this, true, this.sbdb, user);
        dialog.setVisible(true);
        if (dialog.isOK()) {
            try {
                this.loadUsers(this.allUsers);
                int index = this.getRowOf(dialog.user);
                if (index >= 0) {
                    this.jTableUsers.setRowSelectionInterval(index, index);
                } else {
                    this.jTableUsers.clearSelection();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
    }

    private int getRowOf(Object o) {
        for (int i = 0; i < this.model.users.size(); ++i) {
            if (this.model.users.get(this.sorter.getIndexOf(i)) != o) continue;
            return i;
        }
        return -1;
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        DialogUserdef dialog = new DialogUserdef(this, true, this.sbdb, null, null, null);
        dialog.setVisible(true);
        if (dialog.isOK()) {
            try {
                this.loadUsers(this.allUsers);
                int index = this.sorter.getIndexOf(this.model.users.indexOf(dialog.user));
                this.jTableUsers.setRowSelectionInterval(index, index);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jTableUsers.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "No item selected", this.getTitle(), 2);
            return;
        }
        this.selectedUser = this.model.users.get(this.sorter.getIndexOf(this.jTableUsers.getSelectedRow()));
        this.dispose();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogselectanalyst.html");
    }

    private void jButtonMergeActionPerformed(ActionEvent evt) {
        if (this.jTableUsers.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "Select a user to merge", this.getTitle(), 2);
            return;
        }
        this.selectedUser = this.model.users.get(this.sorter.getIndexOf(this.jTableUsers.getSelectedRow()));
        if (this.selectedUser.getUsrID() == this.sbdb.getUser().getUsrID()) {
            JOptionPane.showMessageDialog(this, "You cannot merge the current user", this.getTitle(), 2);
            return;
        }
        if (JOptionPane.showConfirmDialog(this, "After this operation the control panel and all open modules will be closed.\nDo you want to continue?", "Merge Users", 2) == 0) {
            DialogMergeAnalysts dialog = new DialogMergeAnalysts(this, true, this.sbdb, this.model.users, this.selectedUser);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.completed && this.parent instanceof FrameJsbugs) {
                FrameJsbugs frame = (FrameJsbugs)this.parent;
                try {
                    frame.connect(true, true);
                    this.dispose();
                }
                catch (SQLException ex) {
                    JOptionPane.showMessageDialog(null, "SQL Error: " + ex.getMessage(), this.getTitle(), 0);
                    ex.printStackTrace();
                }
            }
        }
    }
}

