/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableModel;
import jsbugs.DialogEvent;
import jsbugs.DialogSelectTaxa;
import jsbugs.FrameJsbugs;
import jsbugs.SBEventsTableModel;
import model2.SBEvent;
import model2.SBdb;
import model2.TaxaMap;
import model2.Taxon;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;
import util.TableSorter;

public class DialogSelectEvent
extends JDialog {
    private static final int NAMELEN = 100;
    private final SBEventsTableModel model = new SBEventsTableModel();
    private final TableSorter sorter = new TableSorter((TableModel)this.model);
    private final SBdb db;
    private Taxon searchedTaxon = null;
    SBEvent selection;
    private JButton jButtonAdd;
    private JButton jButtonCancel;
    private JButton jButtonEdit;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonSearch;
    private JButton jButtonSelectTaxa;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JTable jTableSBEvents;
    private JTextField jTextFieldSearch;
    private JTextField jTextFieldSearchTaxa;

    public DialogSelectEvent(Frame parent, boolean modal, SBdb db, List<SBEvent> eventList) throws SQLException, SBException {
        super(parent, modal);
        this.db = db;
        this.initComponents();
        this.init(eventList, null);
    }

    public DialogSelectEvent(JDialog parent, boolean modal, SBdb db, SBEvent selection, String searchString) throws SQLException, SBException {
        super((Dialog)parent, modal);
        this.db = db;
        this.selection = selection;
        this.initComponents();
        this.init(null, searchString);
    }

    private void init(List<SBEvent> eventList, String searchString) throws SQLException, SBException {
        List events;
        this.setTitle("Event : Select");
        if (searchString != null) {
            this.jTextFieldSearch.setText(searchString + "%");
        }
        this.sorter.addMouseListenerToHeaderInTable(this.jTableSBEvents);
        this.model.setupTable(this.jTableSBEvents);
        if (eventList != null) {
            events = eventList;
        } else if (this.selection != null && this.selection.getName() != null) {
            String string = this.selection.getName().length() < 10 ? this.selection.getName() : this.selection.getName().substring(0, 10) + "%";
            this.jTextFieldSearch.setText(string);
            events = SBEvent.search((SBdb)this.db, (String)string);
        } else {
            events = new LinkedList<SBEvent>();
        }
        this.model.setEvents(events);
        this.sorter.reallocateIndexes();
        this.sorter.fireTableDataChanged();
        if (this.selection != null) {
            int index = this.sorter.getIndexOf(this.model.getEvents().indexOf(this.selection));
            this.jTableSBEvents.setRowSelectionInterval(index, index);
            this.jTableSBEvents.scrollRectToVisible(this.jTableSBEvents.getCellRect(index, 0, true));
        }
        this.getRootPane().setDefaultButton(this.jButtonSearch);
    }

    private void initComponents() {
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonOK = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTableSBEvents = new JTable();
        this.jButtonAdd = new JButton();
        this.jButtonEdit = new JButton();
        this.jLabel1 = new JLabel();
        this.jTextFieldSearch = new JTextField();
        this.jButtonSearch = new JButton();
        this.jLabel2 = new JLabel();
        this.jTextFieldSearchTaxa = new JTextField();
        this.jButtonSelectTaxa = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(325, 375));
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectEvent.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectEvent.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectEvent.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jTableSBEvents.setModel((TableModel)this.sorter);
        this.jTableSBEvents.setSelectionMode(0);
        this.jTableSBEvents.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DialogSelectEvent.this.jTableSBEventsMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableSBEvents);
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectEvent.this.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText("Edit...");
        this.jButtonEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectEvent.this.jButtonEditActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Search event name:");
        this.jTextFieldSearch.setText("%");
        this.jTextFieldSearch.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                DialogSelectEvent.this.jTextFieldSearchFocusGained(evt);
            }
        });
        this.jTextFieldSearch.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogSelectEvent.this.jTextFieldSearchKeyTyped(evt);
            }
        });
        this.jButtonSearch.setText("Search");
        this.jButtonSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectEvent.this.jButtonSearchActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Search taxon/taxa:");
        this.jTextFieldSearchTaxa.setEditable(false);
        this.jButtonSelectTaxa.setText("...");
        this.jButtonSelectTaxa.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectEvent.this.jButtonSelectTaxaActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jScrollPane1).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jButtonCancel).add((Component)this.jButtonHelp).add((Component)this.jButtonOK)).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jButtonAdd).add((Component)this.jButtonEdit)))).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabel2).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jTextFieldSearch).add((Component)this.jTextFieldSearchTaxa)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jButtonSearch).add((Component)this.jButtonSelectTaxa, -2, 30, -2)).add(75, 75, 75))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jTextFieldSearch, -2, -1, -2).add((Component)this.jButtonSearch)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jTextFieldSearchTaxa, -2, -1, -2).add((Component)this.jButtonSelectTaxa)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((Component)this.jButtonAdd).addPreferredGap(0).add((Component)this.jButtonEdit).add(242, 242, 242).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel)).add((Component)this.jScrollPane1, -2, 0, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void jTableSBEventsMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonOKActionPerformed(null);
        }
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        SBEvent selectedEvent = null;
        int selectedRow = this.jTableSBEvents.getSelectedRow();
        if (selectedRow >= 0) {
            selectedEvent = this.model.getEvents().get(this.sorter.getIndexOf(selectedRow));
        }
        DialogEvent dialog = new DialogEvent(this, true, this.db, null, selectedEvent != null ? selectedEvent.getTaxon() : this.searchedTaxon);
        if (selectedEvent == null) {
            dialog.setEventName(this.jTextFieldSearch.getText().replaceAll("%", ""));
        }
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.sbEvent != null) {
            this.selection = dialog.sbEvent;
            int size = this.model.getEvents().size();
            this.model.getEvents().add(this.selection);
            this.sorter.reallocateIndexes();
            this.sorter.fireTableDataChanged();
            int index = this.sorter.getIndexOf(size);
            this.jTableSBEvents.setRowSelectionInterval(index, index);
            this.dispose();
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jTableSBEvents.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select an event", this.getTitle(), 1);
            return;
        }
        if (this.jTableSBEvents.getSelectedRowCount() == 1) {
            this.selection = this.model.getEvents().get(this.sorter.getIndexOf(this.jTableSBEvents.getSelectedRow()));
        }
        this.dispose();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        int row = this.jTableSBEvents.getSelectedRow();
        if (row < 0) {
            JOptionPane.showMessageDialog(this, "Select an event", this.getTitle(), 1);
            return;
        }
        SBEvent event = this.model.getEvents().get(this.sorter.getIndexOf(row));
        DialogEvent dialog = new DialogEvent(this, true, this.db, event);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        this.sorter.fireTableDataChanged();
        this.jTableSBEvents.getSelectionModel().setSelectionInterval(row, row);
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogselectevent.html");
    }

    private void jButtonSearchActionPerformed(ActionEvent evt) {
        this.search();
    }

    private void jTextFieldSearchFocusGained(FocusEvent evt) {
        this.jTextFieldSearch.setCaretPosition(0);
    }

    private void jTextFieldSearchKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldSearch, (int)100, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonSelectTaxaActionPerformed(ActionEvent evt) {
        this.searchedTaxon = null;
        try {
            TaxaMap.BuilderPair bp = null;
            if (!this.jTextFieldSearch.getText().isEmpty()) {
                String searchString = this.jTextFieldSearch.getText().trim();
                if (searchString.indexOf("%") > 0) {
                    searchString = searchString.substring(0, searchString.indexOf("%"));
                }
                bp = TaxaMap.parse((String)searchString);
            }
            DialogSelectTaxa dialog = new DialogSelectTaxa((JDialog)this, true, this.db, false, bp);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.selection != null && !dialog.selection.isEmpty()) {
                int[] specIDs = new int[dialog.selection.size()];
                for (int i = 0; i < dialog.selection.size(); ++i) {
                    specIDs[i] = dialog.selection.get(i).getSpecID();
                }
                this.model.setEvents(SBEvent.search((SBdb)this.db, (int[])specIDs));
                this.sorter.fireTableDataChanged();
                this.sorter.reallocateIndexes();
                String species = "";
                if (dialog.selection.size() == 1) {
                    this.searchedTaxon = dialog.selection.get(0);
                }
                for (Taxon t : dialog.selection) {
                    if (!species.isEmpty()) {
                        species = species + ", ";
                    }
                    species = species + t.toString(false, false, false);
                }
                this.jTextFieldSearchTaxa.setText(species);
            }
        }
        catch (SQLException sql) {
            SB.showStackError((String)"SQL Error", (SQLException)sql);
        }
        catch (Exception e) {
            SB.showStackError((String)"Error selecting taxon", (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void search() {
        String text = this.jTextFieldSearch.getText();
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.model.setEvents(SBEvent.search((SBdb)this.db, (String)text));
            this.sorter.fireTableDataChanged();
            this.sorter.reallocateIndexes();
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (SQLException sql) {
            SB.showStackError((String)"SQL Error", (SQLException)sql);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }
}

