/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import model2.SBdb;
import model2.TxGroup;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;

public class DialogSelectGroup
extends JDialog {
    SBdb db;
    DefaultListModel model = new DefaultListModel();
    TxGroup selection;
    boolean nameCleared = false;
    static final int NAME_LEN = 30;
    private JButton jButtonAdd;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JList jListGroups;
    private JScrollPane jScrollPane1;

    public DialogSelectGroup(Frame parent, boolean modal, SBdb db, TxGroup preselect) throws SQLException {
        super(parent, modal);
        this.db = db;
        this.initComponents();
        this.init(preselect);
    }

    public DialogSelectGroup(JDialog parent, boolean modal, SBdb db) throws SQLException {
        super((Dialog)parent, modal);
        this.db = db;
        this.initComponents();
        this.init(null);
    }

    private void init(TxGroup preselect) throws SQLException {
        this.setTitle("Group : Select");
        this.model.removeAllElements();
        LinkedList groups = new LinkedList(this.db.getTxGroups());
        Collections.sort(groups);
        for (TxGroup group : groups) {
            this.model.addElement(group);
        }
        if (preselect != null) {
            this.jListGroups.setSelectedValue(preselect, true);
        }
        this.jListGroups.repaint();
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jListGroups = new JList();
        this.jButtonAdd = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(400, 300));
        this.jListGroups.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.jListGroups.setModel(this.model);
        this.jListGroups.setToolTipText("Select a group name if you want to overwrite or add to it");
        this.jListGroups.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DialogSelectGroup.this.jListGroupsMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListGroups);
        this.jButtonAdd.setText("New group...");
        this.jButtonAdd.setToolTipText("Add new group to list");
        this.jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectGroup.this.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectGroup.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectGroup.this.jButtonOKActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 377, Short.MAX_VALUE).add(2, (GroupLayout.Group)layout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((Component)this.jButtonAdd).addPreferredGap(0).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonCancel))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 261, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonOK).add((Component)this.jButtonAdd)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.selection = (TxGroup)this.jListGroups.getSelectedValue();
        if (this.selection == null) {
            JOptionPane.showMessageDialog(this, "No group selected", this.getTitle(), 1);
            return;
        }
        this.dispose();
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        String groupName = JOptionPane.showInputDialog(this, (Object)"Group name: ");
        if (groupName.length() == 0) {
            JOptionPane.showMessageDialog(this, "Name blank", this.getTitle(), 1);
            return;
        }
        try {
            if (this.db.getTxGroup(groupName) != null) {
                JOptionPane.showMessageDialog(this, "A group of that name already exists", this.getTitle(), 1);
                return;
            }
            TxGroup group = this.db.addTxGroup(groupName, null, -1);
            this.model.addElement(group);
            this.jListGroups.setSelectedValue(group, true);
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage() + '\n' + SB.sql, this.getTitle(), 0);
            ex.printStackTrace();
        }
        catch (SBException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), this.getTitle(), 0);
            ex.printStackTrace();
        }
    }

    private void jListGroupsMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonOKActionPerformed(null);
        }
    }
}

