/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import jsbugs.DialogAHDchart;
import jsbugs.DialogPanelChromalog;
import jsbugs.DialogPanelTaxonGroup;
import jsbugs.DialogTVDOffsetChart;
import jsbugs.PanelChromalog;
import jsbugs.PanelListElement;
import jsbugs.PanelTaxonGroup;
import jsbugs.PanelWellVSProperties;
import jsbugs.SBDialog;
import jsbugs.WellBlock;
import model2.Discipline;
import model2.EnvScheme;
import model2.IGDScheme;
import model2.SBdb;
import model2.WellInterp;
import util.SB;
import util.SBException;

public class DialogSelectIGDPanel
extends SBDialog {
    DefaultListModel panelModel = new DefaultListModel();
    WellBlock block;
    WellInterp interp = null;
    static int[] ptypes = new int[]{3, 2, 4};
    static char[] discs = new char[]{'M', 'N', 'P', 'A'};
    boolean inStartup = true;
    SBdb db;
    String title;
    PanelWellVSProperties vsProp;
    LinkedList<IGDScheme> biozoneSchemes = new LinkedList();
    LinkedList<EnvScheme> envSchemes = new LinkedList();
    LinkedList<PanelListElement> panelList = new LinkedList();
    AddType type = AddType.SCALED;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JComboBox jComboBoxVersion;
    private JLabel jLabel1;
    private JList jListPanels;
    private JScrollPane jScrollPane1;

    public DialogSelectIGDPanel(SBDialog parent, boolean modal, SBdb db, WellBlock block, PanelWellVSProperties prop, String title, WellInterp interp) {
        super((Dialog)parent, modal);
        if (parent instanceof DialogTVDOffsetChart) {
            if (prop != null) {
                this.type = AddType.VS;
                this.vsProp = prop;
            }
        } else if (parent instanceof DialogAHDchart) {
            this.type = AddType.ALL;
        }
        this.block = block;
        this.db = db;
        this.title = title;
        this.interp = interp;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setTitle(this.title);
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.fillCombo(this.jComboBoxVersion);
        if (this.type == AddType.VS) {
            this.jComboBoxVersion.setEnabled(false);
            this.jListPanels.setSelectionMode(0);
        }
        this.createPanelList();
        this.inStartup = false;
    }

    private void fillCombo(JComboBox comboBox) {
        try {
            this.block.well.loadInterps();
            this.block.well.fillInterpCombo(comboBox);
            if (this.interp == null) {
                this.interp = (WellInterp)comboBox.getSelectedItem();
            } else {
                comboBox.setSelectedItem(this.interp);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (SBException sbe) {
            sbe.printStackTrace();
        }
    }

    private void createBiozoneSchemeList() {
        try {
            this.biozoneSchemes.clear();
            for (IGDScheme scheme : this.interp.getIGDSchemes(4)) {
                scheme.loadUnits();
                this.biozoneSchemes.add(scheme);
            }
        }
        catch (Exception e) {
            System.out.println("ERROR: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void createEnvSchemeList() {
        try {
            this.envSchemes.clear();
            for (EnvScheme scheme : this.interp.getEnvSchemes()) {
                this.envSchemes.add(scheme);
            }
            for (EnvScheme sch : this.block.well.getEnvSchemes()) {
                if (this.envSchemes.contains(sch)) continue;
                this.envSchemes.add(sch);
            }
        }
        catch (Exception e) {
            System.out.println("ERROR: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void createPanelList() {
        this.panelModel.clear();
        try {
            PanelListElement listElement;
            this.block.well.loadInterp(this.interp);
            for (int i = 0; i < ptypes.length - 1; ++i) {
                if (!this.interp.hasData(ptypes[i])) continue;
                PanelListElement panelListElement = new PanelListElement(ptypes[i], null, '\u0000');
                this.panelModel.addElement(panelListElement);
            }
            this.createBiozoneSchemeList();
            for (IGDScheme iGDScheme : this.biozoneSchemes) {
                PanelListElement listElement2 = new PanelListElement(ptypes[2], iGDScheme, '\u0000');
                this.panelModel.addElement(listElement2);
            }
            if (this.type == AddType.ALL || this.type == AddType.SCALED) {
                PanelListElement listElement2;
                if (this.interp.hasData(20)) {
                    listElement = new PanelListElement(20, null, 'E');
                    this.panelModel.addElement(listElement);
                }
                if (this.block.well.getSamples() != null && !this.block.well.getSamples().isEmpty()) {
                    listElement = new PanelListElement(-1, null, 'S');
                    this.panelModel.addElement(listElement);
                }
                if (this.interp.hasData(21)) {
                    for (IGDScheme iGDScheme : this.interp.getSequenceSchemes()) {
                        listElement2 = new PanelListElement(21, iGDScheme, '\u0000');
                        this.panelModel.addElement(listElement2);
                    }
                }
                if (this.block.well.getCurves() != null && this.block.well.getCurves().getSize() > 0) {
                    listElement = new PanelListElement(-1, null, 'W');
                    this.panelModel.addElement(listElement);
                }
                if (this.interp.hasData(19)) {
                    listElement = new PanelListElement(19, null, '\u0000');
                    this.panelModel.addElement(listElement);
                }
                this.panelModel.addElement(new PanelListElement(-1, null, 'J'));
                this.panelModel.addElement(new PanelListElement(-1, null, 'D'));
                for (int i = 0; i < discs.length; ++i) {
                    if (this.block.well.getAnalyses(discs[i], null, 0).isEmpty()) continue;
                    PanelListElement panelListElement = new PanelListElement(-1, null, discs[i]);
                    this.panelModel.addElement(panelListElement);
                }
                this.createEnvSchemeList();
                for (EnvScheme envScheme : this.envSchemes) {
                    if (envScheme == null) continue;
                    listElement2 = new PanelListElement(5, envScheme, '\u0000');
                    this.panelModel.addElement(listElement2);
                }
                listElement = new PanelListElement(-1, null, 'L');
                this.panelModel.addElement(listElement);
                if (this.block.well.hasSampleLithology()) {
                    listElement = new PanelListElement(-1, null, 'H');
                    this.panelModel.addElement(listElement);
                }
            }
            if (this.type == AddType.ALL) {
                if (!this.block.well.getCasing().getList().isEmpty()) {
                    listElement = new PanelListElement(-1, null, 'C');
                    this.panelModel.addElement(listElement);
                }
                if (!this.block.well.getCores().getList().isEmpty()) {
                    listElement = new PanelListElement(-1, null, 'F');
                    this.panelModel.addElement(listElement);
                }
                if (!this.block.well.getMarkers().getList().isEmpty()) {
                    listElement = new PanelListElement(-1, null, 'G');
                    this.panelModel.addElement(listElement);
                }
                if (!this.block.well.getCoreImages().isEmpty()) {
                    listElement = new PanelListElement(-1, null, 'I');
                    this.panelModel.addElement(listElement);
                }
                this.panelModel.addElement(new PanelListElement(-1, null, 'K'));
            }
        }
        catch (Exception e) {
            SB.showStackError((String)"Error creating panel list", (Exception)e);
        }
    }

    private void initComponents() {
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jComboBoxVersion = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jListPanels = new JList();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(285, 300));
        this.setModal(true);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectIGDPanel.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectIGDPanel.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jComboBoxVersion.setModel(new DefaultComboBoxModel<String>(new String[]{"<Select>"}));
        this.jComboBoxVersion.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectIGDPanel.this.jComboBoxVersionActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Version:");
        this.jListPanels.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.jListPanels.setModel(this.panelModel);
        this.jListPanels.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DialogSelectIGDPanel.this.jListPanelsMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListPanels);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 250, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxVersion, -2, 207, -2)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel))).addContainerGap()));
        layout.linkSize(0, this.jButtonCancel, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jComboBoxVersion, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane1, -1, 269, Short.MAX_VALUE).addGap(11, 11, 11).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jListPanels.getSelectedValue() == null) {
            JOptionPane.showMessageDialog(this, "Select an item from the list", this.getTitle(), 2);
            return;
        }
        try {
            if (this.type == AddType.VS) {
                PanelListElement element = (PanelListElement)this.jListPanels.getSelectedValue();
                int t = element.igdtype;
                if (t >= 0) {
                    this.vsProp.igdType = t;
                    this.vsProp.schID = element.scheme != null ? ((IGDScheme)element.scheme).getID() : -1;
                } else {
                    System.out.println("error - no IGD type selected");
                }
            } else {
                Object[] panels;
                block12: for (Object o : panels = this.jListPanels.getSelectedValues()) {
                    PanelListElement element = (PanelListElement)o;
                    switch (element.igdtype) {
                        case 3: {
                            if (this.block.addIGDPanel(3, -1, this.interp, false)) continue block12;
                            JOptionPane.showMessageDialog(this, "Chart already has panel: \n" + element.toString() + " : " + this.interp, this.getTitle(), 2);
                            continue block12;
                        }
                        case 2: {
                            if (this.block.addIGDPanel(2, -1, this.interp, false)) continue block12;
                            JOptionPane.showMessageDialog(this, "Chart already has panel: \n" + element.toString() + " : " + this.interp, this.getTitle(), 2);
                            continue block12;
                        }
                        case 4: {
                            if (this.block.addIGDPanel(4, ((IGDScheme)element.scheme).getID(), this.interp, false)) continue block12;
                            JOptionPane.showMessageDialog(this, "Chart already has panel: \n" + element.toString() + " : " + this.interp, this.getTitle(), 2);
                            continue block12;
                        }
                        case 21: {
                            if (this.block.addIGDPanel(21, ((IGDScheme)element.scheme).getID(), this.interp, false)) continue block12;
                            JOptionPane.showMessageDialog(this, "Chart already has panel: \n" + element.toString() + " : " + this.interp, this.getTitle(), 2);
                            continue block12;
                        }
                        case 20: {
                            if (this.block.addIGDPanel(20, -1, this.interp, false)) continue block12;
                            JOptionPane.showMessageDialog(this, "Chart already has panel: \n" + element.toString() + " : " + this.interp, this.getTitle(), 2);
                            continue block12;
                        }
                        case 5: {
                            if (this.block.addIGDPanel(5, ((EnvScheme)element.scheme).getID(), this.interp, false)) continue block12;
                            JOptionPane.showMessageDialog(this, "Chart already has panel: \n" + element.toString() + " : " + this.interp, this.getTitle(), 2);
                            continue block12;
                        }
                        case 19: {
                            this.block.addIGDPanel(19, -1, this.interp, false);
                            continue block12;
                        }
                        case -1: {
                            SBDialog dialog;
                            if (element.discID == 'W') {
                                this.block.addLogPanel(false);
                                continue block12;
                            }
                            if (element.discID == 'D') {
                                if (this.block.addDepthPanel(false)) continue block12;
                                JOptionPane.showMessageDialog(this, "Chart already has panel: \n" + element.toString(), this.getTitle(), 2);
                                continue block12;
                            }
                            if (element.discID == 'S') {
                                if (this.block.addSamplesPanel(false)) continue block12;
                                JOptionPane.showMessageDialog(this, "Chart already has panel: \n" + element.toString(), this.getTitle(), 2);
                                continue block12;
                            }
                            if (element.discID == 'L') {
                                if (this.block.addIntLithPanel(false)) continue block12;
                                JOptionPane.showMessageDialog(this, "Chart already has panel: \n" + element.toString(), this.getTitle(), 2);
                                continue block12;
                            }
                            if (element.discID == 'C') {
                                if (this.block.addCasingPanel(false)) continue block12;
                                JOptionPane.showMessageDialog(this, "Chart already has panel: \n" + element.toString(), this.getTitle(), 2);
                                continue block12;
                            }
                            if (element.discID == 'F') {
                                if (this.block.addCoresPanel()) continue block12;
                                JOptionPane.showMessageDialog(this, "Chart already has panel: \n" + element.toString(), this.getTitle(), 2);
                                continue block12;
                            }
                            if (element.discID == 'G') {
                                if (this.block.addMarkersPanel()) continue block12;
                                JOptionPane.showMessageDialog(this, "Chart already has panel: \n" + element.toString(), this.getTitle(), 2);
                                continue block12;
                            }
                            if (element.discID == 'H') {
                                if (this.block.addSampleLithologyPanel()) continue block12;
                                JOptionPane.showMessageDialog(this, "Chart already has panel: \n" + element.toString(), this.getTitle(), 2);
                                continue block12;
                            }
                            if (element.discID == 'I') {
                                if (this.block.addCoreImagesPanel()) continue block12;
                                JOptionPane.showMessageDialog(this, "Chart already has panel: \n" + element.toString(), this.getTitle(), 2);
                                continue block12;
                            }
                            if (element.discID == 'J') {
                                if (this.block.addWellHeaderPanel()) continue block12;
                                JOptionPane.showMessageDialog(this, "Chart already has panel: \n" + element.toString(), this.getTitle(), 2);
                                continue block12;
                            }
                            if (element.discID == 'K') {
                                PanelChromalog panelChromalog = new PanelChromalog(this.block, this.db);
                                dialog = new DialogPanelChromalog(this, true, panelChromalog);
                                dialog.setLocationRelativeTo(this);
                                dialog.setVisible(true);
                                if (!dialog.isOK()) continue block12;
                                this.block.addPanel(panelChromalog);
                                continue block12;
                            }
                            PanelTaxonGroup ptg = new PanelTaxonGroup(this.db, this.block, Discipline.getDisc((char)element.discID));
                            dialog = new DialogPanelTaxonGroup((Dialog)this, true, ptg);
                            dialog.setLocationRelativeTo(this);
                            dialog.setVisible(true);
                            if (ptg.size() <= 0) continue block12;
                            this.block.addPanel(ptg);
                            continue block12;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println("ERROR: " + e.getMessage());
            e.printStackTrace();
        }
        this.setOK();
    }

    private void jComboBoxVersionActionPerformed(ActionEvent evt) {
        if (this.inStartup) {
            return;
        }
        this.interp = (WellInterp)this.jComboBoxVersion.getSelectedItem();
        this.createPanelList();
    }

    private void jListPanelsMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonOKActionPerformed(null);
        }
    }

    static enum AddType {
        VS,
        ALL,
        SCALED;

    }
}

