/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import jsbugs.FrameJsbugs;
import model2.Project;
import model2.SBdb;
import org.jdesktop.layout.GroupLayout;
import util.InvalidFieldException;
import util.SB;
import util.SBException;

public class DialogSelectProject
extends JDialog {
    SBdb sbdb;
    DefaultListModel model = new DefaultListModel();
    Project selection = null;
    boolean allowAdd = true;
    private JButton jButtonAdd;
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JButton jButtonEdit;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JList jListProjects;
    private JScrollPane jScrollPane1;

    public DialogSelectProject(Frame parent, boolean modal, SBdb sbdb, boolean allowAdd) throws SQLException, SBException {
        super(parent, modal);
        this.sbdb = sbdb;
        this.allowAdd = allowAdd;
        this.initComponents();
        this.init();
    }

    public DialogSelectProject(JDialog parent, boolean modal, SBdb sbdb) throws SQLException, SBException {
        super((Dialog)parent, modal);
        this.sbdb = sbdb;
        this.initComponents();
        this.init();
    }

    private void update() throws SQLException, SBException {
        Object pSelection = this.jListProjects.getSelectedValue();
        this.model.clear();
        this.sbdb.getProjects().loadList(this.model, false);
        this.jListProjects.repaint();
    }

    private void init() throws SQLException, SBException {
        this.setTitle("Project : Select");
        this.sbdb.getProjects().loadList(this.model, false);
        this.getRootPane().setDefaultButton(this.jButtonClose);
        this.jListProjects.updateUI();
        if (!this.allowAdd) {
            this.jButtonAdd.setEnabled(false);
        }
    }

    private void initComponents() {
        this.jButtonAdd = new JButton();
        this.jButtonEdit = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonClose = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jListProjects = new JList();
        this.jButtonOK = new JButton();
        this.jButtonHelp = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(300, 300));
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectProject.this.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText("Edit...");
        this.jButtonEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectProject.this.jButtonEditActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectProject.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonClose.setText("Cancel");
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectProject.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jListProjects.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.jListProjects.setModel(this.model);
        this.jListProjects.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DialogSelectProject.this.jListProjectsMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListProjects);
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectProject.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectProject.this.jButtonHelpActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 183, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add(2, (GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jButtonAdd).add((Component)this.jButtonEdit).add((Component)this.jButtonDelete)).add((Component)this.jButtonClose, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonOK, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonHelp, 0, 0, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonAdd, this.jButtonDelete, this.jButtonEdit}, 1);
        layout.linkSize(new Component[]{this.jButtonClose, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.jScrollPane1, -1, 215, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonAdd).addPreferredGap(0).add((Component)this.jButtonEdit).addPreferredGap(0).add((Component)this.jButtonDelete).addPreferredGap(0, 52, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).add(7, 7, 7).add((Component)this.jButtonClose))).addContainerGap()));
        this.pack();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.selection = (Project)this.jListProjects.getSelectedValue();
        if (this.selection == null) {
            JOptionPane.showMessageDialog(this, "No project selected", this.getTitle(), 0);
            return;
        }
        this.dispose();
    }

    private void jListProjectsMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonOKActionPerformed(null);
        }
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        try {
            Project project = (Project)this.jListProjects.getSelectedValue();
            if (project == null) {
                JOptionPane.showMessageDialog(this, "No project selected", this.getTitle(), 0);
                return;
            }
            String name = (String)JOptionPane.showInputDialog(this, "New name of project: ", "Project : Edit", 3, null, null, project.getName());
            if (name == null || name.isEmpty() || name.equals(project.getName())) {
                return;
            }
            if (name.length() > 60) {
                JOptionPane.showMessageDialog(this, "Name must be less than 60 characters", this.getTitle(), 1);
                return;
            }
            project.update(this.sbdb, name);
            this.sbdb.commit();
            this.selection = this.sbdb.getProjects().getProject(name);
            this.dispose();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error: " + e.getMessage(), this.getTitle(), 0);
            e.printStackTrace();
            this.sbdb.doRollback();
        }
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        try {
            String name = JOptionPane.showInputDialog(this, "Name of new project: ", "Project : Add", 3);
            if (name == null || name.isEmpty()) {
                return;
            }
            if (name.length() > 60) {
                JOptionPane.showMessageDialog(this, "Name must be less than 60 characters", this.getTitle(), 1);
                return;
            }
            this.sbdb.getProjects().add(name);
            this.sbdb.commit();
            this.selection = this.sbdb.getProjects().getProject(name);
            this.dispose();
        }
        catch (InvalidFieldException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), this.getTitle(), 2);
        }
        catch (SQLException sql) {
            this.sbdb.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (SBException sbe) {
            this.sbdb.doRollback();
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        try {
            Project project = (Project)this.jListProjects.getSelectedValue();
            if (project == null) {
                JOptionPane.showMessageDialog(this, "No project selected", this.getTitle(), 0);
                return;
            }
            if (JOptionPane.showConfirmDialog(this, "Delete project: " + project + "? (will not delete the project's wells)", this.getTitle(), 0, 3) != 0) {
                return;
            }
            this.sbdb.getProjects().delete(project);
            this.update();
            this.sbdb.commit();
        }
        catch (SQLException sql) {
            this.sbdb.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogselectproject.html");
    }
}

