/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jsbugs.DepthRenderer;
import jsbugs.DialogSample;
import jsbugs.FrameJsbugs;
import jsbugs.SampleLithologyCellRenderer;
import jsbugs.TableModelSamples;
import model2.SBdb;
import model2.Sample;
import model2.Well;
import org.jdesktop.layout.GroupLayout;
import util.ColouredRenderer;
import util.SB;
import util.SBException;
import util.TableSorter;

public class DialogSelectSample
extends JDialog
implements Observer {
    Sample sample;
    Well well;
    SBdb db;
    boolean showLOCage = false;
    TableModelSamples model = new TableModelSamples(true);
    TableSorter sorter = new TableSorter((TableModel)this.model);
    boolean isOK = false;
    Sample selection = null;
    static Sample lastSelection = null;
    private JButton jButtonAdd;
    private JButton jButtonCancel;
    private JButton jButtonDelete;
    private JButton jButtonEdit;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JScrollPane jScrollPane1;
    private JTable jTableSamples;

    public DialogSelectSample(Frame parent, boolean modal, SBdb db, Well well, Sample sample, char units) throws SQLException, SBException {
        super(parent, modal);
        this.well = well;
        this.db = db;
        this.sample = sample;
        this.initComponents();
        this.init(units);
    }

    public DialogSelectSample(JDialog parent, boolean modal, SBdb db, Well well, Sample sample, char units, boolean showLOCage) throws SQLException, SBException {
        super((Dialog)parent, modal);
        this.well = well;
        this.db = db;
        this.sample = sample;
        this.initComponents();
        this.showLOCage = showLOCage;
        this.init(units);
    }

    TableModelSamples getTableModel() {
        return this.model;
    }

    @Override
    public void update(Observable obs, Object obj) {
        boolean update = false;
        if (obs instanceof Well && obs == this.well) {
            update = true;
        } else if (obs instanceof Sample) {
            update = true;
        }
        if (update) {
            this.sorter.reallocateIndexes();
            this.sorter.sort((Object)this);
            this.sorter.fireTableDataChanged();
        }
    }

    private void init(char units) throws SQLException, SBException {
        this.setTitle("Sample : Select");
        SB.setTableHeaderBold((JTable)this.jTableSamples);
        this.model.setUnits(units);
        TableColumnModel columnModel = this.jTableSamples.getTableHeader().getColumnModel();
        this.sorter.addMouseListenerToHeaderInTable(this.jTableSamples);
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(TableModelSamples.columnHeaders[i]);
            columnModel.getColumn(i).setWidth(this.model.getDefaultColumnWidths()[i]);
        }
        columnModel.getColumn(0).setCellRenderer(new DepthRenderer());
        columnModel.getColumn(1).setCellRenderer(new DepthRenderer());
        if (this.showLOCage) {
            columnModel.getColumn(4).setCellRenderer((TableCellRenderer)new ColouredRenderer(false, new Color(220, 220, 220)));
        } else {
            columnModel.getColumn(4).setHeaderValue("");
            columnModel.getColumn(4).setPreferredWidth(0);
            columnModel.getColumn(4).setMinWidth(0);
            columnModel.getColumn(4).setMaxWidth(0);
        }
        this.jTableSamples.setDefaultRenderer(List.class, new SampleLithologyCellRenderer());
        this.model.setSamples(this.well, this);
        this.sorter.reallocateIndexes();
        if (this.sample == null && this.model.getSamples().indexOf(lastSelection) >= 0) {
            this.sample = lastSelection;
        }
        this.sorter.fireTableDataChanged();
        if (this.sample != null) {
            int index = this.model.getSamples().indexOf(this.sample);
            this.jTableSamples.setRowSelectionInterval(index, index);
            if ((index += 10) > this.model.getRowCount()) {
                index = this.model.getRowCount();
            }
            this.jTableSamples.scrollRectToVisible(this.jTableSamples.getCellRect(index, 0, true));
        }
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTableSamples = new JTable();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonAdd = new JButton();
        this.jButtonEdit = new JButton();
        this.jButtonDelete = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(400, 300));
        this.jTableSamples.setModel((TableModel)this.sorter);
        this.jTableSamples.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DialogSelectSample.this.jTableSamplesMouseClicked(evt);
            }
        });
        this.jTableSamples.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                DialogSelectSample.this.jTableSamplesKeyPressed(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableSamples);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectSample.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectSample.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectSample.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectSample.this.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText("Edit...");
        this.jButtonEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectSample.this.jButtonEditActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectSample.this.jButtonDeleteActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 352, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jButtonAdd).add((Component)this.jButtonEdit).add((Component)this.jButtonDelete).add((Component)this.jButtonCancel).add((Component)this.jButtonHelp).add((Component)this.jButtonOK)).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonAdd).addPreferredGap(0).add((Component)this.jButtonEdit).addPreferredGap(0).add((Component)this.jButtonDelete).addPreferredGap(0, 146, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel)).add((Component)this.jScrollPane1, -1, 308, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogselectsample.html");
    }

    private void jTableSamplesMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonOKActionPerformed(null);
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        int row = this.jTableSamples.getSelectedRow();
        if (this.jTableSamples.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one sample from the table, or add one", this.getTitle(), 1);
            return;
        }
        try {
            lastSelection = this.selection = this.model.getSamples().get(this.sorter.getIndexOf(row));
            this.isOK = true;
            this.dispose();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage());
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        if (this.jTableSamples.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one sample to edit", this.getTitle(), 1);
            return;
        }
        try {
            Sample selected = this.model.getSamples().get(this.sorter.getIndexOf(this.jTableSamples.getSelectedRow()));
            DialogSample dialog = new DialogSample(this, true, this.db, this.well, this.model.getUnits(), selected);
            dialog.setVisible(true);
            if (dialog.isOK) {
                this.jTableSamples.clearSelection();
                this.sorter.fireTableDataChanged();
                int index = this.sorter.getIndexOf(this.model.getSamples().indexOf(dialog.sample));
                if (index >= 0) {
                    this.jTableSamples.getSelectionModel().setSelectionInterval(index, index);
                }
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error: " + e.getMessage(), this.getTitle(), 0);
            e.printStackTrace();
        }
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        DialogSample dialog = new DialogSample(this, true, this.db, this.well, this.model.getUnits());
        dialog.setVisible(true);
        if (dialog.isOK) {
            try {
                int index = this.model.getSamples().indexOf(dialog.sample);
                index = this.sorter.getIndexOf(index);
                this.jTableSamples.setRowSelectionInterval(index, index);
            }
            catch (Exception ex) {
                System.out.println("Error getting index of newly added sample: " + ex.getMessage());
            }
        }
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        int[] selected = this.jTableSamples.getSelectedRows();
        if (selected.length == 0) {
            JOptionPane.showMessageDialog(this, "No samples selected", this.getTitle(), 1);
            return;
        }
        LinkedList<Sample> samples = new LinkedList<Sample>();
        try {
            for (int i : selected) {
                samples.add((Sample)this.well.getSamples().get(this.sorter.getIndexOf(i)));
            }
            for (Sample sampleToDelete : samples) {
                int dType = this.well.hasSampleIGD(sampleToDelete);
                if (dType == 0) continue;
                String msg = "Can't delete sample '" + sampleToDelete + "' because of associated interpreted data, which should be deleted first.\nData type: " + SBdb.dTypeNames[dType];
                JOptionPane.showMessageDialog(this, msg, this.getTitle(), 1);
                return;
            }
            if (JOptionPane.showConfirmDialog(this, "Really delete " + (samples.size() > 1 ? "these " : "this ") + samples.size() + (samples.size() > 1 ? " samples?" : " sample?"), this.getTitle(), 0, 3) != 0) {
                return;
            }
            for (Sample sampleToDelete : samples) {
                this.well.deleteSample(sampleToDelete);
            }
            this.well.notifyObservers();
            this.jTableSamples.clearSelection();
            this.db.commit();
        }
        catch (SQLException sql) {
            this.db.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
    }

    private void jTableSamplesKeyPressed(KeyEvent evt) {
        int key = evt.getKeyCode();
        if (key == 127) {
            this.jButtonDeleteActionPerformed(null);
        }
    }
}

