/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import jsbugs.DialogIGDScheme;
import jsbugs.DialogList;
import jsbugs.FrameJsbugs;
import model2.CompositeStandard;
import model2.IGDScheme;
import model2.SBdb;
import model2.WellInterp;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;

public class DialogSelectScheme
extends JDialog {
    private final SBdb db;
    private final DefaultListModel listModel = new DefaultListModel();
    private final int igdType;
    IGDScheme selection = null;
    private JButton jButtonAdd;
    private JButton jButtonCancel;
    private JButton jButtonDelete;
    private JButton jButtonEdit;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonShowUsage;
    private JList jListScheme;
    private JScrollPane jScrollPane1;

    public DialogSelectScheme(Frame parent, boolean modal, SBdb db, int igdType) throws SQLException, SBException {
        super(parent, modal);
        this.db = db;
        this.igdType = igdType;
        this.setTitle("Scheme : Select");
        this.initComponents();
        this.init(null);
    }

    public DialogSelectScheme(JDialog parent, boolean modal, SBdb db, int igdType, WellInterp wellInterp) throws SQLException, SBException {
        super((Dialog)parent, modal);
        this.db = db;
        this.igdType = igdType;
        this.setTitle("Scheme : Select");
        this.initComponents();
        this.init(wellInterp);
    }

    private void init(WellInterp wellInterp) throws SQLException, SBException {
        LinkedList schemes = null;
        if (wellInterp != null) {
            schemes = wellInterp.getIGDSchemes(this.igdType);
        }
        if (schemes == null) {
            schemes = new LinkedList(this.db.getIGDSchemes(this.igdType));
        }
        Collections.sort(schemes);
        this.listModel.clear();
        for (IGDScheme scheme : schemes) {
            this.listModel.addElement(scheme);
        }
        this.jListScheme.setModel(this.listModel);
        this.jListScheme.repaint();
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jListScheme = new JList();
        this.jButtonAdd = new JButton();
        this.jButtonEdit = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonShowUsage = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonOK = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(325, 300));
        this.setModal(true);
        this.setName("Select Scheme");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DialogSelectScheme.this.formWindowClosing(evt);
            }
        });
        this.jListScheme.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.jListScheme.setModel(new AbstractListModel(){
            String[] strings = new String[]{"model"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jListScheme.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DialogSelectScheme.this.jListSchemeMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListScheme);
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectScheme.this.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText("Edit...");
        this.jButtonEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectScheme.this.jButtonEditActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectScheme.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonShowUsage.setText("Show Usage...");
        this.jButtonShowUsage.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonShowUsage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectScheme.this.jButtonShowUsageActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectScheme.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectScheme.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectScheme.this.jButtonOKActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 208, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2, false).add((Component)this.jButtonCancel, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonHelp, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonOK, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonAdd, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonEdit, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonDelete, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonShowUsage, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jScrollPane1, -1, 308, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonAdd).addPreferredGap(0).add((Component)this.jButtonEdit).addPreferredGap(0).add((Component)this.jButtonDelete).addPreferredGap(0).add((Component)this.jButtonShowUsage).addPreferredGap(0, 117, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel))).addContainerGap()));
        this.pack();
    }

    private void jListSchemeMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonOKActionPerformed(null);
        }
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        IGDScheme scheme = (IGDScheme)this.jListScheme.getSelectedValue();
        if (scheme == null) {
            JOptionPane.showMessageDialog(this, "Select a scheme", this.getTitle(), 1);
            return;
        }
        try {
            DialogIGDScheme dialog = new DialogIGDScheme(this, true, this.db, scheme, scheme.getIGDType());
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            this.jListScheme.repaint();
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.selection = null;
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.selection = (IGDScheme)this.jListScheme.getSelectedValue();
        if (this.selection == null) {
            JOptionPane.showMessageDialog(this, "Select a scheme", this.getTitle(), 1);
            return;
        }
        this.dispose();
    }

    private void jButtonShowUsageActionPerformed(ActionEvent evt) {
        Object object = this.jListScheme.getSelectedValue();
        if (object == null) {
            JOptionPane.showMessageDialog(this, "No scheme selected", this.getTitle(), 1);
            return;
        }
        try {
            if (object instanceof IGDScheme) {
                IGDScheme scheme = (IGDScheme)object;
                List occs = scheme.getOccs();
                if (occs == null || occs.isEmpty()) {
                    JOptionPane.showMessageDialog(this, "Scheme does not occur in any wells or outcrops.", scheme.toString(), 1);
                } else {
                    DialogList dialog = new DialogList(this, true, scheme.toString(), this.db, occs, false, false);
                    dialog.setLocationRelativeTo(this);
                    dialog.setVisible(true);
                }
            } else {
                CompositeStandard scheme = (CompositeStandard)object;
                List occs = scheme.getOccs();
                if (occs == null || occs.isEmpty()) {
                    JOptionPane.showMessageDialog(this, "Scheme does not occur in any wells or outcrops.", scheme.toString(), 1);
                } else {
                    DialogList dialog = new DialogList(this, true, scheme.toString(), this.db, occs, false, false);
                    dialog.setLocationRelativeTo(this);
                    dialog.setVisible(true);
                }
            }
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        try {
            DialogIGDScheme dialog = new DialogIGDScheme(this, true, this.db, null, this.igdType);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.init(null);
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.jListScheme.getSelectedValue() == null) {
            JOptionPane.showMessageDialog(this, "No scheme selected", this.getTitle(), 2);
            return;
        }
        IGDScheme scheme = (IGDScheme)this.jListScheme.getSelectedValue();
        try {
            String msg = "";
            int occs = scheme.getNoccs();
            if (occs > 0) {
                JOptionPane.showMessageDialog(this, "You cannot delete this scheme because it occurs " + occs + " times in well intervals.", this.getTitle(), 2);
                return;
            }
            if (JOptionPane.showConfirmDialog(this, msg + "Really delete scheme: " + scheme + "?", this.getTitle(), 0, 3) == 0) {
                this.db.deleteIGDScheme(scheme);
                this.db.commit();
                scheme.notifyObservers();
                scheme.deleteObservers();
                this.listModel.removeElement(scheme);
            }
        }
        catch (SQLException sql) {
            this.db.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogselectscheme.html");
    }

    private void formWindowClosing(WindowEvent evt) {
        this.jButtonCancelActionPerformed(null);
    }
}

