/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import jsbugs.TableModelSurfaces;
import model2.IGDScheme;
import model2.SBdb;
import model2.Surface;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;
import util.TableSorter;

public class DialogSelectSurface
extends JDialog {
    TableModelSurfaces model = new TableModelSurfaces();
    TableSorter sorter = new TableSorter((TableModel)this.model);
    SBdb db;
    private static Surface last = null;
    Surface selection;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JScrollPane jScrollPane1;
    private JTable jTableSurfaces;

    public DialogSelectSurface(Frame parent, boolean modal, SBdb db) throws SQLException, SBException {
        super(parent, modal);
        this.db = db;
        this.initComponents();
        this.init();
    }

    public DialogSelectSurface(JDialog parent, boolean modal, SBdb db, IGDScheme scheme, Surface selection) throws SQLException, SBException {
        super((Dialog)parent, modal);
        this.db = db;
        this.selection = selection;
        this.model.setScheme(scheme);
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException, SBException {
        int unsortedIndex;
        this.setTitle("Surface : Select");
        this.model.setupTable(this.jTableSurfaces);
        this.sorter.addMouseListenerToHeaderInTable(this.jTableSurfaces);
        this.sorter.reallocateIndexes();
        this.sorter.fireTableDataChanged();
        if (this.selection == null) {
            last = this.selection;
        }
        if (this.selection != null && (unsortedIndex = this.model.getScheme().getSurfaces().indexOf(this.selection)) >= 0) {
            int index = this.sorter.getIndexOf(unsortedIndex);
            this.jTableSurfaces.setRowSelectionInterval(index, index);
            this.jTableSurfaces.scrollRectToVisible(this.jTableSurfaces.getCellRect(index, 0, true));
        }
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void initComponents() {
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTableSurfaces = new JTable();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(325, 375));
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectSurface.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectSurface.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jTableSurfaces.setModel((TableModel)this.sorter);
        this.jTableSurfaces.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DialogSelectSurface.this.jTableSurfacesMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableSurfaces);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 492, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jButtonCancel).add((Component)this.jButtonOK)).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonCancel)).add((Component)this.jScrollPane1, -1, 460, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void jTableSurfacesMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonOKActionPerformed(null);
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jTableSurfaces.getSelectedRowCount() > 1) {
            JOptionPane.showMessageDialog(this, "Select one event", this.getTitle(), 1);
            return;
        }
        try {
            last = this.selection = (Surface)this.model.getScheme().getSurfaces().get(this.sorter.getIndexOf(this.jTableSurfaces.getSelectedRow()));
            this.dispose();
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(this, "SQL Error: " + e.getMessage() + "\n" + SB.sql, this.getTitle(), 0);
            e.printStackTrace();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error: " + e.getMessage(), this.getTitle(), 0);
            e.printStackTrace();
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

