/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import jsbugs.DialogSynonymScheme;
import jsbugs.FrameJsbugs;
import model2.SBdb;
import model2.SynonymScheme;
import org.jdesktop.layout.GroupLayout;
import util.InvalidFieldException;
import util.SB;
import util.SBException;

public class DialogSelectSynonymScheme
extends JDialog {
    private final SBdb db;
    private final DefaultListModel listModel = new DefaultListModel();
    SynonymScheme selection;
    private JButton jButtonAdd;
    private JButton jButtonCancel;
    private JButton jButtonDelete;
    private JButton jButtonEdit;
    private JButton jButtonOK;
    private JButton jButtonView;
    private JList jListSchemes;
    private JScrollPane jScrollPane1;

    public DialogSelectSynonymScheme(JDialog parent, boolean modal, SBdb db) throws SQLException {
        super((Dialog)parent, modal);
        this.db = db;
        this.setLocation(parent.getLocation().x + 25, parent.getLocation().y + 25);
        this.initComponents();
        this.setTitle("Synonym Scheme : Select");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.initList();
    }

    private void initList() throws SQLException {
        this.listModel.clear();
        for (SynonymScheme s : this.db.getSynSchemes()) {
            this.listModel.addElement(s);
        }
        this.jListSchemes.repaint();
    }

    private void initComponents() {
        this.jButtonAdd = new JButton();
        this.jButtonEdit = new JButton();
        this.jButtonDelete = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jListSchemes = new JList();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonView = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(325, 375));
        this.setModal(true);
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectSynonymScheme.this.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText("Edit...");
        this.jButtonEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectSynonymScheme.this.jButtonEditActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectSynonymScheme.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jListSchemes.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.jListSchemes.setModel(this.listModel);
        this.jListSchemes.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DialogSelectSynonymScheme.this.jListSchemesMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListSchemes);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectSynonymScheme.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectSynonymScheme.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonView.setText("View...");
        this.jButtonView.setMargin(new Insets(2, 12, 2, 12));
        this.jButtonView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectSynonymScheme.this.jButtonViewActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 232, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jButtonCancel).add((Component)this.jButtonOK).add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (Component)this.jButtonView, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jButtonAdd, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jButtonEdit, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jButtonDelete))).add(8, 8, 8)));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonAdd).addPreferredGap(0).add((Component)this.jButtonEdit).addPreferredGap(0).add((Component)this.jButtonView).addPreferredGap(0).add((Component)this.jButtonDelete).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonCancel)).add((Component)this.jScrollPane1, -1, 308, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void jListSchemesMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonOKActionPerformed(null);
        }
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.jListSchemes.getSelectedValue() == null) {
            JOptionPane.showMessageDialog(this, "No scheme selected", this.getTitle(), 2);
            return;
        }
        SynonymScheme scheme = (SynonymScheme)this.jListSchemes.getSelectedValue();
        if (scheme.getSchID() == 1) {
            JOptionPane.showMessageDialog(this, "You cannot delete the default scheme", this.getTitle(), 2);
            return;
        }
        try {
            int nSyns = scheme.getNTerms();
            if (JOptionPane.showConfirmDialog(this, "Do you really want to delete this scheme?\nNumber of terms in scheme: " + nSyns, this.getTitle(), 0, 3) == 0) {
                this.db.deleteSynonymScheme(scheme);
                this.jListSchemes.clearSelection();
                this.initList();
            }
            this.db.commit();
        }
        catch (SQLException sql) {
            this.db.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        if (this.jListSchemes.getSelectedValue() == null) {
            JOptionPane.showMessageDialog(this, "No scheme selected", this.getTitle(), 2);
            return;
        }
        try {
            SynonymScheme scheme = (SynonymScheme)this.jListSchemes.getSelectedValue();
            String newName = JOptionPane.showInputDialog(this, "Change name to: ", scheme.getName());
            if (newName != null) {
                scheme.setName(newName);
                this.initList();
                this.db.commit();
            }
        }
        catch (InvalidFieldException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "New Scheme", 2);
        }
        catch (SQLException sql) {
            this.db.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (SBException sbe) {
            this.db.doRollback();
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        try {
            String newName = JOptionPane.showInputDialog(this, "Name of new Synonym Scheme: ", null, -1);
            if (newName != null) {
                this.db.addSynonymScheme(newName);
                this.db.commit();
                this.initList();
            }
        }
        catch (InvalidFieldException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "New Scheme", 2);
        }
        catch (SQLException sql) {
            this.db.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jListSchemes.getSelectedValue() == null) {
            JOptionPane.showMessageDialog(this, "No scheme selected", this.getTitle(), 2);
            return;
        }
        this.selection = (SynonymScheme)this.jListSchemes.getSelectedValue();
        this.dispose();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonViewActionPerformed(ActionEvent evt) {
        if (this.jListSchemes.getSelectedValue() == null) {
            JOptionPane.showMessageDialog(this, "No scheme selected", this.getTitle(), 2);
            return;
        }
        SynonymScheme scheme = (SynonymScheme)this.jListSchemes.getSelectedValue();
        try {
            DialogSynonymScheme dialog = new DialogSynonymScheme((Dialog)this, true, this.db, scheme);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
    }
}

