/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableModel;
import jsbugs.DialogTaxon;
import jsbugs.FrameJsbugs;
import jsbugs.TaxonTableModel;
import model2.Categories;
import model2.Lastval;
import model2.SBdb;
import model2.TaxaMap;
import model2.Taxon;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;
import util.TableSorter;

public class DialogSelectTaxa
extends JDialog {
    private static final int GENLEN = 30;
    private static final int SPECLEN = 30;
    private static Integer dialogWidth;
    private static Integer dialogHeight;
    private final TaxonTableModel model = new TaxonTableModel();
    private final TableSorter sorter = new TableSorter((TableModel)this.model);
    private final SBdb db;
    private Taxon original;
    List<Taxon> selection = null;
    private JButton jButtonAdd;
    private JButton jButtonCancel;
    private JButton jButtonClear;
    private JButton jButtonClearGenus;
    private JButton jButtonClearSpecies;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonSearch;
    private JButton jButtonSwap;
    private JComboBox jComboBoxCategory;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JScrollPane jScrollPane1;
    private JTable jTableTaxa;
    private JTextField jTextFieldAlphaCode;
    private JTextField jTextFieldGenus;
    private JTextField jTextFieldSpecies;
    private JTextField jTextFieldSubGenus;
    private JTextField jTextFieldSubSpecies;
    private JTextField jTextFieldTaxon;

    public DialogSelectTaxa(Frame parent, boolean modal, SBdb db, boolean singleSelection, Taxon initial) throws SQLException {
        super(parent, modal);
        this.db = db;
        this.initComponents();
        SB.centreDialog((Dialog)this);
        this.init(singleSelection, initial);
    }

    public DialogSelectTaxa(JDialog parent, boolean modal, SBdb db, boolean singleSelection, Taxon initial) throws SQLException {
        super((Dialog)parent, modal);
        this.db = db;
        this.initComponents();
        this.init(singleSelection, initial);
    }

    public DialogSelectTaxa(JDialog parent, boolean modal, SBdb db, boolean singleSelection, TaxaMap.BuilderPair builders) throws SQLException {
        super((Dialog)parent, modal);
        this.db = db;
        this.initComponents();
        this.init(singleSelection, builders);
    }

    private void init(boolean singleSelection, Object obj) throws SQLException {
        this.setTitle("Taxa : Select");
        if (dialogWidth != null && dialogHeight != null) {
            this.setSize(dialogWidth, dialogHeight);
        }
        this.getRootPane().setDefaultButton(this.jButtonSearch);
        this.model.setupTable(this.jTableTaxa, this.sorter, false, this.db);
        this.db.fillCatCombo(this.jComboBoxCategory, false, null);
        this.jComboBoxCategory.setSelectedIndex(0);
        if (singleSelection) {
            this.jTableTaxa.setSelectionMode(0);
        }
        if (obj != null) {
            if (obj instanceof Taxon) {
                Taxon taxon = (Taxon)obj;
                this.jTextFieldGenus.setText(SB.nullString((String)taxon.getGenusName()) + "%");
                this.jTextFieldSubGenus.setText(SB.nullString((String)taxon.getSubGenus()) + "%");
                this.jTextFieldSpecies.setText(SB.nullString((String)taxon.getSpecies()) + "%");
                this.jTextFieldSubSpecies.setText(SB.nullString((String)taxon.getSubSpecies()) + "%");
                this.jTextFieldAlphaCode.setText(SB.nullString((String)taxon.getAlphaCode()) + "%");
                this.jTextFieldTaxon.setText(taxon.toString(true, true));
                this.original = taxon;
            } else if (obj instanceof TaxaMap.BuilderPair) {
                TaxaMap.BuilderPair taxon = (TaxaMap.BuilderPair)obj;
                this.jTextFieldGenus.setText(SB.nullString((String)taxon.genusBuilder.getName()) + "%");
                this.jTextFieldSubGenus.setText(SB.nullString((String)taxon.genusBuilder.getSubGenus()) + "%");
                this.jTextFieldSpecies.setText(SB.nullString((String)taxon.taxonBuilder.getName()) + "%");
                this.jTextFieldSubSpecies.setText(SB.nullString((String)taxon.taxonBuilder.getSubSpecies()) + "%");
                this.jTextFieldAlphaCode.setText(SB.nullString((String)taxon.taxonBuilder.getAlphaCode()) + "%");
                this.jTextFieldTaxon.setText(taxon.toString());
            }
        } else {
            this.jTextFieldTaxon.setBackground(Color.lightGray);
            try {
                String params = Lastval.getString((SBdb)this.db, (String)"TSEARCH");
                StringTokenizer tok = new StringTokenizer(params, "|");
                if (tok.hasMoreTokens()) {
                    this.jTextFieldGenus.setText(tok.nextToken());
                }
                if (tok.hasMoreTokens()) {
                    this.jTextFieldSubGenus.setText(tok.nextToken());
                }
                if (tok.hasMoreTokens()) {
                    this.jTextFieldSpecies.setText(tok.nextToken());
                }
                if (tok.hasMoreTokens()) {
                    this.jTextFieldSubSpecies.setText(tok.nextToken());
                }
                if (tok.hasMoreTokens()) {
                    this.jComboBoxCategory.setSelectedItem(tok.nextToken());
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private void initComponents() {
        this.jTextFieldTaxon = new JTextField();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonSearch = new JButton();
        this.jButtonClearGenus = new JButton();
        this.jButtonClearSpecies = new JButton();
        this.jButtonClear = new JButton();
        this.jButtonOK = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTableTaxa = new JTable();
        this.jLabel6 = new JLabel();
        this.jTextFieldAlphaCode = new JTextField();
        this.jComboBoxCategory = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jTextFieldGenus = new JTextField();
        this.jTextFieldSubGenus = new JTextField();
        this.jLabel5 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jTextFieldSpecies = new JTextField();
        this.jTextFieldSubSpecies = new JTextField();
        this.jButtonAdd = new JButton();
        this.jButtonSwap = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(515, 400));
        this.setModal(true);
        this.jTextFieldTaxon.setEditable(false);
        this.jTextFieldTaxon.setBackground(new Color(255, 255, 204));
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectTaxa.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectTaxa.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonSearch.setText("Search");
        this.jButtonSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectTaxa.this.jButtonSearchActionPerformed(evt);
            }
        });
        this.jButtonClearGenus.setText("Search genus");
        this.jButtonClearGenus.setToolTipText("Search for matches from GENUS fields only");
        this.jButtonClearGenus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectTaxa.this.jButtonClearGenusActionPerformed(evt);
            }
        });
        this.jButtonClearSpecies.setText("Search species");
        this.jButtonClearSpecies.setToolTipText("Search for matches from SPECIES fields only");
        this.jButtonClearSpecies.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectTaxa.this.jButtonClearSpeciesActionPerformed(evt);
            }
        });
        this.jButtonClear.setText("Clear ");
        this.jButtonClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectTaxa.this.jButtonClearActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectTaxa.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jTableTaxa.setModel((TableModel)this.sorter);
        this.jTableTaxa.setAutoResizeMode(4);
        this.jTableTaxa.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DialogSelectTaxa.this.jTableTaxaMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableTaxa);
        this.jLabel6.setText("Alpha Code:");
        this.jTextFieldAlphaCode.setText("%");
        this.jTextFieldAlphaCode.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                DialogSelectTaxa.this.jTextFieldAlphaCodeFocusGained(evt);
            }
        });
        this.jTextFieldAlphaCode.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogSelectTaxa.this.jTextFieldAlphaCodeKeyTyped(evt);
            }
        });
        this.jLabel1.setText("Category:");
        this.jLabel3.setText("Sub-genus:");
        this.jLabel2.setText("Genus:");
        this.jTextFieldGenus.setText("%");
        this.jTextFieldGenus.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                DialogSelectTaxa.this.jTextFieldGenusFocusGained(evt);
            }
        });
        this.jTextFieldGenus.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogSelectTaxa.this.jTextFieldGenusKeyTyped(evt);
            }
        });
        this.jTextFieldSubGenus.setText("%");
        this.jTextFieldSubGenus.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                DialogSelectTaxa.this.jTextFieldSubGenusFocusGained(evt);
            }
        });
        this.jTextFieldSubGenus.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogSelectTaxa.this.jTextFieldSubGenusKeyTyped(evt);
            }
        });
        this.jLabel5.setText("Sub-species:");
        this.jLabel4.setText("Species:");
        this.jTextFieldSpecies.setText("%");
        this.jTextFieldSpecies.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                DialogSelectTaxa.this.jTextFieldSpeciesFocusGained(evt);
            }
        });
        this.jTextFieldSpecies.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogSelectTaxa.this.jTextFieldSpeciesKeyTyped(evt);
            }
        });
        this.jTextFieldSubSpecies.setText("%");
        this.jTextFieldSubSpecies.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                DialogSelectTaxa.this.jTextFieldSubSpeciesFocusGained(evt);
            }
        });
        this.jTextFieldSubSpecies.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogSelectTaxa.this.jTextFieldSubSpeciesKeyTyped(evt);
            }
        });
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectTaxa.this.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonSwap.setText("Swap");
        this.jButtonSwap.setToolTipText("Swap terms in genus and speices fields");
        this.jButtonSwap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectTaxa.this.jButtonSwapActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel)).add(1, (Component)this.jScrollPane1).add(1, (GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(6, 6, 6).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabel2).add((Component)this.jLabel1))).add((Component)this.jLabel3)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jComboBoxCategory, -2, 175, -2).add((Component)this.jTextFieldGenus, -2, 175, -2).add((Component)this.jTextFieldSubGenus, -2, 175, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabel5).add((Component)this.jLabel4).add((Component)this.jLabel6)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jTextFieldSubSpecies, -2, 174, -2).add((Component)this.jTextFieldSpecies, -2, 174, -2).add((Component)this.jTextFieldAlphaCode, -2, 174, -2))).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonSearch).addPreferredGap(0).add((Component)this.jButtonClear).addPreferredGap(0).add((Component)this.jButtonSwap).addPreferredGap(0).add((Component)this.jButtonClearGenus).addPreferredGap(0).add((Component)this.jButtonClearSpecies).addPreferredGap(0).add((Component)this.jButtonAdd)).add((Component)this.jTextFieldTaxon, -2, 477, -2))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jTextFieldTaxon, -2, -1, -2).add(17, 17, 17).add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jComboBoxCategory, -2, -1, -2)).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel6).add((Component)this.jTextFieldAlphaCode, -2, -1, -2))).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jLabel4).add((Component)this.jTextFieldSpecies, -2, -1, -2).add((Component)this.jTextFieldGenus, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.jLabel5).add((Component)this.jTextFieldSubSpecies, -2, -1, -2).add((Component)this.jTextFieldSubGenus, -2, -1, -2)).add(18, 18, 18).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonSearch).add((Component)this.jButtonAdd).add((Component)this.jButtonClearSpecies).add((Component)this.jButtonClearGenus).add((Component)this.jButtonClear).add((Component)this.jButtonSwap)).addPreferredGap(1).add((Component)this.jScrollPane1, -1, 280, Short.MAX_VALUE).add(11, 11, 11).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonHelp).add((Component)this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        try {
            DialogTaxon dialog;
            if (this.original == null || this.original.getSpecID() > 0 && this.original.getDatabase() == this.db) {
                String alphaCode;
                String cat;
                String subSpecies;
                String species;
                String subGenus;
                String genus;
                if (this.model.taxa != null && this.model.taxa.size() > 0 && this.jTableTaxa.getSelectedRow() >= 0) {
                    Taxon taxon = this.model.taxa.get(this.sorter.getIndexOf(this.jTableTaxa.getSelectedRow()));
                    genus = taxon.getGenusName();
                    subGenus = taxon.getSubGenus();
                    species = taxon.getSpecies();
                    subSpecies = taxon.getSubSpecies();
                    cat = taxon.getCatMnem();
                    alphaCode = taxon.getAlphaCode();
                } else {
                    genus = this.jTextFieldGenus.getText().replace('%', ' ').trim();
                    if (this.original != null && this.original.getGenusName().length() > genus.length()) {
                        genus = this.original.getGenusName();
                    }
                    species = this.jTextFieldSpecies.getText().replace('%', ' ').trim();
                    if (this.original != null && this.original.getSpecies().length() > species.length()) {
                        species = this.original.getSpecies();
                    }
                    subGenus = this.jTextFieldSubGenus.getText().replace('%', ' ').trim();
                    if (this.original != null && this.original.getSubGenus().length() > subGenus.length()) {
                        subGenus = this.original.getGenusName();
                    }
                    subSpecies = this.jTextFieldSubSpecies.getText().replace('%', ' ').trim();
                    if (this.original != null && this.original.getSubSpecies().length() > subSpecies.length()) {
                        subSpecies = this.original.getSubSpecies();
                    }
                    alphaCode = this.jTextFieldAlphaCode.getText().replace('%', ' ').trim();
                    cat = this.jComboBoxCategory.getSelectedIndex() > 0 || this.original == null ? Categories.getCatmnem((JComboBox)this.jComboBoxCategory) : this.original.getCatMnem();
                }
                dialog = new DialogTaxon(this, true, this.db, cat, genus, subGenus, species, subSpecies, alphaCode);
            } else {
                dialog = new DialogTaxon(this, true, this.db, this.original, true);
            }
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.taxon != null) {
                this.selection = new ArrayList<Taxon>();
                this.selection.add(dialog.taxon);
                this.dispose();
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error opening dialog", sql, this.db);
        }
    }

    private void jTableTaxaMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonOKActionPerformed(null);
        }
    }

    private void jButtonSearchActionPerformed(ActionEvent evt) {
        try {
            this.search(true, true);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void search(boolean useGenus, boolean useSpecies) throws SQLException, SBException {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            String alphaCode;
            String mnem = useGenus ? Categories.getCatmnem((JComboBox)this.jComboBoxCategory) : "";
            String genus = useGenus ? this.jTextFieldGenus.getText() : "%";
            String species = useSpecies ? this.jTextFieldSpecies.getText() : "%";
            String subGenus = useGenus ? this.jTextFieldSubGenus.getText() : "%";
            String subSpecies = useSpecies ? this.jTextFieldSubSpecies.getText() : "%";
            String string = alphaCode = useGenus && useSpecies ? this.jTextFieldAlphaCode.getText() : "%";
            if (mnem.length() == 0 && genus.equals("%") && species.equals("%") && subGenus.equals("%") && subSpecies.equals("%") && alphaCode.equals("%") && JOptionPane.showConfirmDialog(this, "No search parameters specified. \nEntire database search may take a long time. \nContinue?", this.getTitle(), 0) != 0) {
                return;
            }
            List list = Taxon.search((SBdb)this.db, (String)mnem, (boolean)true, (String)genus, (String)subGenus, (String)species, (String)subSpecies, (String)alphaCode, null, null, null, null, null, null, null, null);
            if (list.isEmpty()) {
                if (!this.db.hasSoundex()) {
                    JOptionPane.showMessageDialog(this, "No taxa found", "TaxaDB", 1);
                    return;
                }
                int opt = JOptionPane.showConfirmDialog(this, "No exact matches found. Search for similar sounding taxa?", this.getTitle(), 0, 3);
                if (opt != 0) {
                    return;
                }
                list = Taxon.searchSoundex((SBdb)this.db, (String)genus, (String)subGenus, (String)species, (String)subSpecies);
                if (list.isEmpty()) {
                    return;
                }
            }
            this.model.taxa = list;
            this.sorter.reallocateIndexes();
            this.sorter.fireTableDataChanged();
        }
        finally {
            this.getRootPane().setDefaultButton(this.jButtonOK);
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jTableTaxa.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "No selection", this.getTitle(), 2);
            return;
        }
        int[] rows = this.jTableTaxa.getSelectedRows();
        if (rows.length > 0) {
            this.selection = new ArrayList<Taxon>();
            for (int row : rows) {
                this.selection.add(this.model.taxa.get(this.sorter.getIndexOf(row)));
            }
        }
        String params = this.jTextFieldGenus.getText() + '|' + this.jTextFieldSubGenus.getText() + '|' + this.jTextFieldSpecies.getText() + '|' + this.jTextFieldSubSpecies.getText() + '|' + this.jComboBoxCategory.getSelectedItem() + '|' + true;
        try {
            Lastval.putString((SBdb)this.db, (String)"TSEARCH", (String)params);
            this.model.putTableColumnWidths(this.db, this.jTableTaxa);
            this.db.commit();
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        dialogWidth = this.getWidth();
        dialogHeight = this.getHeight();
        this.dispose();
    }

    private void jTextFieldAlphaCodeKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldAlphaCode, (int)30, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldSubSpeciesKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldSubSpecies, (int)30, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldSpeciesKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldSpecies, (int)30, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldSubGenusKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldSubGenus, (int)30, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldGenusKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldGenus, (int)30, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldAlphaCodeFocusGained(FocusEvent evt) {
        this.jTextFieldAlphaCode.setCaretPosition(0);
    }

    private void jTextFieldSubSpeciesFocusGained(FocusEvent evt) {
        this.jTextFieldSubSpecies.setCaretPosition(0);
    }

    private void jTextFieldSpeciesFocusGained(FocusEvent evt) {
        this.jTextFieldSpecies.setCaretPosition(0);
    }

    private void jTextFieldSubGenusFocusGained(FocusEvent evt) {
        this.jTextFieldSubGenus.setCaretPosition(0);
    }

    private void jTextFieldGenusFocusGained(FocusEvent evt) {
        this.jTextFieldGenus.setCaretPosition(0);
    }

    private void jButtonClearActionPerformed(ActionEvent evt) {
        this.jTextFieldSpecies.setText("%");
        this.jTextFieldSubSpecies.setText("%");
        this.jTextFieldGenus.setText("%");
        this.jTextFieldSubGenus.setText("%");
        this.jTextFieldAlphaCode.setText("%");
    }

    private void jButtonClearSpeciesActionPerformed(ActionEvent evt) {
        try {
            this.search(false, true);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonClearGenusActionPerformed(ActionEvent evt) {
        try {
            this.search(true, false);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogselecttaxa.html");
    }

    private void jButtonSwapActionPerformed(ActionEvent evt) {
        String gen = this.jTextFieldGenus.getText();
        String subGen = this.jTextFieldSubGenus.getText();
        String spec = this.jTextFieldSpecies.getText();
        String subSpec = this.jTextFieldSubSpecies.getText();
        this.jTextFieldGenus.setText(spec);
        this.jTextFieldSubGenus.setText(subSpec);
        this.jTextFieldSpecies.setText(gen);
        this.jTextFieldSubSpecies.setText(subGen);
    }
}

