/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import jsbugs.FrameJsbugs;
import model2.IGDScheme;
import model2.IGDUnit;
import model2.Project;
import model2.SBdb;
import model2.Taxon;
import model2.TxGroup;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;

public class DialogSelectTaxaAdv
extends JDialog {
    static final int DEPTHLEN = 4;
    static String NONITEM = "<none>";
    SBdb db;
    DefaultComboBoxModel projectModel = new DefaultComboBoxModel();
    List<Taxon> selection = null;
    static IGDScheme lastScheme = null;
    static IGDUnit lastUnit = null;
    private ButtonGroup buttonGroupWellRestriction;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JCheckBox jCheckBoxMacrofaunal;
    private JCheckBox jCheckBoxMicrofaunal;
    private JCheckBox jCheckBoxNannofloral;
    private JCheckBox jCheckBoxPalynofloral;
    private JComboBox jComboBoxGroup;
    private JComboBox jComboBoxProject;
    private JComboBox jComboBoxScheme;
    private JComboBox jComboBoxUnit;
    private JComboBox jComboBoxUnits;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JRadioButton jRadioButtonNoRestriction;
    private JRadioButton jRadioButtonRestrictDepths;
    private JRadioButton jRadioButtonRestrictZone;
    private JSeparator jSeparator1;
    private JTextField jTextFieldAbundance;
    private JTextField jTextFieldDepth1;
    private JTextField jTextFieldDepth2;
    private JTextField jTextFieldSQL;

    public DialogSelectTaxaAdv(Frame parent, boolean modal, SBdb db) throws SQLException, SBException {
        super(parent, modal);
        this.setTitle("Advanced Taxa Search");
        this.db = db;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException, SBException {
        this.jComboBoxGroup.removeAllItems();
        this.jComboBoxGroup.addItem(NONITEM);
        for (TxGroup group : this.db.getTxGroups()) {
            this.jComboBoxGroup.addItem(group);
        }
        this.db.getProjects().loadCombo(this.projectModel, true);
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.initSchemes();
        this.setUnitEnabled(false);
        this.setDepthsEnabled(false);
    }

    private void initComponents() {
        this.jLabel5 = new JLabel();
        this.buttonGroupWellRestriction = new ButtonGroup();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonOK = new JButton();
        this.jPanel1 = new JPanel();
        this.jCheckBoxMacrofaunal = new JCheckBox();
        this.jCheckBoxMicrofaunal = new JCheckBox();
        this.jCheckBoxNannofloral = new JCheckBox();
        this.jCheckBoxPalynofloral = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.jComboBoxGroup = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jComboBoxProject = new JComboBox();
        this.jTextFieldAbundance = new JTextField();
        this.jLabel7 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jTextFieldSQL = new JTextField();
        this.jLabel6 = new JLabel();
        this.jPanel3 = new JPanel();
        this.jRadioButtonRestrictDepths = new JRadioButton();
        this.jRadioButtonRestrictZone = new JRadioButton();
        this.jTextFieldDepth1 = new JTextField();
        this.jLabel4 = new JLabel();
        this.jTextFieldDepth2 = new JTextField();
        this.jComboBoxUnits = new JComboBox();
        this.jComboBoxScheme = new JComboBox();
        this.jComboBoxUnit = new JComboBox();
        this.jRadioButtonNoRestriction = new JRadioButton();
        this.jLabel5.setText("jLabel5");
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectTaxaAdv.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectTaxaAdv.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectTaxaAdv.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Within disciplines", 0, 0, null, new Color(51, 102, 204)));
        this.jCheckBoxMacrofaunal.setSelected(true);
        this.jCheckBoxMacrofaunal.setText("Macrofaunal");
        this.jCheckBoxMacrofaunal.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxMacrofaunal.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBoxMicrofaunal.setSelected(true);
        this.jCheckBoxMicrofaunal.setText("Microfaunal");
        this.jCheckBoxMicrofaunal.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxMicrofaunal.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBoxNannofloral.setSelected(true);
        this.jCheckBoxNannofloral.setText("Nannofloral");
        this.jCheckBoxNannofloral.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxNannofloral.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBoxPalynofloral.setSelected(true);
        this.jCheckBoxPalynofloral.setText("Palynofloral");
        this.jCheckBoxPalynofloral.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxPalynofloral.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1, false).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jCheckBoxMicrofaunal).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jCheckBoxPalynofloral)).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jCheckBoxMacrofaunal).add(18, 18, 18).add((Component)this.jCheckBoxNannofloral))).addContainerGap(134, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(2).add((Component)this.jCheckBoxNannofloral).add((Component)this.jCheckBoxMacrofaunal)).addPreferredGap(1).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jCheckBoxMicrofaunal).add((Component)this.jCheckBoxPalynofloral)).addContainerGap()));
        this.jLabel1.setText("Within group:");
        this.jComboBoxGroup.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel2.setText("Within project:");
        this.jComboBoxProject.setModel(this.projectModel);
        this.jTextFieldAbundance.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogSelectTaxaAdv.this.jTextFieldAbundanceKeyTyped(evt);
            }
        });
        this.jLabel7.setText("Additional SQL parameters:");
        this.jTextFieldSQL.setMinimumSize(new Dimension(6, 40));
        this.jLabel6.setText("With abundance greater than:");
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(null, "Restriction within well(s)", 0, 0, null, new Color(51, 102, 204)));
        this.buttonGroupWellRestriction.add(this.jRadioButtonRestrictDepths);
        this.jRadioButtonRestrictDepths.setText("Between depths: ");
        this.jRadioButtonRestrictDepths.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectTaxaAdv.this.jRadioButtonRestrictDepthsActionPerformed(evt);
            }
        });
        this.buttonGroupWellRestriction.add(this.jRadioButtonRestrictZone);
        this.jRadioButtonRestrictZone.setText("Within zone/unit:");
        this.jRadioButtonRestrictZone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectTaxaAdv.this.jRadioButtonRestrictZoneActionPerformed(evt);
            }
        });
        this.jTextFieldDepth1.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                DialogSelectTaxaAdv.this.jTextFieldDepth1FocusGained(evt);
            }
        });
        this.jTextFieldDepth1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogSelectTaxaAdv.this.jTextFieldDepth1KeyTyped(evt);
            }
        });
        this.jLabel4.setText("to:");
        this.jTextFieldDepth2.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                DialogSelectTaxaAdv.this.jTextFieldDepth2FocusGained(evt);
            }
        });
        this.jTextFieldDepth2.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogSelectTaxaAdv.this.jTextFieldDepth2KeyTyped(evt);
            }
        });
        this.jComboBoxUnits.setModel(new DefaultComboBoxModel<String>(new String[]{"m", "ft"}));
        this.jComboBoxScheme.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxScheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectTaxaAdv.this.jComboBoxSchemeActionPerformed(evt);
            }
        });
        this.jComboBoxUnit.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.buttonGroupWellRestriction.add(this.jRadioButtonNoRestriction);
        this.jRadioButtonNoRestriction.setSelected(true);
        this.jRadioButtonNoRestriction.setText("No restriction");
        this.jRadioButtonNoRestriction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectTaxaAdv.this.jRadioButtonNoRestrictionActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((Component)this.jRadioButtonNoRestriction).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((Component)this.jRadioButtonRestrictDepths).addPreferredGap(0).add((Component)this.jTextFieldDepth1, -2, 57, -2).add(4, 4, 4).add((Component)this.jLabel4).addPreferredGap(0).add((Component)this.jTextFieldDepth2, -2, 52, -2).addPreferredGap(0).add((Component)this.jComboBoxUnits, -2, 41, -2)).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((Component)this.jRadioButtonRestrictZone).add(6, 6, 6).add((Component)this.jComboBoxScheme, 0, 183, Short.MAX_VALUE)).add(2, (GroupLayout.Group)jPanel3Layout.createSequentialGroup().add(113, 113, 113).add((Component)this.jComboBoxUnit, 0, 183, Short.MAX_VALUE))).addContainerGap()));
        jPanel3Layout.linkSize(new Component[]{this.jTextFieldDepth1, this.jTextFieldDepth2}, 1);
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((Component)this.jRadioButtonNoRestriction).addPreferredGap(0).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.jRadioButtonRestrictDepths).add((Component)this.jTextFieldDepth1, -2, -1, -2).add((Component)this.jLabel4).add((Component)this.jTextFieldDepth2, -2, -1, -2).add((Component)this.jComboBoxUnits, -2, -1, -2)).addPreferredGap(1).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.jRadioButtonRestrictZone).add((Component)this.jComboBoxScheme, -2, -1, -2)).addPreferredGap(0).add((Component)this.jComboBoxUnit, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jPanel3, -1, -1, Short.MAX_VALUE).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabel2).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jComboBoxProject, 0, 249, Short.MAX_VALUE).add((Component)this.jComboBoxGroup, 0, 249, Short.MAX_VALUE))))).add(2, (GroupLayout.Group)layout.createSequentialGroup().add(20, 20, 20).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabel6).add((Component)this.jLabel7)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jTextFieldSQL, -1, 164, Short.MAX_VALUE).add((Component)this.jTextFieldAbundance, -2, 62, -2))).add((Component)this.jSeparator1, -1, 314, Short.MAX_VALUE).add(2, (GroupLayout.Group)layout.createSequentialGroup().add(107, 107, 107).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel))))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jComboBoxGroup, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jComboBoxProject, -2, -1, -2).add((Component)this.jLabel2)).addPreferredGap(1).add((Component)this.jPanel3, -2, -1, -2).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel6).add((Component)this.jTextFieldAbundance, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jTextFieldSQL, -2, -1, -2).add((Component)this.jLabel7)).add(11, 11, 11).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonHelp).add((Component)this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jTextFieldDepth2FocusGained(FocusEvent evt) {
        this.jTextFieldDepth2.setSelectionStart(0);
        this.jTextFieldDepth2.setSelectionEnd(this.jTextFieldDepth2.getText().length());
    }

    private void jTextFieldDepth1FocusGained(FocusEvent evt) {
        this.jTextFieldDepth1.setSelectionStart(0);
        this.jTextFieldDepth1.setSelectionEnd(this.jTextFieldDepth1.getText().length());
    }

    private void jTextFieldDepth2KeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldDepth2, (int)4, (KeyEvent)evt, (boolean)true)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldDepth1KeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldDepth1, (int)4, (KeyEvent)evt, (boolean)true)) {
            this.getToolkit().beep();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonOKActionPerformed(ActionEvent evt) {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            String discs = "";
            if (this.jCheckBoxMicrofaunal.isSelected()) {
                discs = discs + 'M';
            }
            if (this.jCheckBoxMacrofaunal.isSelected()) {
                discs = discs + 'A';
            }
            if (this.jCheckBoxNannofloral.isSelected()) {
                discs = discs + 'N';
            }
            if (this.jCheckBoxPalynofloral.isSelected()) {
                discs = discs + 'P';
            }
            if (discs.length() == 0) {
                JOptionPane.showMessageDialog(this, "no discipline selected", this.getTitle(), 2);
                return;
            }
            TxGroup group = null;
            if (this.jComboBoxGroup.getSelectedIndex() > 0) {
                group = (TxGroup)this.jComboBoxGroup.getSelectedItem();
            }
            Project project = (Project)this.jComboBoxProject.getSelectedItem();
            int abund = -1;
            if (this.jTextFieldAbundance.getText().length() > 0) {
                abund = Integer.parseInt(this.jTextFieldAbundance.getText());
            }
            if (this.jRadioButtonRestrictZone.isSelected()) {
                IGDScheme scheme = (IGDScheme)this.jComboBoxScheme.getSelectedItem();
                IGDUnit unit = (IGDUnit)this.jComboBoxUnit.getSelectedItem();
                lastScheme = scheme;
                lastUnit = unit;
                String addSql = this.jTextFieldSQL.getText();
                this.selection = Taxon.search((SBdb)this.db, (String)discs, (TxGroup)group, (Project)project, (IGDUnit)unit, (int)abund, (String)addSql);
            } else {
                Double upper = null;
                Double lower = null;
                if (this.jRadioButtonRestrictDepths.isSelected()) {
                    if (this.jTextFieldDepth1.getText().length() > 0) {
                        upper = new Double(this.jTextFieldDepth1.getText());
                    }
                    if (this.jTextFieldDepth2.getText().length() > 0) {
                        lower = new Double(this.jTextFieldDepth2.getText());
                    }
                    if (this.jComboBoxUnits.getSelectedItem().equals("ft")) {
                        if (upper != null) {
                            upper = new Double(SB.convToM((double)upper, (char)'F'));
                        }
                        if (lower != null) {
                            lower = new Double(SB.convToM((double)lower, (char)'F'));
                        }
                    }
                }
                String addSql = this.jTextFieldSQL.getText();
                this.selection = Taxon.search((SBdb)this.db, (String)discs, (TxGroup)group, (Project)project, (int)0, (Double)upper, lower, (int)abund, (String)addSql);
            }
            if (this.selection == null || this.selection.isEmpty()) {
                JOptionPane.showMessageDialog(this, "No taxa found", this.getTitle(), 2);
                return;
            }
            this.dispose();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, ex.getMessage() + "\nSQL: " + SB.sql, this.getTitle(), 0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, ex.getMessage(), this.getTitle(), 0);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jTextFieldAbundanceKeyTyped(KeyEvent evt) {
        if (SB.intFieldVal((JTextField)this.jTextFieldAbundance, (int)5, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogselecttaxaadv.html");
    }

    private void jRadioButtonNoRestrictionActionPerformed(ActionEvent evt) {
        this.setDepthsEnabled(false);
        this.setUnitEnabled(false);
    }

    private void jComboBoxSchemeActionPerformed(ActionEvent evt) {
        Object o = this.jComboBoxScheme.getSelectedItem();
        if (!(o instanceof IGDScheme)) {
            return;
        }
        try {
            IGDScheme scheme = (IGDScheme)o;
            this.jComboBoxUnit.removeAllItems();
            for (IGDUnit unit : scheme.getUnits()) {
                this.jComboBoxUnit.addItem(unit);
            }
            this.jComboBoxUnit.repaint();
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.toString(), (Exception)ex);
        }
    }

    private void jRadioButtonRestrictDepthsActionPerformed(ActionEvent evt) {
        this.setDepthsEnabled(true);
        this.setUnitEnabled(false);
    }

    private void jRadioButtonRestrictZoneActionPerformed(ActionEvent evt) {
        this.setDepthsEnabled(false);
        this.setUnitEnabled(true);
    }

    private void setDepthsEnabled(boolean b) {
        this.jTextFieldDepth1.setEnabled(b);
        this.jTextFieldDepth2.setEnabled(b);
    }

    private void setUnitEnabled(boolean b) {
        this.jComboBoxScheme.setEnabled(b);
        this.jComboBoxUnit.setEnabled(b);
    }

    private void initSchemes() throws SQLException {
        this.jComboBoxScheme.removeAllItems();
        this.jComboBoxUnit.removeAllItems();
        Collection coll = this.db.getIGDSchemes(3);
        if (coll != null) {
            for (IGDScheme o : coll) {
                this.jComboBoxScheme.addItem(o);
            }
        }
        if ((coll = this.db.getIGDSchemes(2)) != null) {
            for (IGDScheme o : coll) {
                this.jComboBoxScheme.addItem(o);
            }
        }
        if ((coll = this.db.getIGDSchemes(4)) != null) {
            for (IGDScheme o : coll) {
                this.jComboBoxScheme.addItem(o);
            }
        }
        if (lastScheme != null) {
            this.jComboBoxScheme.setSelectedItem(lastScheme);
            if (lastUnit != null) {
                this.jComboBoxUnit.setSelectedItem(lastUnit);
            }
        }
    }
}

