/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import model2.SBdb;
import model2.Taxon;
import util.SB;

public class DialogSelectTaxaAdvDict
extends JDialog {
    private final SBdb sbdb;
    List<Taxon> selection = null;
    private JButton jButtonCancel;
    private JButton jButtonSearch;
    private JFormattedTextField jFormattedTextFieldDateFrom;
    private JFormattedTextField jFormattedTextFieldDateTo;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JPanel jPanelDates;

    public DialogSelectTaxaAdvDict(Frame parent, boolean modal, SBdb sbdb) {
        super(parent, modal);
        this.sbdb = sbdb;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setTitle("Search Dictionary");
        this.getRootPane().setDefaultButton(this.jButtonSearch);
        SB.initSBDateFormatter((JFormattedTextField)this.jFormattedTextFieldDateTo, null);
        SB.initSBDateFormatter((JFormattedTextField)this.jFormattedTextFieldDateFrom, null);
    }

    private void initComponents() {
        this.jPanelDates = new JPanel();
        this.jLabel3 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jFormattedTextFieldDateFrom = new JFormattedTextField();
        this.jFormattedTextFieldDateTo = new JFormattedTextField();
        this.jButtonCancel = new JButton();
        this.jButtonSearch = new JButton();
        this.setDefaultCloseOperation(2);
        this.jPanelDates.setBorder(BorderFactory.createTitledBorder(null, "Dates", 0, 0, null, new Color(51, 102, 204)));
        this.jLabel3.setText("Created or modified between:");
        this.jLabel1.setText("and");
        this.jFormattedTextFieldDateFrom.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                DialogSelectTaxaAdvDict.this.jFormattedTextFieldDateFromFocusLost(evt);
            }
        });
        this.jFormattedTextFieldDateTo.setToolTipText("Leave blank for today");
        GroupLayout jPanelDatesLayout = new GroupLayout(this.jPanelDates);
        this.jPanelDates.setLayout(jPanelDatesLayout);
        jPanelDatesLayout.setHorizontalGroup(jPanelDatesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelDatesLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jFormattedTextFieldDateFrom, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jFormattedTextFieldDateTo, -2, 100, -2).addGap(19, 19, 19)));
        jPanelDatesLayout.setVerticalGroup(jPanelDatesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelDatesLayout.createSequentialGroup().addContainerGap().addGroup(jPanelDatesLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jLabel1).addComponent(this.jFormattedTextFieldDateFrom, -2, -1, -2).addComponent(this.jFormattedTextFieldDateTo, -2, -1, -2)).addContainerGap(14, Short.MAX_VALUE)));
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectTaxaAdvDict.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonSearch.setText("Search");
        this.jButtonSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectTaxaAdvDict.this.jButtonSearchActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonSearch).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addComponent(this.jPanelDates, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(0, this.jButtonCancel, this.jButtonSearch);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jPanelDates, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonSearch)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonSearchActionPerformed(ActionEvent evt) {
        Date fromDate = (Date)this.jFormattedTextFieldDateFrom.getValue();
        if (fromDate == null) {
            JOptionPane.showMessageDialog(this, "Enter a start date", this.getTitle(), 2);
            return;
        }
        Date toDate = (Date)this.jFormattedTextFieldDateTo.getValue();
        if (toDate == null) {
            toDate = new Date();
        }
        try {
            this.selection = Taxon.search((SBdb)this.sbdb, (Date)fromDate, (Date)toDate);
            if (this.selection == null || this.selection.isEmpty()) {
                JOptionPane.showMessageDialog(this, "No taxa found", this.getTitle(), 2);
                return;
            }
            this.dispose();
        }
        catch (Exception e) {
            SB.showStackError((String)"Error searching for taxa", (Exception)e);
        }
    }

    private void jFormattedTextFieldDateFromFocusLost(FocusEvent evt) {
        if (this.jFormattedTextFieldDateFrom.getValue() != null && this.jFormattedTextFieldDateTo.getValue() == null) {
            this.jFormattedTextFieldDateTo.setValue(new Date());
        }
    }
}

