/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import jsbugs.DialogUnit;
import jsbugs.FrameJsbugs;
import jsbugs.SBDialog;
import model2.IGDScheme;
import model2.IGDUnit;
import org.jdesktop.layout.GroupLayout;
import util.SB;

public class DialogSelectUnit
extends SBDialog {
    private final IGDScheme scheme;
    private final DefaultListModel model = new DefaultListModel();
    private static IGDUnit last = null;
    IGDUnit selection = null;
    private JButton jButtonAdd;
    private JButton jButtonCancel;
    private JButton jButtonDelete;
    private JButton jButtonEdit;
    private JButton jButtonOK;
    private JList jListUnits;
    private JScrollPane jScrollPane1;

    public DialogSelectUnit(JDialog parent, boolean modal, IGDScheme scheme, IGDUnit initialSelection) throws SQLException {
        super((Dialog)parent, modal);
        this.scheme = scheme;
        this.setTitle("Unit : Select");
        this.initComponents();
        this.init(initialSelection);
    }

    private void init(IGDUnit initialSelection) throws SQLException {
        this.scheme.loadUnits();
        this.loadUnits(initialSelection == null ? last : initialSelection);
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void loadUnits(IGDUnit initialSelection) {
        String selector = null;
        this.model.clear();
        this.model.addElement(" ");
        for (IGDUnit unit : this.scheme.getUnitsX()) {
            String hier = "";
            for (int i = 0; i < unit.getHier(); ++i) {
                hier = hier + "  ";
            }
            if (initialSelection == unit) {
                selector = hier + unit;
            }
            this.model.addElement(hier + unit);
        }
        this.jListUnits.setSelectedValue(selector, true);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jListUnits = new JList();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonAdd = new JButton();
        this.jButtonEdit = new JButton();
        this.jButtonDelete = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(325, 375));
        this.setModal(true);
        this.jListUnits.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.jListUnits.setModel(this.model);
        this.jListUnits.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DialogSelectUnit.this.jListUnitsMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListUnits);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectUnit.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectUnit.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectUnit.this.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText("Edit...");
        this.jButtonEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectUnit.this.jButtonEditActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectUnit.this.jButtonDeleteActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 234, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jButtonCancel).add((Component)this.jButtonDelete).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jButtonAdd).add((Component)this.jButtonEdit)).add((Component)this.jButtonOK)).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonAdd).addPreferredGap(0).add((Component)this.jButtonEdit).addPreferredGap(0).add((Component)this.jButtonDelete).addPreferredGap(0, 175, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonCancel)).add((Component)this.jScrollPane1, -1, 308, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.jListUnits.getSelectedIndex() < 1) {
            JOptionPane.showMessageDialog(this, "Select a unit from the list", this.getTitle(), 2);
            return;
        }
        try {
            this.selection = (IGDUnit)this.scheme.getUnitsX().get(this.jListUnits.getSelectedIndex() - 1);
            if (this.selection.getNoccs(true) > 0) {
                JOptionPane.showMessageDialog(this, "Unit occurs " + this.selection.getNoccs(false) + " times, you cannot delete this unit here", this.getTitle(), 2);
                return;
            }
            if (JOptionPane.showConfirmDialog(this, "Are you sure you want to delete " + this.selection.getName() + "?", this.getTitle(), 0, 2) != 0) {
                return;
            }
            this.scheme.deleteUnit(this.selection);
            this.scheme.getDatabase().commit();
            this.loadUnits(null);
        }
        catch (SQLException sql) {
            this.scheme.getDatabase().doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.scheme.getDatabase());
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jListUnitsMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonOKActionPerformed(null);
        }
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        if (this.jListUnits.getSelectedIndex() < 1) {
            JOptionPane.showMessageDialog(this, "Select a unit from the list", this.getTitle(), 2);
            return;
        }
        try {
            this.selection = (IGDUnit)this.scheme.getUnitsX().get(this.jListUnits.getSelectedIndex() - 1);
            if (this.selection.getNoccs(true) > 0 && JOptionPane.showConfirmDialog(this, "Unit occurs " + this.selection.getNoccs(false) + " times, are you sure you want to edit it?", this.getTitle(), 0, 2) != 0) {
                return;
            }
            DialogUnit dialog = new DialogUnit(this, true, this.scheme, this.selection);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.loadUnits(dialog.unit);
            }
        }
        catch (SQLException sql) {
            this.scheme.getDatabase().doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.scheme.getDatabase());
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        DialogUnit dialog = new DialogUnit(this, true, this.scheme, null);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.unit != null) {
            this.loadUnits(dialog.unit);
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jListUnits.getSelectedIndex() < 0) {
            JOptionPane.showMessageDialog(this, "Select a unit from the list", this.getTitle(), 2);
            return;
        }
        int index = this.jListUnits.getSelectedIndex();
        if (index == 0) {
            this.selection = null;
        } else {
            last = this.selection = (IGDUnit)this.scheme.getUnitsX().get(index - 1);
        }
        this.setOK();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.selection = null;
        this.dispose();
    }
}

