/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import jsbugs.DialogList;
import jsbugs.DialogVersionHeader;
import jsbugs.FrameJsbugs;
import model2.InterpHdr;
import model2.Project;
import model2.SBdb;
import model2.Well;
import model2.WellInterp;
import model2.WsWell;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;

public class DialogSelectVersion
extends JDialog {
    SBdb db;
    DefaultListModel model = new DefaultListModel();
    List<InterpHdr> selection = null;
    List<Well> project = null;
    private ButtonGroup buttonGroupVersion;
    private JButton jButtonAdd;
    private JButton jButtonCancel;
    private JButton jButtonDelete;
    private JButton jButtonEdit;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonShowWells;
    private JList jListVersion;
    private JPanel jPanel1;
    private JRadioButton jRadioButtonAll;
    private JRadioButton jRadioButtonWells;
    private JScrollPane jScrollPane1;

    public DialogSelectVersion(Frame parent, boolean modal, SBdb db, boolean singleSelection, Project project) throws SQLException {
        super(parent, modal);
        this.db = db;
        this.project = new LinkedList<Well>();
        Iterator it = project.getWellIterator();
        while (it.hasNext()) {
            this.project.add((Well)it.next());
        }
        this.setLocation(parent.getLocation().x + 25, parent.getLocation().y + 25);
        this.initComponents();
        this.init(singleSelection);
    }

    public DialogSelectVersion(Dialog parent, boolean modal, SBdb db, List<Well> wells) throws SQLException {
        super(parent, modal);
        this.db = db;
        this.project = wells;
        this.initComponents();
        this.init(true);
    }

    private void init(boolean singleSelection) throws SQLException {
        if (this.project != null && this.project.size() > 0) {
            this.jRadioButtonWells.setSelected(true);
        } else {
            this.jRadioButtonWells.setEnabled(false);
            this.jRadioButtonAll.setSelected(true);
        }
        this.loadList();
        if (singleSelection) {
            this.jListVersion.setSelectionMode(0);
        }
        this.setTitle("Version : Select");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        InterpHdr.setDisplayDefault((boolean)true);
    }

    private void loadList() throws SQLException {
        this.model.clear();
        if (this.jRadioButtonAll.isSelected()) {
            List interps = this.db.getInterps();
            for (Object o : interps) {
                InterpHdr interp = (InterpHdr)o;
                this.model.addElement(interp);
            }
        } else {
            try {
                for (Well well : this.project) {
                    if (well instanceof WsWell && ((WsWell)well).getLink() != null) {
                        well = ((WsWell)well).getLink();
                    }
                    well.loadInterps();
                    Iterator iit = well.getInterpIterator();
                    while (iit.hasNext()) {
                        WellInterp wellInterp = (WellInterp)iit.next();
                        if (this.model.contains(wellInterp.getHeader())) continue;
                        this.model.addElement(wellInterp.getHeader());
                    }
                }
            }
            catch (Exception e) {
                SB.showStackError((String)"Error", (Exception)e);
                this.db.doRollback();
            }
        }
    }

    private void initComponents() {
        this.buttonGroupVersion = new ButtonGroup();
        this.jButtonShowWells = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonEdit = new JButton();
        this.jButtonAdd = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jListVersion = new JList();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonOK = new JButton();
        this.jPanel1 = new JPanel();
        this.jRadioButtonAll = new JRadioButton();
        this.jRadioButtonWells = new JRadioButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(370, 300));
        this.setModal(true);
        this.jButtonShowWells.setText("Show wells...");
        this.jButtonShowWells.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonShowWells.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectVersion.this.jButtonShowWellsActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete...");
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectVersion.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText("Edit...");
        this.jButtonEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectVersion.this.jButtonEditActionPerformed(evt);
            }
        });
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectVersion.this.jButtonAddActionPerformed(evt);
            }
        });
        this.jListVersion.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.jListVersion.setModel(this.model);
        this.jListVersion.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DialogSelectVersion.this.jListVersionMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListVersion);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectVersion.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectVersion.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectVersion.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Restrict display", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.buttonGroupVersion.add(this.jRadioButtonAll);
        this.jRadioButtonAll.setText("All versions");
        this.jRadioButtonAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectVersion.this.jRadioButtonAllActionPerformed(evt);
            }
        });
        this.buttonGroupVersion.add(this.jRadioButtonWells);
        this.jRadioButtonWells.setText("Selected well(s) only");
        this.jRadioButtonWells.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectVersion.this.jRadioButtonWellsActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.jRadioButtonAll).addPreferredGap(1).add((Component)this.jRadioButtonWells).addContainerGap(50, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jRadioButtonAll).add((Component)this.jRadioButtonWells)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -2, -1, -2).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jScrollPane1, -1, 272, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(2, false).add((Component)this.jButtonCancel, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonHelp, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonOK, -1, -1, Short.MAX_VALUE)).add((Component)this.jButtonEdit, -1, 85, Short.MAX_VALUE).add((Component)this.jButtonAdd, -1, 85, Short.MAX_VALUE).add((Component)this.jButtonDelete, -1, 85, Short.MAX_VALUE).add((Component)this.jButtonShowWells, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonAdd, this.jButtonCancel, this.jButtonDelete, this.jButtonEdit, this.jButtonHelp, this.jButtonOK, this.jButtonShowWells}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel1, -2, -1, -2).add(9, 9, 9).add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonAdd).addPreferredGap(0).add((Component)this.jButtonEdit).addPreferredGap(0).add((Component)this.jButtonDelete).addPreferredGap(0).add((Component)this.jButtonShowWells).addPreferredGap(0, 105, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel)).add((Component)this.jScrollPane1, -1, 296, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        InterpHdr interp = (InterpHdr)this.jListVersion.getSelectedValue();
        if (interp == null) {
            JOptionPane.showMessageDialog(this, "No version selected", this.getTitle(), 2);
            return;
        }
        try {
            if (interp.getInterpID() == 0) {
                JOptionPane.showMessageDialog(this, "You can't delete the Default Version.", this.getTitle(), 2);
                return;
            }
            if (interp.getDatabase() == null || !interp.getDatabase().isConnected()) {
                JOptionPane.showMessageDialog(this, "You can't delete a workspace version, use Remove Selected Version tab in Organiser instead.", this.getTitle(), 2);
                return;
            }
            List wellList = interp.findWells();
            String msg = "No well/outcrop data for version '" + interp + "'. Continue to delete?";
            if (wellList.size() > 0) {
                msg = "Warning: Version is used for data in " + wellList.size() + " well/outcrops.\nDo you want to delete version and ALL these data?";
            }
            if (JOptionPane.showConfirmDialog(this, msg, this.getTitle(), 0, 3) != 0) {
                return;
            }
            interp.delete();
            this.model.removeElement(interp);
            this.jListVersion.updateUI();
            this.db.commit();
        }
        catch (SQLException sql) {
            this.db.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jListVersionMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonOKActionPerformed(null);
        }
    }

    private void jButtonShowWellsActionPerformed(ActionEvent evt) {
        InterpHdr interp = (InterpHdr)this.jListVersion.getSelectedValue();
        if (interp == null) {
            JOptionPane.showMessageDialog(this, "No version selected", this.getTitle(), 2);
            return;
        }
        try {
            if (interp.getDatabase() == null || !interp.getDatabase().isConnected()) {
                JOptionPane.showMessageDialog(this, "You can't perform this operation on the workspace version.", this.getTitle(), 2);
                return;
            }
            List wellList = interp.findWells();
            DialogList dialog = new DialogList(this, false, "Wells : " + interp.toString(), this.db, wellList, true, false);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            SB.showStackError((String)"Error", (Exception)e);
        }
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        InterpHdr interp = (InterpHdr)this.jListVersion.getSelectedValue();
        if (interp == null) {
            JOptionPane.showMessageDialog(this, "No version selected", this.getTitle(), 2);
            return;
        }
        if (interp.getDatabase() == null || !interp.getDatabase().isConnected()) {
            JOptionPane.showMessageDialog(this, "You can't perform this operation on the workspace version.", this.getTitle(), 2);
            return;
        }
        if (interp.getInterpID() == 0 && (this.db.getUser().getPriv() & 0x40) == 0) {
            JOptionPane.showMessageDialog(this, "You must be a super-user to edit the Default Version", "Edit Default Version", 2);
            return;
        }
        try {
            DialogVersionHeader dialog = new DialogVersionHeader((JDialog)this, true, this.db, interp);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK) {
                this.loadList();
                this.jListVersion.setSelectedValue(dialog.interpHdr, true);
            }
        }
        catch (Exception e) {
            SB.showStackError((String)"Error", (Exception)e);
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        Object[] rows = this.jListVersion.getSelectedValues();
        if (rows.length == 0) {
            JOptionPane.showMessageDialog(this, "No version selected", this.getTitle(), 2);
            return;
        }
        this.selection = new LinkedList<InterpHdr>();
        for (Object row : rows) {
            this.selection.add((InterpHdr)row);
        }
        this.dispose();
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        try {
            DialogVersionHeader dialog = new DialogVersionHeader((JDialog)this, true, this.db, (InterpHdr)null);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK) {
                this.loadList();
                this.jListVersion.setSelectedValue(dialog.interpHdr, true);
            }
        }
        catch (Exception e) {
            SB.showStackError((String)"Error", (Exception)e);
        }
    }

    @Override
    public void dispose() {
        InterpHdr.setDisplayDefault((boolean)false);
        super.dispose();
    }

    private void jRadioButtonWellsActionPerformed(ActionEvent evt) {
        try {
            this.loadList();
        }
        catch (Exception e) {
            SB.showStackError((String)"Error", (Exception)e);
        }
    }

    private void jRadioButtonAllActionPerformed(ActionEvent evt) {
        try {
            this.loadList();
        }
        catch (Exception e) {
            SB.showStackError((String)"Error", (Exception)e);
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogselectversion.html");
    }
}

