/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableModel;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelWells;
import model2.Lastval;
import model2.SBdb;
import model2.WellSearchResult;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;
import util.TableSorter;

public class DialogSelectWellMaster
extends JDialog {
    SBdb sbdb;
    String selectedWellCode = null;
    TableModelWells model = new TableModelWells(false);
    TableSorter sorter = new TableSorter((TableModel)this.model);
    static final String TABLE_COLUMN_LASTVAL = "TABLESW";
    private JButton jButtonCancel;
    private JButton jButtonClear;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonSearch;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JTable jTableWells;
    private JTextField jTextFieldCountry;
    private JTextField jTextFieldWellCode;
    private JTextField jTextFieldWellName;

    public DialogSelectWellMaster(JDialog parent, boolean modal, SBdb SB2, String wellName) {
        super((Dialog)parent, modal);
        this.sbdb = SB2;
        this.setTitle("Well Master : Select");
        this.initComponents();
        this.setLocation(parent.getLocation().x + 25, parent.getLocation().y + 25);
        this.init(wellName);
    }

    private void init(String wellName) {
        this.getRootPane().setDefaultButton(this.jButtonSearch);
        for (int i = 0; i < this.model.maxColumn; ++i) {
            this.jTableWells.getColumnModel().getColumn(i).setHeaderValue(TableModelWells.columnHeaders[i]);
            this.jTableWells.getColumnModel().getColumn(i).setWidth(TableModelWells.columnWidths[i]);
        }
        SB.setTableHeaderBold((JTable)this.jTableWells);
        this.jTableWells.setSelectionMode(0);
        this.sorter.addMouseListenerToHeaderInTable(this.jTableWells);
        try {
            this.sbdb.setTableColumnWidths(TABLE_COLUMN_LASTVAL, this.jTableWells);
            if (wellName != null && wellName.length() > 0) {
                this.jTextFieldWellName.setText(wellName + "%");
                this.jTextFieldWellName.setCaretPosition(wellName.length() - 1);
            } else {
                String defaults = Lastval.getString((SBdb)this.sbdb, (String)"JWSEARCH");
                if (defaults == null || defaults.length() == 0) {
                    defaults = "%|%|%|%|";
                }
                StringTokenizer tok = new StringTokenizer(defaults, "|");
                this.jTextFieldWellName.setText((String)tok.nextElement());
                this.jTextFieldWellName.setCaretPosition(this.jTextFieldWellName.getText().length() - 1);
                this.jTextFieldWellCode.setText((String)tok.nextElement());
                this.jTextFieldWellCode.setCaretPosition(this.jTextFieldWellCode.getText().length() - 1);
                this.jTextFieldCountry.setText((String)tok.nextElement());
                this.jTextFieldCountry.setCaretPosition(this.jTextFieldCountry.getText().length() - 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jTextFieldWellName = new JTextField();
        this.jTextFieldWellCode = new JTextField();
        this.jTextFieldCountry = new JTextField();
        this.jButtonSearch = new JButton();
        this.jButtonClear = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTableWells = new JTable();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(400, 400));
        this.jPanel2.setMinimumSize(new Dimension(400, 300));
        this.jLabel1.setText("Well name:");
        this.jLabel2.setText("Well code:");
        this.jLabel3.setText("Country:");
        this.jTextFieldWellName.setText("%");
        this.jTextFieldWellCode.setText("%");
        this.jTextFieldCountry.setText("%");
        this.jButtonSearch.setText("Search");
        this.jButtonSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectWellMaster.this.jButtonSearchActionPerformed(evt);
            }
        });
        this.jButtonClear.setText("Clear");
        this.jButtonClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectWellMaster.this.jButtonClearActionPerformed(evt);
            }
        });
        this.jTableWells.setModel((TableModel)this.sorter);
        this.jTableWells.setAutoResizeMode(4);
        this.jTableWells.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DialogSelectWellMaster.this.jTableWellsMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableWells);
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectWellMaster.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectWellMaster.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSelectWellMaster.this.jButtonHelpActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(2).add(1, (Component)this.jScrollPane1, -1, 456, Short.MAX_VALUE).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(2).add((Component)this.jLabel2).add((Component)this.jLabel3).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jTextFieldWellCode, -1, 171, Short.MAX_VALUE).add((Component)this.jTextFieldWellName, -1, 171, Short.MAX_VALUE).add((Component)this.jTextFieldCountry, -1, 171, Short.MAX_VALUE)).add(228, 228, 228)).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel))).add(18, 18, 18)).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jButtonSearch).addPreferredGap(0).add((Component)this.jButtonClear).addContainerGap(338, Short.MAX_VALUE)))));
        jPanel2Layout.linkSize(new Component[]{this.jButtonClear, this.jButtonSearch}, 1);
        jPanel2Layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jTextFieldWellName, -2, -1, -2).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jTextFieldWellCode, -2, -1, -2).add((Component)this.jLabel2)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jTextFieldCountry, -2, -1, -2).add((Component)this.jLabel3)).add(12, 12, 12).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jButtonClear).add((Component)this.jButtonSearch)).addPreferredGap(1).add((Component)this.jScrollPane1, -1, 374, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonHelp).add((Component)this.jButtonOK)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void jTableWellsMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonOKActionPerformed(null);
        }
    }

    private void jButtonClearActionPerformed(ActionEvent evt) {
        this.jTextFieldWellName.setText("%");
        this.jTextFieldWellName.setCaretPosition(this.jTextFieldWellName.getText().length() - 1);
        this.jTextFieldWellCode.setText("%");
        this.jTextFieldWellCode.setCaretPosition(this.jTextFieldWellCode.getText().length() - 1);
        this.jTextFieldCountry.setText("%");
        this.jTextFieldCountry.setCaretPosition(this.jTextFieldCountry.getText().length() - 1);
        this.jTextFieldWellName.requestFocusInWindow();
    }

    private void jButtonSearchActionPerformed(ActionEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.model.results = WellSearchResult.searchMaster((SBdb)this.sbdb, (String)this.jTextFieldWellName.getText(), (String)this.jTextFieldWellCode.getText(), (String)this.jTextFieldCountry.getText());
            if (this.model.results.isEmpty()) {
                JOptionPane.showMessageDialog(this, "No wells found", this.getTitle(), 1);
            }
            this.sorter.reallocateIndexes();
            this.sorter.fireTableDataChanged();
        }
        catch (SBException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), this.getTitle(), 0);
        }
        catch (SQLException sqle) {
            JOptionPane.showMessageDialog(this, sqle.getMessage() + '\n' + SB.sql, "SQL Error", 0);
            sqle.printStackTrace();
        }
        this.setCursor(Cursor.getDefaultCursor());
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jTableWells.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "No well selected", this.getTitle(), 2);
            return;
        }
        this.selectedWellCode = this.model.results.get(this.sorter.getIndexOf(this.jTableWells.getSelectedRow())).getWellCode();
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogselectwellmaster.html");
    }
}

