/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import jsbugs.FrameJsbugs;
import jsbugs.FrameTaxaDB;
import jsbugs.InternalFrameGroup;
import model2.SBdb;
import model2.TxGroup;
import model2.TxGroupSet;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;

public class DialogSet
extends JDialog {
    SBdb sbdb;
    TxGroupSet set;
    DefaultListModel setGroupModel = new DefaultListModel();
    DefaultListModel availGroupModel = new DefaultListModel();
    static final int NAME_LEN = 30;
    FrameTaxaDB parent = null;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonMoveIn;
    private JButton jButtonMoveOut;
    private JButton jButtonOK;
    private JButton jButtonShowGroup;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JList jListAvailGroups;
    private JList jListSetGroups;
    private JScrollPane jScrollPaneAvail;
    private JScrollPane jScrollPaneSet;
    private JSeparator jSeparator1;
    private JTextField jTextFieldName;

    public DialogSet(Frame parent, boolean modal, SBdb sbdb, TxGroupSet set) throws SQLException, SBException {
        super(parent, modal);
        this.sbdb = sbdb;
        this.set = set;
        if (parent instanceof FrameTaxaDB) {
            this.parent = (FrameTaxaDB)parent;
        }
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException, SBException {
        LinkedList availGroups = new LinkedList(this.sbdb.getTxGroups());
        Collections.sort(availGroups);
        if (this.set != null) {
            this.jTextFieldName.setText(this.set.getName());
            List groups = this.set.getGroups();
            for (TxGroup group : groups) {
                this.setGroupModel.addElement(group);
            }
            availGroups.removeAll(groups);
        }
        for (TxGroup group : availGroups) {
            this.availGroupModel.addElement(group);
        }
        this.jListAvailGroups.repaint();
        if (this.parent == null) {
            this.jButtonShowGroup.setEnabled(false);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jScrollPaneSet = new JScrollPane();
        this.jListSetGroups = new JList();
        this.jScrollPaneAvail = new JScrollPane();
        this.jListAvailGroups = new JList();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jButtonMoveIn = new JButton();
        this.jButtonMoveOut = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jButtonHelp = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonShowGroup = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(400, 250));
        this.setModal(true);
        this.jLabel1.setText("Name:");
        this.jTextFieldName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogSet.this.jTextFieldNameKeyTyped(evt);
            }
        });
        this.jListSetGroups.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.jListSetGroups.setModel(this.setGroupModel);
        this.jListSetGroups.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DialogSet.this.jListSetGroupsMouseClicked(evt);
            }
        });
        this.jScrollPaneSet.setViewportView(this.jListSetGroups);
        this.jListAvailGroups.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.jListAvailGroups.setModel(this.availGroupModel);
        this.jListAvailGroups.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DialogSet.this.jListAvailGroupsMouseClicked(evt);
            }
        });
        this.jScrollPaneAvail.setViewportView(this.jListAvailGroups);
        this.jLabel2.setText("Groups in set:");
        this.jLabel3.setText("Available groups:");
        this.jButtonMoveIn.setText("<");
        this.jButtonMoveIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSet.this.jButtonMoveInActionPerformed(evt);
            }
        });
        this.jButtonMoveOut.setText(">");
        this.jButtonMoveOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSet.this.jButtonMoveOutActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSet.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSet.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSet.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonShowGroup.setText("Show...");
        this.jButtonShowGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSet.this.jButtonShowGroupActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jSeparator1, -1, 537, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jTextFieldName, -1, 502, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jScrollPaneSet, -1, 227, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jButtonShowGroup, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonMoveOut, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonMoveIn, -1, -1, Short.MAX_VALUE))).add((Component)this.jLabel2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel3).add((Component)this.jScrollPaneAvail, -1, 227, Short.MAX_VALUE))).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jTextFieldName, -2, -1, -2)).add(22, 22, 22).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jScrollPaneSet, -1, 292, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonMoveIn).addPreferredGap(0).add((Component)this.jButtonMoveOut).add(3, 3, 3).add((Component)this.jButtonShowGroup)))).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel3).addPreferredGap(0).add((Component)this.jScrollPaneAvail, -1, 292, Short.MAX_VALUE))).addPreferredGap(1).add((Component)this.jSeparator1, -2, 3, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonHelp).add((Component)this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        String name = this.jTextFieldName.getText().trim();
        if (name.length() == 0) {
            JOptionPane.showMessageDialog(this, "No set name entered.", this.getTitle(), 2);
            return;
        }
        if (this.setGroupModel.isEmpty()) {
            JOptionPane.showMessageDialog(this, "No groups selected.", this.getTitle(), 2);
            return;
        }
        try {
            TxGroupSet newSet = this.sbdb.getTxGroupSet(name);
            if (newSet != null) {
                if (this.set == null) {
                    JOptionPane.showMessageDialog(this, "A set of that name already exists", this.getTitle(), 2);
                    return;
                }
                if (this.set.getID() != newSet.getID()) {
                    JOptionPane.showMessageDialog(this, "A set of the new name already exists", this.getTitle(), 2);
                    return;
                }
            }
            Enumeration e = this.setGroupModel.elements();
            LinkedList<TxGroup> groups = new LinkedList<TxGroup>();
            while (e.hasMoreElements()) {
                groups.add((TxGroup)e.nextElement());
            }
            if (this.set == null) {
                this.set = this.sbdb.addTxGroupSet(name, groups);
            } else {
                this.set.update(name, groups);
                this.set.notifyObservers();
            }
            this.sbdb.commit();
            this.dispose();
        }
        catch (Exception e) {
            SB.showStackError((String)"Error saving set: ", (Exception)e);
            this.sbdb.doRollback();
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonMoveInActionPerformed(ActionEvent evt) {
        Object[] selection = this.jListAvailGroups.getSelectedValues();
        int[] scrollIndices = new int[selection.length];
        int n = 0;
        for (Object o : selection) {
            boolean inserted = false;
            for (int i = 0; i < this.setGroupModel.getSize(); ++i) {
                Object element = this.setGroupModel.elementAt(i);
                if (o.toString().compareToIgnoreCase(element.toString()) >= 0) continue;
                this.setGroupModel.add(i, o);
                scrollIndices[n++] = i;
                inserted = true;
                break;
            }
            if (!inserted) {
                scrollIndices[n++] = this.setGroupModel.getSize();
                this.setGroupModel.addElement(o);
            }
            this.availGroupModel.removeElement(o);
        }
        this.jListSetGroups.repaint();
        this.jListAvailGroups.repaint();
        this.jListSetGroups.setSelectedIndices(scrollIndices);
    }

    private void jButtonMoveOutActionPerformed(ActionEvent evt) {
        Object[] selection = this.jListSetGroups.getSelectedValues();
        int[] scrollIndices = new int[selection.length];
        int n = 0;
        for (Object o : selection) {
            boolean inserted = false;
            for (int i = 0; i < this.availGroupModel.getSize(); ++i) {
                Object element = this.availGroupModel.elementAt(i);
                if (o.toString().compareToIgnoreCase(element.toString()) >= 0) continue;
                this.availGroupModel.add(i, o);
                scrollIndices[n++] = i;
                inserted = true;
                break;
            }
            if (!inserted) {
                scrollIndices[n++] = this.availGroupModel.getSize();
                this.availGroupModel.addElement(o);
            }
            this.setGroupModel.removeElement(o);
        }
        this.jListSetGroups.repaint();
        this.jListAvailGroups.repaint();
        this.jListAvailGroups.setSelectedIndices(scrollIndices);
    }

    private void jListSetGroupsMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonShowGroupActionPerformed(null);
        }
    }

    private void jListAvailGroupsMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonMoveInActionPerformed(null);
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogset.html");
    }

    private void jTextFieldNameKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldName, (int)30, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonShowGroupActionPerformed(ActionEvent evt) {
        Object[] selection;
        for (Object o : selection = this.jListSetGroups.getSelectedValues()) {
            TxGroup group = (TxGroup)o;
            try {
                InternalFrameGroup frame = this.parent.getGroupFrame(group);
                if (frame != null) {
                    frame.setIcon(false);
                    frame.setVisible(true);
                    frame.setLocation(50, 50);
                    return;
                }
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.parent.createInternalFrameGroup(group);
            }
            catch (Exception e) {
                SB.showStackError((String)"Error opening group", (Exception)e);
                this.sbdb.doRollback();
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }
}

