/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import jsbugs.DialogSourceMatches;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelSource;
import model2.SBdb;
import model2.Source;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;

public class DialogSource
extends JDialog {
    TableModelSource model = new TableModelSource();
    SBdb db;
    public Source selection = null;
    boolean isOK = false;
    private JButton jButtonAdd;
    private JButton jButtonAddEdit;
    private JButton jButtonCancel;
    private JButton jButtonDelete;
    private JButton jButtonMatches;
    private JButton jButtonOK;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JTable jTableSource;

    public DialogSource(JDialog parent, boolean modal, SBdb db) throws SQLException {
        super((Dialog)parent, modal);
        this.db = db;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException {
        this.setTitle("Data Source : Select");
        this.model.setupTable(this.jTableSource, Source.getSources((SBdb)this.db));
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTableSource = new JTable();
        this.jButtonAdd = new JButton();
        this.jButtonMatches = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonAddEdit = new JButton();
        this.jSeparator1 = new JSeparator();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(400, 200));
        this.jTableSource.setModel(this.model);
        this.jTableSource.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DialogSource.this.jTableSourceMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableSource);
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSource.this.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonMatches.setText("Matches...");
        this.jButtonMatches.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonMatches.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSource.this.jButtonMatchesActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSource.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSource.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSource.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonAddEdit.setText("Edit...");
        this.jButtonAddEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSource.this.jButtonAddEditActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 297, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2, false).add((Component)this.jButtonCancel, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonOK, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonAdd, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonDelete, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonMatches, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonAddEdit, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jSeparator1, -2, 77, -2)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.jScrollPane1, -1, 207, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonAdd, -2, 22, -2).addPreferredGap(0).add((Component)this.jButtonAddEdit, -2, 22, -2).add(7, 7, 7).add((Component)this.jSeparator1, -2, 10, -2).add(1, 1, 1).add((Component)this.jButtonMatches, -2, 23, -2).addPreferredGap(0).add((Component)this.jButtonDelete).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonCancel))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonOK}, 2);
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jTableSource.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one row", this.getTitle(), 2);
            return;
        }
        int row = this.jTableSource.getSelectedRow();
        this.selection = this.model.sources.get(row);
        this.isOK = true;
        this.dispose();
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        String abr = null;
        abr = JOptionPane.showInputDialog(this, "Enter new Abbreviation: ", "Add Data Source", 3);
        if (abr == null) {
            return;
        }
        abr = abr.toUpperCase();
        Iterator<Source> it = this.model.sources.iterator();
        while (it.hasNext()) {
            if (!it.next().getID().equals(abr)) continue;
            JOptionPane.showMessageDialog(this, "Already exists", this.getTitle(), 2);
            return;
        }
        String name = null;
        name = JOptionPane.showInputDialog(this, "Enter a description: ", "Add Data Source", 3);
        if (name == null) {
            return;
        }
        try {
            Source source = new Source(this.db, abr, name);
            int index = 0;
            while (it.hasNext() && it.next().getID().compareTo(abr) >= 0) {
                ++index;
            }
            this.model.sources.add(index, source);
            this.model.fireTableDataChanged();
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "SQL Error", 0);
            ex.printStackTrace();
        }
    }

    private void jButtonMatchesActionPerformed(ActionEvent evt) {
        try {
            if (this.jTableSource.getSelectedRowCount() != 1) {
                JOptionPane.showMessageDialog(this, "Select one row", this.getTitle(), 2);
                return;
            }
            int row = this.jTableSource.getSelectedRow();
            this.selection = this.model.sources.get(row);
            this.setCursor(Cursor.getPredefinedCursor(3));
            DialogSourceMatches dialog = new DialogSourceMatches(this, true, this.db, this.selection);
            this.setCursor(Cursor.getDefaultCursor());
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (SQLException sql) {
            SB.showStackError((String)"SQL Error", (SQLException)sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.jTableSource.getSelectedRowCount() < 1) {
            JOptionPane.showMessageDialog(this, "Select source(s) to delete", this.getTitle(), 2);
            return;
        }
        LinkedList<Source> deleted = new LinkedList<Source>();
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            int[] toDelete = this.jTableSource.getSelectedRows();
            for (int i = 0; i < toDelete.length; ++i) {
                Source source = this.model.sources.get(toDelete[i]);
                int opt = JOptionPane.showConfirmDialog(this, "Really delete: " + source.getID() + "?\n(" + source.getNEnvs(this.db) + " environment matches and " + source.getnTxload(this.db) + " taxon matches)", this.getTitle(), 1, 3);
                if (opt == 0) {
                    source.delete(this.db);
                    deleted.add(source);
                    continue;
                }
                if (opt != 2 && opt != -1) continue;
                this.db.doRollback();
                this.model.sources.addAll(deleted);
                return;
            }
            this.model.sources.removeAll(deleted);
        }
        catch (SQLException sql) {
            this.db.doRollback();
            this.model.sources.addAll(deleted);
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        finally {
            this.jTableSource.clearSelection();
            this.model.fireTableDataChanged();
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jTableSourceMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonOKActionPerformed(null);
        }
    }

    private void jButtonAddEditActionPerformed(ActionEvent evt) {
        try {
            if (this.jTableSource.getSelectedRowCount() != 1) {
                JOptionPane.showMessageDialog(this, "Select one row", this.getTitle(), 2);
                return;
            }
            int row = this.jTableSource.getSelectedRow();
            this.selection = this.model.sources.get(row);
            Object name = null;
            name = JOptionPane.showInputDialog(this, "Enter a description: ", "Edit Data Source", 1, null, null, this.selection.getName());
            if (name == null) {
                return;
            }
            this.selection.setName(this.db, name.toString());
            this.db.commit();
            this.model.fireTableDataChanged();
        }
        catch (SQLException sql) {
            SB.showStackError((String)"SQL Error", (SQLException)sql);
        }
    }
}

