/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import jsbugs.TableModelSourceMatches;
import model2.SBdb;
import model2.Source;
import org.jdesktop.layout.GroupLayout;
import util.SBException;

public class DialogSourceMatches
extends JDialog {
    TableModelSourceMatches model = new TableModelSourceMatches();
    Source source;
    SBdb db;
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JButton jButtonSelectAll;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTable jTableMatches;

    public DialogSourceMatches(JDialog parent, boolean modal, SBdb db, Source source) throws SQLException, SBException {
        super((Dialog)parent, modal);
        this.db = db;
        this.source = source;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException, SBException {
        this.setTitle("Matches for data source: " + this.source.getID());
        this.getRootPane().setDefaultButton(this.jButtonClose);
        this.model.setupTable(this.jTableMatches);
        this.source.loadMatches(this.db, this.model.taxa, this.model.donor);
        this.model.fireTableDataChanged();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jScrollPane2 = new JScrollPane();
        this.jTableMatches = new JTable();
        this.jButtonSelectAll = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonClose = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(400, 400));
        this.jTableMatches.setModel(this.model);
        this.jScrollPane2.setViewportView(this.jTableMatches);
        this.jButtonSelectAll.setText("Select all");
        this.jButtonSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSourceMatches.this.jButtonSelectAllActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete selection");
        this.jButtonDelete.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSourceMatches.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSourceMatches.this.jButtonCloseActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane2, -1, 546, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().addPreferredGap(0).add((Component)this.jButtonDelete).addContainerGap()).add((GroupLayout.Group)layout.createSequentialGroup().addPreferredGap(0).add((Component)this.jButtonSelectAll).addContainerGap()).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonClose).addContainerGap()))));
        layout.linkSize(new Component[]{this.jButtonClose, this.jButtonDelete, this.jButtonSelectAll}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.jScrollPane2, -1, 507, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonSelectAll).addPreferredGap(0).add((Component)this.jButtonDelete).addPreferredGap(0, 432, Short.MAX_VALUE).add((Component)this.jButtonClose))).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonSelectAllActionPerformed(ActionEvent evt) {
        this.jTableMatches.selectAll();
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.jTableMatches.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "Select items(s) to delete", "Warning", 2);
            return;
        }
        try {
            int[] toDelete = this.jTableMatches.getSelectedRows();
            for (int i = toDelete.length - 1; i >= 0; --i) {
                this.source.deleteMatch(this.db, this.model.donor.get(toDelete[i]));
                this.model.taxa.remove(toDelete[i]);
                this.model.donor.remove(toDelete[i]);
                this.db.commit();
            }
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "SQL Error", 0);
        }
        this.jTableMatches.clearSelection();
        this.model.fireTableDataChanged();
    }
}

