/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import jsbugs.FrameJsbugs;
import model2.SBdb;
import util.SB;

public class DialogSpecType
extends JDialog {
    DefaultListModel model = new DefaultListModel();
    SBdb db;
    private JButton jButtonAdd;
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JButton jButtonEdit;
    private JButton jButtonHelp;
    private JButton jButtonInfo;
    private JList jListSpecType;
    private JScrollPane jScrollPane1;

    public DialogSpecType(Frame parent, boolean modal, SBdb db) throws SQLException {
        super(parent, modal);
        this.db = db;
        this.initComponents();
        this.init();
        this.setTitle("Species Sub-Types");
    }

    private void init() throws SQLException {
        this.model.clear();
        Iterator it = this.db.getSpecTypeIterator();
        while (it.hasNext()) {
            this.model.addElement(it.next());
        }
        this.jListSpecType.repaint();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jListSpecType = new JList();
        this.jButtonAdd = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonClose = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonEdit = new JButton();
        this.jButtonInfo = new JButton();
        this.setDefaultCloseOperation(2);
        this.jListSpecType.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jListSpecType);
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSpecType.this.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSpecType.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSpecType.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSpecType.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText("Edit...");
        this.jButtonEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSpecType.this.jButtonEditActionPerformed(evt);
            }
        });
        this.jButtonInfo.setText("Info...");
        this.jButtonInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSpecType.this.jButtonInfoActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 283, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonAdd).addComponent(this.jButtonEdit).addComponent(this.jButtonHelp).addComponent(this.jButtonClose).addComponent(this.jButtonDelete)).addComponent(this.jButtonInfo)).addContainerGap()));
        layout.linkSize(0, this.jButtonAdd, this.jButtonClose, this.jButtonDelete, this.jButtonEdit, this.jButtonHelp, this.jButtonInfo);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jButtonAdd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonEdit).addGap(7, 7, 7).addComponent(this.jButtonInfo).addGap(18, 18, 18).addComponent(this.jButtonDelete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 103, Short.MAX_VALUE).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonClose)).addComponent(this.jScrollPane1, -1, 278, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogspectype.html");
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        try {
            String newType = JOptionPane.showInputDialog(this, "Enter new species sub-type: ", null);
            if (newType != null) {
                while (this.db.getSpecType(newType) > 0) {
                    if ((newType = JOptionPane.showInputDialog(this, "Sub-type already exists, re-enter: ", newType)) != null) continue;
                    return;
                }
                this.db.getAddSpecType(newType);
                this.db.commit();
                this.init();
                this.jListSpecType.setSelectedValue(newType, true);
            }
        }
        catch (Exception ex) {
            SB.showStackError((String)"Error: ", (Exception)ex);
        }
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        String specType = (String)this.jListSpecType.getSelectedValue();
        if (specType == null) {
            JOptionPane.showMessageDialog(this, "No type selected", this.getTitle(), 1);
            return;
        }
        try {
            int nOccs = this.db.getSpecTypeUsage(specType);
            if (nOccs > 0 && JOptionPane.showConfirmDialog(this, "Warning: this sub-type is already used by " + nOccs + " occurrences.\nContinue edit?", this.getTitle(), 0, 3) != 0) {
                return;
            }
            int typeID = this.db.getSpecType(specType);
            String newType = specType;
            while (this.db.getSpecType(newType) > 0) {
                newType = JOptionPane.showInputDialog(this, "Species sub type: ", specType);
                if (newType == null) {
                    return;
                }
                if (newType.equals(specType)) {
                    return;
                }
                while (this.db.getSpecType(newType) > 0) {
                    if ((newType = JOptionPane.showInputDialog(this, "Sub-type already exists, re-enter: ", newType)) == null) {
                        return;
                    }
                    if (!newType.equals(specType)) continue;
                    return;
                }
            }
            this.db.updateSpecType(typeID, newType);
            this.db.commit();
            this.init();
            this.jListSpecType.setSelectedValue(newType, true);
        }
        catch (SQLException sql) {
            this.db.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonInfoActionPerformed(ActionEvent evt) {
        String specType = null;
        specType = (String)this.jListSpecType.getSelectedValue();
        if (specType == null) {
            JOptionPane.showMessageDialog(this, "No type selected", this.getTitle(), 1);
            return;
        }
        try {
            if (this.db.getSpecType(specType) > 0) {
                int nOccs = this.db.getSpecTypeUsage(specType);
                JOptionPane.showMessageDialog(this, "This sub-type is used by " + nOccs + " occurrences.", this.getTitle(), 3);
            } else {
                JOptionPane.showMessageDialog(this, "This is the default setting.", this.getTitle(), 3);
            }
        }
        catch (Exception ex) {
            SB.showStackError((String)"Error: ", (Exception)ex);
        }
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        String specType = null;
        specType = (String)this.jListSpecType.getSelectedValue();
        if (specType == null) {
            JOptionPane.showMessageDialog(this, "No type selected", this.getTitle(), 1);
            return;
        }
        try {
            int ID = this.db.getSpecType(specType);
            if (ID == 0) {
                JOptionPane.showMessageDialog(this, "You can't delete the default setting.", this.getTitle(), 1);
                return;
            }
            int nOccs = this.db.getSpecTypeUsage(specType);
            if (nOccs > 0) {
                JOptionPane.showMessageDialog(this, "This sub-type is used by " + nOccs + " occurrences, and can't be deleted.", this.getTitle(), 1);
                return;
            }
            this.db.deleteSpecType(specType);
            this.db.commit();
            this.init();
            this.jListSpecType.clearSelection();
        }
        catch (Exception ex) {
            SB.showStackError((String)"Error: ", (Exception)ex);
        }
    }
}

