/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.sql.SQLException;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import jsbugs.BlockProperties;
import jsbugs.Chart;
import jsbugs.ChartBlock;
import jsbugs.ChartProperties;
import jsbugs.DialogChartFont;
import jsbugs.DialogSelectCmpStd;
import jsbugs.DialogSelectIGDType;
import jsbugs.DialogSelectScheme;
import jsbugs.FrameJsbugs;
import jsbugs.JPanelSchemeBlock;
import jsbugs.PanelEnv;
import jsbugs.PanelWellDepthAge;
import jsbugs.PanelWellDepthAgeProperties;
import jsbugs.ProjectBlock;
import jsbugs.SBDialog;
import jsbugs.SBPanel;
import jsbugs.SchemeBlock;
import model2.EnvScheme;
import model2.InterpHdr;
import model2.LOC;
import model2.Project;
import model2.SBdb;
import model2.Well;
import model2.WellInterp;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;

public class DialogSubsidenceChart
extends SBDialog {
    private static final int DEPTHLEN = 8;
    private static final int AGELEN = 6;
    private final DefaultComboBoxModel scaleModel = new DefaultComboBoxModel();
    private final DefaultComboBoxModel interpModel = new DefaultComboBoxModel();
    private final DefaultComboBoxModel projectModel = new DefaultComboBoxModel();
    private final DefaultComboBoxModel ageScaleModel = new DefaultComboBoxModel();
    private final DefaultComboBoxModel envSchemeModel = new DefaultComboBoxModel();
    private JPanelSchemeBlock schemeBlockPanel;
    private boolean inStartup = true;
    private final SBdb db;
    private final ProjectBlock block;
    private char units;
    final PanelWellDepthAgeProperties p;
    private final PanelWellDepthAge panel;
    private ChartProperties cpCopy;
    private final Chart chart;
    private ButtonGroup buttonGroupStyle;
    private ButtonGroup buttonGroupUnits;
    private ButtonGroup buttonGroupXleft;
    private JButton jButtonCancel;
    private JButton jButtonClearComposite;
    private JButton jButtonClearScheme;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonOptions;
    private JButton jButtonSelectComposite;
    private JButton jButtonSelectScheme;
    private JCheckBox jCheckBoxEnvs;
    private JCheckBox jCheckBoxSchemeShading;
    private JCheckBox jCheckBoxShowEvents;
    private JComboBox jComboBoxAgeScale;
    private JComboBox jComboBoxEnvScheme;
    private JComboBox jComboBoxProject;
    private JComboBox jComboBoxVersion;
    private JComboBox jComboBoxVerticalScale;
    private JLabel jLabel1;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JLabel jLabelTD;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanelInterpretations;
    private JPanel jPanelPanel;
    private JRadioButton jRadioButtonFeet;
    private JRadioButton jRadioButtonMetres;
    private JRadioButton jRadioButtonStyleAccumulation;
    private JRadioButton jRadioButtonStyleSubsidence;
    private JRadioButton jRadioButtonXLeft;
    private JRadioButton jRadioButtonXRight;
    private JTabbedPane jTabbedPane1;
    private JTextField jTextFieldBaseDepth;
    private JTextField jTextFieldComposite;
    private JTextField jTextFieldMaxAge;
    private JTextField jTextFieldMinAge;
    private JTextField jTextFieldScheme;
    private JTextField jTextFieldTopDepth;

    public DialogSubsidenceChart(Frame parent, boolean modal, SBdb db, Chart chart) throws SQLException, SBException {
        super(parent, modal);
        this.db = db;
        ProjectBlock pb = null;
        PanelWellDepthAge pwda = null;
        block0: for (ChartBlock b : chart.blocks) {
            if (!(b instanceof ProjectBlock)) continue;
            pb = (ProjectBlock)b;
            for (SBPanel sbp : b.panels) {
                if (!(sbp instanceof PanelWellDepthAge)) continue;
                pwda = (PanelWellDepthAge)sbp;
                break block0;
            }
        }
        if (pb == null) {
            assert (false);
            pb = new ProjectBlock(null, db, null);
            chart.blocks.add(pb);
        }
        if (pwda == null) {
            pwda = new PanelWellDepthAge(db, pb, new PanelWellDepthAgeProperties(db, true));
            pb.addPanel(pwda);
        }
        this.block = pb;
        this.panel = pwda;
        this.initComponents();
        this.chart = chart;
        this.p = new PanelWellDepthAgeProperties(this.panel.getProperties());
        this.init();
    }

    private void init() throws SQLException, SBException {
        this.setTitle("Subsidence Chart Properties");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.fillProjectCombo();
        this.units = this.block.prop.units;
        if (this.block.prop.units == 'M') {
            this.jRadioButtonMetres.setSelected(true);
        } else {
            this.jRadioButtonFeet.setSelected(true);
        }
        for (InterpHdr interp : this.db.getInterps()) {
            this.interpModel.addElement(interp);
        }
        if (this.p.interp != null) {
            this.jComboBoxVersion.setSelectedItem(this.p.interp);
        } else {
            this.p.interp = (InterpHdr)this.jComboBoxVersion.getSelectedItem();
        }
        if (this.block.getProject() != null) {
            this.jComboBoxProject.setSelectedItem(this.block.getProject());
            this.jTextFieldTopDepth.setText("" + SB.convFromM((double)this.block.prop.min, (char)this.units));
            this.jTextFieldBaseDepth.setText("" + SB.convFromM((double)this.block.prop.max, (char)this.units));
            this.jTextFieldMinAge.setText("" + this.p.sBlock.prop.min);
            this.jTextFieldMaxAge.setText("" + this.p.sBlock.prop.max);
        }
        SchemeBlock.fillScaleCombo(this.ageScaleModel);
        if (this.p.getScheme() != null) {
            this.jTextFieldScheme.setText(this.p.getScheme().toString());
        }
        if (this.p.getCmpStd() != null) {
            this.jTextFieldComposite.setText(this.p.getCmpStd().toString());
        }
        Iterator itE = this.db.getEnvSchemes().iterator();
        while (itE.hasNext()) {
            this.envSchemeModel.addElement(itE.next());
        }
        if (this.p.getEnvPanel() != null) {
            this.jCheckBoxEnvs.setSelected(true);
            this.jComboBoxEnvScheme.setSelectedItem(this.db.getEnvScheme(this.p.getEnvPanel().getSchemeID()));
        }
        try {
            this.db.getChartScales(this.scaleModel);
        }
        catch (SQLException sql) {
            SB.showStackError((String)"SQL Error loading scales: ", (SQLException)sql);
        }
        String sScale = Integer.toString((int)this.block.getScale());
        if (this.scaleModel.getIndexOf(sScale) < 0) {
            this.scaleModel.addElement(sScale);
        }
        this.scaleModel.setSelectedItem(sScale);
        if (this.ageScaleModel.getIndexOf(Float.valueOf(this.p.sBlock.prop.scale)) >= 0) {
            this.ageScaleModel.setSelectedItem(Float.valueOf(this.p.sBlock.prop.scale));
        } else {
            this.ageScaleModel.addElement(Float.valueOf(this.p.sBlock.prop.scale));
            this.ageScaleModel.setSelectedItem(Float.valueOf(this.p.sBlock.prop.scale));
        }
        this.jRadioButtonXLeft.setSelected(this.p.sBlock.prop.ageLeftToRight);
        this.jRadioButtonXRight.setSelected(!this.p.sBlock.prop.ageLeftToRight);
        switch (this.block.prop.scaleType) {
            case TVD: {
                this.jRadioButtonStyleAccumulation.setSelected(true);
                break;
            }
            case SUBSIDENCE: {
                this.jRadioButtonStyleSubsidence.setSelected(true);
            }
        }
        this.jCheckBoxShowEvents.setSelected(this.p.drawEvents);
        this.jCheckBoxSchemeShading.setSelected(this.p.drawShading);
        this.schemeBlockPanel = new JPanelSchemeBlock(this.p.sBlock, this.db, this);
        this.jTabbedPane1.insertTab("Scheme Header", null, this.schemeBlockPanel, null, 2);
        this.inStartup = false;
        this.jComboBoxAgeScale.getEditor().getEditorComponent().addKeyListener(new CbKeyListener(this.jComboBoxAgeScale));
        this.setTDLabel();
    }

    private void fillProjectCombo() {
        this.projectModel.removeAllElements();
        try {
            this.db.getProjects().loadCombo(this.projectModel, true);
        }
        catch (SQLException sqle) {
            SB.showStackError((String)"Error loading projects", (SQLException)sqle);
            sqle.printStackTrace();
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error loading projects", (Exception)((Object)sbe));
            sbe.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDepthAgeRanges(boolean depths) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            if (depths) {
                Well baseWell;
                this.block.getProject().loadWells(this.db, null);
                Well topWell = this.block.getProject().getTopDepth();
                if (topWell != null) {
                    this.jTextFieldTopDepth.setText("" + SB.convFromM((double)topWell.getTopSampleDepth(), (char)this.units, (char)topWell.getType()));
                }
                if ((baseWell = this.block.getProject().getBaseDepth(true)) != null) {
                    double baseDepth = baseWell.getTVDlist(false).getBaseTVD();
                    if (baseDepth == 0.0) {
                        baseDepth = baseWell.getBaseSampleDepth();
                    }
                    this.jTextFieldBaseDepth.setText("" + SB.convFromM((double)baseDepth, (char)this.units, (char)baseWell.getType()));
                }
            }
            if (this.p.interp != null) {
                Double minAge = null;
                Double maxAge = null;
                Iterator wellIt = this.block.getProject().getWellIterator();
                while (wellIt.hasNext()) {
                    Well well = (Well)wellIt.next();
                    well.loadInterps();
                    if (!well.hasInterpLoaded(this.p.interp.getInterpID())) continue;
                    well.getInterp(this.p.interp.getInterpID()).loadLOC(well.getWellID());
                    LOC loc = well.getInterp(this.p.interp.getInterpID()).getLOC();
                    if (loc == null) continue;
                    double min = loc.getMinAge();
                    if (minAge == null || min < minAge) {
                        minAge = min;
                    }
                    double max = loc.getMaxAge();
                    if (maxAge != null && !(max > maxAge)) continue;
                    maxAge = max;
                }
                if (minAge != null && maxAge != null) {
                    this.jTextFieldMinAge.setText("" + SB.roundToSignificantFigures((double)minAge, (int)3));
                    this.jTextFieldMaxAge.setText("" + SB.roundToSignificantFigures((double)maxAge, (int)3));
                }
            }
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInterp(boolean forceRefresh) {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (this.p.interp == null || this.inStartup || forceRefresh && this.p.interp != (InterpHdr)this.jComboBoxVersion.getSelectedItem()) {
                this.p.interp = (InterpHdr)this.jComboBoxVersion.getSelectedItem();
                this.jTextFieldMinAge.setText("" + this.p.sBlock.prop.min);
                this.jTextFieldMaxAge.setText("" + this.p.sBlock.prop.max);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error: " + e.getMessage(), this.getTitle(), 0);
            e.printStackTrace();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void initComponents() {
        this.buttonGroupUnits = new ButtonGroup();
        this.buttonGroupXleft = new ButtonGroup();
        this.buttonGroupStyle = new ButtonGroup();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonHelp = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanelPanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.jLabel6 = new JLabel();
        this.jTextFieldMinAge = new JTextField();
        this.jLabel7 = new JLabel();
        this.jTextFieldMaxAge = new JTextField();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jPanel4 = new JPanel();
        this.jRadioButtonXLeft = new JRadioButton();
        this.jRadioButtonXRight = new JRadioButton();
        this.jComboBoxAgeScale = new JComboBox();
        this.jComboBoxVersion = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jLabel13 = new JLabel();
        this.jComboBoxProject = new JComboBox();
        this.jPanel3 = new JPanel();
        this.jRadioButtonStyleAccumulation = new JRadioButton();
        this.jRadioButtonStyleSubsidence = new JRadioButton();
        this.jPanelInterpretations = new JPanel();
        this.jCheckBoxShowEvents = new JCheckBox();
        this.jCheckBoxSchemeShading = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.jLabel14 = new JLabel();
        this.jTextFieldComposite = new JTextField();
        this.jTextFieldScheme = new JTextField();
        this.jButtonSelectScheme = new JButton();
        this.jButtonSelectComposite = new JButton();
        this.jButtonClearComposite = new JButton();
        this.jButtonClearScheme = new JButton();
        this.jCheckBoxEnvs = new JCheckBox();
        this.jComboBoxEnvScheme = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jComboBoxVerticalScale = new JComboBox();
        this.jTextFieldBaseDepth = new JTextField();
        this.jTextFieldTopDepth = new JTextField();
        this.jPanel2 = new JPanel();
        this.jRadioButtonFeet = new JRadioButton();
        this.jRadioButtonMetres = new JRadioButton();
        this.jLabelTD = new JLabel();
        this.jButtonOptions = new JButton();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSubsidenceChart.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSubsidenceChart.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSubsidenceChart.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Horizontal Axis (Age)", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.jLabel6.setText("Min age:");
        this.jTextFieldMinAge.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogSubsidenceChart.this.jTextFieldMinAgeKeyTyped(evt);
            }
        });
        this.jLabel7.setText("Max age:");
        this.jTextFieldMaxAge.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogSubsidenceChart.this.jTextFieldMaxAgeKeyTyped(evt);
            }
        });
        this.jLabel8.setText("Scale:");
        this.jLabel9.setText("mm/Ma");
        this.jLabel11.setText("Ma");
        this.jLabel12.setText("Ma");
        this.jPanel4.setBorder(BorderFactory.createTitledBorder("Age increases:"));
        this.buttonGroupXleft.add(this.jRadioButtonXLeft);
        this.jRadioButtonXLeft.setText("Left - Right");
        this.buttonGroupXleft.add(this.jRadioButtonXRight);
        this.jRadioButtonXRight.setSelected(true);
        this.jRadioButtonXRight.setText("Right - Left");
        GroupLayout jPanel4Layout = new GroupLayout((Container)this.jPanel4);
        this.jPanel4.setLayout((LayoutManager)jPanel4Layout);
        jPanel4Layout.setHorizontalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((Component)this.jRadioButtonXRight).add((Component)this.jRadioButtonXLeft)).addContainerGap(15, Short.MAX_VALUE)));
        jPanel4Layout.setVerticalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((Component)this.jRadioButtonXLeft).addPreferredGap(0).add((Component)this.jRadioButtonXRight)));
        this.jComboBoxAgeScale.setEditable(true);
        this.jComboBoxAgeScale.setModel(this.ageScaleModel);
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(2).add((Component)this.jLabel8).add((Component)this.jLabel7).add((Component)this.jLabel6)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1, false).add((Component)this.jComboBoxAgeScale, 0, 100, Short.MAX_VALUE).add((Component)this.jTextFieldMaxAge).add((Component)this.jTextFieldMinAge, -1, 100, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jLabel9).add((Component)this.jLabel11).add((Component)this.jLabel12)).addPreferredGap(0, 29, Short.MAX_VALUE).add((Component)this.jPanel4, -2, -1, -2).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(2).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel6).add((Component)this.jTextFieldMinAge, -2, -1, -2).add((Component)this.jLabel11)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel7).add((Component)this.jTextFieldMaxAge, -2, -1, -2).add((Component)this.jLabel12)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel8).add((Component)this.jLabel9).add((Component)this.jComboBoxAgeScale, -2, -1, -2))).add((Component)this.jPanel4, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jComboBoxVersion.setModel(this.interpModel);
        this.jComboBoxVersion.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSubsidenceChart.this.jComboBoxVersionActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Version:");
        this.jLabel13.setText("Project:");
        this.jComboBoxProject.setModel(this.projectModel);
        this.jComboBoxProject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSubsidenceChart.this.jComboBoxProjectActionPerformed(evt);
            }
        });
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(null, "Style", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.buttonGroupStyle.add(this.jRadioButtonStyleAccumulation);
        this.jRadioButtonStyleAccumulation.setText("Accumulation");
        this.jRadioButtonStyleAccumulation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSubsidenceChart.this.jRadioButtonStyleAccumulationActionPerformed(evt);
            }
        });
        this.buttonGroupStyle.add(this.jRadioButtonStyleSubsidence);
        this.jRadioButtonStyleSubsidence.setText("Subsidence");
        this.jRadioButtonStyleSubsidence.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSubsidenceChart.this.jRadioButtonStyleSubsidenceActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((Component)this.jRadioButtonStyleAccumulation).add(10, 10, 10).add((Component)this.jRadioButtonStyleSubsidence).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.jRadioButtonStyleAccumulation).add((Component)this.jRadioButtonStyleSubsidence)));
        GroupLayout jPanelPanelLayout = new GroupLayout((Container)this.jPanelPanel);
        this.jPanelPanel.setLayout((LayoutManager)jPanelPanelLayout);
        jPanelPanelLayout.setHorizontalGroup((GroupLayout.Group)jPanelPanelLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanelPanelLayout.createSequentialGroup().add((GroupLayout.Group)jPanelPanelLayout.createParallelGroup(2).add((Component)this.jLabel13).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)jPanelPanelLayout.createParallelGroup(1).add((Component)this.jComboBoxProject, 0, -1, Short.MAX_VALUE).add((Component)this.jComboBoxVersion, 0, -1, Short.MAX_VALUE))).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)jPanelPanelLayout.createSequentialGroup().add((Component)this.jPanel3, -2, -1, -2).add(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanelPanelLayout.setVerticalGroup((GroupLayout.Group)jPanelPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanelPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((GroupLayout.Group)jPanelPanelLayout.createParallelGroup(3).add((Component)this.jComboBoxProject, -2, -1, -2).add((Component)this.jLabel13)).add(8, 8, 8).add((GroupLayout.Group)jPanelPanelLayout.createParallelGroup(3).add((Component)this.jComboBoxVersion, -2, -1, -2).add((Component)this.jLabel1)).add(18, 18, 18).add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(1).add((Component)this.jPanel3, -2, -1, -2).add(218, 218, 218)));
        this.jTabbedPane1.addTab("Subsidence Panel", this.jPanelPanel);
        this.jCheckBoxShowEvents.setText("Show events");
        this.jCheckBoxSchemeShading.setText("Show scheme shading");
        this.jLabel2.setText("Scheme:");
        this.jLabel14.setText("Composite:");
        this.jTextFieldComposite.setEditable(false);
        this.jTextFieldComposite.setBackground(new Color(255, 255, 204));
        this.jTextFieldScheme.setEditable(false);
        this.jTextFieldScheme.setBackground(new Color(255, 255, 204));
        this.jButtonSelectScheme.setText("...");
        this.jButtonSelectScheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSubsidenceChart.this.jButtonSelectSchemeActionPerformed(evt);
            }
        });
        this.jButtonSelectComposite.setText("...");
        this.jButtonSelectComposite.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSubsidenceChart.this.jButtonSelectCompositeActionPerformed(evt);
            }
        });
        this.jButtonClearComposite.setText("Clear");
        this.jButtonClearComposite.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonClearComposite.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSubsidenceChart.this.jButtonClearCompositeActionPerformed(evt);
            }
        });
        this.jButtonClearScheme.setText("Clear");
        this.jButtonClearScheme.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonClearScheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSubsidenceChart.this.jButtonClearSchemeActionPerformed(evt);
            }
        });
        this.jCheckBoxEnvs.setText("Show palaeoenvironments:");
        this.jComboBoxEnvScheme.setModel(this.envSchemeModel);
        GroupLayout jPanelInterpretationsLayout = new GroupLayout((Container)this.jPanelInterpretations);
        this.jPanelInterpretations.setLayout((LayoutManager)jPanelInterpretationsLayout);
        jPanelInterpretationsLayout.setHorizontalGroup((GroupLayout.Group)jPanelInterpretationsLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelInterpretationsLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelInterpretationsLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelInterpretationsLayout.createSequentialGroup().add((GroupLayout.Group)jPanelInterpretationsLayout.createParallelGroup(2).add((Component)this.jLabel2).add((Component)this.jLabel14)).addPreferredGap(0).add((GroupLayout.Group)jPanelInterpretationsLayout.createParallelGroup(2).add((Component)this.jTextFieldScheme, -1, 213, Short.MAX_VALUE).add((Component)this.jTextFieldComposite)).addPreferredGap(0).add((GroupLayout.Group)jPanelInterpretationsLayout.createParallelGroup(1, false).add((Component)this.jButtonSelectScheme, -2, 28, -2).add((Component)this.jButtonSelectComposite, -2, 28, -2)).add(4, 4, 4).add((GroupLayout.Group)jPanelInterpretationsLayout.createParallelGroup(1, false).add((Component)this.jButtonClearComposite, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonClearScheme, -2, 51, -2))).add((GroupLayout.Group)jPanelInterpretationsLayout.createSequentialGroup().add((GroupLayout.Group)jPanelInterpretationsLayout.createParallelGroup(1).add((Component)this.jCheckBoxSchemeShading).add((Component)this.jCheckBoxShowEvents)).add(0, 0, Short.MAX_VALUE)).add((GroupLayout.Group)jPanelInterpretationsLayout.createSequentialGroup().add((Component)this.jCheckBoxEnvs).addPreferredGap(0).add((Component)this.jComboBoxEnvScheme, 0, -1, Short.MAX_VALUE))).addContainerGap()));
        jPanelInterpretationsLayout.setVerticalGroup((GroupLayout.Group)jPanelInterpretationsLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelInterpretationsLayout.createSequentialGroup().add(21, 21, 21).add((GroupLayout.Group)jPanelInterpretationsLayout.createParallelGroup(3).add((Component)this.jTextFieldScheme, -2, -1, -2).add((Component)this.jButtonClearScheme).add((Component)this.jButtonSelectScheme).add((Component)this.jLabel2)).addPreferredGap(0).add((GroupLayout.Group)jPanelInterpretationsLayout.createParallelGroup(3).add((Component)this.jLabel14).add((Component)this.jTextFieldComposite, -2, -1, -2).add((Component)this.jButtonSelectComposite).add((Component)this.jButtonClearComposite)).add(32, 32, 32).add((Component)this.jCheckBoxShowEvents).addPreferredGap(1).add((Component)this.jCheckBoxSchemeShading).addPreferredGap(1).add((GroupLayout.Group)jPanelInterpretationsLayout.createParallelGroup(3).add((Component)this.jCheckBoxEnvs).add((Component)this.jComboBoxEnvScheme, -2, -1, -2)).addContainerGap(83, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Interpretations", this.jPanelInterpretations);
        this.jLabel3.setHorizontalAlignment(11);
        this.jLabel3.setText("Top depth:");
        this.jLabel4.setHorizontalAlignment(11);
        this.jLabel4.setText("Base depth:");
        this.jLabel5.setHorizontalAlignment(11);
        this.jLabel5.setText("Scale:");
        this.jComboBoxVerticalScale.setEditable(true);
        this.jComboBoxVerticalScale.setModel(this.scaleModel);
        this.jTextFieldBaseDepth.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogSubsidenceChart.this.jTextFieldBaseDepthKeyTyped(evt);
            }
        });
        this.jTextFieldTopDepth.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogSubsidenceChart.this.jTextFieldTopDepthKeyTyped(evt);
            }
        });
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Depth units", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.buttonGroupUnits.add(this.jRadioButtonFeet);
        this.jRadioButtonFeet.setText("Feet");
        this.jRadioButtonFeet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSubsidenceChart.this.jRadioButtonFeetActionPerformed(evt);
            }
        });
        this.buttonGroupUnits.add(this.jRadioButtonMetres);
        this.jRadioButtonMetres.setText("Metres");
        this.jRadioButtonMetres.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSubsidenceChart.this.jRadioButtonMetresActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jRadioButtonFeet).add((Component)this.jRadioButtonMetres)).addContainerGap()));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jRadioButtonMetres).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jRadioButtonFeet)));
        this.jLabelTD.setForeground(new Color(255, 0, 0));
        this.jLabelTD.setText("<html>Note: Well TDs must be<br>set correctly</html>");
        this.jButtonOptions.setText("Options...");
        this.jButtonOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSubsidenceChart.this.jButtonOptionsActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel)).add((Component)this.jTabbedPane1, -2, 385, -2).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabel5).add((Component)this.jLabel4).add((Component)this.jLabel3)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jComboBoxVerticalScale, -2, 100, -2).add((Component)this.jTextFieldTopDepth, -2, 100, -2).add((Component)this.jTextFieldBaseDepth, -2, 100, -2)).addPreferredGap(1).add((Component)this.jPanel2, -2, -1, -2).add(18, 18, 18).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabelTD, -2, -1, -2).add((Component)this.jButtonOptions)))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.jTextFieldTopDepth, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.jTextFieldBaseDepth, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel5).add((Component)this.jComboBoxVerticalScale, -2, -1, -2))).add((GroupLayout.Group)layout.createParallelGroup(2, false).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabelTD, -2, -1, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jButtonOptions)).add((Component)this.jPanel2, -2, -1, -2))).add(18, 18, 18).add((Component)this.jTabbedPane1, -2, 294, -2).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonHelp).add((Component)this.jButtonOK)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.block.getProject() == null || this.block.getProject().getID() == 0) {
            JOptionPane.showMessageDialog(this, "You must select a project", this.getTitle(), 2);
            return;
        }
        if (this.jTextFieldTopDepth.getText().trim().isEmpty()) {
            JOptionPane.showMessageDialog(this, "Enter a top depth", this.getTitle(), 2);
            return;
        }
        if (this.jTextFieldBaseDepth.getText().trim().isEmpty()) {
            JOptionPane.showMessageDialog(this, "Enter a base depth", this.getTitle(), 2);
            return;
        }
        if (this.jTextFieldMinAge.getText().trim().isEmpty()) {
            JOptionPane.showMessageDialog(this, "Enter a minimum age", this.getTitle(), 2);
            return;
        }
        if (this.jTextFieldMaxAge.getText().trim().isEmpty()) {
            JOptionPane.showMessageDialog(this, "Enter a maximum age", this.getTitle(), 2);
            return;
        }
        float topDepth = Float.parseFloat(this.jTextFieldTopDepth.getText());
        float baseDepth = Float.parseFloat(this.jTextFieldBaseDepth.getText());
        float scale = Float.parseFloat("" + this.jComboBoxVerticalScale.getSelectedItem());
        float minAge = Float.parseFloat(this.jTextFieldMinAge.getText());
        float maxAge = Float.parseFloat(this.jTextFieldMaxAge.getText());
        Float ageScale = (Float)this.jComboBoxAgeScale.getSelectedItem();
        if (topDepth > baseDepth) {
            JOptionPane.showMessageDialog(this, "Top depth is greater than base depth", this.getTitle(), 2);
            return;
        }
        if (minAge > maxAge) {
            JOptionPane.showMessageDialog(this, "Minimum age is greater than maxiumum age", this.getTitle(), 2);
            return;
        }
        this.units = (char)(this.jRadioButtonFeet.isSelected() ? 70 : 77);
        this.block.setTopDepth((float)SB.convToM((double)topDepth, (char)this.units, (char)'W'));
        this.block.setBaseDepth((float)SB.convToM((double)baseDepth, (char)this.units, (char)'W'));
        this.block.setScale(scale);
        this.block.prop.units = this.units;
        this.p.sBlock.prop.min = minAge;
        this.p.sBlock.prop.max = maxAge;
        this.p.sBlock.prop.scale = ageScale.floatValue();
        this.p.sBlock.prop.ageLeftToRight = this.jRadioButtonXLeft.isSelected();
        this.p.drawEvents = this.jCheckBoxShowEvents.isSelected();
        this.p.drawShading = this.jCheckBoxSchemeShading.isSelected();
        if (this.jRadioButtonStyleAccumulation.isSelected()) {
            this.block.prop.scaleType = BlockProperties.ScaleType.TVD;
        } else if (this.jRadioButtonStyleSubsidence.isSelected()) {
            this.block.prop.scaleType = BlockProperties.ScaleType.SUBSIDENCE;
        }
        this.schemeBlockPanel.confirm();
        if (this.jCheckBoxEnvs.isSelected()) {
            if (this.p.getEnvPanel() == null) {
                try {
                    this.p.pBlock = new ProjectBlock(this.block.getProject(), this.db, this.p.sBlock.prop);
                    PanelEnv panelEnv = new PanelEnv(this.p.pBlock, this.p.getInterpID(), ((EnvScheme)this.jComboBoxEnvScheme.getSelectedItem()).getID(), this.db);
                    panelEnv.getProperties().columnWidth = 6.0f;
                    this.p.pBlock.addPanel(panelEnv);
                }
                catch (SQLException sql) {
                    this.p.pBlock = null;
                    FrameJsbugs.showStackError("SQL Error", sql, this.db);
                }
                catch (SBException sbe) {
                    this.p.pBlock = null;
                    SB.showStackError((String)"Error", (Exception)((Object)sbe));
                }
            } else {
                this.p.getEnvPanel().setScheme((EnvScheme)this.jComboBoxEnvScheme.getSelectedItem());
            }
        } else {
            this.p.pBlock = null;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.block.getProject().loadWells(this.db, null);
            Iterator wellIterator = this.block.getProject().getWellIterator();
            while (wellIterator.hasNext()) {
                Well well = (Well)wellIterator.next();
                well.loadInterps();
                if (!well.hasInterpLoaded(this.p.getInterpID())) continue;
                WellInterp interp = well.getInterp(this.p.getInterpID());
                if (interp != null) {
                    interp.loadLOC(well.getWellID());
                    well.getSamples();
                    if (!this.jCheckBoxEnvs.isSelected()) continue;
                    interp.loadEnvs(well);
                    continue;
                }
                System.out.println("Interp null for " + well + " " + this.panel.getProperties().getInterpID());
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error loading data", sql, this.db);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error loading data", (Exception)((Object)sbe));
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
        this.p.encode(this.db, true);
        if (this.cpCopy != null) {
            this.chart.chartProperties.copy(this.cpCopy);
        }
        this.panel.setProperties(this.p);
        this.chart.chartProperties.setPanelSubHeaderHeight(this.panel.getHeaderHeight(this.chart.chartProperties));
        try {
            String prefKey = this.block.getPrefKey(5);
            this.chart.savePreference(this.db, prefKey);
            this.db.commit();
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        this.setOK();
    }

    private void jTextFieldBaseDepthKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldBaseDepth, (int)8, (KeyEvent)evt, (boolean)true)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldTopDepthKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldTopDepth, (int)8, (KeyEvent)evt, (boolean)true)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonClearSchemeActionPerformed(ActionEvent evt) {
        try {
            this.p.setScheme(null);
            this.jTextFieldScheme.setText("");
            this.schemeBlockPanel.createPanelList(this.p.sBlock);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonSelectSchemeActionPerformed(ActionEvent evt) {
        try {
            DialogSelectIGDType dialog = new DialogSelectIGDType(this, true, false, false, false, false);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                if (dialog.igdType == 20) {
                    JOptionPane.showMessageDialog(this, "You can't select a composite Standard here", this.getTitle(), 2);
                    return;
                }
                DialogSelectScheme dialogScheme = new DialogSelectScheme(this, true, this.db, dialog.igdType, null);
                dialogScheme.setLocationRelativeTo(this);
                dialogScheme.setVisible(true);
                if (dialogScheme.selection != null && dialogScheme.selection != this.p.getScheme()) {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this.p.setScheme(dialogScheme.selection);
                    this.jTextFieldScheme.setText(dialogScheme.selection.toString());
                    this.setInterp(true);
                    this.schemeBlockPanel.createPanelList(this.p.sBlock);
                }
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jTextFieldMinAgeKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldMinAge, (int)6, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldMaxAgeKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldMaxAge, (int)6, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }

    private void jRadioButtonMetresActionPerformed(ActionEvent evt) {
        this.setUnits();
    }

    private void jRadioButtonFeetActionPerformed(ActionEvent evt) {
        this.setUnits();
    }

    private void jComboBoxVersionActionPerformed(ActionEvent evt) {
        if (this.inStartup) {
            return;
        }
        InterpHdr interp = (InterpHdr)this.jComboBoxVersion.getSelectedItem();
        if (interp.getInterpID() != this.p.getInterpID()) {
            this.p.interp = interp;
            this.setDepthAgeRanges(false);
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("howtousesubsidencecurves.html");
    }

    private void jComboBoxProjectActionPerformed(ActionEvent evt) {
        if (this.inStartup) {
            return;
        }
        Project project = (Project)this.jComboBoxProject.getSelectedItem();
        if (project != this.block.getProject()) {
            this.block.setProject(project);
            this.setDepthAgeRanges(true);
        }
    }

    private void jButtonClearCompositeActionPerformed(ActionEvent evt) {
        try {
            this.p.setCmpStd(null, this.db);
            this.jTextFieldComposite.setText("");
            this.schemeBlockPanel.createPanelList(this.p.sBlock);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
    }

    private void jButtonOptionsActionPerformed(ActionEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (this.cpCopy == null) {
            this.cpCopy = new ChartProperties(this.chart.chartProperties);
        }
        DialogChartFont dialog = new DialogChartFont(this, true, this.cpCopy);
        dialog.setLocationRelativeTo(this);
        this.setCursor(Cursor.getDefaultCursor());
        dialog.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonSelectCompositeActionPerformed(ActionEvent evt) {
        try {
            DialogSelectCmpStd dialog = new DialogSelectCmpStd(this, true, this.db);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.selection != null && dialog.selection != this.p.getCmpStd()) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.p.setCmpStd(dialog.selection, this.db);
                this.jTextFieldComposite.setText(this.p.getCmpStd().getName());
                try {
                    if (Float.parseFloat(this.jTextFieldMinAge.getText()) == 0.0f && Float.parseFloat(this.jTextFieldMaxAge.getText()) == 0.0f) {
                        this.jTextFieldMinAge.setText("" + this.p.getCmpStd().getMinAge());
                        this.jTextFieldMaxAge.setText("" + this.p.getCmpStd().getMaxAge());
                    }
                }
                catch (NumberFormatException e) {
                    this.jTextFieldMinAge.setText("" + this.p.getCmpStd().getMinAge());
                    this.jTextFieldMaxAge.setText("" + this.p.getCmpStd().getMaxAge());
                }
            }
            this.schemeBlockPanel.createPanelList(this.p.sBlock);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jRadioButtonStyleAccumulationActionPerformed(ActionEvent evt) {
        this.setTDLabel();
    }

    private void jRadioButtonStyleSubsidenceActionPerformed(ActionEvent evt) {
        this.setTDLabel();
    }

    private void setUnits() {
        if (this.jRadioButtonFeet.isSelected() && this.units != 'F') {
            this.units = (char)70;
            try {
                this.jTextFieldTopDepth.setText("" + SB.convFromM((double)Float.parseFloat(this.jTextFieldTopDepth.getText()), (char)'F'));
            }
            catch (Exception e) {
                this.jTextFieldTopDepth.setText("0.0");
            }
            try {
                this.jTextFieldBaseDepth.setText("" + SB.convFromM((double)Float.parseFloat(this.jTextFieldBaseDepth.getText()), (char)'F'));
            }
            catch (Exception e) {
                this.jTextFieldBaseDepth.setText("0.0");
            }
        } else {
            this.units = (char)77;
            try {
                this.jTextFieldTopDepth.setText("" + SB.convToM((float)Float.parseFloat(this.jTextFieldTopDepth.getText()), (char)'F'));
            }
            catch (Exception e) {
                this.jTextFieldTopDepth.setText("0.0");
            }
            try {
                this.jTextFieldBaseDepth.setText("" + SB.convToM((float)Float.parseFloat(this.jTextFieldBaseDepth.getText()), (char)'F'));
            }
            catch (Exception e) {
                this.jTextFieldBaseDepth.setText("0.0");
            }
        }
    }

    private void setTDLabel() {
        this.jLabelTD.setVisible(this.jRadioButtonStyleSubsidence.isSelected());
    }

    private class CbKeyListener
    implements KeyListener {
        JComboBox comboBox;

        public CbKeyListener(JComboBox box) {
            this.comboBox = box;
        }

        @Override
        public void keyReleased(KeyEvent evt) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent evt) {
            char c = evt.getKeyChar();
            if ((c < '0' || c > '9') && c != '.' && c != '-' && c != '+' && c != '\b' && c != '\u007f') {
                DialogSubsidenceChart.this.getToolkit().beep();
                evt.consume();
            }
        }
    }
}

