/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.HashMap;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jsbugs.FrameJsbugs;
import model2.SBdb;
import model2.SynonymScheme;
import util.SB;
import util.TableSorter;

public class DialogSynonymScheme
extends JDialog {
    private final TableModelSynonymy model;
    private final TableSorter sorter;
    private JButton jButtonClose;
    private JScrollPane jScrollPane1;
    private JTable jTableSyn;

    public DialogSynonymScheme(Dialog parent, boolean modal, SBdb sbdb, SynonymScheme scheme) throws SQLException {
        super(parent, modal);
        this.model = new TableModelSynonymy(sbdb, scheme);
        this.sorter = new TableSorter((TableModel)this.model);
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setTitle("Synonymy : " + this.model.scheme.getName());
        this.getRootPane().setDefaultButton(this.jButtonClose);
        this.sorter.addMouseListenerToHeaderInTable(this.jTableSyn);
        SB.setTableHeaderBold((JTable)this.jTableSyn);
        TableColumnModel columnModel = this.jTableSyn.getTableHeader().getColumnModel();
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(TableModelSynonymy.colTitles[i]);
        }
        this.sorter.reallocateIndexes();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTableSyn = new JTable();
        this.jButtonClose = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(250, 250));
        this.jTableSyn.setModel((TableModel)this.sorter);
        this.jScrollPane1.setViewportView(this.jTableSyn);
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSynonymScheme.this.jButtonCloseActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 380, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonClose))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 275, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonClose).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private static class TableModelSynonymy
    extends AbstractTableModel {
        private final SBdb sbdb;
        private final SynonymScheme scheme;
        private final HashMap<Integer, Integer> synonyms;
        private Integer[] species;
        private static String[] colTitles = new String[]{"Taxon", "Preferred Name"};

        public TableModelSynonymy(SBdb sbdb, SynonymScheme scheme) throws SQLException {
            this.scheme = scheme;
            this.sbdb = sbdb;
            this.synonyms = scheme.getSynonyms();
            this.species = this.synonyms.keySet().toArray(new Integer[this.synonyms.size()]);
        }

        @Override
        public int getRowCount() {
            return this.species.length;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            try {
                switch (columnIndex) {
                    case 0: {
                        return this.sbdb.getTaxon(this.species[rowIndex].intValue());
                    }
                    case 1: {
                        return this.sbdb.getTaxon(this.synonyms.get(this.species[rowIndex]).intValue());
                    }
                }
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
            }
            return null;
        }
    }
}

