/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import jsbugs.DialogSelectSynonymScheme;
import jsbugs.DialogSelectTaxa;
import jsbugs.FrameJsbugs;
import jsbugs.SBDialog;
import model2.SBdb;
import model2.SynonymScheme;
import model2.Taxon;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;

public class DialogSynonymy
extends SBDialog {
    private final SBdb db;
    private final Taxon taxon;
    private Taxon pref;
    private int synSch;
    private List<Taxon> synonyms = null;
    DefaultListModel listModel = new DefaultListModel();
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonPrefName;
    private JButton jButtonPreferred;
    private JButton jButtonRemovePref;
    private JButton jButtonRemoveSynonym;
    private JButton jButtonScheme;
    private JButton jButtonSynonyms;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JList jListJunior;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JTextField jTextFieldPreferredName;
    private JTextField jTextFieldSynonymScheme;
    private JTextField jTextFieldTaxonName;

    public DialogSynonymy(Frame parent, boolean modal, SBdb db, Taxon taxon, int synSchID) throws SQLException, SBException {
        super(parent, modal);
        this.setTitle("Synonymy");
        this.taxon = taxon;
        this.db = db;
        this.setLocation(parent.getLocation().x + 25, parent.getLocation().y + 25);
        this.initComponents();
        this.init(synSchID);
    }

    private void init(int synSchID) throws SQLException, SBException {
        this.synSch = synSchID;
        if (synSchID == 0) {
            this.synSch = 1;
        }
        if (this.synSch > 0) {
            this.jTextFieldSynonymScheme.setText(this.db.getSynSch(this.synSch).getName());
        }
        this.refresh();
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void refresh() throws SQLException, SBException {
        this.jTextFieldTaxonName.setText(this.taxon.toString(true));
        this.pref = this.db.getPreferredTerm(this.synSch, this.taxon.getSpecID());
        if (this.pref != null) {
            this.jTextFieldPreferredName.setText(this.pref.toString(true));
        }
        this.synonyms = this.db.getSynonymy(this.synSch, this.pref != null ? this.pref.getSpecID() : this.taxon.getSpecID());
        this.updateList();
    }

    private void updateList() {
        this.listModel.clear();
        for (Taxon tx : this.synonyms) {
            this.listModel.addElement(tx);
        }
        this.jListJunior.updateUI();
    }

    private void initComponents() {
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonOK = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jLabel1 = new JLabel();
        this.jTextFieldTaxonName = new JTextField();
        this.jButtonPreferred = new JButton();
        this.jLabel2 = new JLabel();
        this.jTextFieldPreferredName = new JTextField();
        this.jButtonPrefName = new JButton();
        this.jButtonRemovePref = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jListJunior = new JList();
        this.jLabel3 = new JLabel();
        this.jButtonSynonyms = new JButton();
        this.jButtonRemoveSynonym = new JButton();
        this.jTextFieldSynonymScheme = new JTextField();
        this.jLabel4 = new JLabel();
        this.jButtonScheme = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(500, 300));
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSynonymy.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSynonymy.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSynonymy.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Taxon name:");
        this.jTextFieldTaxonName.setEditable(false);
        this.jButtonPreferred.setText("Make preferred");
        this.jButtonPreferred.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonPreferred.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSynonymy.this.jButtonPreferredActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Preferred name:");
        this.jTextFieldPreferredName.setBackground(new Color(255, 255, 204));
        this.jTextFieldPreferredName.setEditable(false);
        this.jButtonPrefName.setText("...");
        this.jButtonPrefName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSynonymy.this.jButtonPrefNameActionPerformed(evt);
            }
        });
        this.jButtonRemovePref.setText("Remove");
        this.jButtonRemovePref.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonRemovePref.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSynonymy.this.jButtonRemovePrefActionPerformed(evt);
            }
        });
        this.jListJunior.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.jListJunior.setModel(this.listModel);
        this.jScrollPane1.setViewportView(this.jListJunior);
        this.jLabel3.setText("Junior synonyms of preferred name:");
        this.jButtonSynonyms.setText("...");
        this.jButtonSynonyms.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSynonymy.this.jButtonSynonymsActionPerformed(evt);
            }
        });
        this.jButtonRemoveSynonym.setText("Remove");
        this.jButtonRemoveSynonym.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonRemoveSynonym.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSynonymy.this.jButtonRemoveSynonymActionPerformed(evt);
            }
        });
        this.jTextFieldSynonymScheme.setBackground(new Color(255, 255, 204));
        this.jTextFieldSynonymScheme.setEditable(false);
        this.jLabel4.setText("Synonym scheme:");
        this.jButtonScheme.setText("...");
        this.jButtonScheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSynonymy.this.jButtonSchemeActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel4).addPreferredGap(0).add((Component)this.jTextFieldSynonymScheme, -1, 287, Short.MAX_VALUE)).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabel2).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jTextFieldPreferredName, -1, 295, Short.MAX_VALUE).add((Component)this.jTextFieldTaxonName, -1, 295, Short.MAX_VALUE))).add(1, (Component)this.jLabel3).add(1, (Component)this.jScrollPane1, -1, 378, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jButtonPreferred).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.jButtonSynonyms, -2, 27, Short.MAX_VALUE).add(1, (Component)this.jButtonPrefName, -2, 26, Short.MAX_VALUE).add(1, (Component)this.jButtonScheme, -2, 27, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2, false).add((Component)this.jButtonRemoveSynonym, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonRemovePref, -1, -1, Short.MAX_VALUE))))).add((Component)this.jSeparator1, -1, 480, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jButtonPreferred).add((Component)this.jTextFieldTaxonName, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jButtonPrefName).add((Component)this.jButtonRemovePref).add((Component)this.jTextFieldPreferredName, -2, -1, -2)).add(20, 20, 20).add((Component)this.jLabel3).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonSynonyms).add((Component)this.jButtonRemoveSynonym)).add((Component)this.jScrollPane1, -1, 149, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.jTextFieldSynonymScheme, -2, -1, -2).add((Component)this.jButtonScheme)).addPreferredGap(1).add((Component)this.jSeparator1, -2, 10, -2).add(1, 1, 1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonHelp).add((Component)this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jButtonRemoveSynonymActionPerformed(ActionEvent evt) {
        if (this.jListJunior.getSelectedValue() == null) {
            JOptionPane.showMessageDialog(this, "Nothing selected", this.getTitle(), 1);
            return;
        }
        for (Object o : this.jListJunior.getSelectedValues()) {
            Taxon t = (Taxon)o;
            this.synonyms.remove(t);
        }
        this.updateList();
    }

    private void jButtonRemovePrefActionPerformed(ActionEvent evt) {
        if (this.pref != null) {
            this.pref = null;
            this.jTextFieldPreferredName.setText("");
        }
    }

    private void jButtonPreferredActionPerformed(ActionEvent evt) {
        if (this.pref != this.taxon) {
            if (this.pref != null) {
                this.synonyms.add(this.pref);
            }
            this.pref = this.taxon;
            this.synonyms.remove(this.pref);
            this.updateList();
            this.jTextFieldPreferredName.setText(this.pref.toString(true));
        }
    }

    private void jButtonSchemeActionPerformed(ActionEvent evt) {
        try {
            DialogSelectSynonymScheme dialog = new DialogSelectSynonymScheme(this, true, this.db);
            dialog.setVisible(true);
            if (dialog.selection != null) {
                SynonymScheme scheme = dialog.selection;
                this.jTextFieldSynonymScheme.setText(scheme.toString());
                this.synSch = scheme.getSchID();
                this.refresh();
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
    }

    private void jButtonSynonymsActionPerformed(ActionEvent evt) {
        try {
            DialogSelectTaxa dialog = new DialogSelectTaxa((JDialog)this, true, this.db, true, this.taxon);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.selection != null) {
                for (Taxon t : dialog.selection) {
                    if (this.synonyms.contains(t)) continue;
                    this.synonyms.add(t);
                }
                this.updateList();
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
    }

    private void jButtonPrefNameActionPerformed(ActionEvent evt) {
        try {
            DialogSelectTaxa dialog = new DialogSelectTaxa((JDialog)this, true, this.db, true, this.taxon);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.selection != null) {
                this.pref = dialog.selection.get(0);
                this.jTextFieldPreferredName.setText(this.pref.toString(true));
                this.synonyms = this.db.getSynonymy(this.synSch, this.pref.getSpecID());
                this.updateList();
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        try {
            if (this.pref == null) {
                if (JOptionPane.showConfirmDialog(this, "No preferred term specified? Clear synonymy?", this.getTitle(), 0, 1) != 0) {
                    return;
                }
                this.synonyms = null;
            } else {
                for (Taxon t : this.synonyms) {
                    if (t != this.pref) continue;
                    JOptionPane.showMessageDialog(this, "Cannot make taxon  '" + t + "' a synonym of itself.", this.getTitle(), 1);
                    return;
                }
            }
            this.db.updateSynonymy(this.synSch, this.taxon, this.pref, this.synonyms);
            this.db.commit();
            this.setOK();
        }
        catch (SQLException sql) {
            this.db.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (SBException sbe) {
            this.db.doRollback();
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogsynonymy.html");
    }
}

