/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelTSCreator;
import model2.SBdb;
import model2.TSCreatorReader;

public class DialogTSCreator
extends JDialog {
    TSCreatorReader reader;
    SBdb ws;
    SBdb db;
    boolean isOK = false;
    TableModelTSCreator model = new TableModelTSCreator();
    private boolean useScheme = false;
    private ButtonGroup buttonGroupSchType;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JComboBox jComboBoxCmpStd;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JList jListTSC;
    private JRadioButton jRadioButtonBiozone;
    private JRadioButton jRadioButtonChrono;
    private JRadioButton jRadioButtonLitho;
    private JRadioButton jRadioButtonSeq;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTable jTableTSC;

    public DialogTSCreator(Frame parent, boolean modal, SBdb db, SBdb ws, TSCreatorReader reader) {
        super(parent, modal);
        this.ws = ws;
        this.db = db;
        this.reader = reader;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.jListTSC.setListData(this.reader.getLists().toArray());
        this.model.setupTable(this.jTableTSC);
        this.setTitle("Read TSCreator File");
    }

    private void initComponents() {
        this.buttonGroupSchType = new ButtonGroup();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonOK = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jListTSC = new JList();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jRadioButtonChrono = new JRadioButton();
        this.jRadioButtonLitho = new JRadioButton();
        this.jRadioButtonBiozone = new JRadioButton();
        this.jRadioButtonSeq = new JRadioButton();
        this.jScrollPane2 = new JScrollPane();
        this.jTableTSC = new JTable();
        this.jComboBoxCmpStd = new JComboBox();
        this.setDefaultCloseOperation(2);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTSCreator.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTSCreator.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTSCreator.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jListTSC.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jListTSC.setSelectionMode(0);
        this.jListTSC.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                DialogTSCreator.this.jListTSCValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListTSC);
        this.jLabel1.setFont(new Font("Tahoma", 1, 11));
        this.jLabel1.setText("Select stratigraphy from TSCreator file...");
        this.jLabel2.setFont(new Font("Tahoma", 1, 11));
        this.jLabel2.setText("Composite Standard :");
        this.jLabel3.setFont(new Font("Tahoma", 1, 11));
        this.jLabel3.setText("Select StrataBugs scheme type: ");
        this.buttonGroupSchType.add(this.jRadioButtonChrono);
        this.jRadioButtonChrono.setText("Chronostrat.");
        this.jRadioButtonChrono.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTSCreator.this.jRadioButtonChronoActionPerformed(evt);
            }
        });
        this.buttonGroupSchType.add(this.jRadioButtonLitho);
        this.jRadioButtonLitho.setText("Lithostrat.");
        this.jRadioButtonLitho.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTSCreator.this.jRadioButtonLithoActionPerformed(evt);
            }
        });
        this.buttonGroupSchType.add(this.jRadioButtonBiozone);
        this.jRadioButtonBiozone.setText("Biozone");
        this.jRadioButtonBiozone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTSCreator.this.jRadioButtonBiozoneActionPerformed(evt);
            }
        });
        this.buttonGroupSchType.add(this.jRadioButtonSeq);
        this.jRadioButtonSeq.setText("Sequence");
        this.jRadioButtonSeq.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTSCreator.this.jRadioButtonSeqActionPerformed(evt);
            }
        });
        this.jTableTSC.setModel(this.model);
        this.jScrollPane2.setViewportView(this.jTableTSC);
        this.jComboBoxCmpStd.setEnabled(false);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane2, GroupLayout.Alignment.LEADING, -1, 651, Short.MAX_VALUE).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 651, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel1).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jLabel2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jRadioButtonBiozone).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonChrono).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonLitho).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonSeq)).addComponent(this.jComboBoxCmpStd, 0, -1, Short.MAX_VALUE)))).addContainerGap()));
        layout.linkSize(0, this.jButtonCancel, this.jButtonHelp, this.jButtonOK);
        layout.linkSize(0, this.jRadioButtonBiozone, this.jRadioButtonChrono, this.jRadioButtonLitho, this.jRadioButtonSeq);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(11, 11, 11).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jComboBoxCmpStd, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jRadioButtonLitho).addComponent(this.jRadioButtonChrono).addComponent(this.jRadioButtonBiozone).addComponent(this.jRadioButtonSeq)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane2, -2, 178, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonHelp).addComponent(this.jButtonOK)).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(213, 213, 213).addComponent(this.jLabel3).addGap(235, 235, 235)));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogtscreator.html");
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        TSCreatorReader.TSCScheme scheme = (TSCreatorReader.TSCScheme)this.jListTSC.getSelectedValue();
        if (this.buttonGroupSchType.getSelection() != null) {
            HashSet<Integer> set = new HashSet<Integer>();
            for (int i = 0; i < scheme.getBlockCount(); ++i) {
                TSCreatorReader.TSCBlock block = scheme.getBlock(i);
                if (block.getHier() <= 0) continue;
                if (set.contains(block.getHier())) {
                    JOptionPane.showMessageDialog(this, "You cannot select multiple columns of the same type in the scheme.\nYou must remove column(s) from the selection.", this.getTitle(), 2);
                    return;
                }
                set.add(block.getHier());
            }
            if (scheme.getSequenceCount() == 0 && set.isEmpty()) {
                JOptionPane.showMessageDialog(this, "You have not selected any columns to add to your StrataBugs scheme.", this.getTitle(), 2);
                return;
            }
            scheme.setIGDType(this.model.igdType);
            this.useScheme = true;
        }
        if (!this.useScheme && this.getEventList() == null) {
            JOptionPane.showMessageDialog(this, "You have not select any event lists or schemes.", this.getTitle(), 2);
            return;
        }
        this.isOK = true;
        this.dispose();
    }

    public TSCreatorReader.TSCEventList getEventList() {
        Object o = this.jComboBoxCmpStd.getSelectedItem();
        if (o instanceof TSCreatorReader.TSCEventList) {
            return (TSCreatorReader.TSCEventList)o;
        }
        return null;
    }

    public boolean useScheme() {
        return this.useScheme;
    }

    private void jRadioButtonSeqActionPerformed(ActionEvent evt) {
        this.loadScheme();
    }

    private void jListTSCValueChanged(ListSelectionEvent evt) {
        TSCreatorReader.TSCScheme scheme = (TSCreatorReader.TSCScheme)this.jListTSC.getSelectedValue();
        if (scheme != null) {
            this.jComboBoxCmpStd.removeAllItems();
            List events = scheme.getEventLists();
            if (!events.isEmpty()) {
                this.jComboBoxCmpStd.addItem("<Select Event list for Composite Standard>");
                for (TSCreatorReader.TSCEventList ev : events) {
                    this.jComboBoxCmpStd.addItem(ev);
                }
                this.jComboBoxCmpStd.setEnabled(true);
            } else {
                this.jComboBoxCmpStd.addItem("No events in selected section");
                this.jComboBoxCmpStd.setEnabled(false);
            }
            boolean zonesEnabled = scheme.getBlockCount() > 0;
            this.jRadioButtonBiozone.setEnabled(zonesEnabled);
            this.jRadioButtonChrono.setEnabled(zonesEnabled);
            this.jRadioButtonLitho.setEnabled(zonesEnabled);
            this.jRadioButtonSeq.setEnabled(zonesEnabled);
            if (!zonesEnabled && scheme.getSequenceCount() > 0) {
                this.jRadioButtonSeq.setEnabled(true);
            }
            this.model.load(null, 0);
            this.buttonGroupSchType.clearSelection();
            this.model.fireTableDataChanged();
        }
    }

    private void jRadioButtonBiozoneActionPerformed(ActionEvent evt) {
        this.loadScheme();
    }

    private void jRadioButtonChronoActionPerformed(ActionEvent evt) {
        this.loadScheme();
    }

    private void jRadioButtonLithoActionPerformed(ActionEvent evt) {
        this.loadScheme();
    }

    TSCreatorReader.TSCScheme getScheme() {
        return (TSCreatorReader.TSCScheme)this.jListTSC.getSelectedValue();
    }

    void loadScheme() {
        TSCreatorReader.TSCScheme scheme = (TSCreatorReader.TSCScheme)this.jListTSC.getSelectedValue();
        if (scheme != null) {
            if (this.buttonGroupSchType.getSelection() == this.jRadioButtonBiozone.getModel()) {
                this.model.load(scheme, 4);
            } else if (this.buttonGroupSchType.getSelection() == this.jRadioButtonChrono.getModel()) {
                this.model.load(scheme, 3);
            } else if (this.buttonGroupSchType.getSelection() == this.jRadioButtonLitho.getModel()) {
                this.model.load(scheme, 2);
            } else if (this.buttonGroupSchType.getSelection() == this.jRadioButtonSeq.getModel()) {
                this.model.load(scheme, 10);
            }
        }
        this.model.fireTableDataChanged();
    }
}

