/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import jsbugs.DialogTVDCalc;
import jsbugs.DialogTVDHeader;
import jsbugs.DialogTVDReader;
import jsbugs.FrameJsbugs;
import jsbugs.TVDTableModel;
import model2.Lastval;
import model2.SBdb;
import model2.TVDList;
import model2.TVDepth;
import model2.Well;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;
import util.SbugsFileFilter;

public class DialogTVD
extends JDialog {
    Well well;
    char units;
    TVDTableModel modelActual = new TVDTableModel();
    TVDTableModel modelPlanned = new TVDTableModel();
    String headerActual = null;
    boolean TVDSSactual = false;
    String headerPlanned = null;
    boolean TVDSSplanned = false;
    boolean isPlan = false;
    public boolean isOK = false;
    private ButtonGroup buttonGroupPlan;
    private JButton jButtonAddRows;
    private JButton jButtonCalc;
    private JButton jButtonCancel;
    private JButton jButtonDelete;
    private JButton jButtonHeader;
    private JButton jButtonHelp;
    private JButton jButtonInsertRow;
    private JButton jButtonOK;
    private JButton jButtonRead;
    private JButton jButtonSelectAll;
    private JLabel jLabelUnits;
    private JRadioButton jRadioButtonActual;
    private JRadioButton jRadioButtonPlanned;
    private JScrollPane jScrollPane1;
    private JTable jTableTVD;

    public DialogTVD(Frame parent, boolean modal, Well well, char units) throws SQLException {
        super(parent, modal);
        this.well = well;
        this.units = units;
        this.initComponents();
        this.init();
    }

    public DialogTVD(JDialog parent, boolean modal, Well well, char units) throws SQLException {
        super((Dialog)parent, modal);
        this.well = well;
        this.units = units;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException {
        this.setTitle("Deviation Survey : Edit");
        SB.setTableHeaderBold((JTable)this.jTableTVD);
        this.jLabelUnits.setText("Depth units are : " + SB.unitString((char)this.units));
        if (!this.well.getDataModel().hasTVDplan()) {
            this.jRadioButtonActual.setEnabled(false);
            this.jRadioButtonActual.setSelected(true);
            this.jRadioButtonPlanned.setEnabled(false);
        } else {
            this.jRadioButtonActual.setSelected(true);
            this.modelPlanned.load(this.well.getTVDlist(true), this.units);
            this.headerPlanned = this.well.getTVDlist(true).getHeaderText();
            this.TVDSSplanned = this.well.getTVDlist(true).isIsTVDSS();
        }
        this.modelActual.load(this.well.getTVDlist(false), this.units);
        this.headerActual = this.well.getTVDlist(false).getHeaderText();
        this.TVDSSactual = this.well.getTVDlist(false).isIsTVDSS();
        this.modelActual.fireTableDataChanged();
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void initComponents() {
        this.buttonGroupPlan = new ButtonGroup();
        this.jButtonRead = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonSelectAll = new JButton();
        this.jButtonInsertRow = new JButton();
        this.jButtonAddRows = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTableTVD = new JTable();
        this.jButtonHelp = new JButton();
        this.jButtonCalc = new JButton();
        this.jLabelUnits = new JLabel();
        this.jButtonHeader = new JButton();
        this.jRadioButtonActual = new JRadioButton();
        this.jRadioButtonPlanned = new JRadioButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(500, 400));
        this.jButtonRead.setText("Read...");
        this.jButtonRead.setToolTipText("Read deviation survey from file");
        this.jButtonRead.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTVD.this.jButtonReadActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTVD.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonSelectAll.setText("Select All");
        this.jButtonSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTVD.this.jButtonSelectAllActionPerformed(evt);
            }
        });
        this.jButtonInsertRow.setText("Insert Row");
        this.jButtonInsertRow.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonInsertRow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTVD.this.jButtonInsertRowActionPerformed(evt);
            }
        });
        this.jButtonAddRows.setText("Add Rows...");
        this.jButtonAddRows.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonAddRows.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTVD.this.jButtonAddRowsActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTVD.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTVD.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jTableTVD.setModel(this.modelActual);
        this.jTableTVD.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                DialogTVD.this.jTableTVDKeyPressed(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableTVD);
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTVD.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonCalc.setText("Calculate...");
        this.jButtonCalc.setToolTipText("Calculate values for empty columns");
        this.jButtonCalc.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonCalc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTVD.this.jButtonCalcActionPerformed(evt);
            }
        });
        this.jLabelUnits.setFont(new Font("Tahoma", 1, 11));
        this.jLabelUnits.setText("Depth units are : Metres");
        this.jButtonHeader.setText("Header...");
        this.jButtonHeader.setToolTipText("Edit stored header information");
        this.jButtonHeader.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTVD.this.jButtonHeaderActionPerformed(evt);
            }
        });
        this.buttonGroupPlan.add(this.jRadioButtonActual);
        this.jRadioButtonActual.setText("Actual");
        this.jRadioButtonActual.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTVD.this.jRadioButtonActualActionPerformed(evt);
            }
        });
        this.buttonGroupPlan.add(this.jRadioButtonPlanned);
        this.jRadioButtonPlanned.setText("Planned");
        this.jRadioButtonPlanned.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTVD.this.jRadioButtonPlannedActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabelUnits).addPreferredGap(0, 208, Short.MAX_VALUE).add((Component)this.jRadioButtonActual).addPreferredGap(1).add((Component)this.jRadioButtonPlanned)).add((Component)this.jScrollPane1, -1, 464, Short.MAX_VALUE)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(2, false).add((Component)this.jButtonHelp, -1, 83, Short.MAX_VALUE).add((Component)this.jButtonCancel, -1, 83, Short.MAX_VALUE).add(1, (Component)this.jButtonOK, -1, 83, Short.MAX_VALUE).add((Component)this.jButtonRead, -1, 83, Short.MAX_VALUE).add((Component)this.jButtonDelete, -1, 83, Short.MAX_VALUE).add((Component)this.jButtonSelectAll, -1, 83, Short.MAX_VALUE).add((Component)this.jButtonAddRows, -2, 83, Short.MAX_VALUE).add(1, (Component)this.jButtonInsertRow, -2, 83, -2).add((Component)this.jButtonHeader, -1, 83, Short.MAX_VALUE).add(1, (Component)this.jButtonCalc, -2, 83, -2)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelUnits).add((Component)this.jRadioButtonPlanned).add((Component)this.jRadioButtonActual)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonRead).addPreferredGap(0).add((Component)this.jButtonAddRows).add(8, 8, 8).add((Component)this.jButtonInsertRow).addPreferredGap(0).add((Component)this.jButtonSelectAll).addPreferredGap(0).add((Component)this.jButtonDelete).addPreferredGap(0).add((Component)this.jButtonCalc).addPreferredGap(0).add((Component)this.jButtonHeader).addPreferredGap(0, 96, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel)).add((Component)this.jScrollPane1, -1, 376, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        TVDTableModel model = this.isPlan ? this.modelPlanned : this.modelActual;
        int[] exclusions = this.jTableTVD.getSelectedRows();
        if (exclusions.length == 0) {
            JOptionPane.showMessageDialog(this, "Select rows to delete");
            return;
        }
        if (JOptionPane.showConfirmDialog(this, "Really delete " + (exclusions.length > 1 ? "these " : "this ") + exclusions.length + (exclusions.length > 1 ? " rows?" : " row?"), this.getTitle(), 0, 3) != 0) {
            return;
        }
        int newSize = model.rowCount - exclusions.length;
        Double[] newDepth = new Double[newSize];
        Double[] newTVD = new Double[newSize];
        Double[] newInclination = new Double[newSize];
        Double[] newAzumith = new Double[newSize];
        Double[] newvs = new Double[newSize];
        Double[] newnorth = new Double[newSize];
        Double[] neweast = new Double[newSize];
        for (int i = 0; i < exclusions.length; ++i) {
            model.depth[exclusions[i]] = null;
        }
        int j = 0;
        for (int i = 0; i < model.rowCount; ++i) {
            if (model.depth[i] == null) continue;
            newDepth[j] = model.depth[i];
            newTVD[j] = model.tvd[i];
            newInclination[j] = model.inclination[i];
            newAzumith[j] = model.azimuth[i];
            newvs[j] = model.vs[i];
            newnorth[j] = model.north[i];
            neweast[j] = model.east[i];
            ++j;
        }
        model.depth = newDepth;
        model.tvd = newTVD;
        model.azimuth = newAzumith;
        model.vs = newvs;
        model.north = newnorth;
        model.east = neweast;
        model.rowCount = newDepth.length;
        model.isDirty = true;
        this.jTableTVD.clearSelection();
        model.fireTableDataChanged();
    }

    private void jButtonSelectAllActionPerformed(ActionEvent evt) {
        this.jTableTVD.selectAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonReadActionPerformed(ActionEvent evt) {
        TVDTableModel model;
        TVDTableModel tVDTableModel = model = this.isPlan ? this.modelPlanned : this.modelActual;
        if (model.rowCount > 0 && JOptionPane.showConfirmDialog(this, "The current entries must be cleared. Do you want to continue?", "TVD", 0, 3) != 0) {
            return;
        }
        String sFilter = JOptionPane.showInputDialog(this, "Enter depth filter value\n(reduces the number of stored values to improve performance)\n\nSuccessive records within the current depth + filter value will be skipped.\nA value of 10 will read values at least 10 m/ft apart.", new Double(1.0));
        if (sFilter == null) {
            return;
        }
        Double depthFilter = Double.parseDouble(sFilter);
        SbugsFileFilter filterAll = new SbugsFileFilter();
        JFileChooser jFileChooser = new JFileChooser();
        File setDir = null;
        try {
            setDir = new File(Lastval.getString((SBdb)this.well.getDataModel(), (String)"WINTVDIMP", (String)"UNXTVDIMP"));
        }
        catch (SQLException ex) {
            // empty catch block
        }
        jFileChooser.setCurrentDirectory(setDir);
        SbugsFileFilter filter = new SbugsFileFilter();
        filter.addExtension("txt");
        if (jFileChooser.showOpenDialog(this) == 0) {
            File file = jFileChooser.getSelectedFile();
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                DialogTVDReader dialog = new DialogTVDReader(this, true, file);
                dialog.setLocationRelativeTo(this);
                this.setCursor(Cursor.getDefaultCursor());
                dialog.setVisible(true);
                if (dialog.isOK) {
                    String buff;
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    file = dialog.file;
                    BufferedReader in = new BufferedReader(new FileReader(file));
                    double lastDepth = -100.0;
                    LinkedList<TVDepth> values = new LinkedList<TVDepth>();
                    while ((buff = in.readLine()) != null) {
                        StringTokenizer tok = new StringTokenizer(buff, " ,;\t");
                        if (tok.countTokens() != dialog.nColumns) continue;
                        try {
                            double[] tokvalues = new double[dialog.nColumns];
                            int nTok = 0;
                            while (tok.hasMoreTokens()) {
                                try {
                                    tokvalues[nTok++] = Double.parseDouble(tok.nextToken());
                                }
                                catch (NumberFormatException e) {
                                    if (dialog.useCol(nTok)) {
                                        throw e;
                                    }
                                    System.out.println("Ignored number format exception in unused column: " + e.getMessage());
                                }
                            }
                            double depth1 = tokvalues[dialog.depCol - 1];
                            double tvd = 0.0;
                            if (dialog.tvdCol > 0) {
                                tvd = tokvalues[dialog.tvdCol - 1];
                            }
                            Float incl = null;
                            if (dialog.inclCol > 0) {
                                incl = new Float(tokvalues[dialog.inclCol - 1]);
                            }
                            Float az = null;
                            if (dialog.azCol > 0) {
                                az = new Float(tokvalues[dialog.azCol - 1]);
                            }
                            Double vs = null;
                            if (dialog.vsCol > 0) {
                                vs = new Double(tokvalues[dialog.vsCol - 1]);
                            }
                            Double north = null;
                            if (dialog.northCol > 0) {
                                north = new Double(tokvalues[dialog.northCol - 1]);
                            }
                            Double east = null;
                            if (dialog.eastCol > 0) {
                                east = new Double(tokvalues[dialog.eastCol - 1]);
                            }
                            if (!(depth1 - lastDepth > depthFilter)) continue;
                            values.add(new TVDepth(depth1, Double.valueOf(tvd), incl, az, vs, north, east));
                            lastDepth = depth1;
                        }
                        catch (Exception sbe) {
                            System.out.println("Error inserting values for row: " + buff);
                        }
                    }
                    model.setSize(values.size());
                    for (int i = 0; i < model.rowCount; ++i) {
                        TVDepth tvd = (TVDepth)values.get(i);
                        model.setValueAt(new Double(tvd.getDDepth()), i, 0);
                        model.setValueAt(new Double(tvd.getTVDepth()), i, 1);
                        if (tvd.getInclination() != null) {
                            model.setValueAt(new Double(tvd.getInclination().floatValue()), i, 2);
                        }
                        if (tvd.getAzumith() != null) {
                            model.setValueAt(new Double(tvd.getAzumith().floatValue()), i, 3);
                        }
                        if (tvd.getVS() != null) {
                            model.setValueAt(new Double(tvd.getVS()), i, 4);
                        }
                        if (tvd.getNorth() != null) {
                            model.setValueAt(new Double(tvd.getNorth()), i, 5);
                        }
                        if (tvd.getEast() == null) continue;
                        model.setValueAt(new Double(tvd.getEast()), i, 6);
                    }
                    this.jTableTVD.clearSelection();
                    model.fireTableDataChanged();
                    Lastval.putString((SBdb)this.well.getDataModel(), (String)"WINTVDIMP", (String)"UNXTVDIMP", (String)file.getPath());
                    this.well.getDataModel().commit();
                }
            }
            catch (Exception eio) {
                JOptionPane.showMessageDialog(null, "Problem reading file: " + eio.getMessage());
                eio.printStackTrace();
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private void jButtonInsertRowActionPerformed(ActionEvent evt) {
        int i;
        if (this.jTableTVD.getSelectedRow() < 0) {
            JOptionPane.showMessageDialog(this, "Select a row insertion point.");
            return;
        }
        int insertionPoint = this.jTableTVD.getSelectedRow();
        TVDTableModel model = this.isPlan ? this.modelPlanned : this.modelActual;
        Double[] oldDepth = model.depth;
        Double[] oldTvd = model.tvd;
        Double[] oldIncl = model.inclination;
        Double[] oldAz = model.azimuth;
        Double[] oldVs = model.vs;
        Double[] oldN = model.north;
        Double[] oldE = model.east;
        model.setSize(model.rowCount + 1);
        for (i = 0; i < insertionPoint; ++i) {
            model.depth[i] = oldDepth[i];
            model.tvd[i] = oldTvd[i];
            model.inclination[i] = oldIncl[i];
            model.azimuth[i] = oldAz[i];
            model.vs[i] = oldVs[i];
            model.north[i] = oldN[i];
            model.east[i] = oldE[i];
        }
        for (i = insertionPoint + 1; i < model.rowCount; ++i) {
            model.depth[i] = oldDepth[i - 1];
            model.tvd[i] = oldTvd[i - 1];
            model.inclination[i] = oldIncl[i - 1];
            model.azimuth[i] = oldAz[i - 1];
            model.vs[i] = oldVs[i - 1];
            model.north[i] = oldN[i - 1];
            model.east[i] = oldE[i - 1];
        }
        model.isDirty = true;
        this.jTableTVD.clearSelection();
        model.fireTableDataChanged();
    }

    private void jButtonAddRowsActionPerformed(ActionEvent evt) {
        TVDTableModel model = this.isPlan ? this.modelPlanned : this.modelActual;
        try {
            String rows = JOptionPane.showInputDialog(this, "Enter number of rows to add", new Integer(1));
            if (rows != null) {
                int nRows = Integer.parseInt(rows);
                Double[] oldDepth = model.depth;
                Double[] oldTvd = model.tvd;
                Double[] oldIncl = model.inclination;
                Double[] oldAz = model.azimuth;
                Double[] oldVs = model.vs;
                Double[] oldN = model.north;
                Double[] oldE = model.east;
                model.setSize(model.rowCount + nRows);
                for (int i = 0; i < oldDepth.length; ++i) {
                    model.depth[i] = oldDepth[i];
                    model.tvd[i] = oldTvd[i];
                    model.inclination[i] = oldIncl[i];
                    model.azimuth[i] = oldAz[i];
                    model.vs[i] = oldVs[i];
                    model.north[i] = oldN[i];
                    model.east[i] = oldE[i];
                }
                this.jTableTVD.clearSelection();
                model.fireTableDataChanged();
                this.jTableTVD.setRowSelectionInterval(model.rowCount - nRows, model.rowCount - 1);
                this.jScrollPane1.getViewport().setViewPosition(new Point(0, this.jTableTVD.getBounds().getSize().height));
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private boolean saveData() throws SBException, SQLException {
        int opt;
        int saveThreshold = 10000;
        if (this.modelActual.isDirty) {
            if (this.modelActual.rowCount > saveThreshold && ((opt = JOptionPane.showConfirmDialog(this, "There are over " + saveThreshold + " values, which will take a long time to store and plot. Consider using a depth filter to re-read the data.\nDo you want to continue to save?", this.getTitle(), 1, 3)) == 1 || opt == 2 || opt == -1)) {
                return false;
            }
            this.saveData(this.modelActual, this.headerActual, this.TVDSSactual, false);
        }
        if (this.modelPlanned != null && this.modelPlanned.isDirty) {
            if (this.modelPlanned.rowCount > saveThreshold && ((opt = JOptionPane.showConfirmDialog(this, "There are over " + saveThreshold + " values, which will take a long time to store and plot. Consider using a depth filter to re-read the data.\nDo you want to continue to save?", this.getTitle(), 1, 3)) == 1 || opt == 2 || opt == -1)) {
                return false;
            }
            this.saveData(this.modelPlanned, this.headerPlanned, this.TVDSSplanned, true);
        }
        return true;
    }

    private void saveData(TVDTableModel model, String header, boolean TVDSS, boolean isPlan) throws SBException, SQLException {
        TVDList newList = new TVDList(this.well.getDataModel(), isPlan);
        model.save(newList);
        if (header != null) {
            newList.setHeader(header, TVDSS ? 2 : 1);
        }
        newList.store(this.well.getWellID());
        this.well.getDataModel().commit();
        this.well.getTVDlist(isPlan).setHeader(header, TVDSS ? 2 : 1);
        model.save(this.well.getTVDlist(isPlan));
        this.well.getTVDlist(isPlan).notifyObservers();
        this.well.setDataChanged();
        this.well.notifyObservers((Object)this.well.getTVDlist(isPlan));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonOKActionPerformed(ActionEvent evt) {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.isOK = this.saveData();
            if (this.isOK) {
                this.dispose();
            }
        }
        catch (SBException ex) {
            JOptionPane.showMessageDialog(this, "Error saving data: " + ex.getMessage(), this.getTitle(), 0);
            ex.printStackTrace();
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(this, "Error saving data: " + ex.getMessage(), this.getTitle(), 0);
            ex.printStackTrace();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogtvd.html");
    }

    private void jButtonCalcActionPerformed(ActionEvent evt) {
        TVDTableModel model = this.isPlan ? this.modelPlanned : this.modelActual;
        DialogTVDCalc dialog = new DialogTVDCalc(this, true);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.selection != null) {
            try {
                int[] selectedRows = null;
                if (this.jTableTVD.getSelectedRowCount() > 0) {
                    int opt = JOptionPane.showConfirmDialog(this, "Restrict calculation to selected rows only?", this.getTitle(), 1, 3);
                    if (opt == 2 || opt == -1) {
                        return;
                    }
                    if (opt == 0) {
                        selectedRows = this.jTableTVD.getSelectedRows();
                    }
                }
                if (dialog.selection == DialogTVDCalc.CALC.TVD) {
                    model.calcTVDVS("TVD", this, selectedRows);
                } else if (dialog.selection == DialogTVDCalc.CALC.VSTVD) {
                    model.calcVS(this, selectedRows);
                } else if (dialog.selection == DialogTVDCalc.CALC.VSINCL) {
                    model.calcTVDVS("VS", this, selectedRows);
                } else if (dialog.selection == DialogTVDCalc.CALC.NEAZ) {
                    model.calcNE(this, selectedRows);
                }
                model.isDirty = true;
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "There was an error in the calculation. Check values", this.getTitle(), 2);
                ex.printStackTrace();
            }
        }
        model.fireTableDataChanged();
    }

    private void jButtonHeaderActionPerformed(ActionEvent evt) {
        DialogTVDHeader dialog = new DialogTVDHeader(this, true, this.isPlan ? this.headerPlanned : this.headerActual, this.isPlan ? this.TVDSSplanned : this.TVDSSactual);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.isOK) {
            if (this.isPlan) {
                if (!dialog.getHeader().equals(this.headerPlanned)) {
                    this.headerPlanned = dialog.getHeader();
                    this.modelPlanned.isDirty = true;
                }
                if (this.TVDSSplanned != dialog.getTVDSS()) {
                    this.TVDSSplanned = dialog.getTVDSS();
                    this.modelPlanned.isDirty = true;
                }
            } else {
                if (!dialog.getHeader().equals(this.headerActual)) {
                    this.headerActual = dialog.getHeader();
                    this.modelActual.isDirty = true;
                }
                if (this.TVDSSactual != dialog.getTVDSS()) {
                    this.TVDSSactual = dialog.getTVDSS();
                    this.modelActual.isDirty = true;
                }
            }
        }
    }

    private void jTableTVDKeyPressed(KeyEvent evt) {
        int key = evt.getKeyCode();
        if (key == 127) {
            this.jButtonDeleteActionPerformed(null);
        }
    }

    private void jRadioButtonActualActionPerformed(ActionEvent evt) {
        if (this.isPlan) {
            this.isPlan = false;
            this.jTableTVD.setModel(this.modelActual);
            this.modelActual.fireTableDataChanged();
        }
    }

    private void jRadioButtonPlannedActionPerformed(ActionEvent evt) {
        if (!this.isPlan) {
            this.isPlan = true;
            this.jTableTVD.setModel(this.modelPlanned);
            this.modelActual.fireTableDataChanged();
        }
    }
}

