/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import jsbugs.Chart;
import jsbugs.ChartProperties;
import jsbugs.DialogChartFont;
import jsbugs.DialogIGDColmap;
import jsbugs.DialogLogDef;
import jsbugs.DialogSelectIGDPanel;
import jsbugs.DialogSelectWell;
import jsbugs.DialogTVD;
import jsbugs.FrameJsbugs;
import jsbugs.JPanelWell;
import jsbugs.JPanelWellBlock;
import jsbugs.PanelWellVS;
import jsbugs.PanelWellVSProperties;
import jsbugs.SBDialog;
import jsbugs.SBPanel;
import jsbugs.WellBlock;
import model2.Curve;
import model2.IGDColMap;
import model2.IGDInterval;
import model2.LogDef;
import model2.SBdb;
import model2.TVDepth;
import model2.Well;
import model2.WellInterp;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;
import util.SbugsInputVerifier;

public class DialogTVDOffsetChart
extends SBDialog {
    SBdb db;
    WellBlock block;
    PanelWellVS vsPanel = null;
    char units;
    DefaultComboBoxModel scaleModel = new DefaultComboBoxModel();
    DefaultComboBoxModel colModel = new DefaultComboBoxModel();
    DefaultListModel panelModel = new DefaultListModel();
    static final int DEPTHLEN = 8;
    ChartProperties cp;
    WellBlock motherBlock;
    boolean inStartup = true;
    PanelWellVSProperties prop;
    JPanelWell jPanelWell;
    static final String noInterpString = "No version selected";
    static final String noIGDTypeString = "Select interpretation type";
    Chart chart;
    JPanelWellBlock jPanelWellBlock;
    private ButtonGroup buttonGroupEvents;
    private ButtonGroup buttonGroupNames;
    private ButtonGroup buttonGroupUnits;
    private JButton jButtonCalcDefaultVS;
    private JButton jButtonCancel;
    private JButton jButtonClearMB;
    private JButton jButtonColMap;
    private JButton jButtonFonts;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonSelectMB;
    private JButton jButtonStratigraphy;
    private JButton jButtonTrace1Props;
    private JButton jButtonTrace2Props;
    private JButton jButtonWellTVD;
    private JCheckBox jCheckBoxEvents;
    private JCheckBox jCheckBoxFaults;
    private JCheckBox jCheckBoxGrid;
    private JCheckBox jCheckBoxLog1ScaleLine;
    private JCheckBox jCheckBoxLog2ScaleLine;
    private JCheckBox jCheckBoxPlan;
    private JCheckBox jCheckBoxSamples;
    private JCheckBox jCheckBoxShowStrat;
    private JCheckBox jCheckBoxUnitNames;
    private JComboBox jComboBoxColMap;
    private JComboBox jComboBoxTrace1;
    private JComboBox jComboBoxTrace2;
    private JComboBox jComboBoxVerticalScale;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JLabel jLabelShiftUnits;
    private JLabel jLabelShiftUnits2;
    private JLabel jLabelVersion;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanelAxes;
    private JPanel jPanelHorz;
    private JPanel jPanelLogs;
    private JPanel jPanelMother;
    private JPanelWellBlock jPanelMotherBlock;
    private JPanel jPanelStrat;
    private JRadioButton jRadioButtonAbrs;
    private JRadioButton jRadioButtonEvtHorz;
    private JRadioButton jRadioButtonEvtKey;
    private JRadioButton jRadioButtonEvtNone;
    private JRadioButton jRadioButtonFeet;
    private JRadioButton jRadioButtonMetres;
    private JRadioButton jRadioButtonNames;
    private JSeparator jSeparator1;
    private JSpinner jSpinnerCurveWeight;
    private JTabbedPane jTabbedPane1;
    private JTabbedPane jTabbedPane2;
    private JTextField jTextFieldBaseDepth;
    private JTextField jTextFieldBaseTVD;
    private JTextField jTextFieldDepthShift1;
    private JTextField jTextFieldDepthShift2;
    private JTextField jTextFieldMaxVS;
    private JTextField jTextFieldMinVS;
    private JTextField jTextFieldMotherbore;
    private JTextField jTextFieldStratigraphy;
    private JTextField jTextFieldTopDepth;
    private JTextField jTextFieldTopTVD;
    private JTextField jTextFieldTrace1Offset;
    private JTextField jTextFieldTrace1Width;
    private JTextField jTextFieldTrace2Offset;
    private JTextField jTextFieldTrace2Width;

    public DialogTVDOffsetChart(Frame parent, JPanelWell jPanelWell, boolean modal, SBdb db, Chart chart, WellBlock block, WellBlock motherBlock) throws SQLException {
        super(parent, modal);
        this.db = db;
        this.block = block;
        this.chart = chart;
        this.motherBlock = motherBlock;
        this.jPanelWell = jPanelWell;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException {
        this.setTitle("TVD/Offset Chart Properties");
        for (SBPanel panel : this.block.panels) {
            if (!(panel instanceof PanelWellVS)) continue;
            this.vsPanel = (PanelWellVS)panel;
        }
        this.jTextFieldTopTVD.setText(SB.floatString((double)SB.convFromM((double)this.block.prop.min, (char)this.block.prop.units), (int)2));
        this.jTextFieldBaseTVD.setText(SB.floatString((double)SB.convFromM((double)this.block.prop.max, (char)this.block.prop.units), (int)2));
        ((JTextField)this.jComboBoxVerticalScale.getEditor().getEditorComponent()).setInputVerifier((InputVerifier)new SbugsInputVerifier(1.0f, 100000.0f, (float)((int)this.block.getScale())));
        try {
            this.db.getChartScales(this.scaleModel);
        }
        catch (SQLException sql) {
            SB.showStackError((String)"SQL Error loading scales: ", (SQLException)sql);
        }
        String sScale = Integer.toString((int)this.block.getScale());
        if (this.scaleModel.getIndexOf(sScale) < 0) {
            this.scaleModel.addElement(sScale);
        }
        this.scaleModel.setSelectedItem(sScale);
        if (this.block.prop.units == 'F') {
            this.jRadioButtonFeet.setSelected(true);
        } else {
            this.jRadioButtonMetres.setSelected(true);
        }
        this.units = this.block.prop.units;
        this.updateDepthField(true);
        this.updateDepthField(false);
        this.prop = new PanelWellVSProperties(this.vsPanel.getProps());
        this.jTextFieldMinVS.setText(SB.floatString((double)SB.convFromM((double)this.prop.minVS, (char)this.block.prop.units), (int)2));
        this.jTextFieldMaxVS.setText(SB.floatString((double)SB.convFromM((double)this.prop.maxVS, (char)this.block.prop.units), (int)2));
        if (!this.db.hasTVDplan()) {
            this.jCheckBoxPlan.setEnabled(false);
        }
        this.jCheckBoxSamples.setSelected(this.prop.drawSamples);
        this.jCheckBoxFaults.setSelected(this.prop.drawFaults);
        this.jCheckBoxPlan.setSelected(this.prop.drawPlan);
        this.jCheckBoxGrid.setSelected(this.prop.drawGridLines);
        this.jSpinnerCurveWeight.getModel().setValue(Float.valueOf(this.prop.curveWeight));
        this.jCheckBoxShowStrat.setText("Show stratigraphy for " + this.block.well.getWellName() + ":");
        this.jCheckBoxShowStrat.setSelected(this.prop.drawIGD);
        this.jTextFieldStratigraphy.setEnabled(this.prop.drawIGD);
        this.jCheckBoxUnitNames.setSelected(this.prop.drawUnitNames);
        if (this.jCheckBoxUnitNames.isSelected()) {
            this.jRadioButtonAbrs.setSelected(this.prop.useAbrs);
            this.jRadioButtonNames.setSelected(!this.prop.useAbrs);
        } else {
            this.jCheckBoxUnitNamesActionPerformed(null);
        }
        this.setStratText();
        if (this.jPanelWell.getInterp() != null) {
            this.jLabelVersion.setText(this.jPanelWell.getInterp().toString());
        } else {
            this.jLabelVersion.setForeground(Color.RED);
            this.jLabelVersion.setText("Select a version on the Interpretations tab");
            this.enableAll(false);
        }
        this.fillColCombo();
        this.jCheckBoxEvents.setSelected(this.prop.drawEvents);
        this.jCheckBoxEventsActionPerformed(null);
        switch (this.prop.eventLabelStyle) {
            case 0: {
                this.jRadioButtonEvtHorz.setSelected(true);
                break;
            }
            default: {
                this.jRadioButtonEvtKey.setSelected(true);
                break;
            }
            case 1: {
                this.jRadioButtonEvtNone.setSelected(true);
            }
        }
        this.fillLogDefCombos();
        this.jTextFieldTrace1Width.setText("" + this.prop.logInfo1.logColWidth);
        this.jTextFieldDepthShift1.setText("" + this.prop.logInfo1.logShift);
        this.jTextFieldTrace1Offset.setText("" + this.prop.logInfo1.logTraceOffset);
        this.jCheckBoxLog1ScaleLine.setSelected(this.prop.logInfo1.logScaleLine);
        this.jLabelShiftUnits.setText(this.units == 'M' ? "m" : "ft");
        this.jTextFieldTrace2Width.setText("" + this.prop.logInfo2.logColWidth);
        this.jTextFieldDepthShift2.setText("" + this.prop.logInfo2.logShift);
        this.jTextFieldTrace2Offset.setText("" + this.prop.logInfo2.logTraceOffset);
        this.jCheckBoxLog2ScaleLine.setSelected(this.prop.logInfo2.logScaleLine);
        this.jLabelShiftUnits2.setText(this.units == 'M' ? "m" : "ft");
        this.cp = new ChartProperties(this.chart.chartProperties);
        this.jPanelMotherBlock.init(this.motherBlock, this.db, this, this.cp);
        this.setMotherboreString();
        this.jPanelWellBlock = new JPanelWellBlock(this.block, this.db, this, this.cp);
        this.jTabbedPane2.insertTab(this.block.well.getWellName(), null, this.jPanelWellBlock, null, 1);
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.inStartup = false;
    }

    void setMotherboreString() {
        if (this.motherBlock.well != null) {
            this.jTextFieldMotherbore.setText(this.motherBlock.well.getWellName());
        } else {
            this.jTextFieldMotherbore.setText("<Select>");
        }
        this.jTextFieldMotherbore.repaint();
    }

    private void fillColCombo() {
        try {
            WellInterp vsInterp = this.vsPanel.getInterp();
            this.colModel.removeAllElements();
            if (vsInterp == null) {
                this.colModel.addElement(noInterpString);
                this.jButtonColMap.setEnabled(false);
            } else if (this.prop.igdType < 0) {
                this.colModel.addElement(noIGDTypeString);
                this.jButtonColMap.setEnabled(false);
            } else {
                IGDColMap colMap = vsInterp.getColMap(this.block.well.getWellID(), this.prop.igdType);
                for (int i = 1; i < colMap.getSize() + 1; ++i) {
                    String entry = colMap.getColTitle(i);
                    this.colModel.addElement(entry);
                }
                if (this.prop.col > 0) {
                    this.jComboBoxColMap.setSelectedIndex(this.prop.col - 1);
                } else {
                    this.jComboBoxColMap.setSelectedIndex(this.colModel.getSize() - 1);
                }
                this.jButtonColMap.setEnabled(true);
            }
        }
        catch (SQLException sql) {
            sql.printStackTrace();
        }
        catch (SBException sbe) {
            sbe.printStackTrace();
        }
    }

    private void fillLogDefCombos() {
        this.jComboBoxTrace1.removeAllItems();
        this.jComboBoxTrace2.removeAllItems();
        HashSet<String> abrs = new HashSet<String>();
        try {
            for (Curve curve : this.block.well.getCurves().getCurves()) {
                String abr = curve.getAbr();
                abrs.add(abr);
            }
        }
        catch (SQLException sql) {
            sql.printStackTrace();
        }
        abrs.add(null);
        for (String item : abrs) {
            this.jComboBoxTrace1.addItem(item);
            this.jComboBoxTrace2.addItem(item);
        }
        if (this.prop.logInfo1.logDef != null) {
            this.jComboBoxTrace1.setSelectedItem(this.prop.logInfo1.logDef.getAbr());
        }
        if (this.prop.logInfo2.logDef != null) {
            this.jComboBoxTrace2.setSelectedItem(this.prop.logInfo2.logDef.getAbr());
        }
    }

    private void initComponents() {
        this.buttonGroupUnits = new ButtonGroup();
        this.buttonGroupNames = new ButtonGroup();
        this.buttonGroupEvents = new ButtonGroup();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonHelp = new JButton();
        this.jTextFieldBaseDepth = new JTextField();
        this.jComboBoxVerticalScale = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jTextFieldTopDepth = new JTextField();
        this.jLabel1 = new JLabel();
        this.jTextFieldTopTVD = new JTextField();
        this.jTextFieldBaseTVD = new JTextField();
        this.jPanel3 = new JPanel();
        this.jRadioButtonFeet = new JRadioButton();
        this.jRadioButtonMetres = new JRadioButton();
        this.jSeparator1 = new JSeparator();
        this.jTabbedPane2 = new JTabbedPane();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanelAxes = new JPanel();
        this.jPanelHorz = new JPanel();
        this.jLabel3 = new JLabel();
        this.jTextFieldMinVS = new JTextField();
        this.jLabel4 = new JLabel();
        this.jTextFieldMaxVS = new JTextField();
        this.jButtonCalcDefaultVS = new JButton();
        this.jCheckBoxPlan = new JCheckBox();
        this.jCheckBoxSamples = new JCheckBox();
        this.jCheckBoxFaults = new JCheckBox();
        this.jButtonWellTVD = new JButton();
        this.jCheckBoxGrid = new JCheckBox();
        this.jLabel19 = new JLabel();
        this.jSpinnerCurveWeight = new JSpinner();
        this.jLabel20 = new JLabel();
        this.jPanelStrat = new JPanel();
        this.jCheckBoxShowStrat = new JCheckBox();
        this.jCheckBoxUnitNames = new JCheckBox();
        this.jRadioButtonNames = new JRadioButton();
        this.jRadioButtonAbrs = new JRadioButton();
        this.jPanel1 = new JPanel();
        this.jLabel8 = new JLabel();
        this.jLabelVersion = new JLabel();
        this.jTextFieldStratigraphy = new JTextField();
        this.jLabel6 = new JLabel();
        this.jComboBoxColMap = new JComboBox();
        this.jLabel10 = new JLabel();
        this.jButtonColMap = new JButton();
        this.jButtonStratigraphy = new JButton();
        this.jCheckBoxEvents = new JCheckBox();
        this.jRadioButtonEvtHorz = new JRadioButton();
        this.jRadioButtonEvtKey = new JRadioButton();
        this.jRadioButtonEvtNone = new JRadioButton();
        this.jPanelLogs = new JPanel();
        this.jPanel4 = new JPanel();
        this.jComboBoxTrace1 = new JComboBox();
        this.jLabel12 = new JLabel();
        this.jTextFieldTrace1Width = new JTextField();
        this.jLabel13 = new JLabel();
        this.jTextFieldTrace1Offset = new JTextField();
        this.jLabel14 = new JLabel();
        this.jTextFieldDepthShift1 = new JTextField();
        this.jLabelShiftUnits = new JLabel();
        this.jCheckBoxLog1ScaleLine = new JCheckBox();
        this.jButtonTrace1Props = new JButton();
        this.jPanel5 = new JPanel();
        this.jComboBoxTrace2 = new JComboBox();
        this.jButtonTrace2Props = new JButton();
        this.jTextFieldTrace2Width = new JTextField();
        this.jTextFieldTrace2Offset = new JTextField();
        this.jTextFieldDepthShift2 = new JTextField();
        this.jCheckBoxLog2ScaleLine = new JCheckBox();
        this.jLabelShiftUnits2 = new JLabel();
        this.jLabel15 = new JLabel();
        this.jLabel16 = new JLabel();
        this.jLabel17 = new JLabel();
        this.jPanelMother = new JPanel();
        this.jLabel9 = new JLabel();
        this.jTextFieldMotherbore = new JTextField();
        this.jButtonSelectMB = new JButton();
        this.jButtonClearMB = new JButton();
        this.jLabel7 = new JLabel();
        this.jPanelMotherBlock = new JPanelWellBlock();
        this.jButtonFonts = new JButton();
        this.jLabel11 = new JLabel();
        this.jLabel18 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTVDOffsetChart.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTVDOffsetChart.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTVDOffsetChart.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jTextFieldBaseDepth.setEditable(false);
        this.jTextFieldBaseDepth.setBackground(new Color(255, 255, 204));
        this.jComboBoxVerticalScale.setEditable(true);
        this.jComboBoxVerticalScale.setModel(this.scaleModel);
        this.jLabel2.setHorizontalAlignment(11);
        this.jLabel2.setText("Base TVD:");
        this.jLabel5.setText("Scale:");
        this.jTextFieldTopDepth.setEditable(false);
        this.jTextFieldTopDepth.setBackground(new Color(255, 255, 204));
        this.jLabel1.setHorizontalAlignment(11);
        this.jLabel1.setText("Top TVD:");
        this.jTextFieldTopTVD.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                DialogTVDOffsetChart.this.jTextFieldTopTVDFocusLost(evt);
            }
        });
        this.jTextFieldTopTVD.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogTVDOffsetChart.this.jTextFieldTopTVDKeyTyped(evt);
            }
        });
        this.jTextFieldBaseTVD.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                DialogTVDOffsetChart.this.jTextFieldBaseTVDFocusLost(evt);
            }
        });
        this.jTextFieldBaseTVD.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogTVDOffsetChart.this.jTextFieldBaseTVDKeyTyped(evt);
            }
        });
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(null, "Units", 0, 0, null, new Color(51, 102, 204)));
        this.buttonGroupUnits.add(this.jRadioButtonFeet);
        this.jRadioButtonFeet.setText("Feet");
        this.jRadioButtonFeet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTVDOffsetChart.this.jRadioButtonFeetActionPerformed(evt);
            }
        });
        this.buttonGroupUnits.add(this.jRadioButtonMetres);
        this.jRadioButtonMetres.setText("Metres");
        this.jRadioButtonMetres.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTVDOffsetChart.this.jRadioButtonMetresActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((Component)this.jRadioButtonMetres).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jRadioButtonFeet).addContainerGap()));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.jRadioButtonMetres).add((Component)this.jRadioButtonFeet)));
        this.jPanelHorz.setBorder(BorderFactory.createTitledBorder(null, "Horizontal Axis", 0, 0, null, new Color(51, 102, 204)));
        this.jLabel3.setHorizontalAlignment(11);
        this.jLabel3.setText("Min:");
        this.jTextFieldMinVS.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogTVDOffsetChart.this.jTextFieldMinVSKeyTyped(evt);
            }
        });
        this.jLabel4.setHorizontalAlignment(11);
        this.jLabel4.setText("Max:");
        this.jTextFieldMaxVS.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogTVDOffsetChart.this.jTextFieldMaxVSKeyTyped(evt);
            }
        });
        this.jButtonCalcDefaultVS.setText("Get survey range");
        this.jButtonCalcDefaultVS.setToolTipText("Calculate VS range from deviation survey");
        this.jButtonCalcDefaultVS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTVDOffsetChart.this.jButtonCalcDefaultVSActionPerformed(evt);
            }
        });
        GroupLayout jPanelHorzLayout = new GroupLayout((Container)this.jPanelHorz);
        this.jPanelHorz.setLayout((LayoutManager)jPanelHorzLayout);
        jPanelHorzLayout.setHorizontalGroup((GroupLayout.Group)jPanelHorzLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelHorzLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelHorzLayout.createParallelGroup(1).add(2, (Component)this.jButtonCalcDefaultVS).add((GroupLayout.Group)jPanelHorzLayout.createSequentialGroup().add((GroupLayout.Group)jPanelHorzLayout.createParallelGroup(2).add((Component)this.jLabel3).add((Component)this.jLabel4)).addPreferredGap(0).add((GroupLayout.Group)jPanelHorzLayout.createParallelGroup(1).add((Component)this.jTextFieldMinVS, -1, 92, Short.MAX_VALUE).add((Component)this.jTextFieldMaxVS, -1, 92, Short.MAX_VALUE)))).addContainerGap()));
        jPanelHorzLayout.setVerticalGroup((GroupLayout.Group)jPanelHorzLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelHorzLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelHorzLayout.createParallelGroup(3).add((Component)this.jTextFieldMinVS, -2, -1, -2).add((Component)this.jLabel3)).addPreferredGap(0).add((GroupLayout.Group)jPanelHorzLayout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.jTextFieldMaxVS, -2, -1, -2)).addPreferredGap(1).add((Component)this.jButtonCalcDefaultVS).addContainerGap(-1, Short.MAX_VALUE)));
        this.jCheckBoxPlan.setText("Planned path");
        this.jCheckBoxSamples.setSelected(true);
        this.jCheckBoxSamples.setText("Samples");
        this.jCheckBoxFaults.setText("Faults");
        this.jButtonWellTVD.setText("Deviation Surveys...");
        this.jButtonWellTVD.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTVDOffsetChart.this.jButtonWellTVDActionPerformed(evt);
            }
        });
        this.jCheckBoxGrid.setText("Vertical grid lines");
        this.jLabel19.setText("Curve weight:");
        this.jSpinnerCurveWeight.setModel(new SpinnerNumberModel(Float.valueOf(3.0f), Float.valueOf(1.5f), Float.valueOf(10.0f), Float.valueOf(0.5f)));
        this.jLabel20.setText("mm");
        GroupLayout jPanelAxesLayout = new GroupLayout((Container)this.jPanelAxes);
        this.jPanelAxes.setLayout((LayoutManager)jPanelAxesLayout);
        jPanelAxesLayout.setHorizontalGroup((GroupLayout.Group)jPanelAxesLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelAxesLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelAxesLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelAxesLayout.createSequentialGroup().add((Component)this.jPanelHorz, -2, -1, -2).add(18, 18, 18).add((GroupLayout.Group)jPanelAxesLayout.createParallelGroup(1).add((Component)this.jCheckBoxPlan).add((Component)this.jCheckBoxFaults).add((Component)this.jCheckBoxSamples).add((Component)this.jCheckBoxGrid).add((GroupLayout.Group)jPanelAxesLayout.createSequentialGroup().add((Component)this.jLabel19).addPreferredGap(0).add((Component)this.jSpinnerCurveWeight, -2, 64, -2).addPreferredGap(0).add((Component)this.jLabel20)))).add((Component)this.jButtonWellTVD)).addContainerGap(53, Short.MAX_VALUE)));
        jPanelAxesLayout.setVerticalGroup((GroupLayout.Group)jPanelAxesLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelAxesLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelAxesLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelAxesLayout.createSequentialGroup().add(8, 8, 8).add((GroupLayout.Group)jPanelAxesLayout.createParallelGroup(3).add((Component)this.jLabel19).add((Component)this.jSpinnerCurveWeight, -2, -1, -2).add((Component)this.jLabel20)).add(18, 18, 18).add((Component)this.jCheckBoxPlan).addPreferredGap(0).add((Component)this.jCheckBoxSamples).addPreferredGap(0).add((Component)this.jCheckBoxFaults).addPreferredGap(0).add((Component)this.jCheckBoxGrid)).add((Component)this.jPanelHorz, -2, -1, -2)).addPreferredGap(0, 83, Short.MAX_VALUE).add((Component)this.jButtonWellTVD).addContainerGap()));
        this.jTabbedPane1.addTab("Panel", this.jPanelAxes);
        this.jCheckBoxShowStrat.setText("Show curve stratigraphy:");
        this.jCheckBoxShowStrat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTVDOffsetChart.this.jCheckBoxShowStratActionPerformed(evt);
            }
        });
        this.jCheckBoxUnitNames.setText("Unit names:");
        this.jCheckBoxUnitNames.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTVDOffsetChart.this.jCheckBoxUnitNamesActionPerformed(evt);
            }
        });
        this.buttonGroupNames.add(this.jRadioButtonNames);
        this.jRadioButtonNames.setText("Names");
        this.buttonGroupNames.add(this.jRadioButtonAbrs);
        this.jRadioButtonAbrs.setSelected(true);
        this.jRadioButtonAbrs.setText("Abbreviations");
        this.jLabel8.setText("Version:");
        this.jLabelVersion.setText("jLabel10");
        this.jTextFieldStratigraphy.setEditable(false);
        this.jTextFieldStratigraphy.setBackground(new Color(255, 255, 204));
        this.jLabel6.setText("Type:");
        this.jComboBoxColMap.setModel(this.colModel);
        this.jLabel10.setText("Column:");
        this.jButtonColMap.setText("Column mapping...");
        this.jButtonColMap.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonColMap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTVDOffsetChart.this.jButtonColMapActionPerformed(evt);
            }
        });
        this.jButtonStratigraphy.setText("...");
        this.jButtonStratigraphy.setToolTipText("Select stratigraphy type");
        this.jButtonStratigraphy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTVDOffsetChart.this.jButtonStratigraphyActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(2).add((Component)this.jLabel8).add((Component)this.jLabel6)).add((Component)this.jLabel10, -2, 39, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jLabelVersion).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jComboBoxColMap, -2, 157, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jButtonColMap)).add((Component)this.jTextFieldStratigraphy)).addPreferredGap(0).add((Component)this.jButtonStratigraphy, -2, 26, -2).add(22, 22, 22))).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel8).add((Component)this.jLabelVersion)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jTextFieldStratigraphy, -2, -1, -2).add((Component)this.jLabel6).add((Component)this.jButtonStratigraphy)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jComboBoxColMap, -2, -1, -2).add((Component)this.jLabel10).add((Component)this.jButtonColMap)).addContainerGap()));
        this.jCheckBoxEvents.setText("Events:");
        this.jCheckBoxEvents.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTVDOffsetChart.this.jCheckBoxEventsActionPerformed(evt);
            }
        });
        this.buttonGroupEvents.add(this.jRadioButtonEvtHorz);
        this.jRadioButtonEvtHorz.setText("Horizontal labels");
        this.buttonGroupEvents.add(this.jRadioButtonEvtKey);
        this.jRadioButtonEvtKey.setText("Key");
        this.buttonGroupEvents.add(this.jRadioButtonEvtNone);
        this.jRadioButtonEvtNone.setText("No labels");
        GroupLayout jPanelStratLayout = new GroupLayout((Container)this.jPanelStrat);
        this.jPanelStrat.setLayout((LayoutManager)jPanelStratLayout);
        jPanelStratLayout.setHorizontalGroup((GroupLayout.Group)jPanelStratLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelStratLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelStratLayout.createParallelGroup(1).add((Component)this.jCheckBoxShowStrat).add((Component)this.jPanel1, -2, 368, -2).add((GroupLayout.Group)jPanelStratLayout.createSequentialGroup().add((GroupLayout.Group)jPanelStratLayout.createParallelGroup(1).add((Component)this.jCheckBoxUnitNames).add((Component)this.jCheckBoxEvents)).addPreferredGap(1).add((GroupLayout.Group)jPanelStratLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelStratLayout.createSequentialGroup().add((Component)this.jRadioButtonEvtHorz).addPreferredGap(0).add((Component)this.jRadioButtonEvtKey).addPreferredGap(0).add((Component)this.jRadioButtonEvtNone)).add((GroupLayout.Group)jPanelStratLayout.createSequentialGroup().add((Component)this.jRadioButtonNames).addPreferredGap(1).add((Component)this.jRadioButtonAbrs))))).addContainerGap(11, Short.MAX_VALUE)));
        jPanelStratLayout.setVerticalGroup((GroupLayout.Group)jPanelStratLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelStratLayout.createSequentialGroup().add(19, 19, 19).add((Component)this.jCheckBoxShowStrat).addPreferredGap(1).add((Component)this.jPanel1, -2, -1, -2).add(9, 9, 9).add((GroupLayout.Group)jPanelStratLayout.createParallelGroup(3).add((Component)this.jCheckBoxUnitNames).add((Component)this.jRadioButtonNames).add((Component)this.jRadioButtonAbrs)).addPreferredGap(1).add((GroupLayout.Group)jPanelStratLayout.createParallelGroup(3).add((Component)this.jCheckBoxEvents).add((Component)this.jRadioButtonEvtKey).add((Component)this.jRadioButtonEvtHorz).add((Component)this.jRadioButtonEvtNone)).add(65, 65, 65)));
        this.jTabbedPane1.addTab("Interpretations", this.jPanelStrat);
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(null, "Trace 1", 0, 0, null, new Color(51, 102, 204)));
        this.jComboBoxTrace1.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel12.setText("Trace width:");
        this.jTextFieldTrace1Width.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogTVDOffsetChart.this.jTextFieldTrace1WidthKeyTyped(evt);
            }
        });
        this.jLabel13.setText("Offset:");
        this.jTextFieldTrace1Offset.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogTVDOffsetChart.this.jTextFieldTrace1OffsetKeyTyped(evt);
            }
        });
        this.jLabel14.setText("Depth shift:");
        this.jTextFieldDepthShift1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogTVDOffsetChart.this.jTextFieldDepthShift1KeyTyped(evt);
            }
        });
        this.jLabelShiftUnits.setText("m");
        this.jCheckBoxLog1ScaleLine.setText("Plot line at scale centre");
        this.jButtonTrace1Props.setText("Properties...");
        this.jButtonTrace1Props.setToolTipText("<html>Set log header properties for this<br>\n trace on this chart</html>");
        this.jButtonTrace1Props.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTVDOffsetChart.this.jButtonTrace1PropsActionPerformed(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout((Container)this.jPanel4);
        this.jPanel4.setLayout((LayoutManager)jPanel4Layout);
        jPanel4Layout.setHorizontalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((Component)this.jCheckBoxLog1ScaleLine).add(2, (GroupLayout.Group)jPanel4Layout.createSequentialGroup().add((GroupLayout.Group)jPanel4Layout.createParallelGroup(2).add((Component)this.jLabel12).add((Component)this.jLabel13).add((Component)this.jLabel14)).addPreferredGap(0).add((GroupLayout.Group)jPanel4Layout.createParallelGroup(1, false).add((Component)this.jTextFieldDepthShift1).add((Component)this.jTextFieldTrace1Offset).add((Component)this.jTextFieldTrace1Width, -2, 54, -2)).addPreferredGap(0).add((Component)this.jLabelShiftUnits))).add((GroupLayout.Group)jPanel4Layout.createParallelGroup(2).add((Component)this.jButtonTrace1Props).add((Component)this.jComboBoxTrace1, -2, 151, -2))).addContainerGap()));
        jPanel4Layout.setVerticalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel4Layout.createSequentialGroup().add((Component)this.jComboBoxTrace1, -2, -1, -2).addPreferredGap(0).add((Component)this.jButtonTrace1Props).addPreferredGap(0, 23, Short.MAX_VALUE).add((GroupLayout.Group)jPanel4Layout.createParallelGroup(3).add((Component)this.jTextFieldTrace1Width, -2, -1, -2).add((Component)this.jLabel12)).addPreferredGap(0).add((GroupLayout.Group)jPanel4Layout.createParallelGroup(3).add((Component)this.jLabel13).add((Component)this.jTextFieldTrace1Offset, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel4Layout.createParallelGroup(3).add((Component)this.jTextFieldDepthShift1, -2, -1, -2).add((Component)this.jLabel14).add((Component)this.jLabelShiftUnits)).add(18, 18, 18).add((Component)this.jCheckBoxLog1ScaleLine).add(32, 32, 32)));
        this.jPanel5.setBorder(BorderFactory.createTitledBorder(null, "Trace 2", 0, 0, null, new Color(51, 102, 204)));
        this.jComboBoxTrace2.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jButtonTrace2Props.setText("Properties...");
        this.jButtonTrace2Props.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTVDOffsetChart.this.jButtonTrace2PropsActionPerformed(evt);
            }
        });
        this.jTextFieldTrace2Width.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogTVDOffsetChart.this.jTextFieldTrace2WidthKeyTyped(evt);
            }
        });
        this.jTextFieldTrace2Offset.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogTVDOffsetChart.this.jTextFieldTrace2OffsetKeyTyped(evt);
            }
        });
        this.jTextFieldDepthShift2.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogTVDOffsetChart.this.jTextFieldDepthShift2KeyTyped(evt);
            }
        });
        this.jCheckBoxLog2ScaleLine.setText("Plot line at scale centre");
        this.jLabelShiftUnits2.setText("m");
        this.jLabel15.setText("Trace width:");
        this.jLabel16.setText("Depth shift:");
        this.jLabel17.setText("Offset:");
        GroupLayout jPanel5Layout = new GroupLayout((Container)this.jPanel5);
        this.jPanel5.setLayout((LayoutManager)jPanel5Layout);
        jPanel5Layout.setHorizontalGroup((GroupLayout.Group)jPanel5Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel5Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel5Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel5Layout.createSequentialGroup().add(0, 62, Short.MAX_VALUE).add((Component)this.jButtonTrace2Props)).add((GroupLayout.Group)jPanel5Layout.createSequentialGroup().add((GroupLayout.Group)jPanel5Layout.createParallelGroup(1).add((Component)this.jCheckBoxLog2ScaleLine).add(2, (GroupLayout.Group)jPanel5Layout.createSequentialGroup().add((GroupLayout.Group)jPanel5Layout.createParallelGroup(2).add((Component)this.jLabel15).add((Component)this.jLabel17).add((Component)this.jLabel16)).addPreferredGap(0).add((GroupLayout.Group)jPanel5Layout.createParallelGroup(1, false).add((Component)this.jTextFieldDepthShift2).add((Component)this.jTextFieldTrace2Offset).add((Component)this.jTextFieldTrace2Width, -2, 54, -2)).addPreferredGap(0).add((Component)this.jLabelShiftUnits2))).add(0, 18, Short.MAX_VALUE)).add((Component)this.jComboBoxTrace2, 0, 155, Short.MAX_VALUE)).addContainerGap()));
        jPanel5Layout.setVerticalGroup((GroupLayout.Group)jPanel5Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel5Layout.createSequentialGroup().add((Component)this.jComboBoxTrace2, -2, -1, -2).addPreferredGap(0).add((Component)this.jButtonTrace2Props).add(18, 18, 18).add((GroupLayout.Group)jPanel5Layout.createParallelGroup(3).add((Component)this.jTextFieldTrace2Width, -2, -1, -2).add((Component)this.jLabel15)).addPreferredGap(0).add((GroupLayout.Group)jPanel5Layout.createParallelGroup(3).add((Component)this.jLabel17).add((Component)this.jTextFieldTrace2Offset, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel5Layout.createParallelGroup(3).add((Component)this.jTextFieldDepthShift2, -2, -1, -2).add((Component)this.jLabel16).add((Component)this.jLabelShiftUnits2)).add(18, 18, 18).add((Component)this.jCheckBoxLog2ScaleLine).addContainerGap(33, Short.MAX_VALUE)));
        GroupLayout jPanelLogsLayout = new GroupLayout((Container)this.jPanelLogs);
        this.jPanelLogs.setLayout((LayoutManager)jPanelLogsLayout);
        jPanelLogsLayout.setHorizontalGroup((GroupLayout.Group)jPanelLogsLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelLogsLayout.createSequentialGroup().add(6, 6, 6).add((Component)this.jPanel4, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel5, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelLogsLayout.setVerticalGroup((GroupLayout.Group)jPanelLogsLayout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanelLogsLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelLogsLayout.createParallelGroup(1).add((Component)this.jPanel4, -1, -1, Short.MAX_VALUE).add((Component)this.jPanel5, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        this.jTabbedPane1.addTab("Wireline Logs", this.jPanelLogs);
        this.jTabbedPane2.addTab("Horizontal Length Panel", this.jTabbedPane1);
        this.jLabel9.setText("Well:");
        this.jTextFieldMotherbore.setEditable(false);
        this.jTextFieldMotherbore.setBackground(new Color(255, 255, 204));
        this.jTextFieldMotherbore.setText("jTextField");
        this.jButtonSelectMB.setText("...");
        this.jButtonSelectMB.setToolTipText("Select a well");
        this.jButtonSelectMB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTVDOffsetChart.this.jButtonSelectMBActionPerformed(evt);
            }
        });
        this.jButtonClearMB.setText("Clear");
        this.jButtonClearMB.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonClearMB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTVDOffsetChart.this.jButtonClearMBActionPerformed(evt);
            }
        });
        this.jLabel7.setText("Motherbore chart panels:");
        GroupLayout jPanelMotherBlockLayout = new GroupLayout((Container)this.jPanelMotherBlock);
        this.jPanelMotherBlock.setLayout((LayoutManager)jPanelMotherBlockLayout);
        jPanelMotherBlockLayout.setHorizontalGroup((GroupLayout.Group)jPanelMotherBlockLayout.createParallelGroup(1).add(0, 374, Short.MAX_VALUE));
        jPanelMotherBlockLayout.setVerticalGroup((GroupLayout.Group)jPanelMotherBlockLayout.createParallelGroup(1).add(0, 218, Short.MAX_VALUE));
        GroupLayout jPanelMotherLayout = new GroupLayout((Container)this.jPanelMother);
        this.jPanelMother.setLayout((LayoutManager)jPanelMotherLayout);
        jPanelMotherLayout.setHorizontalGroup((GroupLayout.Group)jPanelMotherLayout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanelMotherLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelMotherLayout.createParallelGroup(2).add(1, (Component)this.jPanelMotherBlock, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)jPanelMotherLayout.createSequentialGroup().add((Component)this.jLabel9).addPreferredGap(0).add((Component)this.jTextFieldMotherbore, -1, 253, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jButtonSelectMB, -2, 36, -2).addPreferredGap(0).add((Component)this.jButtonClearMB)).add(1, (GroupLayout.Group)jPanelMotherLayout.createSequentialGroup().add((Component)this.jLabel7).add(0, 252, Short.MAX_VALUE))).addContainerGap()));
        jPanelMotherLayout.setVerticalGroup((GroupLayout.Group)jPanelMotherLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelMotherLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelMotherLayout.createParallelGroup(3).add((Component)this.jTextFieldMotherbore, -2, -1, -2).add((Component)this.jLabel9).add((Component)this.jButtonClearMB).add((Component)this.jButtonSelectMB)).addPreferredGap(1).add((Component)this.jLabel7, -2, 14, -2).addPreferredGap(0).add((Component)this.jPanelMotherBlock, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane2.addTab("Motherbore", this.jPanelMother);
        this.jButtonFonts.setText("Options...");
        this.jButtonFonts.setToolTipText("Chart display options, including fonts and core corrections");
        this.jButtonFonts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTVDOffsetChart.this.jButtonFontsActionPerformed(evt);
            }
        });
        this.jLabel11.setText("DD:");
        this.jLabel18.setText("DD:");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add(0, 192, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel).add(10, 10, 10)).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabel1).add((Component)this.jLabel2).add((Component)this.jLabel5)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jComboBoxVerticalScale, 0, 81, Short.MAX_VALUE).add((Component)this.jTextFieldBaseTVD, -1, 81, Short.MAX_VALUE).add((Component)this.jTextFieldTopTVD)).add(14, 14, 14).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel11).add((Component)this.jLabel18)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jTextFieldTopDepth, -2, 81, -2).add((Component)this.jTextFieldBaseDepth, -2, 81, -2)).add(18, 18, 18).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jPanel3, -2, -1, -2).add(2, (Component)this.jButtonFonts)).addContainerGap(-1, Short.MAX_VALUE)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jTabbedPane2, -2, 0, Short.MAX_VALUE).add((Component)this.jSeparator1, -1, 399, Short.MAX_VALUE)).addContainerGap()))));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jTextFieldTopTVD, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jTextFieldBaseTVD, -2, -1, -2)).add(7, 7, 7).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jComboBoxVerticalScale, -2, -1, -2).add((Component)this.jLabel5).add((Component)this.jButtonFonts))).add((Component)this.jPanel3, -2, -1, -2).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel11).add((Component)this.jTextFieldTopDepth, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel18).add((Component)this.jTextFieldBaseDepth, -2, -1, -2)))).add(18, 18, 18).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((Component)this.jTabbedPane2, -2, -1, -2).addPreferredGap(0, 8, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonHelp).add((Component)this.jButtonOK)).addContainerGap()));
        this.jTabbedPane2.getAccessibleContext().setAccessibleName("Horizontal Length Panel");
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.jPanelMotherBlock.cancel();
        this.jPanelWellBlock.cancel();
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        float VSmax;
        float baseTVD;
        if (this.jTextFieldTopTVD.getText().trim().isEmpty()) {
            JOptionPane.showMessageDialog(this, "Enter a top depth", this.getTitle(), 2);
            this.jTextFieldTopTVD.requestFocusInWindow();
            return;
        }
        if (this.jTextFieldBaseTVD.getText().trim().isEmpty()) {
            JOptionPane.showMessageDialog(this, "Enter a base depth", this.getTitle(), 2);
            this.jTextFieldBaseTVD.requestFocusInWindow();
            return;
        }
        if (this.jTextFieldMinVS.getText().trim().isEmpty()) {
            JOptionPane.showMessageDialog(this, "Enter a minimum vertical section", this.getTitle(), 2);
            this.jTextFieldMinVS.requestFocusInWindow();
            return;
        }
        if (this.jTextFieldMaxVS.getText().trim().isEmpty()) {
            JOptionPane.showMessageDialog(this, "Enter maximum vertical section", this.getTitle(), 2);
            this.jTextFieldMaxVS.requestFocusInWindow();
            return;
        }
        float topTVD = Float.parseFloat(this.jTextFieldTopTVD.getText());
        if (topTVD > (baseTVD = Float.parseFloat(this.jTextFieldBaseTVD.getText()))) {
            JOptionPane.showMessageDialog(this, "Top depth is greater than base depth", this.getTitle(), 2);
            return;
        }
        float scale = Float.parseFloat("" + this.jComboBoxVerticalScale.getSelectedItem());
        float VSmin = SB.convToM((float)Float.parseFloat(this.jTextFieldMinVS.getText()), (char)this.units);
        if (VSmin > (VSmax = SB.convToM((float)Float.parseFloat(this.jTextFieldMaxVS.getText()), (char)this.units))) {
            JOptionPane.showMessageDialog(this, "Minimum Vertical Section is greater than Maximum", this.getTitle(), 2);
            return;
        }
        this.units = (char)(this.jRadioButtonFeet.isSelected() ? 70 : 77);
        this.block.prop.min = SB.convToM((float)topTVD, (char)this.units);
        this.block.prop.max = SB.convToM((float)baseTVD, (char)this.units);
        this.block.setScale(scale);
        this.block.prop.units = this.units;
        this.motherBlock.prop.units = this.units;
        this.prop.minVS = VSmin;
        this.prop.maxVS = VSmax;
        this.prop.curveWeight = ((Float)this.jSpinnerCurveWeight.getModel().getValue()).floatValue();
        this.prop.drawPlan = this.jCheckBoxPlan.isSelected();
        this.prop.drawSamples = this.jCheckBoxSamples.isSelected();
        this.prop.drawFaults = this.jCheckBoxFaults.isSelected();
        this.prop.drawGridLines = this.jCheckBoxGrid.isSelected();
        this.prop.drawIGD = this.jCheckBoxShowStrat.isSelected() && this.prop.igdType >= 0 && this.vsPanel.getInterp() != null;
        int col = this.jComboBoxColMap.getItemAt(0) != noInterpString && this.jComboBoxColMap.getItemAt(0) != noIGDTypeString ? this.jComboBoxColMap.getSelectedIndex() + 1 : -1;
        this.prop.col = col;
        this.prop.drawUnitNames = this.jCheckBoxUnitNames.isSelected();
        this.prop.useAbrs = this.jRadioButtonAbrs.isSelected();
        this.prop.drawEvents = this.jCheckBoxEvents.isSelected();
        int evtLabelStyle = 2;
        if (this.jRadioButtonEvtHorz.isSelected()) {
            evtLabelStyle = 0;
        } else if (this.jRadioButtonEvtNone.isSelected()) {
            evtLabelStyle = 1;
        }
        this.prop.eventLabelStyle = evtLabelStyle;
        this.setLogProps(true);
        this.setLogProps(false);
        this.prop.encode(this.db);
        this.vsPanel.setProperties(this.prop);
        this.chart.chartProperties = this.cp;
        this.jPanelMotherBlock.confirm();
        this.jPanelWellBlock.confirm();
        try {
            if (this.motherBlock.well != null) {
                this.prop.setMotherID(this.motherBlock.well.getWellID());
            }
            String prefKey = this.block.getPrefKey(3);
            this.chart.savePreference(this.db, prefKey);
            this.db.commit();
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        this.setOK();
    }

    private void setLogProps(boolean trace1) {
        JComboBox box = trace1 ? this.jComboBoxTrace1 : this.jComboBoxTrace2;
        String abr = (String)box.getSelectedItem();
        PanelWellVSProperties.LogInfo info = trace1 ? this.prop.logInfo1 : this.prop.logInfo2;
        LogDef def = info.logDef;
        if (abr == null || abr.isEmpty()) {
            def = null;
        } else if (def != null && !def.getAbr().equals(abr) || def == null) {
            try {
                def = new LogDef((LogDef)this.db.getLogDef().get(abr));
            }
            catch (SQLException sql) {
                sql.printStackTrace();
            }
        }
        info.logDef = def;
        info.logColWidth = Float.parseFloat((trace1 ? this.jTextFieldTrace1Width : this.jTextFieldTrace2Width).getText());
        info.logShift = SB.convToM((double)Double.parseDouble(trace1 ? this.jTextFieldDepthShift1.getText() : this.jTextFieldDepthShift2.getText()), (char)this.units);
        info.logTraceOffset = Float.parseFloat((trace1 ? this.jTextFieldTrace1Offset : this.jTextFieldTrace2Offset).getText());
        info.logScaleLine = trace1 ? this.jCheckBoxLog1ScaleLine.isSelected() : this.jCheckBoxLog2ScaleLine.isSelected();
    }

    private void checkDepthField(JTextField field, KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)field, (int)8, (KeyEvent)evt, (boolean)true)) {
            this.getToolkit().beep();
        }
    }

    private void jRadioButtonMetresActionPerformed(ActionEvent evt) {
        this.setUnits();
    }

    private void jRadioButtonFeetActionPerformed(ActionEvent evt) {
        this.setUnits();
    }

    private void jButtonWellTVDActionPerformed(ActionEvent evt) {
        try {
            DialogTVD dialog = new DialogTVD(this, true, this.block.well, this.units);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK) {
                this.prop.maxVS = (float)this.block.well.getTVDlist(false).getMaxVS() + 20.0f;
                this.prop.minVS = (float)this.block.well.getTVDlist(false).getMinVS();
                this.jTextFieldMaxVS.setText("" + this.prop.maxVS);
                this.jTextFieldMinVS.setText("" + this.prop.minVS);
            }
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.getMessage(), (Exception)ex);
            ex.printStackTrace();
        }
    }

    private void jTextFieldMinVSKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldMinVS, (int)8, (KeyEvent)evt, (boolean)true)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldMaxVSKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldMaxVS, (int)8, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonFontsActionPerformed(ActionEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        DialogChartFont dialog = new DialogChartFont(this, true, this.cp);
        dialog.setLocationRelativeTo(this);
        this.setCursor(Cursor.getDefaultCursor());
        dialog.setVisible(true);
    }

    private void jButtonSelectMBActionPerformed(ActionEvent evt) {
        DialogSelectWell dialog = new DialogSelectWell(this, true, this.db, false, null);
        dialog.setVisible(true);
        try {
            if (dialog.selection != null) {
                Well motherWell = dialog.selection.get(0);
                motherWell.getSamples();
                motherWell.loadInterps();
                this.motherBlock.setWell(motherWell);
                this.setMotherboreString();
                this.motherBlock.setData(this.cp);
            }
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
        catch (SBException sbe) {
            sbe.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void jButtonStratigraphyActionPerformed(ActionEvent evt) {
        DialogSelectIGDPanel dialog = new DialogSelectIGDPanel(this, true, this.db, this.block, this.prop, "Select Interpretation", this.vsPanel.getInterp());
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.isOK()) {
            this.jTextFieldStratigraphy.setEnabled(true);
            this.setStratText();
            this.jCheckBoxShowStrat.setSelected(true);
            this.fillColCombo();
        }
    }

    private void jCheckBoxShowStratActionPerformed(ActionEvent evt) {
        if (!this.inStartup) {
            if (this.jCheckBoxShowStrat.isSelected()) {
                this.jTextFieldStratigraphy.setEnabled(true);
            } else {
                this.jTextFieldStratigraphy.setEnabled(false);
            }
        }
    }

    private void jButtonClearMBActionPerformed(ActionEvent evt) {
        int opt;
        if (!this.motherBlock.panels.isEmpty() && (opt = JOptionPane.showConfirmDialog(this, "This will clear existing motherbore panels. Continue?", "Clear motherbore", 0, 3)) != 0) {
            return;
        }
        this.motherBlock.setWell(null);
        this.setMotherboreString();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogtvdoffsetchart.html");
    }

    private void jButtonCalcDefaultVSActionPerformed(ActionEvent evt) {
        try {
            if (this.block.well.getTVDlist(false) == null) {
                JOptionPane.showMessageDialog(this, "No deviation survey", this.getTitle(), 2);
                return;
            }
            Point2D.Float minmax = PanelWellVS.calcDefaultVSRange(this.block);
            this.prop.minVS = (float)((Point2D)minmax).getX();
            this.prop.maxVS = (float)((Point2D)minmax).getY();
            this.jTextFieldMinVS.setText(SB.floatString((double)SB.convFromM((double)this.prop.minVS, (char)this.block.prop.units), (int)2));
            this.jTextFieldMaxVS.setText(SB.floatString((double)SB.convFromM((double)this.prop.maxVS, (char)this.block.prop.units), (int)2));
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
    }

    private void jCheckBoxUnitNamesActionPerformed(ActionEvent evt) {
        boolean selected = this.jCheckBoxUnitNames.isSelected();
        this.jRadioButtonAbrs.setEnabled(selected);
        this.jRadioButtonNames.setEnabled(selected);
    }

    private void jButtonColMapActionPerformed(ActionEvent evt) {
        try {
            DialogIGDColmap dialog = new DialogIGDColmap(this, true, this.db, this.block.well, this.jPanelWell.getInterp(), this.prop.igdType);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK) {
                this.fillColCombo();
            }
        }
        catch (SQLException sqle) {
            FrameJsbugs.showStackError("Error opening column mapping dialog", sqle, this.db);
        }
    }

    private void jButtonTrace1PropsActionPerformed(ActionEvent evt) {
        this.traceProperties(true);
    }

    private void traceProperties(boolean trace1) {
        LogDef vsLogDef;
        JComboBox box = trace1 ? this.jComboBoxTrace1 : this.jComboBoxTrace2;
        String abr = (String)box.getSelectedItem();
        if (abr == null || abr.isEmpty()) {
            this.getToolkit().beep();
            return;
        }
        LogDef def = null;
        LogDef logDef = vsLogDef = trace1 ? this.prop.logInfo1.logDef : this.prop.logInfo2.logDef;
        if (vsLogDef != null && vsLogDef.getAbr().equals(abr)) {
            def = vsLogDef;
        }
        if (vsLogDef == null || vsLogDef != null && !vsLogDef.getAbr().equals(abr)) {
            try {
                vsLogDef = def = new LogDef((LogDef)this.db.getLogDef().get(abr));
            }
            catch (SQLException sql) {
                sql.printStackTrace();
            }
        }
        DialogLogDef dialog = new DialogLogDef((Dialog)this, true, def, null);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    private void jTextFieldTrace1WidthKeyTyped(KeyEvent evt) {
        if (evt.getKeyChar() == '-') {
            this.getToolkit().beep();
            evt.consume();
            return;
        }
        if (SB.intFieldVal((JTextField)this.jTextFieldTrace1Width, (int)3, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldTrace1OffsetKeyTyped(KeyEvent evt) {
        if (evt.getKeyChar() == '-') {
            this.getToolkit().beep();
            evt.consume();
            return;
        }
        if (SB.intFieldVal((JTextField)this.jTextFieldTrace1Offset, (int)3, (KeyEvent)evt, (boolean)true)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldDepthShift1KeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldDepthShift1, (int)5, (KeyEvent)evt, (boolean)true)) {
            this.getToolkit().beep();
        }
    }

    private void jCheckBoxEventsActionPerformed(ActionEvent evt) {
        boolean selected = this.jCheckBoxEvents.isSelected();
        this.jRadioButtonEvtHorz.setEnabled(selected);
        this.jRadioButtonEvtKey.setEnabled(selected);
        this.jRadioButtonEvtNone.setEnabled(selected);
    }

    private void jTextFieldTrace2WidthKeyTyped(KeyEvent evt) {
        if (evt.getKeyChar() == '-') {
            this.getToolkit().beep();
            evt.consume();
            return;
        }
        if (SB.intFieldVal((JTextField)this.jTextFieldTrace2Width, (int)3, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldTrace2OffsetKeyTyped(KeyEvent evt) {
        if (evt.getKeyChar() == '-') {
            this.getToolkit().beep();
            evt.consume();
            return;
        }
        if (SB.intFieldVal((JTextField)this.jTextFieldTrace2Offset, (int)3, (KeyEvent)evt, (boolean)true)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldDepthShift2KeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldDepthShift2, (int)5, (KeyEvent)evt, (boolean)true)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonTrace2PropsActionPerformed(ActionEvent evt) {
        this.traceProperties(false);
    }

    private void jTextFieldTopTVDKeyTyped(KeyEvent evt) {
        this.checkDepthField(this.jTextFieldTopTVD, evt);
    }

    private void jTextFieldBaseTVDKeyTyped(KeyEvent evt) {
        this.checkDepthField(this.jTextFieldBaseTVD, evt);
    }

    private void jTextFieldTopTVDFocusLost(FocusEvent evt) {
        this.updateDepthField(true);
    }

    private void jTextFieldBaseTVDFocusLost(FocusEvent evt) {
        this.updateDepthField(false);
    }

    public void setStratText() {
        String scheme = "";
        String string = "<none>";
        if (this.prop.igdType >= 0 && this.vsPanel.getInterp() != null) {
            if (this.prop.schID >= 0) {
                try {
                    scheme = this.db.getIGDScheme(this.prop.schID).toString() + " : ";
                }
                catch (Exception e) {
                    scheme = "ERROR GETTING SCHEME : ";
                }
            }
            string = IGDInterval.getIGDName((int)this.prop.igdType) + " : " + scheme + this.vsPanel.getInterp().toString();
        }
        this.jTextFieldStratigraphy.setText(string);
    }

    private void enableAll(boolean enable) {
        this.jCheckBoxFaults.setSelected(enable);
        this.jCheckBoxFaults.setEnabled(enable);
        this.jTextFieldStratigraphy.setEnabled(enable);
        this.jButtonStratigraphy.setEnabled(enable);
    }

    private void updateDepthField(boolean top) {
        JTextField field = top ? this.jTextFieldTopDepth : this.jTextFieldBaseDepth;
        try {
            if (this.block.well.getTVDlist(false).getList().isEmpty()) {
                field.setText("");
                return;
            }
            double tvd = SB.convToM((double)Double.parseDouble(top ? this.jTextFieldTopTVD.getText() : this.jTextFieldBaseTVD.getText()), (char)this.units);
            if (tvd == 0.0) {
                field.setText("0");
                return;
            }
            TVDepth dd = this.block.well.getTVDlist(false).getDepth(tvd, top, null, null);
            if (dd != null) {
                field.setText(SB.floatString((double)SB.convFromM((double)dd.getDDepth(), (char)this.units), (int)2));
            } else if (tvd > this.block.well.getTVDlist(false).getBaseTVD()) {
                field.setText(SB.floatString((double)SB.convFromM((double)this.block.well.getTVDlist(false).getBaseDD(), (char)this.units), (int)2));
            } else {
                field.setText((top ? this.jTextFieldTopTVD : this.jTextFieldBaseTVD).getText());
            }
        }
        catch (Exception e) {
            SB.showStackError((String)"Error setting depth field", (Exception)e);
        }
    }

    private void setUnits() {
        if (this.jRadioButtonFeet.isSelected() && this.units != 'F') {
            this.units = (char)70;
            try {
                this.jTextFieldTopDepth.setText("" + SB.convFromM((double)Float.parseFloat(this.jTextFieldTopDepth.getText()), (char)'F'));
            }
            catch (Exception e) {
                this.jTextFieldTopDepth.setText("0.0");
            }
            try {
                this.jTextFieldBaseDepth.setText("" + SB.convFromM((double)Float.parseFloat(this.jTextFieldBaseDepth.getText()), (char)'F'));
            }
            catch (Exception e) {
                this.jTextFieldBaseDepth.setText("0.0");
            }
            try {
                this.jTextFieldMinVS.setText("" + SB.convFromM((double)Float.parseFloat(this.jTextFieldMinVS.getText()), (char)'F'));
            }
            catch (Exception e) {
                this.jTextFieldMinVS.setText("0.0");
            }
            try {
                this.jTextFieldMaxVS.setText("" + SB.convFromM((double)Float.parseFloat(this.jTextFieldMaxVS.getText()), (char)'F'));
            }
            catch (Exception e) {
                this.jTextFieldMaxVS.setText("0.0");
            }
            try {
                this.jTextFieldDepthShift1.setText("" + SB.convFromM((double)Double.parseDouble(this.jTextFieldDepthShift1.getText()), (char)'F'));
            }
            catch (Exception e) {
                this.jTextFieldDepthShift1.setText("0.0");
            }
            this.jLabelShiftUnits.setText("ft");
        } else {
            this.units = (char)77;
            try {
                this.jTextFieldTopDepth.setText("" + SB.convToM((float)Float.parseFloat(this.jTextFieldTopDepth.getText()), (char)'F'));
            }
            catch (Exception e) {
                this.jTextFieldTopDepth.setText("0.0");
            }
            try {
                this.jTextFieldBaseDepth.setText("" + SB.convToM((float)Float.parseFloat(this.jTextFieldBaseDepth.getText()), (char)'F'));
            }
            catch (Exception e) {
                this.jTextFieldBaseDepth.setText("0.0");
            }
            try {
                this.jTextFieldMinVS.setText("" + SB.convToM((float)Float.parseFloat(this.jTextFieldMinVS.getText()), (char)'F'));
            }
            catch (Exception e) {
                this.jTextFieldMinVS.setText("0.0");
            }
            try {
                this.jTextFieldMaxVS.setText("" + SB.convToM((float)Float.parseFloat(this.jTextFieldMaxVS.getText()), (char)'F'));
            }
            catch (Exception e) {
                this.jTextFieldMaxVS.setText("0.0");
            }
            try {
                this.jTextFieldDepthShift1.setText("" + SB.convToM((double)Double.parseDouble(this.jTextFieldDepthShift1.getText()), (char)'F'));
            }
            catch (Exception e) {
                this.jTextFieldDepthShift1.setText("0.0");
            }
            this.jLabelShiftUnits.setText("m");
        }
    }
}

