/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.StringTokenizer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import jsbugs.DialogTVDHeader;
import jsbugs.FrameJsbugs;
import util.SB;
import util.SbugsFileFilter;

public class DialogTVDReader
extends JDialog {
    File file;
    int nColumns = 0;
    boolean isOK = false;
    int depCol;
    int tvdCol;
    int inclCol;
    int azCol;
    int vsCol;
    int northCol;
    int eastCol;
    String header;
    boolean TVDSS;
    private JButton jButtonCancel;
    private JButton jButtonHeader;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonSelectFile;
    private JCheckBox jCheckBoxAZ;
    private JCheckBox jCheckBoxE;
    private JCheckBox jCheckBoxIC;
    private JCheckBox jCheckBoxMD;
    private JCheckBox jCheckBoxN;
    private JCheckBox jCheckBoxTVD;
    private JCheckBox jCheckBoxVS;
    private JLabel jLabel1;
    private JLabel jLabelNcolumns;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSpinner jSpinnerAZ;
    private JSpinner jSpinnerE;
    private JSpinner jSpinnerIC;
    private JSpinner jSpinnerMD;
    private JSpinner jSpinnerN;
    private JSpinner jSpinnerTVD;
    private JSpinner jSpinnerVS;
    private JTextArea jTextAreaFile;
    private JTextField jTextField1;

    public DialogTVDReader(JDialog parent, boolean modal, File file) throws FileNotFoundException, IOException {
        super((Dialog)parent, modal);
        this.file = file;
        this.initComponents();
        this.init();
    }

    private void init() throws FileNotFoundException, IOException {
        this.setTitle("Deviation Survey File Parameters");
        this.jTextField1.setText(this.file.getPath());
        BufferedReader reader = new BufferedReader(new FileReader(this.file));
        StringBuffer sb = new StringBuffer();
        String strLine = "";
        int totrows = 0;
        int tottok = 0;
        while ((strLine = reader.readLine()) != null) {
            sb.append(strLine + "\r\n");
            StringTokenizer tok = new StringTokenizer(strLine, " ,;\t");
            int ncols = tok.countTokens();
            ++totrows;
            tottok += ncols;
        }
        reader.close();
        this.jTextAreaFile.setText(sb.toString());
        float avgTok = (float)tottok / (float)totrows;
        this.nColumns = Math.round(avgTok);
        this.jLabelNcolumns.setText("No. of columns: " + this.nColumns);
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jButtonSelectFile = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonHelp = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaFile = new JTextArea();
        this.jLabelNcolumns = new JLabel();
        this.jCheckBoxMD = new JCheckBox();
        this.jSpinnerMD = new JSpinner();
        this.jCheckBoxTVD = new JCheckBox();
        this.jSpinnerTVD = new JSpinner();
        this.jSpinnerIC = new JSpinner();
        this.jCheckBoxIC = new JCheckBox();
        this.jSpinnerAZ = new JSpinner();
        this.jCheckBoxAZ = new JCheckBox();
        this.jSpinnerVS = new JSpinner();
        this.jCheckBoxVS = new JCheckBox();
        this.jSpinnerN = new JSpinner();
        this.jCheckBoxN = new JCheckBox();
        this.jSpinnerE = new JSpinner();
        this.jCheckBoxE = new JCheckBox();
        this.jButtonHeader = new JButton();
        this.jSeparator1 = new JSeparator();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(600, 450));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent evt) {
                DialogTVDReader.this.formWindowOpened(evt);
            }
        });
        this.jLabel1.setText("File:");
        this.jTextField1.setEditable(false);
        this.jTextField1.setBackground(new Color(255, 255, 204));
        this.jButtonSelectFile.setText("...");
        this.jButtonSelectFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTVDReader.this.jButtonSelectFileActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTVDReader.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTVDReader.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTVDReader.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jTextAreaFile.setEditable(false);
        this.jTextAreaFile.setColumns(20);
        this.jTextAreaFile.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextAreaFile);
        this.jLabelNcolumns.setFont(new Font("Tahoma", 1, 11));
        this.jLabelNcolumns.setText("No. columns: ");
        this.jCheckBoxMD.setText("Measured Depth");
        this.jCheckBoxMD.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTVDReader.this.jCheckBoxMDActionPerformed(evt);
            }
        });
        this.jSpinnerMD.setModel(new SpinnerNumberModel(1, 1, 15, 1));
        this.jSpinnerMD.setEnabled(false);
        this.jCheckBoxTVD.setText("TVD");
        this.jCheckBoxTVD.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTVDReader.this.jCheckBoxTVDActionPerformed(evt);
            }
        });
        this.jSpinnerTVD.setModel(new SpinnerNumberModel(0, 0, 15, 1));
        this.jSpinnerTVD.setEnabled(false);
        this.jSpinnerIC.setModel(new SpinnerNumberModel(0, 0, 15, 1));
        this.jSpinnerIC.setEnabled(false);
        this.jCheckBoxIC.setText("Inclination");
        this.jCheckBoxIC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTVDReader.this.jCheckBoxICActionPerformed(evt);
            }
        });
        this.jSpinnerAZ.setModel(new SpinnerNumberModel(0, 0, 15, 1));
        this.jSpinnerAZ.setEnabled(false);
        this.jCheckBoxAZ.setText("Azimuth");
        this.jCheckBoxAZ.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTVDReader.this.jCheckBoxAZActionPerformed(evt);
            }
        });
        this.jSpinnerVS.setModel(new SpinnerNumberModel(0, 0, 15, 1));
        this.jSpinnerVS.setEnabled(false);
        this.jCheckBoxVS.setText("Horizontal Length");
        this.jCheckBoxVS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTVDReader.this.jCheckBoxVSActionPerformed(evt);
            }
        });
        this.jSpinnerN.setModel(new SpinnerNumberModel(0, 0, 15, 1));
        this.jSpinnerN.setEnabled(false);
        this.jCheckBoxN.setText("Position North");
        this.jCheckBoxN.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTVDReader.this.jCheckBoxNActionPerformed(evt);
            }
        });
        this.jSpinnerE.setModel(new SpinnerNumberModel(0, 0, 15, 1));
        this.jSpinnerE.setEnabled(false);
        this.jCheckBoxE.setText("Position East");
        this.jCheckBoxE.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTVDReader.this.jCheckBoxEActionPerformed(evt);
            }
        });
        this.jButtonHeader.setText("Header...");
        this.jButtonHeader.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTVDReader.this.jButtonHeaderActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonSelectFile, -2, 30, -2)).addComponent(this.jScrollPane1, -1, 468, Short.MAX_VALUE)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(93, 93, 93).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jButtonCancel, -2, 79, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButtonOK, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonHelp, GroupLayout.Alignment.TRAILING, -1, 79, Short.MAX_VALUE)))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxMD).addComponent(this.jCheckBoxTVD).addComponent(this.jCheckBoxIC).addComponent(this.jCheckBoxAZ).addComponent(this.jCheckBoxVS).addComponent(this.jCheckBoxN).addComponent(this.jCheckBoxE).addComponent(this.jLabelNcolumns)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSpinnerMD, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent(this.jSpinnerTVD, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent(this.jSpinnerIC, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent(this.jSpinnerAZ, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent(this.jSpinnerVS, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent(this.jSpinnerN, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent(this.jSpinnerE, GroupLayout.Alignment.TRAILING, -2, -1, -2)))).addGroup(layout.createSequentialGroup().addGap(93, 93, 93).addComponent(this.jButtonHeader)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 154, -2))).addContainerGap()));
        layout.linkSize(0, this.jCheckBoxAZ, this.jCheckBoxE, this.jCheckBoxIC, this.jCheckBoxMD, this.jCheckBoxN, this.jCheckBoxTVD, this.jCheckBoxVS);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextField1, -2, -1, -2).addComponent(this.jButtonSelectFile)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1)).addGroup(layout.createSequentialGroup().addGap(39, 39, 39).addComponent(this.jLabelNcolumns).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jSpinnerMD, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpinnerTVD, -2, -1, -2).addGap(5, 5, 5).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSpinnerIC, -2, -1, -2).addComponent(this.jCheckBoxIC)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSpinnerAZ, -2, -1, -2).addComponent(this.jCheckBoxAZ)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSpinnerVS, -2, -1, -2).addComponent(this.jCheckBoxVS)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSpinnerN, -2, -1, -2).addComponent(this.jCheckBoxN)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSpinnerE, -2, -1, -2).addComponent(this.jCheckBoxE))).addGroup(layout.createSequentialGroup().addComponent(this.jCheckBoxMD).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxTVD))).addGap(18, 18, 18).addComponent(this.jSeparator1, -2, 11, -2).addGap(30, 30, 30).addComponent(this.jButtonHeader).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel))).addContainerGap()));
        this.pack();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogtvdreader");
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (!this.jCheckBoxMD.isSelected()) {
            JOptionPane.showMessageDialog(this, "No depth column selected", this.getTitle(), 2);
            return;
        }
        HashSet<Integer> columns = new HashSet<Integer>();
        this.depCol = (Integer)this.jSpinnerMD.getValue();
        columns.add(this.depCol);
        if (this.jCheckBoxTVD.isSelected()) {
            this.tvdCol = (Integer)this.jSpinnerTVD.getValue();
            if (!columns.add(this.tvdCol)) {
                JOptionPane.showMessageDialog(this, "Duplicate column", this.getTitle(), 2);
                return;
            }
        }
        if (this.jCheckBoxIC.isSelected()) {
            this.inclCol = (Integer)this.jSpinnerIC.getValue();
            if (!columns.add(this.inclCol)) {
                JOptionPane.showMessageDialog(this, "Duplicate column", this.getTitle(), 2);
                return;
            }
        }
        if (this.jCheckBoxAZ.isSelected()) {
            this.azCol = (Integer)this.jSpinnerAZ.getValue();
            if (!columns.add(this.azCol)) {
                JOptionPane.showMessageDialog(this, "Duplicate column", this.getTitle(), 2);
                return;
            }
        }
        if (this.jCheckBoxVS.isSelected()) {
            this.vsCol = (Integer)this.jSpinnerVS.getValue();
            if (!columns.add(this.vsCol)) {
                JOptionPane.showMessageDialog(this, "Duplicate column", this.getTitle(), 2);
                return;
            }
        }
        if (this.jCheckBoxN.isSelected()) {
            this.northCol = (Integer)this.jSpinnerN.getValue();
            if (!columns.add(this.northCol)) {
                JOptionPane.showMessageDialog(this, "Duplicate column", this.getTitle(), 2);
                return;
            }
        }
        if (this.jCheckBoxE.isSelected()) {
            this.eastCol = (Integer)this.jSpinnerE.getValue();
            if (!columns.add(this.eastCol)) {
                JOptionPane.showMessageDialog(this, "Duplicate column", this.getTitle(), 2);
                return;
            }
        }
        for (Integer i : columns) {
            if (i <= this.nColumns) continue;
            JOptionPane.showMessageDialog(this, "One or more of the columns selected exceeds the number of columns available.", this.getTitle(), 2);
            return;
        }
        this.isOK = true;
        this.dispose();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonSelectFileActionPerformed(ActionEvent evt) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setCurrentDirectory(this.file);
        SbugsFileFilter filter = new SbugsFileFilter();
        filter.addExtension("txt");
        if (jFileChooser.showOpenDialog(this) == 0) {
            this.file = jFileChooser.getSelectedFile();
            try {
                this.init();
            }
            catch (Exception ex) {
                SB.showStackError((String)ex.getMessage(), (Exception)ex);
                ex.printStackTrace();
            }
        }
    }

    private void jCheckBoxMDActionPerformed(ActionEvent evt) {
        this.jSpinnerMD.setEnabled(this.jCheckBoxMD.isSelected());
    }

    private void jCheckBoxTVDActionPerformed(ActionEvent evt) {
        this.setSpinner(this.jSpinnerTVD, this.jCheckBoxTVD);
    }

    private void jCheckBoxICActionPerformed(ActionEvent evt) {
        this.setSpinner(this.jSpinnerIC, this.jCheckBoxIC);
    }

    private void jCheckBoxAZActionPerformed(ActionEvent evt) {
        this.setSpinner(this.jSpinnerAZ, this.jCheckBoxAZ);
    }

    private void jCheckBoxVSActionPerformed(ActionEvent evt) {
        this.setSpinner(this.jSpinnerVS, this.jCheckBoxVS);
    }

    private void jCheckBoxNActionPerformed(ActionEvent evt) {
        this.setSpinner(this.jSpinnerN, this.jCheckBoxN);
    }

    private void jCheckBoxEActionPerformed(ActionEvent evt) {
        this.setSpinner(this.jSpinnerE, this.jCheckBoxE);
    }

    private void formWindowOpened(WindowEvent evt) {
        this.jTextAreaFile.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
    }

    private void jButtonHeaderActionPerformed(ActionEvent evt) {
        if (this.jTextAreaFile.getSelectedText() == null) {
            JOptionPane.showMessageDialog(this, "Make a selection in the text window that will form the header information", this.getTitle(), 1);
            return;
        }
        DialogTVDHeader dialog = new DialogTVDHeader(this, true, this.jTextAreaFile.getSelectedText(), false);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.isOK) {
            this.header = dialog.getHeader();
            this.TVDSS = dialog.getTVDSS();
        }
    }

    public boolean useCol(int col) {
        return col == this.depCol || col == this.tvdCol || col == this.inclCol || col == this.azCol || col == this.vsCol || col == this.northCol || col == this.eastCol;
    }

    private void setSpinner(JSpinner jSpinner, JCheckBox jCheckBox) {
        jSpinner.setEnabled(jCheckBox.isSelected());
        if (jCheckBox.isSelected()) {
            int max = 0;
            int value = 0;
            value = (Integer)this.jSpinnerMD.getValue();
            if (value > max) {
                max = value;
            }
            if ((value = ((Integer)this.jSpinnerTVD.getValue()).intValue()) > max) {
                max = value;
            }
            if ((value = ((Integer)this.jSpinnerIC.getValue()).intValue()) > max) {
                max = value;
            }
            if ((value = ((Integer)this.jSpinnerAZ.getValue()).intValue()) > max) {
                max = value;
            }
            if ((value = ((Integer)this.jSpinnerVS.getValue()).intValue()) > max) {
                max = value;
            }
            if ((value = ((Integer)this.jSpinnerN.getValue()).intValue()) > max) {
                max = value;
            }
            if ((value = ((Integer)this.jSpinnerE.getValue()).intValue()) > max) {
                max = value;
            }
            jSpinner.setValue(new Integer(max + 1));
        } else {
            jSpinner.setValue(new Integer(0));
        }
    }
}

