/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import jsbugs.FrameJsbugs;
import jsbugs.TWTTableModel;
import model2.Lastval;
import model2.SBdb;
import model2.TWTDepth;
import model2.TWTList;
import model2.Well;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;
import util.SbugsFileFilter;

public class DialogTWT
extends JDialog {
    Well well;
    char units;
    TWTTableModel model = new TWTTableModel();
    private JButton jButtonAddRows;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonInsertRow;
    private JButton jButtonOK;
    private JButton jButtonRead;
    private JButton jButtonRemove;
    private JButton jButtonSelectAll;
    private JScrollPane jScrollPane1;
    private JTable jTableTWT;

    public DialogTWT(Frame parent, boolean modal, Well well, char units) throws SQLException {
        super(parent, modal);
        this.well = well;
        this.units = units;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException {
        this.model.load(this.well.getTWTlist(), this.units);
        this.setTitle("Two Way Time : Edit");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        SB.setTableHeaderBold((JTable)this.jTableTWT);
        int col = 0;
        this.jTableTWT.getColumnModel().getColumn(col).setHeaderValue("Depth (" + SB.unitString((char)this.units) + ")");
        this.jTableTWT.getColumnModel().getColumn(col++).setPreferredWidth(40);
        this.jTableTWT.getColumnModel().getColumn(col).setHeaderValue("TWT (" + (this.units == 'M' ? "m" : "ft") + "/sec)");
        this.jTableTWT.getColumnModel().getColumn(col++).setPreferredWidth(30);
    }

    private void initComponents() {
        this.jButtonRead = new JButton();
        this.jButtonRemove = new JButton();
        this.jButtonSelectAll = new JButton();
        this.jButtonInsertRow = new JButton();
        this.jButtonAddRows = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTableTWT = new JTable();
        this.jButtonHelp = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(330, 330));
        this.jButtonRead.setText("Read...");
        this.jButtonRead.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTWT.this.jButtonReadActionPerformed(evt);
            }
        });
        this.jButtonRemove.setText("Remove");
        this.jButtonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTWT.this.jButtonRemoveActionPerformed(evt);
            }
        });
        this.jButtonSelectAll.setText("Select all");
        this.jButtonSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTWT.this.jButtonSelectAllActionPerformed(evt);
            }
        });
        this.jButtonInsertRow.setText("Insert row");
        this.jButtonInsertRow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTWT.this.jButtonInsertRowActionPerformed(evt);
            }
        });
        this.jButtonAddRows.setText("Add rows...");
        this.jButtonAddRows.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonAddRows.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTWT.this.jButtonAddRowsActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTWT.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTWT.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jTableTWT.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTableTWT);
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTWT.this.jButtonHelpActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 214, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jButtonCancel, -2, 83, -2).add((Component)this.jButtonHelp, -2, 83, -2).add((Component)this.jButtonOK, -2, 83, -2).add((Component)this.jButtonSelectAll, -2, 83, -2).add((Component)this.jButtonRemove, -2, 83, -2).add((Component)this.jButtonRead, -2, 83, -2).add((Component)this.jButtonAddRows, -2, 83, -2).add((Component)this.jButtonInsertRow)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.jScrollPane1, -1, 304, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonAddRows).addPreferredGap(0).add((Component)this.jButtonInsertRow).addPreferredGap(0).add((Component)this.jButtonSelectAll).addPreferredGap(0).add((Component)this.jButtonRemove).addPreferredGap(0).add((Component)this.jButtonRead).addPreferredGap(0, 84, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel))).addContainerGap()));
        this.pack();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        try {
            TWTList newList = new TWTList(this.well.getDataModel());
            this.model.save(newList);
            newList.store(this.well.getWellID());
            this.well.getDataModel().commit();
            this.model.save(this.well.getTWTlist());
            this.well.getTWTlist().notifyObservers();
            this.dispose();
        }
        catch (SBException ex) {
            JOptionPane.showMessageDialog(this, "Error saving data: " + ex.getMessage(), this.getTitle(), 0);
            ex.printStackTrace();
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(this, "Error saving data: " + ex.getMessage(), this.getTitle(), 0);
            ex.printStackTrace();
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonInsertRowActionPerformed(ActionEvent evt) {
        int i;
        if (this.jTableTWT.getSelectedRow() < 0) {
            JOptionPane.showMessageDialog(this, "Select a row insertion point.");
            return;
        }
        int insertionPoint = this.jTableTWT.getSelectedRow();
        Float[] oldDepth = this.model.depth;
        Float[] oldTwt = this.model.twt;
        this.model.setSize(this.model.rowCount + 1);
        for (i = 0; i < insertionPoint; ++i) {
            this.model.depth[i] = oldDepth[i];
            this.model.twt[i] = oldTwt[i];
        }
        for (i = insertionPoint + 1; i < this.model.rowCount; ++i) {
            this.model.depth[i] = oldDepth[i - 1];
            this.model.twt[i] = oldTwt[i - 1];
        }
        this.jTableTWT.clearSelection();
        this.jTableTWT.updateUI();
    }

    private void jButtonSelectAllActionPerformed(ActionEvent evt) {
        this.jTableTWT.selectAll();
    }

    private void jButtonRemoveActionPerformed(ActionEvent evt) {
        int[] exclusions = this.jTableTWT.getSelectedRows();
        Float[] newDepth = new Float[this.model.rowCount - exclusions.length];
        Float[] newTWT = new Float[this.model.rowCount - exclusions.length];
        for (int i = 0; i < exclusions.length; ++i) {
            this.model.depth[exclusions[i]] = null;
            this.model.twt[exclusions[i]] = null;
        }
        int j = 0;
        for (int i = 0; i < this.model.rowCount; ++i) {
            if (this.model.depth[i] == null) continue;
            newDepth[j] = this.model.depth[i];
            newTWT[j] = this.model.twt[i];
            ++j;
        }
        this.model.depth = newDepth;
        this.model.twt = newTWT;
        this.model.rowCount = newDepth.length;
        this.jTableTWT.clearSelection();
        this.jTableTWT.updateUI();
    }

    private void jButtonReadActionPerformed(ActionEvent evt) {
        if (this.model.rowCount > 0 && JOptionPane.showConfirmDialog(this, "The current entries must be cleared. Do you want to continue?", "TWT", 0, 3) != 0) {
            return;
        }
        String sFilter = JOptionPane.showInputDialog(this, "Enter depth filter value\n(reduces the number of stored values to improve performance)", new Float(10.0f));
        if (sFilter == null) {
            return;
        }
        float depthFilter = Float.parseFloat(sFilter);
        SbugsFileFilter filterAll = new SbugsFileFilter();
        JFileChooser jFileChooser = new JFileChooser();
        File setDir = null;
        try {
            setDir = new File(Lastval.getString((SBdb)this.well.getDataModel(), (String)"WINTWTIMP", (String)"UNXTWTIMP"));
        }
        catch (SQLException ex) {
            // empty catch block
        }
        jFileChooser.setCurrentDirectory(setDir);
        SbugsFileFilter filter = new SbugsFileFilter();
        filter.addExtension("txt");
        if (jFileChooser.showOpenDialog(this) == 0) {
            String fileName = jFileChooser.getSelectedFile().getPath();
            try {
                String buff;
                BufferedReader in = new BufferedReader(new FileReader(fileName));
                float lastDepth = -100.0f;
                LinkedList<TWTDepth> values = new LinkedList<TWTDepth>();
                while ((buff = in.readLine()) != null) {
                    StringTokenizer tok = new StringTokenizer(buff, " ,\t");
                    if (tok.countTokens() <= 1) continue;
                    try {
                        float depth1 = Float.parseFloat(tok.nextToken());
                        float depth2 = Float.parseFloat(tok.nextToken());
                        if (!(depth1 - lastDepth > depthFilter)) continue;
                        values.add(new TWTDepth((double)depth1, (double)depth2));
                        lastDepth = depth1;
                    }
                    catch (Exception sbe) {
                        System.out.println("Error inserting values for row: " + buff);
                    }
                }
                this.model.setSize(values.size());
                for (int i = 0; i < this.model.rowCount; ++i) {
                    TWTDepth twt = (TWTDepth)values.get(i);
                    this.model.setValueAt(new Float(twt.getDepth()), i, 0);
                    this.model.setValueAt(new Float(twt.getTWT()), i, 1);
                }
                this.jTableTWT.clearSelection();
                this.model.fireTableDataChanged();
                Lastval.putString((SBdb)this.well.getDataModel(), (String)"WINTWTIMP", (String)"UNXTWTIMP", (String)fileName);
                this.well.getDataModel().commit();
            }
            catch (Exception eio) {
                JOptionPane.showMessageDialog(null, "Problem reading file: " + eio.getMessage());
                eio.printStackTrace();
            }
        }
    }

    private void jButtonAddRowsActionPerformed(ActionEvent evt) {
        try {
            String rows = JOptionPane.showInputDialog(this, "Enter number of rows to add", new Integer(1));
            if (rows != null) {
                int nRows = Integer.parseInt(rows);
                Float[] oldDepth = this.model.depth;
                Float[] oldTwt = this.model.twt;
                this.model.setSize(this.model.rowCount + nRows);
                for (int i = 0; i < oldDepth.length; ++i) {
                    this.model.depth[i] = oldDepth[i];
                    this.model.twt[i] = oldTwt[i];
                }
                this.jTableTWT.clearSelection();
                this.jTableTWT.updateUI();
                this.jTableTWT.setRowSelectionInterval(this.model.rowCount - nRows, this.model.rowCount - 1);
                this.jScrollPane1.getViewport().setViewPosition(new Point(0, this.jTableTWT.getBounds().getSize().height));
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogtwt.html");
    }
}

