/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import jsbugs.FrameJsbugs;
import model2.Genus;
import model2.SBdb;
import model2.Taxon;
import util.ProgressBarMonitor;
import util.SB;
import util.SBException;

public class DialogTaxaDelete
extends JDialog {
    int nPresses = 0;
    List<Integer> taxaToDie = new LinkedList<Integer>();
    SwingWorker task;
    ProgressBarMonitor monitor = new ProgressBarMonitor();
    SBdb db;
    private JButton jButtonCancel;
    private JButton jButtonNext;
    private JLabel jLabel1;
    private JLabel jLabelInfo;
    private JProgressBar jProgressBar1;

    public DialogTaxaDelete(Frame parent, boolean modal, SBdb db) {
        super(parent, modal);
        this.db = db;
        this.setTitle("Delete all non-occuring taxa");
        this.initComponents();
        this.monitor.setProgressBar(this.jProgressBar1);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabelInfo = new JLabel();
        this.jProgressBar1 = new JProgressBar();
        this.jButtonNext = new JButton();
        this.jButtonCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jLabel1.setFont(new Font("Tahoma", 1, 11));
        this.jLabel1.setForeground(new Color(255, 0, 51));
        this.jLabel1.setText("Delete all taxa which have no well/outcrop occurrences and no linked events?");
        this.jLabelInfo.setText("Press Next to find number of taxa which will be deleted...");
        this.jButtonNext.setText("Next");
        this.jButtonNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxaDelete.this.jButtonNextActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxaDelete.this.jButtonCancelActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addComponent(this.jLabelInfo).addComponent(this.jProgressBar1, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(312, Short.MAX_VALUE).addComponent(this.jButtonNext).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel).addContainerGap()));
        layout.linkSize(0, this.jButtonCancel, this.jButtonNext);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabelInfo).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jProgressBar1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 26, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonNext)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        if (this.task != null) {
            this.task.cancel(true);
            this.monitor.setInterrupt(true);
            this.db.doRollback();
        }
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonNextActionPerformed(ActionEvent evt) {
        if (this.nPresses == 0) {
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                Taxon.getUnusedSpecies((SBdb)this.db, this.taxaToDie);
                if (this.taxaToDie.isEmpty()) {
                    this.jLabelInfo.setText("There are no unused taxa. Press Cancel to finish");
                    this.jButtonNext.setEnabled(false);
                }
                this.jLabelInfo.setText("Number of taxa to be deleted is: " + this.taxaToDie.size() + ". Press Next to continue");
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(this, "Error: " + ex.getMessage() + "\nSQL: " + SB.sql, "SQL Error", 0);
                this.db.doRollback();
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        } else {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.task = new SwingWorker(){

                @Override
                public void done() {
                    DialogTaxaDelete.this.jButtonCancel.setText("Finish");
                    DialogTaxaDelete.this.setCursor(Cursor.getDefaultCursor());
                }

                public void interrupt() {
                    DialogTaxaDelete.this.monitor.setInterrupt(true);
                    System.out.println("Process interrupted: ");
                    DialogTaxaDelete.this.db.doRollback();
                    DialogTaxaDelete.this.setCursor(Cursor.getDefaultCursor());
                }

                protected Object doInBackground() throws Exception {
                    DialogTaxaDelete.this.setCursor(Cursor.getPredefinedCursor(3));
                    DialogTaxaDelete.this.deleteSpecies();
                    System.out.println("Return from delete species");
                    return "ok";
                }
            };
            this.task.execute();
            this.jButtonNext.setEnabled(false);
        }
        ++this.nPresses;
    }

    void deleteSpecies() {
        try {
            this.jLabelInfo.setText("Deleting unused species...");
            this.db.deleteSpecies(this.taxaToDie, false, this.monitor);
            if (!this.monitor.getInterrupt()) {
                this.jLabelInfo.setText("Deleting unused genera (please wait)...");
                this.jProgressBar1.setValue(0);
                Genus.deleteUnusedGenera((SBdb)this.db);
                this.jProgressBar1.setValue(this.jProgressBar1.getMaximum());
            }
            if (!this.monitor.getInterrupt()) {
                this.jLabelInfo.setText("...done");
                this.db.commit();
            } else {
                this.jLabelInfo.setText("Rolling back...");
                this.db.doRollback();
            }
        }
        catch (SQLException ex) {
            this.db.doRollback();
            FrameJsbugs.showStackError("SQL Error", ex, this.db);
        }
        catch (SBException ex) {
            this.db.doRollback();
            SB.showStackError((String)"Error", (Exception)((Object)ex));
        }
    }
}

