/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import jsbugs.DialogGenusUpdate;
import jsbugs.DialogList;
import jsbugs.DialogMergeTaxa;
import jsbugs.DialogTaxonAdded;
import jsbugs.FrameJsbugs;
import model2.Categories;
import model2.Category;
import model2.Discipline;
import model2.Genus;
import model2.Qualifier;
import model2.SBEvent;
import model2.SBdb;
import model2.Taxon;
import model2.TaxonQual;
import org.jdesktop.layout.GroupLayout;
import util.InvalidFieldException;
import util.SB;
import util.SBException;

public class DialogTaxon
extends JDialog {
    private static final int GENSPECLEN = 30;
    private static final int AUTHLEN = 50;
    private static final int YEARLEN = 8;
    private static final int NUMCODELEN = 8;
    private static final int ALPHNUMCODELEN = 21;
    Taxon taxon;
    private final SBdb db;
    private static final int NFIELDS = 8;
    private final Object[] fields = new Object[8];
    private static String lastCatSelection = null;
    char discID;
    private ButtonGroup buttonGroupDiscipline;
    private JButton jButtonBlankSpecies;
    private JButton jButtonBlankTaxon;
    private JButton jButtonCancel;
    private JButton jButtonConvertCase;
    private JButton jButtonGenera;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonSpecies;
    private JButton jButtonUseLastCat;
    private JComboBox jComboBoxCategory;
    private JComboBox jComboBoxGenusQualifier1;
    private JComboBox jComboBoxGenusQualifier2;
    private JComboBox jComboBoxSpeciesQualifier1;
    private JComboBox jComboBoxSpeciesQualifier2;
    private JComboBox jComboBoxSubGenusQualifier1;
    private JComboBox jComboBoxSubGenusQualifier2;
    private JComboBox jComboBoxSubSpeciesQualifier1;
    private JComboBox jComboBoxSubSpeciesQualifier2;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel13;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JLabel jLabelAudit;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JRadioButton jRadioButtonMacro;
    private JRadioButton jRadioButtonMicro;
    private JRadioButton jRadioButtonNanno;
    private JRadioButton jRadioButtonPaly;
    private JSeparator jSeparator1;
    private JTextField jTextFieldAlphanumericCode;
    private JTextField jTextFieldAuthor;
    private JTextField jTextFieldCurrentTaxon;
    private JTextField jTextFieldGenus;
    private JTextField jTextFieldID;
    private JTextField jTextFieldSpecies;
    private JTextField jTextFieldSubGenus;
    private JTextField jTextFieldSubSpecies;
    private JTextField jTextFieldYear;

    public DialogTaxon(Frame parent, boolean modal, SBdb db, Taxon taxon, boolean useAsTemplate) throws SQLException {
        super(parent, modal);
        this.taxon = taxon;
        this.db = db;
        this.initComponents();
        this.init(useAsTemplate);
    }

    public DialogTaxon(JDialog parent, boolean modal, SBdb db, Taxon taxon, boolean useAsTemplate) throws SQLException {
        super((Dialog)parent, modal);
        this.taxon = taxon;
        this.db = db;
        this.initComponents();
        this.init(useAsTemplate);
    }

    public DialogTaxon(JDialog parent, boolean modal, SBdb db, String cat, String genus, String subGenus, String species, String subSpecies, String alphaCode) throws SQLException {
        super((Dialog)parent, modal);
        LinkedList genera;
        this.db = db;
        this.initComponents();
        this.init(false);
        if (cat != null && cat.length() > 0) {
            db.setCatSelection(this.jComboBoxCategory, cat);
        }
        if (!(this.jComboBoxCategory.getSelectedIndex() > 0 && cat != null && cat.length() != 0 || genus == null || genus.trim().length() <= 0 || (genera = Genus.lookupGenus((SBdb)db, (String)"", (String)genus.trim())).isEmpty())) {
            String str = (String)genera.get(0);
            StringTokenizer tok = new StringTokenizer(str);
            String catMnem = tok.nextToken();
            db.setCatSelection(this.jComboBoxCategory, catMnem);
        }
        this.jTextFieldGenus.setText(genus);
        this.jTextFieldSubGenus.setText(subGenus);
        this.jTextFieldSpecies.setText(species);
        this.jTextFieldSubSpecies.setText(subSpecies);
        this.jTextFieldAlphanumericCode.setText(alphaCode);
    }

    private void init(boolean useAsTemplate) throws SQLException {
        this.jComboBoxCategory.removeAllItems();
        this.fillQualifiers();
        this.db.fillCatCombo(this.jComboBoxCategory, false, null);
        this.jComboBoxCategory.setSelectedIndex(0);
        this.setTitle("Taxon : Add");
        if (this.taxon != null) {
            if (this.taxon.getGenus() != null) {
                this.jTextFieldGenus.setText(this.taxon.getGenus().getGenus());
                this.jTextFieldSubGenus.setText(this.taxon.getGenus().getSubGenus());
                this.db.setCatSelection(this.jComboBoxCategory, this.taxon.getGenus().getCategory().getMnem());
            }
            this.jTextFieldSpecies.setText(this.taxon.getSpecies());
            this.jTextFieldSubSpecies.setText(this.taxon.getSubSpecies());
            this.jTextFieldAuthor.setText(this.taxon.getAuthor());
            if (this.taxon.getYear() > 0) {
                this.jTextFieldYear.setText("" + this.taxon.getYear());
            }
            this.selectQualifier(this.jComboBoxGenusQualifier1, this.taxon.getGenus() == null ? null : this.taxon.getGenus().getQ1());
            this.selectQualifier(this.jComboBoxGenusQualifier2, this.taxon.getGenus() == null ? null : this.taxon.getGenus().getQ2());
            this.selectQualifier(this.jComboBoxSubGenusQualifier1, this.taxon.getGenus() == null ? null : this.taxon.getGenus().getQ3());
            this.selectQualifier(this.jComboBoxSubGenusQualifier2, this.taxon.getGenus() == null ? null : this.taxon.getGenus().getQ4());
            this.selectQualifier(this.jComboBoxSpeciesQualifier1, this.taxon.getQ1());
            this.selectQualifier(this.jComboBoxSpeciesQualifier2, this.taxon.getQ2());
            this.selectQualifier(this.jComboBoxSubSpeciesQualifier1, this.taxon.getQ3());
            this.selectQualifier(this.jComboBoxSubSpeciesQualifier2, this.taxon.getQ4());
            this.jTextFieldAlphanumericCode.setText(this.taxon.getAlphaCode());
            if (useAsTemplate) {
                this.taxon = null;
                this.jLabelAudit.setText("");
            } else {
                this.jTextFieldCurrentTaxon.setText(this.taxon.toString(true));
                this.jTextFieldID.setText("" + this.taxon.getSpecID());
                this.setTitle("Taxon : Edit - " + this.taxon);
                this.jLabelAudit.setText(this.taxon.getAudit().toString(this.db, true));
            }
        } else {
            this.jTextFieldCurrentTaxon.setBackground(Color.lightGray);
            this.jTextFieldID.setBackground(Color.gray);
            this.jLabelAudit.setText("");
        }
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.pack();
    }

    private void selectQualifier(JComboBox combo, Qualifier qual) {
        combo.setSelectedItem(qual);
        if (combo.getSelectedIndex() < 0 && qual != null && qual.hasQuals()) {
            if (qual.getSingle() != null) {
                combo.setSelectedItem(qual.getSingle());
                return;
            }
            Qualifier copy = qual.copy();
            combo.addItem(copy);
            combo.setSelectedItem(copy);
        }
    }

    private void fillQualifiers() {
        JComboBox[] qualBoxes = new JComboBox[]{this.jComboBoxGenusQualifier1, this.jComboBoxGenusQualifier2, this.jComboBoxSubGenusQualifier1, this.jComboBoxSubGenusQualifier2, this.jComboBoxSpeciesQualifier1, this.jComboBoxSpeciesQualifier2, this.jComboBoxSubSpeciesQualifier1, this.jComboBoxSubSpeciesQualifier2};
        for (int i = 0; i < 8; ++i) {
            JComboBox box = qualBoxes[i];
            box.addItem(null);
            for (TaxonQual q : TaxonQual.values()) {
                if (!q.use(i)) continue;
                box.addItem(q);
            }
            this.fields[i] = null;
        }
    }

    private void handleQualifierSelection(JComboBox combo, int index) {
        Object item = combo.getSelectedItem();
        Object field = this.fields[index];
        if (item != null) {
            if (field instanceof Qualifier) {
                if (item instanceof TaxonQual) {
                    TaxonQual newQual = (TaxonQual)item;
                    Qualifier existingQualifier = (Qualifier)field;
                    existingQualifier.addQual(newQual);
                    for (int i = 0; i < combo.getItemCount(); ++i) {
                        Object existing = combo.getItemAt(i);
                        if (!(existing instanceof Qualifier) || existing == existingQualifier || !((Qualifier)existing).equals((Object)existingQualifier)) continue;
                        combo.removeItem(existing);
                    }
                    item = field;
                }
            } else if (field instanceof TaxonQual && item instanceof TaxonQual && item != field) {
                Qualifier qualifier = new Qualifier(index);
                qualifier.addQual((TaxonQual)field);
                if (qualifier.addQual((TaxonQual)item)) {
                    boolean exists = false;
                    for (int i = 0; i < combo.getItemCount(); ++i) {
                        if (!(combo.getItemAt(i) instanceof Qualifier) || !((Qualifier)combo.getItemAt(i)).equals((Object)qualifier)) continue;
                        qualifier = (Qualifier)combo.getItemAt(i);
                        exists = true;
                    }
                    if (!exists) {
                        combo.addItem(qualifier);
                    }
                    item = qualifier;
                }
            }
        }
        this.fields[index] = item;
        combo.setSelectedItem(item);
    }

    void setSpecies(String species) {
        this.jTextFieldSpecies.setText(species);
    }

    void setSq1(TaxonQual tq) {
        Qualifier q = new Qualifier(4, tq);
        this.selectQualifier(this.jComboBoxSpeciesQualifier1, q);
    }

    void setSq2(TaxonQual tq) {
        Qualifier q = new Qualifier(5, tq);
        this.selectQualifier(this.jComboBoxSpeciesQualifier2, q);
    }

    private void initComponents() {
        this.buttonGroupDiscipline = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jTextFieldAuthor = new JTextField();
        this.jLabel10 = new JLabel();
        this.jTextFieldYear = new JTextField();
        this.jLabel11 = new JLabel();
        this.jTextFieldAlphanumericCode = new JTextField();
        this.jLabel13 = new JLabel();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonConvertCase = new JButton();
        this.jButtonOK = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jButtonBlankTaxon = new JButton();
        this.jButtonBlankSpecies = new JButton();
        this.jPanel2 = new JPanel();
        this.jButtonSpecies = new JButton();
        this.jComboBoxSpeciesQualifier2 = new JComboBox();
        this.jTextFieldSpecies = new JTextField();
        this.jComboBoxSpeciesQualifier1 = new JComboBox();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jComboBoxSubSpeciesQualifier1 = new JComboBox();
        this.jTextFieldSubSpecies = new JTextField();
        this.jComboBoxSubSpeciesQualifier2 = new JComboBox();
        this.jComboBoxSubGenusQualifier2 = new JComboBox();
        this.jTextFieldSubGenus = new JTextField();
        this.jComboBoxSubGenusQualifier1 = new JComboBox();
        this.jLabel4 = new JLabel();
        this.jTextFieldGenus = new JTextField();
        this.jComboBoxGenusQualifier2 = new JComboBox();
        this.jButtonGenera = new JButton();
        this.jComboBoxGenusQualifier1 = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jRadioButtonPaly = new JRadioButton();
        this.jComboBoxCategory = new JComboBox();
        this.jButtonUseLastCat = new JButton();
        this.jRadioButtonMacro = new JRadioButton();
        this.jRadioButtonNanno = new JRadioButton();
        this.jRadioButtonMicro = new JRadioButton();
        this.jLabel2 = new JLabel();
        this.jPanel3 = new JPanel();
        this.jLabelAudit = new JLabel();
        this.jTextFieldCurrentTaxon = new JTextField();
        this.jLabel1 = new JLabel();
        this.jTextFieldID = new JTextField();
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.setResizable(false);
        this.jTextFieldAuthor.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogTaxon.this.jTextFieldAuthorKeyTyped(evt);
            }
        });
        this.jLabel10.setText("Author:");
        this.jTextFieldYear.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogTaxon.this.jTextFieldYearKeyTyped(evt);
            }
        });
        this.jLabel11.setText("Year:");
        this.jTextFieldAlphanumericCode.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogTaxon.this.jTextFieldAlphanumericCodeKeyTyped(evt);
            }
        });
        this.jLabel13.setText("Alphanumeric code:");
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add(41, 41, 41).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1, false).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jLabel13).addPreferredGap(0).add((Component)this.jTextFieldAlphanumericCode)).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jLabel10).addPreferredGap(0).add((Component)this.jTextFieldAuthor, -2, 243, -2))).addPreferredGap(1).add((Component)this.jLabel11).addPreferredGap(0).add((Component)this.jTextFieldYear, -2, 55, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel10).add((Component)this.jTextFieldAuthor, -2, -1, -2).add((Component)this.jTextFieldYear, -2, -1, -2).add((Component)this.jLabel11)).addPreferredGap(1).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel13).add((Component)this.jTextFieldAlphanumericCode, -2, -1, -2)).add(30, 30, 30)));
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxon.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxon.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonConvertCase.setText("Convert case");
        this.jButtonConvertCase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxon.this.jButtonConvertCaseActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxon.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonBlankTaxon.setText("Clear taxon");
        this.jButtonBlankTaxon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxon.this.jButtonBlankTaxonActionPerformed(evt);
            }
        });
        this.jButtonBlankSpecies.setText("Clear species");
        this.jButtonBlankSpecies.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxon.this.jButtonBlankSpeciesActionPerformed(evt);
            }
        });
        this.jButtonSpecies.setText("Species...");
        this.jButtonSpecies.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxon.this.jButtonSpeciesActionPerformed(evt);
            }
        });
        this.jComboBoxSpeciesQualifier2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxon.this.jComboBoxSpeciesQualifier2ActionPerformed(evt);
            }
        });
        this.jTextFieldSpecies.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogTaxon.this.jTextFieldSpeciesKeyTyped(evt);
            }
        });
        this.jComboBoxSpeciesQualifier1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxon.this.jComboBoxSpeciesQualifier1ActionPerformed(evt);
            }
        });
        this.jLabel8.setText("Species:");
        this.jLabel9.setText("Sub-species:");
        this.jComboBoxSubSpeciesQualifier1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxon.this.jComboBoxSubSpeciesQualifier1ActionPerformed(evt);
            }
        });
        this.jTextFieldSubSpecies.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogTaxon.this.jTextFieldSubSpeciesKeyTyped(evt);
            }
        });
        this.jComboBoxSubSpeciesQualifier2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxon.this.jComboBoxSubSpeciesQualifier2ActionPerformed(evt);
            }
        });
        this.jComboBoxSubGenusQualifier2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxon.this.jComboBoxSubGenusQualifier2ActionPerformed(evt);
            }
        });
        this.jTextFieldSubGenus.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogTaxon.this.jTextFieldSubGenusKeyTyped(evt);
            }
        });
        this.jComboBoxSubGenusQualifier1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxon.this.jComboBoxSubGenusQualifier1ActionPerformed(evt);
            }
        });
        this.jLabel4.setText("Sub-genus:");
        this.jTextFieldGenus.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogTaxon.this.jTextFieldGenusKeyTyped(evt);
            }
        });
        this.jComboBoxGenusQualifier2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxon.this.jComboBoxGenusQualifier2ActionPerformed(evt);
            }
        });
        this.jButtonGenera.setText("Genera...");
        this.jButtonGenera.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxon.this.jButtonGeneraActionPerformed(evt);
            }
        });
        this.jComboBoxGenusQualifier1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxon.this.jComboBoxGenusQualifier1ActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Genus:");
        this.jLabel7.setText("Name:");
        this.jLabel6.setText("Qualifiers:");
        this.jLabel5.setText("Qualifiers:");
        this.buttonGroupDiscipline.add(this.jRadioButtonPaly);
        this.jRadioButtonPaly.setText("Paly");
        this.jRadioButtonPaly.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxon.this.jRadioButtonPalyActionPerformed(evt);
            }
        });
        this.jButtonUseLastCat.setText("Use last");
        this.jButtonUseLastCat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxon.this.jButtonUseLastCatActionPerformed(evt);
            }
        });
        this.buttonGroupDiscipline.add(this.jRadioButtonMacro);
        this.jRadioButtonMacro.setText("Macro");
        this.jRadioButtonMacro.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxon.this.jRadioButtonMacroActionPerformed(evt);
            }
        });
        this.buttonGroupDiscipline.add(this.jRadioButtonNanno);
        this.jRadioButtonNanno.setText("Nanno");
        this.jRadioButtonNanno.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxon.this.jRadioButtonNannoActionPerformed(evt);
            }
        });
        this.buttonGroupDiscipline.add(this.jRadioButtonMicro);
        this.jRadioButtonMicro.setText("Micro");
        this.jRadioButtonMicro.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxon.this.jRadioButtonMicroActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Category:");
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(2).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(2, (Component)this.jLabel3).add(2, (Component)this.jLabel4).add((Component)this.jLabel9)).add((Component)this.jLabel8).add((Component)this.jLabel2)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(2, false).add((Component)this.jComboBoxSubSpeciesQualifier1, 0, -1, Short.MAX_VALUE).add(1, (Component)this.jComboBoxSpeciesQualifier1, 0, -1, Short.MAX_VALUE).add(1, (Component)this.jLabel6, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jComboBoxGenusQualifier1, 0, -1, Short.MAX_VALUE).add(1, (Component)this.jComboBoxSubGenusQualifier1, 0, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(2, (Component)this.jTextFieldSubGenus).add((Component)this.jTextFieldSubSpecies).add(2, (Component)this.jTextFieldSpecies).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jLabel7).add(0, 0, Short.MAX_VALUE)).add((Component)this.jTextFieldGenus)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(2, false).add((Component)this.jComboBoxSpeciesQualifier2, 0, -1, Short.MAX_VALUE).add(1, (Component)this.jComboBoxSubGenusQualifier2, 0, -1, Short.MAX_VALUE).add((Component)this.jComboBoxGenusQualifier2, 0, -1, Short.MAX_VALUE).add((Component)this.jLabel5, -1, -1, Short.MAX_VALUE).add((Component)this.jComboBoxSubSpeciesQualifier2, 0, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1, false).add((Component)this.jButtonSpecies, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonGenera, -2, 81, -2))).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add(2, 2, 2).add((Component)this.jRadioButtonMicro).addPreferredGap(1).add((Component)this.jRadioButtonNanno).addPreferredGap(1).add((Component)this.jRadioButtonPaly).addPreferredGap(1).add((Component)this.jRadioButtonMacro)).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jComboBoxCategory, -2, 342, -2).addPreferredGap(0).add((Component)this.jButtonUseLastCat, -2, 83, -2))).add(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jRadioButtonPaly).add((Component)this.jRadioButtonMacro).add((Component)this.jRadioButtonNanno).add((Component)this.jRadioButtonMicro)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jComboBoxCategory, -2, -1, -2).add((Component)this.jButtonUseLastCat).add((Component)this.jLabel2)).addPreferredGap(0, -1, Short.MAX_VALUE).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jLabel7).add((Component)this.jLabel6).add((Component)this.jLabel5)).addPreferredGap(1).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jTextFieldGenus, -2, -1, -2).add((Component)this.jComboBoxGenusQualifier2, -2, -1, -2).add((Component)this.jButtonGenera).add((Component)this.jComboBoxGenusQualifier1, -2, -1, -2).add((Component)this.jLabel3)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jComboBoxSubGenusQualifier2, -2, -1, -2).add((Component)this.jTextFieldSubGenus, -2, -1, -2).add((Component)this.jComboBoxSubGenusQualifier1, -2, -1, -2).add((Component)this.jLabel4)).add(18, 18, 18).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jButtonSpecies).add((Component)this.jComboBoxSpeciesQualifier2, -2, -1, -2).add((Component)this.jTextFieldSpecies, -2, -1, -2).add((Component)this.jComboBoxSpeciesQualifier1, -2, -1, -2).add((Component)this.jLabel8)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jLabel9).add((Component)this.jComboBoxSubSpeciesQualifier1, -2, -1, -2).add((Component)this.jTextFieldSubSpecies, -2, -1, -2).add((Component)this.jComboBoxSubSpeciesQualifier2, -2, -1, -2)).add(12, 12, 12)));
        this.jLabelAudit.setForeground(new Color(153, 153, 153));
        this.jLabelAudit.setText("Created by: on:; Modified by: on:");
        this.jTextFieldCurrentTaxon.setEditable(false);
        this.jTextFieldCurrentTaxon.setBackground(new Color(255, 255, 204));
        this.jLabel1.setText("Current taxon:");
        this.jTextFieldID.setEditable(false);
        this.jTextFieldID.setBackground(new Color(255, 255, 204));
        this.jTextFieldID.setText("No ID");
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((Component)this.jLabelAudit)).add((Component)this.jTextFieldCurrentTaxon)).addPreferredGap(0).add((Component)this.jTextFieldID, -2, 71, -2).addContainerGap()));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jTextFieldCurrentTaxon, -2, -1, -2).add((Component)this.jTextFieldID, -2, -1, -2)).addPreferredGap(0).add((Component)this.jLabelAudit)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel3, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jPanel2, -1, -1, Short.MAX_VALUE).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((Component)this.jSeparator1, -2, 502, -2)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jButtonBlankTaxon).addPreferredGap(0).add((Component)this.jButtonBlankSpecies).addPreferredGap(0).add((Component)this.jButtonConvertCase).add(18, 18, 18).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel).add(0, 0, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add(10, 10, 10).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanel3, -2, -1, -2).addPreferredGap(1).add((Component)this.jPanel2, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel1, -2, 75, -2).addPreferredGap(1).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonHelp).add((Component)this.jButtonConvertCase).add((Component)this.jButtonBlankTaxon).add((Component)this.jButtonBlankSpecies).add((Component)this.jButtonOK)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonBlankSpeciesActionPerformed(ActionEvent evt) {
        this.jTextFieldSpecies.setText("");
        this.jTextFieldSubSpecies.setText("");
        this.jComboBoxSpeciesQualifier1.setSelectedItem("");
        this.jComboBoxSpeciesQualifier2.setSelectedItem("");
        this.jComboBoxSubSpeciesQualifier1.setSelectedItem("");
        this.jComboBoxSubSpeciesQualifier2.setSelectedItem("");
    }

    private void jButtonBlankTaxonActionPerformed(ActionEvent evt) {
        this.jTextFieldGenus.setText("");
        this.jTextFieldSubGenus.setText("");
        this.jTextFieldAuthor.setText("");
        this.jTextFieldYear.setText("");
        this.jTextFieldAlphanumericCode.setText("");
        this.jComboBoxGenusQualifier1.setSelectedItem("");
        this.jComboBoxGenusQualifier2.setSelectedItem("");
        this.jComboBoxSubGenusQualifier1.setSelectedItem("");
        this.jComboBoxSubGenusQualifier2.setSelectedItem("");
        this.jButtonBlankSpeciesActionPerformed(null);
    }

    private void jButtonConvertCaseActionPerformed(ActionEvent evt) {
        this.jTextFieldGenus.setText(Genus.toGenusCase((String)this.jTextFieldGenus.getText()));
        this.jTextFieldSubGenus.setText(Genus.toGenusCase((String)this.jTextFieldSubGenus.getText()));
        this.jTextFieldSpecies.setText(Taxon.toSpeciesCase((String)this.jTextFieldSpecies.getText()));
        this.jTextFieldSubSpecies.setText(Taxon.toSpeciesCase((String)this.jTextFieldSubSpecies.getText()));
    }

    private void jComboBoxSubSpeciesQualifier2ActionPerformed(ActionEvent evt) {
        this.handleQualifierSelection(this.jComboBoxSubSpeciesQualifier2, 7);
    }

    private void jComboBoxSpeciesQualifier2ActionPerformed(ActionEvent evt) {
        this.handleQualifierSelection(this.jComboBoxSpeciesQualifier2, 5);
    }

    private void jComboBoxSubSpeciesQualifier1ActionPerformed(ActionEvent evt) {
        this.handleQualifierSelection(this.jComboBoxSubSpeciesQualifier1, 6);
    }

    private void jComboBoxSpeciesQualifier1ActionPerformed(ActionEvent evt) {
        this.handleQualifierSelection(this.jComboBoxSpeciesQualifier1, 4);
    }

    private void jComboBoxSubGenusQualifier2ActionPerformed(ActionEvent evt) {
        this.handleQualifierSelection(this.jComboBoxSubGenusQualifier2, 3);
    }

    private void jComboBoxGenusQualifier2ActionPerformed(ActionEvent evt) {
        this.handleQualifierSelection(this.jComboBoxGenusQualifier2, 1);
    }

    private void jComboBoxSubGenusQualifier1ActionPerformed(ActionEvent evt) {
        this.handleQualifierSelection(this.jComboBoxSubGenusQualifier1, 2);
    }

    private void jComboBoxGenusQualifier1ActionPerformed(ActionEvent evt) {
        this.handleQualifierSelection(this.jComboBoxGenusQualifier1, 0);
    }

    private void jTextFieldYearKeyTyped(KeyEvent evt) {
        if (SB.intFieldVal((JTextField)this.jTextFieldYear, (int)8, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldAlphanumericCodeKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldAlphanumericCode, (int)21, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldAuthorKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldAuthor, (int)50, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldSubSpeciesKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldSubSpecies, (int)30, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldSpeciesKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldSpecies, (int)30, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldSubGenusKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldSubGenus, (int)30, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldGenusKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldGenus, (int)30, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonSpeciesActionPerformed(ActionEvent evt) {
        try {
            String cat_mnem = Categories.getCatmnem((JComboBox)this.jComboBoxCategory);
            if (cat_mnem.isEmpty()) {
                JOptionPane.showMessageDialog(this, "Select a category", this.getTitle(), 2);
                return;
            }
            String genus = this.jTextFieldGenus.getText().trim();
            if (genus.isEmpty()) {
                JOptionPane.showMessageDialog(this, "Enter start of genus name to look up", this.getTitle(), 1);
                return;
            }
            String species = this.jTextFieldSpecies.getText();
            List list = Taxon.lookupSpecies((SBdb)this.db, (String)cat_mnem, (String)genus, (String)species);
            if (list.isEmpty()) {
                JOptionPane.showMessageDialog(this, "No species found", this.getTitle(), 1);
                return;
            }
            DialogList dialog = new DialogList(this, true, "Select Species", this.db, list, true, false);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.selection != null) {
                String item = (String)dialog.selection;
                String subsp = null;
                String ss = " subsp. ";
                if (item.contains(ss)) {
                    int index = item.lastIndexOf(ss);
                    subsp = item.substring(index + ss.length());
                    item = item.substring(0, index);
                }
                this.jTextFieldSpecies.setText(item);
                if (subsp != null) {
                    this.jTextFieldSubSpecies.setText(subsp);
                }
            }
        }
        catch (Exception ex) {
            SB.showStackError((String)"Error", (Exception)ex);
            this.db.doRollback();
        }
    }

    private void jButtonGeneraActionPerformed(ActionEvent evt) {
        try {
            String genus = this.jTextFieldGenus.getText().trim();
            String cat_mnem = Categories.getCatmnem((JComboBox)this.jComboBoxCategory);
            LinkedList list = Genus.lookupGenus((SBdb)this.db, (String)cat_mnem, (String)genus);
            if (list.isEmpty()) {
                JOptionPane.showMessageDialog(this, "No genera found", this.getTitle(), 1);
                return;
            }
            DialogList dialog = new DialogList(this, true, "Select Genus", this.db, (List)list, true, false);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.selection != null) {
                String item = (String)dialog.selection;
                StringTokenizer tok = new StringTokenizer(item);
                if (tok.hasMoreTokens()) {
                    String cat = tok.nextToken();
                    this.db.setCatSelection(this.jComboBoxCategory, cat);
                }
                while (tok.hasMoreTokens()) {
                    this.jTextFieldGenus.setText(tok.nextToken() + ' ');
                }
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonOKActionPerformed(ActionEvent evt) {
        Category cat;
        try {
            cat = this.db.getCategory(Categories.getCatmnem((JComboBox)this.jComboBoxCategory));
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error getting category", sql, this.db);
            return;
        }
        String genus = this.jTextFieldGenus.getText().trim();
        String subGenus = this.jTextFieldSubGenus.getText().trim();
        String species = this.jTextFieldSpecies.getText().trim();
        String subSpecies = this.jTextFieldSubSpecies.getText().trim();
        if (cat == null || genus.length() == 0 || species.length() == 0) {
            JOptionPane.showMessageDialog(this, "Category, genus and species must be completed", this.getTitle(), 2);
            return;
        }
        for (String name : new String[]{genus, subGenus, species, subSpecies}) {
            if (TaxonQual.allowName((String)name)) continue;
            String s = "You must put taxon qualifiers in the appropriate qualifier fields and not part of the taxon name.\nCheck '" + name + "'.";
            JOptionPane.showMessageDialog(this, s, this.getTitle(), 2);
            return;
        }
        for (int i = 0; i < 8; ++i) {
            Object o = this.fields[i];
            if (o != null) {
                if (!(o instanceof TaxonQual)) continue;
                this.fields[i] = new Qualifier(i, (TaxonQual)o);
                continue;
            }
            this.fields[i] = new Qualifier(i);
        }
        Taxon.Builder builder = new Taxon.Builder().species(species).subSpecies(subSpecies);
        builder.qual(4, (Qualifier)this.fields[4]).qual(5, (Qualifier)this.fields[5]).qual(6, (Qualifier)this.fields[6]).qual(7, (Qualifier)this.fields[7]);
        builder.author(this.jTextFieldAuthor.getText());
        String yString = this.jTextFieldYear.getText().trim();
        int year = 0;
        if (yString.length() > 0 && ((year = Integer.parseInt(yString)) < 1000 || year > 3000)) {
            JOptionPane.showMessageDialog(this, "Invalid year", this.getTitle(), 2);
            return;
        }
        builder.year(year);
        builder.alphaCode(this.jTextFieldAlphanumericCode.getText());
        if (this.taxon != null) {
            builder.audit(this.taxon.getAudit());
        }
        Genus.Builder genBuilder = new Genus.Builder().category(cat).genusName(genus).subGenus(subGenus);
        genBuilder.qual(0, (Qualifier)this.fields[0]).qual(1, (Qualifier)this.fields[1]).qual(2, (Qualifier)this.fields[2]).qual(3, (Qualifier)this.fields[3]);
        try {
            genBuilder.verify();
            builder.verify();
        }
        catch (InvalidFieldException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), this.getTitle(), 2);
            return;
        }
        String originalName = this.taxon != null ? this.taxon.toString(false, false) : "";
        try {
            Taxon[] matches = this.db.lookupSpecies(null, genus, subGenus, species, subSpecies, (Qualifier)this.fields[0], (Qualifier)this.fields[1], (Qualifier)this.fields[2], (Qualifier)this.fields[3], (Qualifier)this.fields[4], (Qualifier)this.fields[5], (Qualifier)this.fields[6], (Qualifier)this.fields[7]);
            if (matches != null) {
                int opt;
                String msg = "";
                for (Taxon t : matches) {
                    if (this.taxon != null && t == this.taxon) continue;
                    if (this.db.getCategory(t.getCatMnem()) == cat) {
                        String existsMsg = "Taxon already exists.";
                        if (this.taxon == null) {
                            JOptionPane.showMessageDialog(this, existsMsg, this.getTitle(), 2);
                            return;
                        }
                        int opt2 = JOptionPane.showConfirmDialog(this, existsMsg = existsMsg + "\nWould you like to merge '" + originalName + "' with '" + t + "'?", this.getTitle(), 0);
                        if (opt2 != 0) {
                            return;
                        }
                        this.merge(t);
                        this.dispose();
                        return;
                    }
                    if (!msg.isEmpty()) {
                        msg = msg + ", ";
                    }
                    msg = msg + t.getCatMnem();
                }
                if (!msg.isEmpty() && (opt = JOptionPane.showConfirmDialog(this, msg = "Taxon already exists in categor" + (matches.length > 1 ? "ies: " : "y: ") + msg + "\nDo you still want to add it?", this.getTitle(), 0, 3)) != 0) {
                    return;
                }
            }
            Genus gen = null;
            Genus[] genera = this.db.lookupGenus(genBuilder.category(null));
            genBuilder.category(cat);
            if (genera != null) {
                int opt2;
                String msg = "";
                for (Genus g : genera) {
                    if (g.getCategory() == cat) {
                        gen = g;
                        break;
                    }
                    if (!msg.isEmpty()) {
                        msg = msg + ", ";
                    }
                    msg = msg + g.getCategory().getMnem();
                }
                if (gen == null && !msg.isEmpty() && (opt2 = JOptionPane.showConfirmDialog(this, msg = "Genus already exists in categor" + (genera.length > 1 ? "ies: " : "y: ") + msg + "\nDo you still want to add it to " + cat.getName() + "?", this.getTitle(), 0, 3)) != 0) {
                    return;
                }
            }
            if (this.taxon == null && (builder.hasQual(TaxonQual.Q) || genBuilder.hasQual(TaxonQual.Q)) && JOptionPane.showConfirmDialog(this, "The name contains a '?'. Consider using questionable occurrences rather than creating new species.\nDo you want to continue?", this.getTitle(), 0, 3) != 0) {
                return;
            }
            if (this.taxon != null) {
                String s;
                if (this.taxon.getGenus().equalsBuilder(genBuilder, false) && this.taxon.equalsBuilder(builder)) {
                    this.dispose();
                    return;
                }
                this.setCursor(Cursor.getPredefinedCursor(3));
                int nOcc = this.taxon.checkOcc(false);
                if (nOcc != 0 && JOptionPane.showConfirmDialog(this, s = "There " + (nOcc > 1 ? "are " + nOcc + " sample occurrences" : "is " + nOcc + " sample occurrence") + " of this taxon. Are you sure you want to update it?", "Update taxon", 0) != 0) {
                    this.setCursor(Cursor.getDefaultCursor());
                    return;
                }
            }
            try {
                if (gen == null) {
                    gen = this.taxon == null ? this.db.addGenus(genBuilder) : this.taxon.getGenus();
                }
                if (!gen.equalsBuilder(genBuilder, false)) {
                    int nSpec = gen.checkNSpecies(this.db);
                    boolean update = true;
                    if (nSpec > 1) {
                        DialogGenusUpdate dialog = new DialogGenusUpdate(this, true, gen, nSpec, !gen.equalsBuilder(genBuilder, true));
                        dialog.setLocationRelativeTo(this);
                        dialog.setVisible(true);
                        if (!dialog.isOK()) {
                            this.setCursor(Cursor.getDefaultCursor());
                            return;
                        }
                        update = dialog.updateAll;
                    }
                    if (update) {
                        this.db.updateGenus(gen.getGenID(), genBuilder);
                    } else {
                        gen = this.db.addGenus(genBuilder);
                    }
                }
                this.db.commit();
            }
            catch (SQLException sql) {
                this.db.doRollback();
                FrameJsbugs.showStackError("SQL Error storing genus", sql, this.db);
                this.setCursor(Cursor.getDefaultCursor());
                return;
            }
            builder.genus(gen);
            if (this.taxon != null) {
                this.db.updateSpecies(this.taxon.getSpecID(), builder);
                if (DialogTaxonAdded.showUpdated) {
                    DialogTaxonAdded dialog = new DialogTaxonAdded((Dialog)this, true, this.taxon.getSpecID(), true);
                    dialog.setLocationRelativeTo(this);
                    dialog.setVisible(true);
                }
            } else {
                this.taxon = this.db.addTaxon(builder);
                if (DialogTaxonAdded.showAdded) {
                    DialogTaxonAdded dialog = new DialogTaxonAdded((Dialog)this, true, this.taxon.getSpecID(), false);
                    dialog.setLocationRelativeTo(this);
                    dialog.setVisible(true);
                }
            }
            this.db.commit();
        }
        catch (SQLException sql) {
            this.db.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
            return;
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
            return;
        }
        if (!originalName.isEmpty() && !originalName.equals(this.taxon.toString(false, false))) {
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                int id = SBEvent.getSBEventSQL((SBdb)this.db, (String)originalName);
                SBEvent event = null;
                if (id > 0) {
                    event = this.db.getSBEvent(id);
                }
                if (event != null && event.getSpecID() == this.taxon.getSpecID() && JOptionPane.showConfirmDialog(this, "Do you want to update the Event Dictionary name associated with this taxon as well? (recommended)", "Update taxon", 0) == 0) {
                    this.db.updateSBEventName(event, this.taxon.toString(false, false));
                    this.db.commit();
                }
            }
            catch (SBException sbe) {
                SB.showStackError((String)"Error updating event names", (Exception)((Object)sbe));
            }
            catch (SQLException sql) {
                this.db.doRollback();
                FrameJsbugs.showStackError("SQL Error updating event names", sql, this.db);
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
        lastCatSelection = cat.getMnem();
        this.dispose();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogtaxon.html");
    }

    private void jButtonUseLastCatActionPerformed(ActionEvent evt) {
        if (lastCatSelection != null) {
            this.db.setCatSelection(this.jComboBoxCategory, lastCatSelection);
        }
    }

    private void jRadioButtonMicroActionPerformed(ActionEvent evt) {
        this.setDiscipline(Discipline.MICRO);
    }

    private void jRadioButtonNannoActionPerformed(ActionEvent evt) {
        this.setDiscipline(Discipline.NANNO);
    }

    private void jRadioButtonPalyActionPerformed(ActionEvent evt) {
        this.setDiscipline(Discipline.PALY);
    }

    private void jRadioButtonMacroActionPerformed(ActionEvent evt) {
        this.setDiscipline(Discipline.MACRO);
    }

    private void setDiscipline(Discipline discID) {
        this.discID = discID.getChar();
        this.jComboBoxCategory.removeAllItems();
        try {
            this.db.fillCatCombo(this.jComboBoxCategory, false, discID);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        this.jComboBoxCategory.setSelectedIndex(0);
        ButtonModel bm = this.buttonGroupDiscipline.getSelection();
        if (bm == null || bm != this.getButtonModel(discID)) {
            switch (discID) {
                case MICRO: {
                    this.jRadioButtonMicro.setSelected(true);
                    break;
                }
                case NANNO: {
                    this.jRadioButtonNanno.setSelected(true);
                    break;
                }
                case PALY: {
                    this.jRadioButtonPaly.setSelected(true);
                    break;
                }
                case MACRO: {
                    this.jRadioButtonMacro.setSelected(true);
                }
            }
        }
    }

    private ButtonModel getButtonModel(Discipline discID) {
        switch (discID) {
            case MICRO: {
                return this.jRadioButtonMicro.getModel();
            }
            case NANNO: {
                return this.jRadioButtonNanno.getModel();
            }
            case PALY: {
                return this.jRadioButtonPaly.getModel();
            }
            case MACRO: {
                return this.jRadioButtonPaly.getModel();
            }
        }
        return null;
    }

    private void merge(Taxon target) {
        if (this.taxon == null || this.taxon == target) {
            assert (false);
            return;
        }
        LinkedList<Taxon> list = new LinkedList<Taxon>();
        list.add(this.taxon);
        list.add(target);
        try {
            DialogMergeTaxa dialog = new DialogMergeTaxa(this, true, this.db, list, target);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
    }
}

