/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelTaxonCode;
import model2.SBdb;
import model2.Taxon;
import util.SB;
import util.SBException;

public class DialogTaxonCode
extends JDialog {
    Taxon taxon;
    SBdb db;
    TableModelTaxonCode model = new TableModelTaxonCode();
    private JButton jButtonAddDict;
    private JButton jButtonCancel;
    private JButton jButtonDeleteDict;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JScrollPane jScrollPane1;
    private JTable jTableCode;

    public DialogTaxonCode(Frame parent, boolean modal, SBdb db, Taxon taxon) throws SQLException {
        super(parent, modal);
        this.initComponents();
        this.taxon = taxon;
        this.db = db;
        this.init();
    }

    private void init() throws SQLException {
        this.setTitle("Numeric Codes : " + this.taxon.toString(false));
        SB.setTableHeaderBold((JTable)this.jTableCode);
        for (int i = 0; i < TableModelTaxonCode.columnHeaders.length; ++i) {
            this.jTableCode.getColumnModel().getColumn(i).setHeaderValue(TableModelTaxonCode.columnHeaders[i]);
            this.jTableCode.getColumnModel().getColumn(i).setPreferredWidth(TableModelTaxonCode.columnWidths[i]);
        }
        this.jTableCode.setSelectionMode(0);
        HashMap dicts = this.db.getSIPMDicts();
        Set set = dicts.entrySet();
        for (Map.Entry entry : set) {
            TableModelTaxonCode.RowItem row = new TableModelTaxonCode.RowItem();
            row.ccode = (Integer)entry.getKey();
            row.dictionary = (String)entry.getValue();
            row.code = this.taxon.getSipmCode(row.ccode);
            this.model.rows.add(row);
        }
        this.model.fireTableDataChanged();
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTableCode = new JTable();
        this.jButtonAddDict = new JButton();
        this.jButtonDeleteDict = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonOK = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(350, 200));
        this.jTableCode.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTableCode);
        this.jButtonAddDict.setText("Add dictionary...");
        this.jButtonAddDict.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxonCode.this.jButtonAddDictActionPerformed(evt);
            }
        });
        this.jButtonDeleteDict.setText("Delete dictionary...");
        this.jButtonDeleteDict.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonDeleteDict.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxonCode.this.jButtonDeleteDictActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxonCode.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxonCode.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxonCode.this.jButtonOKActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 272, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jButtonAddDict, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonDeleteDict, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonOK, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonHelp, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonCancel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 167, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jButtonAddDict).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDeleteDict).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 34, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel))).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogtaxoncode.html");
    }

    private void jButtonAddDictActionPerformed(ActionEvent evt) {
        String name = JOptionPane.showInputDialog(this, (Object)"Name of new Dictionary: ");
        if (name == null || name.length() == 0) {
            return;
        }
        for (TableModelTaxonCode.RowItem row : this.model.rows) {
            if (!row.dictionary.equalsIgnoreCase(name)) continue;
            JOptionPane.showMessageDialog(this, "Dictionary already exists", this.getTitle(), 2);
            return;
        }
        try {
            TableModelTaxonCode.RowItem row = new TableModelTaxonCode.RowItem();
            row.ccode = this.db.addSipmDict(name);
            this.db.commit();
            row.dictionary = name;
            this.model.rows.add(row);
            this.model.fireTableDataChanged();
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.getMessage(), (Exception)ex);
            ex.printStackTrace();
            this.db.doRollback();
        }
    }

    private void jButtonDeleteDictActionPerformed(ActionEvent evt) {
        if (this.jTableCode.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one row from the table", this.getTitle(), 2);
            return;
        }
        TableModelTaxonCode.RowItem row = this.model.rows.get(this.jTableCode.getSelectedRow());
        try {
            int opt;
            int nEntries = this.db.getSipmDictEntryCount(row.ccode);
            if (nEntries > 0 && (opt = JOptionPane.showConfirmDialog(this, "Warning: this dictionary contains codes for: " + nEntries + " taxa. Are you sure you want to delete it?", this.getTitle(), 0, 3)) != 0) {
                return;
            }
            this.db.deleteSipmDict(row.ccode);
            this.db.commit();
            this.model.rows.remove(row);
            this.model.fireTableDataChanged();
        }
        catch (SQLException sql) {
            this.db.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jTableCode.isEditing()) {
            this.jTableCode.getCellEditor().stopCellEditing();
        }
        try {
            for (TableModelTaxonCode.RowItem row : this.model.rows) {
                try {
                    this.taxon.storeSipmCode(row.ccode, row.code);
                }
                catch (SBException sbe) {
                    if (sbe.getMessage().startsWith("SIPM code is not unique")) {
                        String msg = "Code for '" + row.dictionary + "' dictionary is not unique.\nSpecify a different code.";
                        JOptionPane.showMessageDialog(this, msg, this.getTitle(), 2);
                        this.db.doRollback();
                        return;
                    }
                    throw sbe;
                }
            }
            this.db.commit();
            this.dispose();
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.getMessage(), (Exception)ex);
            this.db.doRollback();
        }
    }
}

