/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import jsbugs.DictItem;
import jsbugs.FrameJsbugs;
import jsbugs.FrameSamples;
import jsbugs.JPanelPicklist;
import model2.AbnScheme;
import model2.Lastval;
import model2.SBdb;
import model2.Taxon;
import model2.TaxonOcc;
import model2.TxGroup;
import util.SB;
import util.SBException;

public class DialogTaxonCodeInput
extends JDialog {
    private final SBdb sbdb;
    private final DefaultComboBoxModel dictModel = new DefaultComboBoxModel();
    private final DefaultComboBoxModel groupModel = new DefaultComboBoxModel();
    private final FrameSamples parent;
    private HashMap<Integer, Integer> dictEntries = null;
    private Integer dictID = null;
    private boolean pointCountMode = false;
    private boolean hasEnteredTaxon = false;
    private ButtonGroup buttonGroupMode;
    private JButton jButtonAddToSample;
    private JButton jButtonClose;
    private JButton jButtonHelp;
    private JCheckBox jCheckBoxCv;
    private JCheckBox jCheckBoxQ;
    private JCheckBox jCheckBoxRw;
    private JComboBox jComboBoxDictionary;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabelCount;
    private JPanel jPanel1;
    private JRadioButton jRadioButtonPointCount;
    private JRadioButton jRadioButtonTotals;
    private JTextField jTextFieldCode;
    private JTextField jTextFieldCount;

    public DialogTaxonCodeInput(FrameSamples parent, boolean modal, SBdb sbdb) {
        super((Frame)parent, modal);
        this.initComponents();
        this.sbdb = sbdb;
        this.parent = parent;
        this.init();
    }

    private void init() {
        this.setTitle("Input logging sheet");
        try {
            HashMap dicts = this.sbdb.getSIPMDicts();
            Set set = dicts.entrySet();
            int dictPref = Lastval.getInt((SBdb)this.sbdb, (String)"SIPMDICT");
            DictItem pref = null;
            for (Map.Entry entry : set) {
                DictItem item = new DictItem((Integer)entry.getKey(), (String)entry.getValue());
                this.dictModel.addElement(item);
                if ((Integer)entry.getKey() != dictPref) continue;
                pref = item;
            }
            if (pref != null) {
                this.dictModel.setSelectedItem(pref);
            }
            for (TxGroup group : this.sbdb.getTxGroups()) {
                this.groupModel.addElement(group);
            }
            int groupPref = Lastval.getInt((SBdb)this.sbdb, (String)"SIPMGROUP");
            if (groupPref > 0) {
                this.groupModel.setSelectedItem(this.sbdb.getTxGroup(groupPref));
            }
            if (Lastval.getInt((SBdb)this.sbdb, (String)"LOGPTCT") > 0) {
                this.pointCountMode = true;
                this.jRadioButtonPointCount.setSelected(true);
                this.setFields(this.pointCountMode);
            }
        }
        catch (SQLException sql) {
            SB.showStackError((String)"SQL Error", (SQLException)sql);
        }
        Vector<Component> order = new Vector<Component>(4);
        order.add(this.jTextFieldCode);
        order.add(this.jTextFieldCount);
        order.add(this.jButtonAddToSample);
        this.setNumeric();
        SBugsFocusTraversalPolicy focusPolicy = new SBugsFocusTraversalPolicy(order);
        this.setFocusTraversalPolicy(focusPolicy);
    }

    private void initComponents() {
        this.buttonGroupMode = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jComboBoxDictionary = new JComboBox();
        this.jPanel1 = new JPanel();
        this.jTextFieldCount = new JTextField();
        this.jTextFieldCode = new JTextField();
        this.jLabel3 = new JLabel();
        this.jLabelCount = new JLabel();
        this.jCheckBoxRw = new JCheckBox();
        this.jCheckBoxCv = new JCheckBox();
        this.jCheckBoxQ = new JCheckBox();
        this.jButtonAddToSample = new JButton();
        this.jButtonClose = new JButton();
        this.jButtonHelp = new JButton();
        this.jRadioButtonTotals = new JRadioButton();
        this.jRadioButtonPointCount = new JRadioButton();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jLabel1.setText("Dictionary:");
        this.jComboBoxDictionary.setModel(this.dictModel);
        this.jComboBoxDictionary.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxonCodeInput.this.jComboBoxDictionaryActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jTextFieldCount.setFont(new Font("Tahoma", 1, 13));
        this.jTextFieldCount.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogTaxonCodeInput.this.jTextFieldCountKeyTyped(evt);
            }
        });
        this.jTextFieldCode.setFont(new Font("Tahoma", 1, 13));
        this.jTextFieldCode.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogTaxonCodeInput.this.jTextFieldCodeKeyTyped(evt);
            }
        });
        this.jLabel3.setText("Code:");
        this.jLabelCount.setText("Count:");
        this.jCheckBoxRw.setText("Rw");
        this.jCheckBoxCv.setText("Cv");
        this.jCheckBoxQ.setText("?");
        this.jButtonAddToSample.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/FrameSamples_AddTaxon.png")));
        this.jButtonAddToSample.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxonCodeInput.this.jButtonAddToSampleActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabelCount).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButtonAddToSample).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 17, Short.MAX_VALUE)).addComponent(this.jTextFieldCount))).addGroup(jPanel1Layout.createSequentialGroup().addGap(14, 14, 14).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldCode))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 6, -2).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxRw).addComponent(this.jCheckBoxCv).addComponent(this.jCheckBoxQ)).addGap(15, 15, 15)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jTextFieldCode, -2, -1, -2)).addComponent(this.jCheckBoxRw, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldCount, -2, -1, -2).addComponent(this.jLabelCount)).addGap(11, 11, 11).addComponent(this.jButtonAddToSample)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jCheckBoxCv).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxQ))).addContainerGap(-1, Short.MAX_VALUE)));
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxonCodeInput.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxonCodeInput.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.buttonGroupMode.add(this.jRadioButtonTotals);
        this.jRadioButtonTotals.setSelected(true);
        this.jRadioButtonTotals.setText("Enter counts");
        this.jRadioButtonTotals.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxonCodeInput.this.jRadioButtonTotalsActionPerformed(evt);
            }
        });
        this.buttonGroupMode.add(this.jRadioButtonPointCount);
        this.jRadioButtonPointCount.setText("Point count");
        this.jRadioButtonPointCount.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxonCodeInput.this.jRadioButtonPointCountActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxDictionary, 0, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonClose)).addGroup(layout.createSequentialGroup().addComponent(this.jRadioButtonTotals).addGap(18, 18, 18).addComponent(this.jRadioButtonPointCount, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.linkSize(0, this.jButtonClose, this.jButtonHelp);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxDictionary, -2, -1, -2).addComponent(this.jLabel1)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonTotals).addComponent(this.jRadioButtonPointCount)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 9, Short.MAX_VALUE).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonClose).addComponent(this.jButtonHelp)).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        try {
            Lastval.putInt((SBdb)this.sbdb, (String)"LOGPTCT", (int)(this.pointCountMode ? 1 : 0));
            this.sbdb.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.dispose();
    }

    private void jButtonAddToSampleActionPerformed(ActionEvent evt) {
        if (this.jTextFieldCode.getText().isEmpty()) {
            JOptionPane.showMessageDialog(this, "Enter a numeric code", this.getTitle(), 2);
            return;
        }
        int code = Integer.parseInt(this.jTextFieldCode.getText());
        if (this.jTextFieldCount.getText().isEmpty()) {
            JOptionPane.showMessageDialog(this, "Enter count", this.getTitle(), 2);
            return;
        }
        String count = this.jTextFieldCount.getText();
        try {
            this.addToSample(code, count);
        }
        catch (SBException sbe) {
            JOptionPane.showMessageDialog(this, sbe.getMessage(), "Error", 2);
            sbe.printStackTrace();
            this.jTextFieldCode.setSelectionStart(0);
            this.jTextFieldCode.setSelectionEnd(this.jTextFieldCode.getText().length() - 1);
            this.jTextFieldCode.requestFocusInWindow();
        }
        catch (SQLException sql) {
            SB.showStackError((String)"SQL Error", (SQLException)sql);
        }
        this.jTextFieldCode.setText("");
        this.jTextFieldCount.setText("");
        this.jCheckBoxCv.setSelected(false);
        this.jCheckBoxQ.setSelected(false);
        this.jCheckBoxRw.setSelected(false);
        this.jTextFieldCode.requestFocusInWindow();
    }

    private void jTextFieldCodeKeyTyped(KeyEvent evt) {
        if (this.pointCountMode) {
            if (this.checkEnter(evt.getKeyChar())) {
                this.hasEnteredTaxon = true;
                return;
            }
            if (this.hasEnteredTaxon) {
                this.jTextFieldCode.setText(null);
                this.hasEnteredTaxon = false;
            }
        }
        if (SB.intFieldVal((JTextField)this.jTextFieldCode, (int)10, (KeyEvent)evt, (boolean)false) && !this.toggleCheckbox(evt.getKeyChar())) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldCountKeyTyped(KeyEvent evt) {
        if (this.parent.isNumeric()) {
            if (SB.intFieldVal((JTextField)this.jTextFieldCount, (int)10, (KeyEvent)evt, (boolean)false) && !this.toggleCheckbox(evt.getKeyChar())) {
                this.getToolkit().beep();
            }
        } else {
            char c = evt.getKeyChar();
            try {
                AbnScheme abnScheme = this.sbdb.getAbnScheme(this.parent.getTableModelOcc().smpdtl.getHeader().getAbnSchID(), false);
                if (abnScheme == null) {
                    JOptionPane.showMessageDialog(this, "No abundance scheme set for selected analysis suite.\nSet an abundance scheme for this suite, or switch to quantitative mode.", this.getTitle(), 2);
                    evt.consume();
                    return;
                }
                if (Character.isDigit(c)) {
                    int nClass = Character.getNumericValue(c) - 1;
                    if (nClass > -1 && nClass < abnScheme.getNClasses()) {
                        this.jTextFieldCount.setText(abnScheme.getEntry(nClass));
                    } else {
                        this.getToolkit().beep();
                    }
                } else {
                    int index = abnScheme.getIndexStartsWith(String.valueOf(c).toUpperCase());
                    if (index < 0) {
                        this.getToolkit().beep();
                    } else {
                        this.jTextFieldCount.setText(abnScheme.getEntry(index));
                    }
                }
                evt.consume();
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
            }
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("howtousenumericcodes.html");
    }

    private void jComboBoxDictionaryActionPerformed(ActionEvent evt) {
        this.setDictEntries();
    }

    private void jRadioButtonTotalsActionPerformed(ActionEvent evt) {
        if (this.pointCountMode) {
            this.pointCountMode = false;
            this.setFields(this.pointCountMode);
        }
    }

    private void jRadioButtonPointCountActionPerformed(ActionEvent evt) {
        if (!this.pointCountMode) {
            this.pointCountMode = true;
            this.setFields(this.pointCountMode);
        }
    }

    private void setFields(boolean pointCountMode) {
        this.jTextFieldCount.setEnabled(!pointCountMode);
        this.jButtonAddToSample.setEnabled(!pointCountMode);
    }

    private void setDictEntries() {
        int newID = ((DictItem)this.dictModel.getSelectedItem()).code;
        if (this.dictID != null && newID == this.dictID) {
            return;
        }
        try {
            this.dictID = newID;
            System.out.println("Loading SIPM dictionary " + this.dictID + "...");
            this.dictEntries = this.sbdb.getSipmDictEntries(this.dictID.intValue(), false);
        }
        catch (Exception e) {
            SB.showStackError((String)"Error setting SIPM dictionary", (Exception)e);
        }
    }

    boolean toggleCheckbox(char c) {
        if (c == 'r') {
            this.jCheckBoxRw.setSelected(!this.jCheckBoxRw.isSelected());
            return true;
        }
        if (c == 'c') {
            this.jCheckBoxCv.setSelected(!this.jCheckBoxCv.isSelected());
            return true;
        }
        if (c == 'q') {
            this.jCheckBoxQ.setSelected(!this.jCheckBoxQ.isSelected());
            return true;
        }
        return false;
    }

    private boolean checkEnter(int keyCode) {
        try {
            if (keyCode == 10 && this.pointCountMode) {
                int code = Integer.parseInt(this.jTextFieldCode.getText());
                if (code == 0) {
                    return false;
                }
                this.addToSample(code, "1");
                return true;
            }
        }
        catch (SBException sbe) {
            JOptionPane.showMessageDialog(this, sbe.getMessage(), "Error", 2);
            sbe.printStackTrace();
            this.jTextFieldCode.setSelectionStart(0);
            this.jTextFieldCode.setSelectionEnd(this.jTextFieldCode.getText().length() - 1);
            this.jTextFieldCode.requestFocusInWindow();
        }
        catch (SQLException sql) {
            SB.showStackError((String)"SQL Error", (SQLException)sql);
        }
        return false;
    }

    private void addToSample(int code, String abund) throws SQLException, SBException {
        TaxonOcc existing;
        int count = 0;
        String subjAbund = "";
        if (Character.isDigit(abund.charAt(0))) {
            count = Integer.parseInt(abund);
        } else {
            subjAbund = abund;
        }
        Integer specID = this.dictEntries.get(code);
        if (specID == null) {
            this.getToolkit().beep();
            JOptionPane.showMessageDialog(this, "No taxon found", this.getTitle(), 2);
            this.jTextFieldCode.setSelectionStart(0);
            this.jTextFieldCode.setSelectionEnd(this.jTextFieldCode.getText().length());
            this.jTextFieldCode.requestFocusInWindow();
            return;
        }
        Taxon taxon = this.sbdb.getTaxon(specID.intValue());
        if (this.pointCountMode && (existing = this.parent.getTableModelOcc().smpdtl.getFss(taxon, this.jCheckBoxRw.isSelected(), this.jCheckBoxQ.isSelected() ? (char)'?' : 'P', 0)) != null && !existing.getSubAbund().isEmpty() && JOptionPane.showConfirmDialog(this, "Overwrite existing semi-quant data?", this.getTitle(), 0) != 0) {
            return;
        }
        JPanelPicklist.addToSample(taxon, count, subjAbund, this.jCheckBoxRw.isSelected(), this.jCheckBoxCv.isSelected(), this.jCheckBoxQ.isSelected(), this.parent, this.sbdb);
    }

    void setNumeric() {
        if (this.parent.isNumeric()) {
            this.jLabelCount.setText("Count:");
        } else {
            this.jLabelCount.setText("Abund:");
        }
    }

    class SBugsFocusTraversalPolicy
    extends FocusTraversalPolicy {
        Vector<Component> order;

        SBugsFocusTraversalPolicy(Vector<Component> order) {
            this.order = new Vector(order.size());
            this.order.addAll(order);
        }

        @Override
        public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
            int idx = (this.order.indexOf(aComponent) + 1) % this.order.size();
            return this.order.get(idx);
        }

        @Override
        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            int idx = this.order.indexOf(aComponent) - 1;
            if (idx < 0) {
                idx = this.order.size() - 1;
            }
            return this.order.get(idx);
        }

        @Override
        public Component getDefaultComponent(Container focusCycleRoot) {
            return this.order.get(0);
        }

        @Override
        public Component getLastComponent(Container focusCycleRoot) {
            return this.order.lastElement();
        }

        @Override
        public Component getFirstComponent(Container focusCycleRoot) {
            return this.order.get(0);
        }
    }
}

