/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import jsbugs.DictItem;
import jsbugs.FrameJsbugs;
import jsbugs.SBDialog;
import jsbugs.TableModelCodes;
import model2.Lastval;
import model2.SBdb;
import model2.TxGroup;
import util.SB;
import util.SBException;
import util.SbugsTable;

public class DialogTaxonCodePrint
extends SBDialog {
    SBdb sbdb;
    LinkedList<TxGroup> groups;
    DefaultComboBoxModel dictModel = new DefaultComboBoxModel();
    TableModelCodes model = new TableModelCodes();
    HashMap<Integer, String> dicts;
    int nEmpty = 0;
    private JButton jButtonCancel;
    private JButton jButtonGenerate;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JComboBox jComboBoxDict;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSpinner jSpinnerBlanks;
    private JSpinner jSpinnerGenerate;
    private JTable jTableCodes;

    public DialogTaxonCodePrint(Frame parent, boolean modal, SBdb sbdb, LinkedList<TxGroup> groups) {
        super(parent, modal);
        this.sbdb = sbdb;
        this.groups = groups;
        this.initComponents();
        this.init();
    }

    private void init() {
        try {
            this.dicts = this.sbdb.getSIPMDicts();
            this.model.initTable(this.jTableCodes);
            Set<Map.Entry<Integer, String>> set = this.dicts.entrySet();
            int dictPref = Lastval.getInt((SBdb)this.sbdb, (String)"SIPMDICT");
            DictItem pref = null;
            for (Map.Entry<Integer, String> entry : set) {
                DictItem item = new DictItem(entry.getKey(), entry.getValue());
                this.dictModel.addElement(item);
                if (item.code != dictPref) continue;
                pref = item;
            }
            if (pref != null) {
                this.dictModel.setSelectedItem(pref);
            }
        }
        catch (SQLException sql) {
            SB.showStackError((String)"SQL Error opening dialog", (SQLException)sql);
        }
        String title = "Numeric Codes";
        if (this.groups.size() == 1) {
            title = title + " : " + this.groups.get(0).getName();
        }
        this.setTitle(title);
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTableCodes = new SbugsTable();
        this.jLabel1 = new JLabel();
        this.jComboBoxDict = new JComboBox();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jLabel2 = new JLabel();
        this.jSpinnerBlanks = new JSpinner();
        this.jSeparator1 = new JSeparator();
        this.jLabel3 = new JLabel();
        this.jButtonGenerate = new JButton();
        this.jSpinnerGenerate = new JSpinner();
        this.jButtonHelp = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(300, 350));
        this.jTableCodes.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTableCodes);
        this.jLabel1.setText("Dictionary:");
        this.jComboBoxDict.setModel(this.dictModel);
        this.jComboBoxDict.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxonCodePrint.this.jComboBoxDictActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxonCodePrint.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("Save and Print");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxonCodePrint.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Additional blank rows:");
        this.jSpinnerBlanks.setModel(new SpinnerNumberModel((Number)0, null, Integer.valueOf(30), (Number)1));
        this.jLabel3.setText("Generate codes starting from:");
        this.jButtonGenerate.setText("Generate");
        this.jButtonGenerate.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonGenerate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxonCodePrint.this.jButtonGenerateActionPerformed(evt);
            }
        });
        this.jSpinnerGenerate.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxonCodePrint.this.jButtonHelpActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpinnerGenerate, -1, 56, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonGenerate)).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxDict, 0, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpinnerBlanks, -2, 45, -2)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel))))).addContainerGap()));
        layout.linkSize(0, this.jButtonCancel, this.jButtonHelp);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jComboBoxDict, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jButtonGenerate).addComponent(this.jSpinnerGenerate, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane1, -1, 260, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jSpinnerBlanks, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 10, -2).addGap(1, 1, 1).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOK).addComponent(this.jButtonHelp)).addContainerGap()));
        this.pack();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jTableCodes.isEditing()) {
            this.jTableCodes.getCellEditor().stopCellEditing();
        }
        LinkedList<Integer> codes = new LinkedList<Integer>();
        for (TableModelCodes.TableItem item : this.model.taxa) {
            if (item.code == null) {
                JOptionPane.showMessageDialog(this, "All taxa must be given a numeric code", this.getTitle(), 2);
                return;
            }
            if (codes.contains(item.code)) {
                JOptionPane.showMessageDialog(this, "The table contains duplicate codes", this.getTitle(), 2);
                return;
            }
            codes.add(item.code);
        }
        LinkedList<TableModelCodes.TableItem> toUpdate = new LinkedList<TableModelCodes.TableItem>();
        int nUpdates = 0;
        try {
            for (TableModelCodes.TableItem item : this.model.taxa) {
                Integer initialCode = item.taxon.getSipmCode(this.model.dict);
                if (initialCode != null && initialCode.equals(item.code)) continue;
                nUpdates += initialCode != null ? 1 : 0;
                toUpdate.add(item);
            }
            if (nUpdates > 0) {
                String msg = nUpdates + " code" + (nUpdates == 1 ? "" : "s") + " to be updated.\n";
                if ((this.sbdb.getUser().getPriv() & 0x40) == 0) {
                    msg = msg + "Only super users can update existing numeric codes.";
                    msg = msg + "\nOriginal codes will be retained";
                    JOptionPane.showMessageDialog(this, msg, this.getTitle(), 2);
                    Iterator it = toUpdate.iterator();
                    while (it.hasNext()) {
                        TableModelCodes.TableItem item = (TableModelCodes.TableItem)it.next();
                        if (item.taxon.getSipmCode(this.model.dict) == null) continue;
                        it.remove();
                    }
                } else if (JOptionPane.showConfirmDialog(this, msg = msg + "This might affect logging sheets already printed.\nAre you sure you want to continue?", this.getTitle(), 0) != 0) {
                    return;
                }
            }
            for (TableModelCodes.TableItem item : toUpdate) {
                item.taxon.storeSipmCode(this.model.dict, item.code);
            }
            if (this.groups.size() == 1) {
                Lastval.putInt((SBdb)this.sbdb, (String)"SIPMGROUP", (int)this.groups.get(0).getID());
            }
            Lastval.putInt((SBdb)this.sbdb, (String)"SIPMDICT", (int)this.model.dict);
            this.sbdb.commit();
        }
        catch (SQLException sql) {
            SB.showStackError((String)"SQL Error", (SQLException)sql);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        this.nEmpty = (Integer)this.jSpinnerBlanks.getModel().getValue();
        this.setOK();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jComboBoxDictActionPerformed(ActionEvent evt) {
        try {
            this.model.setData(((DictItem)this.jComboBoxDict.getSelectedItem()).code, this.groups, this.sbdb);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (SQLException sql) {
            SB.showStackError((String)"SQL Error", (SQLException)sql);
        }
        this.model.fireTableDataChanged();
    }

    private void jButtonGenerateActionPerformed(ActionEvent evt) {
        HashMap dictEntries;
        try {
            dictEntries = this.sbdb.getSipmDictEntries(this.model.dict, true);
        }
        catch (SQLException sql) {
            SB.showStackError((String)"SQL Error", (SQLException)sql);
            return;
        }
        for (TableModelCodes.TableItem item : this.model.taxa) {
            if (item.code == null) continue;
            dictEntries.put(item.taxon.getSpecID(), item.code);
        }
        int value = (Integer)this.jSpinnerGenerate.getValue();
        for (TableModelCodes.TableItem item : this.model.taxa) {
            if (item.code != null) continue;
            while (dictEntries.containsValue(value)) {
                ++value;
            }
            item.code = value;
            dictEntries.put(item.taxon.getSpecID(), value);
        }
        this.model.fireTableDataChanged();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("howtousenumericcodes.html");
    }
}

