/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import jsbugs.DialogImageSet;
import jsbugs.DialogImageSetOverview;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelTaxonImage;
import model2.SBdb;
import model2.Sample;
import model2.Smpdtl;
import model2.Taxon;
import model2.TaxonWellImage;
import model2.Well;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;
import util.TableSorter;
import util.TextAreaRenderer;

public class DialogTaxonImages
extends JDialog {
    Taxon taxon;
    TableModelTaxonImage model = new TableModelTaxonImage();
    TableSorter sorter = new TableSorter((TableModel)this.model);
    boolean isWorkspace = false;
    private JButton jButtonAdd;
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JButton jButtonEdit;
    private JButton jButtonHelp;
    private JButton jButtonMarkAsType;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JTable jTableTaxonImage;
    private JTextField jTextFieldTaxonName;

    public DialogTaxonImages(Frame parent, boolean modal, SBdb db, Taxon taxon) throws SQLException, SBException {
        super(parent, modal);
        this.initComponents();
        this.taxon = taxon;
        this.model.db = db;
        this.init();
    }

    public DialogTaxonImages(JDialog parent, boolean modal, SBdb db, Taxon taxon) throws SQLException, SBException {
        super((Dialog)parent, modal);
        this.initComponents();
        this.taxon = taxon;
        this.model.db = db;
        this.init();
    }

    public DialogTaxonImages(JDialog parent, boolean modal, SBdb db, Taxon taxon, boolean isWorkspace) throws SQLException, SBException {
        super((Dialog)parent, modal);
        this.initComponents();
        this.taxon = taxon;
        this.model.db = db;
        this.isWorkspace = isWorkspace;
        this.init();
    }

    private void init() throws SQLException, SBException {
        this.setTitle("Taxon : Images");
        this.jTextFieldTaxonName.setText(this.taxon.toString(true, true));
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            this.jTableTaxonImage.getColumnModel().getColumn(i).setHeaderValue(TableModelTaxonImage.colTitles[i]);
            this.jTableTaxonImage.getColumnModel().getColumn(i).setPreferredWidth(TableModelTaxonImage.colWidth[i]);
        }
        this.jTableTaxonImage.setDefaultRenderer(String.class, (TableCellRenderer)new TextAreaRenderer(false, this.jTableTaxonImage.getFont()));
        this.jTableTaxonImage.setDefaultRenderer(Well.class, (TableCellRenderer)new TextAreaRenderer(false, this.jTableTaxonImage.getFont()));
        this.jTableTaxonImage.setDefaultRenderer(Float.class, (TableCellRenderer)new TextAreaRenderer(false, this.jTableTaxonImage.getFont()));
        this.jTableTaxonImage.setDefaultRenderer(Integer.class, (TableCellRenderer)new TextAreaRenderer(false, this.jTableTaxonImage.getFont()));
        SB.setTableHeaderBold((JTable)this.jTableTaxonImage);
        this.sorter.addMouseListenerToHeaderInTable(this.jTableTaxonImage);
        this.jTableTaxonImage.setRowHeight(80);
        this.model.data = this.model.db.getTaxonImages(this.taxon);
        this.sorter.reallocateIndexes();
        this.sorter.fireTableDataChanged();
        this.getRootPane().setDefaultButton(this.jButtonClose);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldTaxonName = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.jTableTaxonImage = new JTable();
        this.jButtonClose = new JButton();
        this.jButtonMarkAsType = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonEdit = new JButton();
        this.jButtonAdd = new JButton();
        this.jButtonHelp = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(600, 300));
        this.jLabel1.setText("Taxon:");
        this.jTextFieldTaxonName.setBackground(new Color(255, 255, 204));
        this.jTextFieldTaxonName.setEditable(false);
        this.jTableTaxonImage.setModel((TableModel)this.sorter);
        this.jTableTaxonImage.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DialogTaxonImages.this.jTableTaxonImageMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableTaxonImage);
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxonImages.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonMarkAsType.setText("Mark as \"Type\"");
        this.jButtonMarkAsType.setToolTipText("Mark selected image set as notable \"type\" specimen");
        this.jButtonMarkAsType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxonImages.this.jButtonMarkAsTypeActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.setToolTipText("Delete selected image set");
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxonImages.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText("Edit...");
        this.jButtonEdit.setToolTipText("Edit selected image set");
        this.jButtonEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxonImages.this.jButtonEditActionPerformed(evt);
            }
        });
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.setToolTipText("Add new images to link to taxon");
        this.jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxonImages.this.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxonImages.this.jButtonHelpActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jTextFieldTaxonName, -1, 579, Short.MAX_VALUE)).add((Component)this.jScrollPane1, -1, 617, Short.MAX_VALUE).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonAdd).addPreferredGap(0).add((Component)this.jButtonEdit).addPreferredGap(0).add((Component)this.jButtonDelete).addPreferredGap(0).add((Component)this.jButtonMarkAsType).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonClose))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonAdd, this.jButtonClose, this.jButtonDelete, this.jButtonEdit, this.jButtonHelp}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jTextFieldTaxonName, -2, -1, -2)).addPreferredGap(1).add((Component)this.jScrollPane1, -1, 262, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonClose).add((Component)this.jButtonMarkAsType).add((Component)this.jButtonDelete).add((Component)this.jButtonEdit).add((Component)this.jButtonAdd).add((Component)this.jButtonHelp)).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        for (TaxonWellImage twi : this.model.data) {
            twi.imageSet.clearImages();
        }
        this.dispose();
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.jTableTaxonImage.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one item", this.getTitle(), 1);
            return;
        }
        TaxonWellImage item = this.model.data.get(this.sorter.getIndexOf(this.jTableTaxonImage.getSelectedRow()));
        try {
            String msg = "Really delete this set of " + item.imageSet.getSize() + " image" + (item.imageSet.getSize() > 1 ? "s" : "");
            msg = item.smpdtl != null ? msg + ", which is linked to an analysis?" : msg + "?";
            if (JOptionPane.showConfirmDialog(this, msg, this.getTitle(), 0, 3) != 0) {
                return;
            }
            boolean deleted = false;
            if (item.smpdtl != null) {
                Smpdtl dtl;
                Well w = this.model.db.getAddWell(item.well.getWellID());
                w.getSamples();
                Sample s = w.getSample(item.sample.getSampID());
                if (s != null && (dtl = s.getAnalysis(item.smpdtl.getAnalyID())) != null) {
                    dtl.deleteImageSet(item.imageSet);
                    deleted = true;
                }
            }
            if (!deleted) {
                item.imageSet.delete();
            }
            this.taxon.getImageSetCount(true);
            this.model.data.remove(item);
            this.model.db.commit();
            this.sorter.reallocateIndexes();
            this.sorter.fireTableDataChanged();
        }
        catch (SBException sbe) {
            this.model.db.doRollback();
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (SQLException sql) {
            this.model.db.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.model.db);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        try {
            DialogImageSet dialog = new DialogImageSet(this, true, this.model.db, null);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK) {
                this.model.db.addTaxonImageSet(this.taxon, dialog.imageSet);
                this.model.db.commit();
                TaxonWellImage item = new TaxonWellImage();
                item.imageSet = dialog.imageSet;
                this.model.data.add(0, item);
                this.sorter.reallocateIndexes();
                this.sorter.fireTableDataChanged();
                this.jTableTaxonImage.clearSelection();
                this.jTableTaxonImage.setRowSelectionInterval(0, 0);
            }
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.getMessage(), (Exception)ex);
            ex.printStackTrace();
            this.model.db.doRollback();
        }
    }

    private void jButtonMarkAsTypeActionPerformed(ActionEvent evt) {
        if (this.jTableTaxonImage.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one item", this.getTitle(), 1);
            return;
        }
        TaxonWellImage item = this.model.data.get(this.sorter.getIndexOf(this.jTableTaxonImage.getSelectedRow()));
        try {
            this.model.db.setTaxonImageSetType(this.taxon, item.imageSet, !item.isType);
            if (!item.isType) {
                this.taxon.incrementTypeImage();
            } else {
                this.taxon.decrementTypeImage();
            }
            item.isType = !item.isType;
            this.model.db.commit();
            this.sorter.reallocateIndexes();
            this.sorter.fireTableDataChanged();
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.getMessage(), (Exception)ex);
            ex.printStackTrace();
            this.model.db.doRollback();
        }
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        if (this.jTableTaxonImage.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one item", this.getTitle(), 1);
            return;
        }
        TaxonWellImage item = this.model.data.get(this.sorter.getIndexOf(this.jTableTaxonImage.getSelectedRow()));
        DialogImageSetOverview dialog = new DialogImageSetOverview((Dialog)this, true, item.imageSet, this.model.db);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    private void jTableTaxonImageMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            if (this.jTableTaxonImage.getSelectedColumn() == 9) {
                this.jButtonMarkAsTypeActionPerformed(null);
            } else {
                this.jButtonEditActionPerformed(null);
            }
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogtaxonimages.html");
    }
}

