/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import jsbugs.FrameJsbugs;
import jsbugs.SBDialog;
import model2.SBdb;
import model2.Taxon;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;

public class DialogTaxonNotes
extends SBDialog {
    private static final int NOTELEN = 240;
    private static final int REFLEN = 240;
    private final Taxon taxon;
    private final SBdb db;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextArea jTextAreaNotes;
    private JTextArea jTextAreaRefs;
    private JTextField jTextFieldTaxonName;

    public DialogTaxonNotes(Frame parent, boolean modal, SBdb db, Taxon taxon) throws SQLException, SBException {
        super(parent, modal);
        this.taxon = taxon;
        this.db = db;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException, SBException {
        String refs;
        this.setTitle("References and Notes");
        this.jTextFieldTaxonName.setText(this.taxon.toString(true));
        String notes = this.taxon.getNotes();
        if (notes != null) {
            this.jTextAreaNotes.setText(notes);
        }
        if ((refs = this.taxon.getReference()) != null) {
            this.jTextAreaRefs.setText(refs);
        }
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void initComponents() {
        this.jTextFieldTaxonName = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaRefs = new JTextArea();
        this.jScrollPane2 = new JScrollPane();
        this.jTextAreaNotes = new JTextArea();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonHelp = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(250, 400));
        this.jTextFieldTaxonName.setBackground(new Color(255, 255, 204));
        this.jTextFieldTaxonName.setEditable(false);
        this.jTextAreaRefs.setColumns(20);
        this.jTextAreaRefs.setFont(new Font("Tahoma", 0, 13));
        this.jTextAreaRefs.setLineWrap(true);
        this.jTextAreaRefs.setRows(5);
        this.jTextAreaRefs.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogTaxonNotes.this.jTextAreaRefsKeyTyped(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTextAreaRefs);
        this.jTextAreaNotes.setColumns(20);
        this.jTextAreaNotes.setFont(new Font("Tahoma", 0, 13));
        this.jTextAreaNotes.setLineWrap(true);
        this.jTextAreaNotes.setRows(5);
        this.jTextAreaNotes.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogTaxonNotes.this.jTextAreaNotesKeyTyped(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jTextAreaNotes);
        this.jLabel1.setText("References:");
        this.jLabel2.setText("Notes:");
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxonNotes.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxonNotes.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxonNotes.this.jButtonHelpActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane2, -1, 380, Short.MAX_VALUE).add((Component)this.jScrollPane1, -1, 380, Short.MAX_VALUE).add((Component)this.jTextFieldTaxonName, -1, 380, Short.MAX_VALUE).add((Component)this.jLabel1).add((Component)this.jLabel2).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonOK).add(5, 5, 5).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jTextFieldTaxonName, -2, -1, -2).add(17, 17, 17).add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 115, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.jScrollPane2, -1, 115, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonOK).add((Component)this.jButtonHelp)).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 2);
        this.pack();
    }

    private void jTextAreaRefsKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextArea)this.jTextAreaRefs, (int)240, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextAreaNotesKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextArea)this.jTextAreaNotes, (int)240, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        try {
            this.taxon.updateNoteRefs(this.jTextAreaNotes.getText().trim(), this.jTextAreaRefs.getText().trim());
            this.db.commit();
            this.setOK();
        }
        catch (SQLException sql) {
            this.db.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogtaxonnotes.html");
    }
}

