/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import jsbugs.DialogSelectTaxa;
import jsbugs.DialogcoOccurrences;
import jsbugs.FrameJsbugs;
import model2.SBdb;
import model2.Taxon;
import model2.TaxonOcc;
import model2.Well;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;

public class DialogTaxonReassign
extends JDialog {
    private final SBdb db;
    private final Well well;
    private final Taxon orig;
    Taxon target;
    boolean isOK;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonSelectTaxon;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabelInsitu;
    private JLabel jLabelNQ;
    private JLabel jLabelNRw;
    private JLabel jLabelNinSitu;
    private JLabel jLabelQuestionable;
    private JLabel jLabelReworked;
    private JLabel jLabelTotalOcc;
    private JSeparator jSeparator1;
    private JTextField jTextFieldOrig;
    private JTextField jTextFieldTarget;

    public DialogTaxonReassign(Frame parent, boolean modal, SBdb db, Well well, Taxon taxon) throws SQLException {
        super(parent, modal);
        this.db = db;
        this.well = well;
        this.orig = taxon;
        this.initComponents();
        this.init();
    }

    public DialogTaxonReassign(JDialog parent, boolean modal, SBdb db, Well well, Taxon taxon) throws SQLException {
        super((Dialog)parent, modal);
        this.db = db;
        this.well = well;
        this.orig = taxon;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException {
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.jTextFieldOrig.setText(this.orig.toString(true, true));
        int total = TaxonOcc.getNOcc((SBdb)this.db, (Well)this.well, (Taxon)this.orig, (int)0);
        int nInSitu = TaxonOcc.getNOcc((SBdb)this.db, (Well)this.well, (Taxon)this.orig, (int)1);
        int nRw = TaxonOcc.getNOcc((SBdb)this.db, (Well)this.well, (Taxon)this.orig, (int)2);
        int nQuestionable = TaxonOcc.getNOcc((SBdb)this.db, (Well)this.well, (Taxon)this.orig, (int)3);
        if (nInSitu > 0) {
            this.jLabelNinSitu.setText("" + nInSitu);
        } else {
            this.jLabelNinSitu.setText(null);
            this.jLabelInsitu.setEnabled(false);
        }
        if (nRw > 0) {
            this.jLabelNRw.setText("" + nRw);
        } else {
            this.jLabelNRw.setText(null);
            this.jLabelReworked.setEnabled(false);
        }
        if (nQuestionable > 0) {
            this.jLabelNQ.setText("" + nQuestionable);
        } else {
            this.jLabelNQ.setText(null);
            this.jLabelQuestionable.setEnabled(false);
        }
        this.jLabelTotalOcc.setText("Total occurrences: " + total);
        this.setTitle("Reassign Taxa");
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jTextFieldOrig = new JTextField();
        this.jLabel3 = new JLabel();
        this.jTextFieldTarget = new JTextField();
        this.jButtonSelectTaxon = new JButton();
        this.jLabelNinSitu = new JLabel();
        this.jLabelNRw = new JLabel();
        this.jLabelNQ = new JLabel();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jLabelTotalOcc = new JLabel();
        this.jLabelInsitu = new JLabel();
        this.jLabelReworked = new JLabel();
        this.jLabelQuestionable = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jButtonHelp = new JButton();
        this.jLabel1.setText("jLabel1");
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jLabel2.setHorizontalAlignment(11);
        this.jLabel2.setText("Original taxon:");
        this.jTextFieldOrig.setBackground(new Color(255, 255, 204));
        this.jTextFieldOrig.setEditable(false);
        this.jTextFieldOrig.setText("jTextField1");
        this.jLabel3.setHorizontalAlignment(11);
        this.jLabel3.setText("New taxon:");
        this.jTextFieldTarget.setEditable(false);
        this.jButtonSelectTaxon.setText("...");
        this.jButtonSelectTaxon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxonReassign.this.jButtonSelectTaxonActionPerformed(evt);
            }
        });
        this.jLabelNinSitu.setText("jLabel4");
        this.jLabelNRw.setText("jLabel5");
        this.jLabelNQ.setText("jLabel6");
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxonReassign.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxonReassign.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jLabelTotalOcc.setFont(new Font("Tahoma", 1, 11));
        this.jLabelTotalOcc.setText("jLabel4");
        this.jLabelInsitu.setText("In-situ occurrences");
        this.jLabelReworked.setText("Reworked occurrences");
        this.jLabelQuestionable.setText("Questionable occurrences");
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxonReassign.this.jButtonHelpActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.jTextFieldOrig, -1, 404, Short.MAX_VALUE).addContainerGap()).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel)).add(1, (Component)this.jSeparator1, -1, 475, Short.MAX_VALUE)).add(14, 14, 14)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel3).addPreferredGap(0).add((Component)this.jTextFieldTarget, -1, 365, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jButtonSelectTaxon, -2, 33, -2).addContainerGap()))).add((GroupLayout.Group)layout.createSequentialGroup().add(45, 45, 45).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabelNinSitu).add((Component)this.jLabelNRw).add((Component)this.jLabelNQ)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabelQuestionable).add((Component)this.jLabelReworked).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabelInsitu).add(64, 64, 64).add((Component)this.jLabelTotalOcc, -2, 173, -2))).addContainerGap(81, Short.MAX_VALUE)));
        layout.linkSize(new Component[]{this.jLabel2, this.jLabel3}, 1);
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jTextFieldOrig, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jTextFieldTarget, -2, -1, -2).add((Component)this.jButtonSelectTaxon).add((Component)this.jLabel3)).add(18, 18, 18).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelNinSitu).add((Component)this.jLabelTotalOcc).add((Component)this.jLabelInsitu)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelNRw).add((Component)this.jLabelReworked)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelNQ).add((Component)this.jLabelQuestionable)).addPreferredGap(0, 16, Short.MAX_VALUE).add((Component)this.jSeparator1, -2, 5, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonOK).add((Component)this.jButtonHelp)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.target == null) {
            JOptionPane.showMessageDialog(this, "No target taxon selected", this.getTitle(), 1);
            return;
        }
        if (this.target.getSpecID() == this.orig.getSpecID()) {
            JOptionPane.showMessageDialog(this, "Target taxon same as original!", this.getTitle(), 1);
            return;
        }
        try {
            Taxon.checkCoOccurrences((SBdb)this.db, (int)this.orig.getSpecID(), (int)this.target.getSpecID(), (int)-1, (int)0, (int)this.well.getWellID());
            this.well.mergeTaxa(this.orig, this.target);
            this.db.commit();
            JOptionPane.showMessageDialog(this, "Taxon reassigned");
            this.isOK = true;
            this.dispose();
        }
        catch (SBException se) {
            if (se.getData() != null) {
                DialogcoOccurrences dialog = new DialogcoOccurrences(this, true, "Co-Occurrences", this.well, this.target, this.orig, this.db, (List)se.getData());
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
                if (dialog.isOK) {
                    try {
                        this.well.mergeTaxa(this.orig, this.target);
                        this.db.commit();
                        JOptionPane.showMessageDialog(this, "Taxon merged/reassigned");
                        this.dispose();
                    }
                    catch (Exception ex) {
                        SB.showStackError((String)ex.getMessage(), (Exception)ex);
                        this.db.doRollback();
                    }
                }
            } else {
                JOptionPane.showMessageDialog(this, se.getMessage(), this.getTitle(), 0);
            }
        }
        catch (SQLException sql) {
            this.db.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (RuntimeException re) {
            this.db.doRollback();
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonSelectTaxonActionPerformed(ActionEvent evt) {
        try {
            DialogSelectTaxa dialog = new DialogSelectTaxa((JDialog)this, true, this.db, true, this.orig);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.selection != null) {
                this.target = dialog.selection.get(0);
                this.jTextFieldTarget.setText(this.target.toString(true, true));
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error opening dialog", sql, this.db);
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("samples_menu.html#analyses");
    }
}

