/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.TableModel;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelTaxonWellOcc;
import jsbugs.TaxonWellOccItem;
import model2.Project;
import model2.SBdb;
import model2.Smpdtl;
import model2.Taxon;
import model2.TaxonOcc;
import model2.Well;
import util.SB;
import util.SBException;
import util.TableSorter;

public class DialogTaxonWellOcc
extends JDialog {
    private int DEPTHLEN = 8;
    DefaultListModel modelWells = new DefaultListModel();
    DefaultComboBoxModel projectModel = new DefaultComboBoxModel();
    TableModelTaxonWellOcc model = new TableModelTaxonWellOcc();
    TableSorter sorter = new TableSorter((TableModel)this.model);
    SBdb db;
    Taxon taxon;
    private boolean addWarn = false;
    TaxonWellOccItem selectedItem = null;
    Well well = null;
    private JButton jButtonClose;
    private JButton jButtonHelp;
    private JButton jButtonSearch;
    private JButton jButtonShowSample;
    private JButton jButtonShowWell;
    private JComboBox jComboBoxProject;
    private JComboBox jComboBoxUnits;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JList jListWell;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTable jTableWellOcc;
    private JTextField jTextFieldAbundance;
    private JTextField jTextFieldDepth1;
    private JTextField jTextFieldDepth2;
    private JTextField jTextFieldSQL;
    private JTextField jTextFieldTaxon;

    public DialogTaxonWellOcc(Frame parent, boolean modal, SBdb db, Taxon taxon) throws SQLException, SBException {
        super(parent, modal);
        this.db = db;
        this.taxon = taxon;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException, SBException {
        this.jTextFieldTaxon.setText(this.taxon.toString());
        this.db.getProjects().loadCombo(this.projectModel, true);
        this.model.setupTable(this.jTableWellOcc);
        this.setTitle("Well Occurrences : " + this.taxon.toString(true, false, true));
        this.getRootPane().setDefaultButton(this.jButtonClose);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jListWell = new JList();
        this.jButtonShowWell = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.jTableWellOcc = new JTable();
        this.jButtonClose = new JButton();
        this.jButtonHelp = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jTextFieldTaxon = new JTextField();
        this.jComboBoxProject = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jTextFieldDepth1 = new JTextField();
        this.jLabel4 = new JLabel();
        this.jTextFieldDepth2 = new JTextField();
        this.jLabel6 = new JLabel();
        this.jTextFieldAbundance = new JTextField();
        this.jTextFieldSQL = new JTextField();
        this.jLabel7 = new JLabel();
        this.jButtonSearch = new JButton();
        this.jComboBoxUnits = new JComboBox();
        this.jButtonShowSample = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(715, 400));
        this.jListWell.setModel(this.modelWells);
        this.jListWell.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DialogTaxonWellOcc.this.jListWellMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListWell);
        this.jButtonShowWell.setText("Show >");
        this.jButtonShowWell.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonShowWell.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxonWellOcc.this.jButtonShowWellActionPerformed(evt);
            }
        });
        this.jTableWellOcc.setModel((TableModel)this.sorter);
        this.jTableWellOcc.setToolTipText("");
        this.jTableWellOcc.setAutoResizeMode(0);
        this.jTableWellOcc.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DialogTaxonWellOcc.this.jTableWellOccMouseClicked(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jTableWellOcc);
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxonWellOcc.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxonWellOcc.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jLabel1.setHorizontalAlignment(11);
        this.jLabel1.setText("Search for taxon:");
        this.jTextFieldTaxon.setEditable(false);
        this.jTextFieldTaxon.setBackground(new Color(255, 255, 204));
        this.jComboBoxProject.setModel(this.projectModel);
        this.jLabel2.setText("Within project:");
        this.jLabel3.setText("Between depths:");
        this.jTextFieldDepth1.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                DialogTaxonWellOcc.this.jTextFieldDepth1FocusGained(evt);
            }
        });
        this.jTextFieldDepth1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogTaxonWellOcc.this.jTextFieldDepth1KeyTyped(evt);
            }
        });
        this.jLabel4.setText("to:");
        this.jTextFieldDepth2.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                DialogTaxonWellOcc.this.jTextFieldDepth2FocusGained(evt);
            }
        });
        this.jTextFieldDepth2.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogTaxonWellOcc.this.jTextFieldDepth2KeyTyped(evt);
            }
        });
        this.jLabel6.setText("With abundance greater than:");
        this.jTextFieldAbundance.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogTaxonWellOcc.this.jTextFieldAbundanceKeyTyped(evt);
            }
        });
        this.jTextFieldSQL.setMinimumSize(new Dimension(6, 40));
        this.jLabel7.setText("Additional SQL parameters:");
        this.jButtonSearch.setText("Search");
        this.jButtonSearch.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxonWellOcc.this.jButtonSearchActionPerformed(evt);
            }
        });
        this.jComboBoxUnits.setModel(new DefaultComboBoxModel<String>(new String[]{"m", "ft"}));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(71, 71, 71).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldTaxon, -2, 523, -2).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jComboBoxProject, GroupLayout.Alignment.LEADING, 0, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addComponent(this.jTextFieldDepth1, -2, 93, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldDepth2, -2, 88, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxUnits, -2, 41, -2)))).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel6).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonSearch).addComponent(this.jTextFieldAbundance, -2, 203, -2).addComponent(this.jTextFieldSQL, -2, 523, -2)).addGap(20, 20, 20))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldTaxon, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxProject, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jTextFieldDepth2, -2, -1, -2).addComponent(this.jComboBoxUnits, -2, -1, -2)).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldDepth1, -2, -1, -2).addComponent(this.jLabel3))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.jTextFieldAbundance, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldSQL, -2, -1, -2).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSearch)));
        this.jButtonShowSample.setText("Go to sample...");
        this.jButtonShowSample.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxonWellOcc.this.jButtonShowSampleActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 195, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jButtonShowWell, -2, 57, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 719, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jButtonShowSample).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp, -2, 59, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonClose))))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jButtonShowWell, GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane2, -1, 274, Short.MAX_VALUE).addComponent(this.jScrollPane1, -1, 274, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonHelp).addComponent(this.jButtonShowSample)).addComponent(this.jButtonClose)).addContainerGap()))));
        this.pack();
    }

    private void jTextFieldDepth2FocusGained(FocusEvent evt) {
        this.jTextFieldDepth2.setSelectionStart(0);
        this.jTextFieldDepth2.setSelectionEnd(this.jTextFieldDepth2.getText().length());
    }

    private void jTextFieldDepth2KeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldDepth2, (int)this.DEPTHLEN, (KeyEvent)evt, (boolean)true)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldDepth1FocusGained(FocusEvent evt) {
        this.jTextFieldDepth1.setSelectionStart(0);
        this.jTextFieldDepth1.setSelectionEnd(this.jTextFieldDepth1.getText().length());
    }

    private void jTextFieldDepth1KeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldDepth1, (int)this.DEPTHLEN, (KeyEvent)evt, (boolean)true)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldAbundanceKeyTyped(KeyEvent evt) {
        if (SB.intFieldVal((JTextField)this.jTextFieldAbundance, (int)5, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogtaxonwellocc.html");
    }

    private void jListWellMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonShowWellActionPerformed(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonShowWellActionPerformed(ActionEvent evt) {
        if (this.jListWell.getSelectedIndex() < 0) {
            JOptionPane.showMessageDialog(this, "Select a well", this.getTitle(), 2);
            return;
        }
        this.well = (Well)this.jListWell.getSelectedValue();
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.well.loadAnalyses();
            List list = this.well.getAnalyses('\u0000', null, 0);
            this.model.occs = new LinkedList<TaxonWellOccItem>();
            if (this.jTextFieldSQL.getText().length() > 0 && !this.addWarn) {
                JOptionPane.showMessageDialog(this, "Note: additional SQL parameters are not used in occurrence display", this.getTitle(), 2);
                this.addWarn = true;
            }
            int abund = -1;
            if (this.jTextFieldAbundance.getText().length() > 0) {
                abund = Integer.parseInt(this.jTextFieldAbundance.getText());
            }
            Double upper = this.getDepth(this.jTextFieldDepth1);
            Double lower = this.getDepth(this.jTextFieldDepth2);
            for (Smpdtl smpdtl : list) {
                for (TaxonOcc occ : smpdtl.getOccur()) {
                    if (occ.getTaxon() != this.taxon) continue;
                    boolean include = true;
                    if (abund > 0 && occ.getTotalCount() < abund) {
                        include = false;
                    }
                    if (upper != null && smpdtl.getSample().getDepth() < upper) {
                        include = false;
                    }
                    if (lower != null && smpdtl.getSample().getDepth() > lower) {
                        include = false;
                    }
                    if (!include) continue;
                    TaxonWellOccItem item = new TaxonWellOccItem();
                    item.occ = occ;
                    item.smpdtl = smpdtl;
                    item.sample = smpdtl.getSample();
                    item.sample.displayUnits = this.well.getWellUnits();
                    if (!this.well.hasInterpLoaded(0)) {
                        this.well.loadInterps();
                        this.well.loadInterp(this.well.getInterp(0));
                    }
                    item.wellInterp = this.well.getInterp(0);
                    this.model.occs.add(item);
                }
            }
            this.sorter.reallocateIndexes();
            this.sorter.fireTableDataChanged();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, ex.getMessage() + "\nSQL: " + SB.sql, this.getTitle(), 0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, ex.getMessage(), this.getTitle(), 0);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private Double getDepth(JTextField field) {
        Double depth = null;
        if (field.getText().length() > 0) {
            depth = new Double(field.getText());
        }
        if (this.jComboBoxUnits.getSelectedItem().equals("ft") && depth != null) {
            depth = new Double(SB.convToM((double)depth, (char)'F'));
        }
        return depth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonSearchActionPerformed(ActionEvent evt) {
        try {
            String addSql;
            Double lower;
            Double upper;
            List selection;
            this.modelWells.clear();
            this.setCursor(Cursor.getPredefinedCursor(3));
            Project project = (Project)this.jComboBoxProject.getSelectedItem();
            int abund = -1;
            if (this.jTextFieldAbundance.getText().length() > 0) {
                abund = Integer.parseInt(this.jTextFieldAbundance.getText());
            }
            if ((selection = this.taxon.search(this.db, project, upper = this.getDepth(this.jTextFieldDepth1), lower = this.getDepth(this.jTextFieldDepth2), abund, addSql = this.jTextFieldSQL.getText())) == null || selection.isEmpty()) {
                JOptionPane.showMessageDialog(this, "No occurrences found", this.getTitle(), 2);
                return;
            }
            LinkedList<Well> sortWells = new LinkedList<Well>();
            for (Integer i : selection) {
                Well w = this.db.getAddWell(i.intValue());
                sortWells.add(w);
            }
            Collections.sort(sortWells);
            for (Well w : sortWells) {
                this.modelWells.addElement(w);
            }
            this.jListWell.repaint();
        }
        catch (SQLException ex) {
            FrameJsbugs.showStackError("SQL Error", ex, this.db);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jButtonShowSampleActionPerformed(ActionEvent evt) {
        if (this.jTableWellOcc.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one occurrence.", this.getTitle(), 2);
            return;
        }
        this.selectedItem = this.model.occs.get(this.sorter.getIndexOf(this.jTableWellOcc.getSelectedRow()));
        this.dispose();
    }

    private void jTableWellOccMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonShowSampleActionPerformed(null);
        }
    }
}

