/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.TableModel;
import jsbugs.FrameJsbugs;
import jsbugs.Occurrence;
import jsbugs.TableModelTaxonOccurrence;
import model2.Smpdtl;
import model2.TaxonOcc;
import model2.Well;
import util.SBException;
import util.TableSorter;

public class DialogTaxonWellOccFiltered
extends JDialog {
    TableModelTaxonOccurrence model = new TableModelTaxonOccurrence();
    TableSorter sorter = new TableSorter((TableModel)this.model);
    Well well;
    static final int FILTER_MKR = 0;
    static final int FILTER_COMM = 1;
    static final int FILTER_IMG = 2;
    private ButtonGroup buttonGroup1;
    private JButton jButtonClose;
    private JButton jButtonHelp;
    private JPanel jPanel1;
    private JRadioButton jRadioButtonComms;
    private JRadioButton jRadioButtonImgs;
    private JRadioButton jRadioButtonMkrs;
    private JScrollPane jScrollPane1;
    private JTable jTableOccs;

    public DialogTaxonWellOccFiltered(Frame parent, boolean modal, Well well, char units) {
        super(parent, modal);
        this.well = well;
        this.initComponents();
        this.init(units);
    }

    private void init(char units) {
        this.setTitle("Filtered Taxon Occurrences : " + this.well.getWellName());
        this.getRootPane().setDefaultButton(this.jButtonClose);
        this.model.setupTable(this.jTableOccs);
        this.model.setUnits(units);
        this.sorter.addMouseListenerToHeaderInTable(this.jTableOccs);
        this.filterButton();
        this.model.fireTableDataChanged();
    }

    private void filterButton() {
        int i = this.jRadioButtonComms.isSelected() ? 1 : (this.jRadioButtonImgs.isSelected() ? 2 : 0);
        this.filter(i);
    }

    private void filter(int filter) {
        LinkedList<Occurrence> occs = new LinkedList<Occurrence>();
        try {
            List allSmpdtls = this.well.getAnalyses('\u0000', null, 0);
            switch (filter) {
                case 0: {
                    for (Smpdtl smpdtl : allSmpdtls) {
                        for (TaxonOcc occ : smpdtl.getOccurUnsorted()) {
                            if (!occ.isMarker()) continue;
                            occs.add(new Occurrence(smpdtl, occ));
                        }
                    }
                    break;
                }
                case 1: {
                    for (Smpdtl smpdtl : allSmpdtls) {
                        for (TaxonOcc occ : smpdtl.getOccurUnsorted()) {
                            if (occ.getComment().isEmpty()) continue;
                            occs.add(new Occurrence(smpdtl, occ));
                        }
                    }
                    break;
                }
                case 2: {
                    for (Smpdtl smpdtl : allSmpdtls) {
                        for (TaxonOcc occ : smpdtl.getOccurUnsorted()) {
                            if (occ.getImageSet().getSize() <= 0) continue;
                            occs.add(new Occurrence(smpdtl, occ));
                        }
                    }
                    break;
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (SBException sbe) {
            sbe.printStackTrace();
        }
        this.model.setList(occs);
        this.model.fireTableDataChanged();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jScrollPane1 = new JScrollPane();
        this.jTableOccs = new JTable();
        this.jButtonClose = new JButton();
        this.jButtonHelp = new JButton();
        this.jPanel1 = new JPanel();
        this.jRadioButtonMkrs = new JRadioButton();
        this.jRadioButtonImgs = new JRadioButton();
        this.jRadioButtonComms = new JRadioButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(400, 300));
        this.jTableOccs.setModel((TableModel)this.sorter);
        this.jScrollPane1.setViewportView(this.jTableOccs);
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxonWellOccFiltered.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxonWellOccFiltered.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Show all:", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.buttonGroup1.add(this.jRadioButtonMkrs);
        this.jRadioButtonMkrs.setSelected(true);
        this.jRadioButtonMkrs.setText("Markers");
        this.jRadioButtonMkrs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxonWellOccFiltered.this.jRadioButtonMkrsActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButtonImgs);
        this.jRadioButtonImgs.setText("Images");
        this.jRadioButtonImgs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxonWellOccFiltered.this.jRadioButtonImgsActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButtonComms);
        this.jRadioButtonComms.setText("Comments");
        this.jRadioButtonComms.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogTaxonWellOccFiltered.this.jRadioButtonCommsActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonMkrs).addComponent(this.jRadioButtonComms).addComponent(this.jRadioButtonImgs)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jRadioButtonMkrs).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonComms).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonImgs).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 629, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonHelp, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonClose, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 234, Short.MAX_VALUE).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonClose))).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jRadioButtonMkrsActionPerformed(ActionEvent evt) {
        this.filterButton();
    }

    private void jRadioButtonCommsActionPerformed(ActionEvent evt) {
        this.filterButton();
    }

    private void jRadioButtonImgsActionPerformed(ActionEvent evt) {
        this.filterButton();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogtaxonwelloccfiltered.html");
    }
}

