/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import jsbugs.FrameJsbugs;
import jsbugs.SBDialog;
import model2.IGDIntervalZone;
import model2.IGDScheme;
import model2.IGDUnit;
import model2.SBdb;
import org.jdesktop.layout.GroupLayout;
import util.InvalidFieldException;
import util.SB;
import util.SBException;

public class DialogUnit
extends SBDialog {
    private final IGDScheme scheme;
    private static final int AGELEN = 8;
    private static final int NAMELEN = 80;
    private static final int ABBLEN = 80;
    private final DefaultComboBoxModel modelHier = new DefaultComboBoxModel();
    IGDUnit unit;
    private JButton jButtonCancel;
    private JButton jButtonChooseColour;
    private JButton jButtonOK;
    private JComboBox jComboBoxUnitType;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JSeparator jSeparator1;
    private JTextField jTextFieldAbbreviation;
    private JTextField jTextFieldColour;
    private JTextField jTextFieldOldest;
    private JTextField jTextFieldUnitName;
    private JTextField jTextFieldYoungest;

    public DialogUnit(JDialog parent, boolean modal, IGDScheme scheme, IGDUnit unit) {
        super((Dialog)parent, modal);
        this.unit = unit;
        this.scheme = scheme;
        this.initComponents();
        this.init();
    }

    public DialogUnit(JFrame parent, boolean modal, IGDScheme scheme, IGDUnit unit) {
        super((Frame)parent, modal);
        this.unit = unit;
        this.scheme = scheme;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setHierCombo();
        if (this.unit == null) {
            this.setTitle("Unit : Add");
        } else {
            this.setTitle("Unit : Edit");
            this.jComboBoxUnitType.setSelectedIndex(this.unit.getHier() - 1);
            this.jTextFieldUnitName.setText(this.unit.getName());
            this.jTextFieldAbbreviation.setText(this.unit.getAbr());
            this.jTextFieldYoungest.setText("" + this.unit.getUage());
            this.jTextFieldOldest.setText("" + this.unit.getLage());
            this.jTextFieldColour.setBackground(this.unit.getColour());
        }
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void setHierCombo() {
        int nHier = IGDIntervalZone.getNHier((int)this.scheme.getIGDType(), (boolean)true);
        for (int hier = 1; hier <= nHier; ++hier) {
            this.modelHier.addElement(IGDIntervalZone.getHierName((int)this.scheme.getIGDType(), (int)hier, (boolean)true));
        }
    }

    private void initComponents() {
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jLabel1 = new JLabel();
        this.jComboBoxUnitType = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jTextFieldUnitName = new JTextField();
        this.jLabel3 = new JLabel();
        this.jTextFieldAbbreviation = new JTextField();
        this.jLabel4 = new JLabel();
        this.jTextFieldYoungest = new JTextField();
        this.jLabel5 = new JLabel();
        this.jTextFieldOldest = new JTextField();
        this.jLabel6 = new JLabel();
        this.jTextFieldColour = new JTextField();
        this.jButtonChooseColour = new JButton();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogUnit.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogUnit.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Unit type:");
        this.jComboBoxUnitType.setModel(this.modelHier);
        this.jLabel2.setText("Unit name:");
        this.jTextFieldUnitName.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                DialogUnit.this.jTextFieldUnitNameFocusGained(evt);
            }
        });
        this.jTextFieldUnitName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogUnit.this.jTextFieldUnitNameKeyTyped(evt);
            }
        });
        this.jLabel3.setText("Abbreviation:");
        this.jTextFieldAbbreviation.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                DialogUnit.this.jTextFieldAbbreviationFocusGained(evt);
            }
        });
        this.jTextFieldAbbreviation.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogUnit.this.jTextFieldAbbreviationKeyTyped(evt);
            }
        });
        this.jLabel4.setText("Youngest:");
        this.jTextFieldYoungest.setText("0.00");
        this.jTextFieldYoungest.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                DialogUnit.this.jTextFieldYoungestFocusGained(evt);
            }
        });
        this.jTextFieldYoungest.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogUnit.this.jTextFieldYoungestKeyTyped(evt);
            }
        });
        this.jLabel5.setText("Oldest:");
        this.jTextFieldOldest.setText("0.00");
        this.jTextFieldOldest.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                DialogUnit.this.jTextFieldOldestFocusGained(evt);
            }
        });
        this.jTextFieldOldest.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogUnit.this.jTextFieldOldestKeyTyped(evt);
            }
        });
        this.jLabel6.setText("Colour:");
        this.jTextFieldColour.setEditable(false);
        this.jButtonChooseColour.setText("...");
        this.jButtonChooseColour.setToolTipText("Select colour");
        this.jButtonChooseColour.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogUnit.this.jButtonChooseColourActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(142, 142, 142).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonCancel)).add(2, (Component)this.jSeparator1, -1, 278, Short.MAX_VALUE)).addContainerGap()).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabel1).add((Component)this.jLabel4).add((Component)this.jLabel3).add((Component)this.jLabel5).add((Component)this.jLabel6).add((Component)this.jLabel2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jTextFieldUnitName, -1, 209, Short.MAX_VALUE).add((Component)this.jComboBoxUnitType, 0, 209, Short.MAX_VALUE).add((Component)this.jTextFieldAbbreviation, -1, 209, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jTextFieldColour, -2, 78, -2).addPreferredGap(0).add((Component)this.jButtonChooseColour, -2, 32, -2)).add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (Component)this.jTextFieldOldest).add(1, (Component)this.jTextFieldYoungest, -1, 127, Short.MAX_VALUE))).addContainerGap()))));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jComboBoxUnitType, -2, -1, -2).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jTextFieldUnitName, -2, -1, -2).add((Component)this.jLabel2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.jTextFieldAbbreviation, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.jTextFieldYoungest, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel5).add((Component)this.jTextFieldOldest, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel6).add((Component)this.jTextFieldColour, -2, -1, -2).add((Component)this.jButtonChooseColour)).addPreferredGap(0).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jButtonChooseColourActionPerformed(ActionEvent evt) {
        Color colour = JColorChooser.showDialog(this, "Unit Colour : Select", this.jTextFieldColour.getBackground());
        if (colour != null) {
            this.jTextFieldColour.setBackground(colour);
        }
    }

    private void jTextFieldAbbreviationFocusGained(FocusEvent evt) {
        this.jTextFieldAbbreviation.setSelectionStart(0);
        this.jTextFieldAbbreviation.setSelectionEnd(this.jTextFieldAbbreviation.getText().length());
    }

    private void jTextFieldAbbreviationKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldAbbreviation, (int)80, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldUnitNameKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldUnitName, (int)80, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldUnitNameFocusGained(FocusEvent evt) {
        this.jTextFieldUnitName.setSelectionStart(0);
        this.jTextFieldUnitName.setSelectionEnd(this.jTextFieldUnitName.getText().length());
    }

    private void jTextFieldOldestKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldOldest, (int)8, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldOldestFocusGained(FocusEvent evt) {
        this.jTextFieldOldest.setSelectionStart(0);
        this.jTextFieldOldest.setSelectionEnd(this.jTextFieldOldest.getText().length());
    }

    private void jTextFieldYoungestFocusGained(FocusEvent evt) {
        this.jTextFieldYoungest.setSelectionStart(0);
        this.jTextFieldYoungest.setSelectionEnd(this.jTextFieldYoungest.getText().length());
    }

    private void jTextFieldYoungestKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldYoungest, (int)8, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        try {
            IGDUnit.Builder builder = this.unit == null ? new IGDUnit.Builder(this.scheme.getDatabase()) : IGDUnit.Builder.copyOf((IGDUnit)this.unit, (SBdb)this.scheme.getDatabase());
            String name = this.jTextFieldUnitName.getText();
            if (name.isEmpty()) {
                JOptionPane.showMessageDialog(this, "Enter a unit name", "Warning", 2);
                return;
            }
            builder.name(name);
            builder.abr(this.jTextFieldAbbreviation.getText());
            double uAge = Double.parseDouble(this.jTextFieldYoungest.getText());
            double lAge = Double.parseDouble(this.jTextFieldOldest.getText());
            if (lAge < uAge) {
                JOptionPane.showMessageDialog(this, "Oldest age is less than youngest age", "Warning", 2);
                return;
            }
            builder.age(uAge, lAge);
            builder.hier(this.jComboBoxUnitType.getSelectedIndex() + 1);
            builder.colour(this.jTextFieldColour.getBackground());
            this.unit = this.unit == null ? this.scheme.addUnit(builder) : this.scheme.updateUnit(builder);
            this.scheme.getDatabase().commit();
            this.scheme.notifyObservers();
            this.setOK();
        }
        catch (InvalidFieldException e) {
            JOptionPane.showMessageDialog(this, "Cannot update unit:\n" + e.getMessage(), this.getTitle(), 2);
        }
        catch (SQLException ex) {
            this.scheme.getDatabase().doRollback();
            FrameJsbugs.showStackError("SQL Error", ex, this.scheme.getDatabase());
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }
}

