/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.filechooser.FileFilter;
import jsbugs.TableModelUnitUsage;
import jsbugs.UnitUse;
import model2.IGDUnit;
import model2.Lastval;
import model2.Project;
import model2.SBdb;
import model2.Sample;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;
import util.SbugsFileFilter;

public class DialogUnitUsage
extends JDialog {
    private IGDUnit unit;
    private DefaultComboBoxModel projectModel = new DefaultComboBoxModel();
    private TableModelUnitUsage model = new TableModelUnitUsage();
    private SBdb sbdb;
    private static String ALL_PROJECTS = "<All Projects>";
    private LinkedList<UnitUse> usageMaster;
    private ButtonGroup buttonGroup1;
    private JButton jButtonCancel;
    private JButton jButtonSaveAs;
    private JComboBox jComboBoxProject;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JRadioButton jRadioButtonF;
    private JRadioButton jRadioButtonM;
    private JScrollPane jScrollPane1;
    private JTable jTableUsage;

    public DialogUnitUsage(JDialog parent, boolean modal, IGDUnit unit, SBdb sbdb) {
        super((Dialog)parent, modal);
        this.unit = unit;
        this.sbdb = sbdb;
        this.initComponents();
        this.init();
    }

    public DialogUnitUsage(Frame parent, boolean modal, IGDUnit unit, SBdb sbdb) {
        super(parent, modal);
        this.unit = unit;
        this.sbdb = sbdb;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setTitle(this.unit.toString());
        this.fillProjectCombo();
        this.model.setUpTable(this.jTableUsage);
        this.usageMaster = this.queryUsage();
        this.model.usages = this.usageMaster;
        this.setModelUnits();
    }

    private LinkedList<UnitUse> queryUsage() {
        String sql = "SELECT DISTINCT v.well_id,w.well_name,v.well_code,ip.descrip, i.top_id,i.base_id FROM " + this.sbdb.DBTableName("IGD") + " i," + this.sbdb.DBTableName("WELL_IDENT") + " v," + this.sbdb.DBTableName("INTERP") + " ip," + this.sbdb.DBTableName("WELLS") + " w" + " WHERE (i.upp_zone=" + this.unit.getUnitID() + " OR i.low_zone=" + this.unit.getUnitID() + ")" + " AND i.well_id=v.well_id AND v.well_code=w.well_code AND ip.interp_id=i.interp_id ORDER BY well_name, ip.descrip";
        LinkedList<UnitUse> usages = new LinkedList<UnitUse>();
        try {
            Statement stmt = this.sbdb.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                UnitUse use = new UnitUse();
                use.wellID = rs.getInt("well_id");
                use.wellName = rs.getString("well_name");
                use.wellCode = rs.getString("well_code");
                use.version = rs.getString("descrip");
                use.topSample = new Sample(this.sbdb, use.wellID, rs.getInt("top_id"), 'W');
                use.baseSample = new Sample(this.sbdb, use.wellID, rs.getInt("base_id"), 'W');
                usages.add(use);
            }
        }
        catch (SQLException sqle) {
            SB.showStackError((String)"Error getting unit usage", (SQLException)sqle);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error getting unit usage", (Exception)((Object)sbe));
        }
        return usages;
    }

    private void fillProjectCombo() {
        this.projectModel.removeAllElements();
        this.projectModel.addElement(ALL_PROJECTS);
        try {
            this.sbdb.getProjects().loadCombo(this.projectModel, false);
        }
        catch (Exception e) {
            SB.showStackError((String)"Error loading projects", (Exception)e);
        }
        this.projectModel.setSelectedItem(ALL_PROJECTS);
    }

    private void setModelUnits() {
        this.model.units = (char)(this.jRadioButtonM.isSelected() ? 77 : 70);
        this.model.fireTableDataChanged();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jScrollPane1 = new JScrollPane();
        this.jTableUsage = new JTable();
        this.jButtonCancel = new JButton();
        this.jButtonSaveAs = new JButton();
        this.jLabel2 = new JLabel();
        this.jComboBoxProject = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jRadioButtonM = new JRadioButton();
        this.jRadioButtonF = new JRadioButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(350, 350));
        this.setModal(true);
        this.jTableUsage.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTableUsage);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogUnitUsage.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonSaveAs.setText("Save as...");
        this.jButtonSaveAs.setToolTipText("Save the current list as a text file");
        this.jButtonSaveAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogUnitUsage.this.jButtonSaveAsActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Project:");
        this.jComboBoxProject.setModel(this.projectModel);
        this.jComboBoxProject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogUnitUsage.this.jComboBoxProjectActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Units:");
        this.buttonGroup1.add(this.jRadioButtonM);
        this.jRadioButtonM.setSelected(true);
        this.jRadioButtonM.setText("metres");
        this.jRadioButtonM.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogUnitUsage.this.jRadioButtonMActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButtonF);
        this.jRadioButtonF.setText("Feet");
        this.jRadioButtonF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogUnitUsage.this.jRadioButtonFActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabel1).add((Component)this.jLabel2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jRadioButtonM).addPreferredGap(0).add((Component)this.jRadioButtonF).add(0, 192, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jComboBoxProject, 0, -1, Short.MAX_VALUE).addContainerGap()))).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((Component)this.jButtonSaveAs).addPreferredGap(0).add((Component)this.jButtonCancel)).add(2, (Component)this.jScrollPane1, -2, 0, Short.MAX_VALUE)).addContainerGap()))));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonSaveAs}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jComboBoxProject, -2, -1, -2).add((Component)this.jLabel2)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jRadioButtonM).add((Component)this.jRadioButtonF)).add(19, 19, 19).add((Component)this.jScrollPane1, -1, 225, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonSaveAs)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jRadioButtonMActionPerformed(ActionEvent evt) {
        this.setModelUnits();
    }

    private void jRadioButtonFActionPerformed(ActionEvent evt) {
        this.setModelUnits();
    }

    private void jComboBoxProjectActionPerformed(ActionEvent evt) {
        this.filterList();
    }

    private void jButtonSaveAsActionPerformed(ActionEvent evt) {
        File setDir = null;
        try {
            setDir = new File(Lastval.getString((SBdb)this.sbdb, (String)"JLISTFILE"));
        }
        catch (SQLException ex) {
            // empty catch block
        }
        JFileChooser jFileChooser1 = new JFileChooser();
        jFileChooser1.setCurrentDirectory(setDir);
        SbugsFileFilter filter = new SbugsFileFilter();
        filter.addExtension("txt");
        filter.setDescription("Text files");
        jFileChooser1.addChoosableFileFilter((FileFilter)filter);
        SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yyyy");
        Date date = new Date();
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (0 == jFileChooser1.showSaveDialog(this)) {
            try {
                String fileName = jFileChooser1.getSelectedFile().getPath();
                if (!fileName.toLowerCase().endsWith(".txt")) {
                    fileName = fileName + ".txt";
                }
                FileWriter out = new FileWriter(fileName);
                String eol = "\r\n";
                out.write("StrataBugs output: " + df.format(date) + eol);
                out.write(this.getTitle() + eol + eol);
                for (int i = 0; i < this.model.getRowCount(); ++i) {
                    for (int j = 0; j < this.model.getColumnCount(); ++j) {
                        String text = this.model.getValueAt(i, j).toString();
                        out.write(text + '\t');
                    }
                    out.write(eol);
                }
                out.close();
                if (JOptionPane.showConfirmDialog(this, "File '" + fileName + "' written", "File Saved", 2) == 0) {
                    Lastval.putString((SBdb)this.sbdb, (String)"JLISTFILE", (String)fileName);
                    this.sbdb.commit();
                }
            }
            catch (SQLException se) {
                JOptionPane.showMessageDialog(null, "Error: " + se.getMessage() + "\nSQL: " + SB.sql, "SQL Error", 0);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "File error: " + ex.getMessage());
            }
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void filterList() {
        if (this.jComboBoxProject.getSelectedItem() instanceof Project) {
            Project project = (Project)this.jComboBoxProject.getSelectedItem();
            try {
                project.loadWells(this.sbdb, null);
            }
            catch (Exception e) {
                SB.showStackError((String)"Error loading projects", (Exception)e);
            }
            LinkedList<UnitUse> filtered = new LinkedList<UnitUse>();
            for (UnitUse use : this.usageMaster) {
                if (!project.contains(use.wellID)) continue;
                filtered.add(use);
            }
            this.model.usages = filtered;
        } else {
            this.model.usages = this.usageMaster;
        }
        this.model.fireTableDataChanged();
    }
}

