/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableModel;
import jsbugs.DialogList;
import jsbugs.FrameJsbugs;
import jsbugs.UnlinkedTableModel;
import model2.IGDScheme;
import model2.IGDUnit;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;
import util.TableSorter;

public class DialogUnlinked
extends JDialog {
    UnlinkedTableModel model = new UnlinkedTableModel();
    TableSorter sorter = new TableSorter((TableModel)this.model);
    LinkedList<IGDScheme.UnlinkedInterval> selection = null;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonLink;
    private JButton jButtonOK;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JTable jTableUnlinked;
    private JTextField jTextFieldScheme;

    public DialogUnlinked(JDialog parent, boolean modal, IGDScheme scheme, List<IGDScheme.UnlinkedInterval> list) {
        super((Dialog)parent, modal);
        this.initComponents();
        this.model.data = list;
        this.model.scheme = scheme;
        this.init();
    }

    private void init() {
        this.setTitle("Unlinked Scheme Intervals");
        this.model.setUpTable(this.jTableUnlinked);
        this.jTextFieldScheme.setText(this.model.scheme.toString());
        this.sorter.addMouseListenerToHeaderInTable(this.jTableUnlinked);
        this.sorter.reallocateIndexes();
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldScheme = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.jTableUnlinked = new JTable();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jLabel2 = new JLabel();
        this.jButtonHelp = new JButton();
        this.jButtonLink = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(400, 250));
        this.jLabel1.setText("Unlinked units in scheme: ");
        this.jTextFieldScheme.setBackground(new Color(255, 255, 204));
        this.jTextFieldScheme.setEditable(false);
        this.jTextFieldScheme.setText("jTextField1");
        this.jTableUnlinked.setModel((TableModel)this.sorter);
        this.jTableUnlinked.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DialogUnlinked.this.jTableUnlinkedMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableUnlinked);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogUnlinked.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogUnlinked.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jLabel2.setFont(new Font("Tahoma", 1, 11));
        this.jLabel2.setText("Select the units below you want to add to the scheme:");
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogUnlinked.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonLink.setText("Link...");
        this.jButtonLink.setToolTipText("Link ALL instances of selected informal unit to scheme unit, either keeping or switching the informal term");
        this.jButtonLink.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogUnlinked.this.jButtonLinkActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.jLabel2, -1, 482, Short.MAX_VALUE).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jTextFieldScheme, -1, 355, Short.MAX_VALUE)).add(1, (Component)this.jScrollPane1, -1, 482, Short.MAX_VALUE)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jButtonOK, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonHelp, 0, 0, Short.MAX_VALUE).add((Component)this.jButtonCancel, -1, -1, Short.MAX_VALUE)).add((Component)this.jButtonLink)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jTextFieldScheme, -2, -1, -2)).add(12, 12, 12).add((Component)this.jLabel2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonLink).addPreferredGap(0, 95, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).add(9, 9, 9).add((Component)this.jButtonCancel)).add((Component)this.jScrollPane1, -1, 202, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        int[] rows;
        if (this.jTableUnlinked.getSelectedRowCount() <= 0) {
            JOptionPane.showMessageDialog(this, "Select one or more rows to add to scheme, or Cancel to close without selecting.", this.getTitle(), 1);
            return;
        }
        this.selection = new LinkedList();
        for (int row : rows = this.jTableUnlinked.getSelectedRows()) {
            this.selection.add(this.model.data.get(this.sorter.getIndexOf(row)));
        }
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogigdscheme.html#dialogunlinked");
    }

    private void jButtonLinkActionPerformed(ActionEvent evt) {
        if (this.jTableUnlinked.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one term only", this.getTitle(), 2);
            return;
        }
        IGDScheme.UnlinkedInterval interval = this.model.data.get(this.sorter.getIndexOf(this.jTableUnlinked.getSelectedRow()));
        DialogList dialog = new DialogList(this, true, "Select Unit", this.model.scheme.getDatabase(), this.model.scheme.getUnitsX(), true, false);
        dialog.setLocationRelativeTo(this);
        if (interval.linked) {
            LinkedList<IGDUnit> list = new LinkedList<IGDUnit>();
            try {
                list.add(this.model.scheme.findUnit(interval.name));
                dialog.setSelectedItems(list);
            }
            catch (SQLException sql) {
                sql.printStackTrace();
            }
        }
        dialog.setVisible(true);
        if (dialog.selection != null) {
            IGDUnit unit = (IGDUnit)dialog.selection;
            boolean updateInformal = false;
            if (!unit.getName().equals(interval.name)) {
                String msg = "Do you want to update informal names of '" + interval.name + "' to '" + unit.getName() + "' as well as link to the unit?";
                int opt = JOptionPane.showConfirmDialog(this, msg, this.getTitle(), 0, 3);
                if (opt == 2 || opt == -1) {
                    return;
                }
                if (opt == 0) {
                    updateInformal = true;
                }
            }
            try {
                this.model.scheme.linkInformal(interval, unit, updateInformal);
                this.model.data.remove(interval);
                this.sorter.reallocateIndexes();
                this.jTableUnlinked.clearSelection();
                this.sorter.fireTableDataChanged();
                this.model.scheme.getDatabase().commit();
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error", sql, this.model.scheme.getDatabase());
            }
            catch (SBException sbe) {
                SB.showStackError((String)"Error", (Exception)((Object)sbe));
            }
            catch (RuntimeException re) {
                SB.showStackError((String)"", (Exception)re);
            }
        }
    }

    private void jTableUnlinkedMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonLinkActionPerformed(null);
        }
    }
}

