/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import jsbugs.FrameJsbugs;
import jsbugs.SBDialog;
import model2.Discipline;
import model2.SBdb;
import model2.Userdef;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;

public class DialogUserdef
extends SBDialog {
    private static final int USRNAMLEN = 40;
    static final int USRIDLEN = 5;
    private static final int LOGLEN = 35;
    private static final int PASSLEN = 9;
    private static final String userText = "<html>Full use of the system <br>but cannot add, edit or <br>delete other user identities.</html>";
    private static final String superUserText = "<html>Full use of the system <br>and can add, edit or delete other user identities.</html>";
    private static final String nonUserText = "<html>Known analyst but not <br>user of this system (use <br>for imported data)</html>";
    private final DefaultComboBoxModel modelDiscipline = new DefaultComboBoxModel<Discipline>(Discipline.values());
    Userdef user;
    private int priv = 0;
    private final SBdb db;
    private ButtonGroup buttonGroupPriv;
    private JButton jButtonCancel;
    private JButton jButtonColour;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JCheckBox jCheckBoxDiscOnly;
    private JCheckBox jCheckBoxExport;
    private JComboBox jComboBoxDiscipline;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabelPriv;
    private JPanel jPanel1;
    private JPanel jPanelName;
    private JPanel jPanelUserDetails;
    private JPasswordField jPasswordField;
    private JRadioButton jRadioButtonNonUser;
    private JRadioButton jRadioButtonSuperUser;
    private JRadioButton jRadioButtonUser;
    private JTextField jTextFieldChartColour;
    private JTextField jTextFieldID;
    private JTextField jTextFieldName;
    private JTextField jTextFieldSysName;

    public DialogUserdef(JDialog parent, boolean modal, SBdb sbdb, Userdef user) {
        super((Dialog)parent, modal);
        this.user = user;
        this.db = sbdb;
        this.setLocation(parent.getLocation().x + 25, parent.getLocation().y + 25);
        this.initComponents();
        this.init();
    }

    public DialogUserdef(JDialog parent, boolean modal, SBdb sbdb, String abr, String userName, Discipline discID) {
        super((Dialog)parent, modal);
        this.db = sbdb;
        this.setLocation(parent.getLocation().x + 25, parent.getLocation().y + 25);
        this.initComponents();
        this.jTextFieldID.setText(abr);
        this.init();
        if (userName == null || userName.isEmpty()) {
            userName = abr;
        }
        this.jTextFieldName.setText(userName);
        this.jTextFieldSysName.setText("");
        if (discID != null) {
            this.jComboBoxDiscipline.setSelectedItem(discID);
        }
    }

    private void init() {
        if (this.user == null) {
            this.setTitle("Person : Add");
            if ((this.db.getUser().getPriv() & 0x40) <= 0) {
                this.jRadioButtonSuperUser.setEnabled(false);
                this.jRadioButtonUser.setEnabled(false);
                this.jRadioButtonNonUser.setSelected(true);
                this.jRadioButtonNonUserActionPerformed(null);
            } else if (!this.jTextFieldID.getText().isEmpty()) {
                this.jRadioButtonNonUser.setSelected(true);
                this.jRadioButtonNonUserActionPerformed(null);
            } else {
                this.jRadioButtonUser.setSelected(true);
                this.jRadioButtonUserActionPerformed(null);
            }
        } else {
            boolean self = this.user.getUsrID() == this.db.getUserID();
            boolean superuser = (this.db.getUser().getPriv() & 0x40) > 0;
            this.setTitle("Person : Edit");
            this.jTextFieldName.setText(this.user.getName());
            this.jTextFieldSysName.setText(this.user.getSysName());
            this.jTextFieldID.setText(this.user.getAbr());
            this.jTextFieldChartColour.setBackground(this.user.getColour());
            this.jPasswordField.setText(this.user.getPwd());
            this.jComboBoxDiscipline.setSelectedItem(this.user.getDiscipline());
            if ((this.user.getPriv() & 0x40) > 0) {
                this.jRadioButtonSuperUser.setSelected(true);
                this.jRadioButtonSuperUserActionPerformed(null);
                if (self) {
                    this.jRadioButtonUser.setEnabled(false);
                    this.jRadioButtonNonUser.setEnabled(false);
                }
            } else if ((this.user.getPriv() & 2) > 0) {
                if (!superuser && self) {
                    this.jRadioButtonSuperUser.setEnabled(false);
                    this.jRadioButtonNonUser.setEnabled(false);
                    if ((this.user.getPriv() & 4) > 0) {
                        this.jComboBoxDiscipline.setEnabled(false);
                    }
                }
                this.jRadioButtonUser.setSelected(true);
                this.jRadioButtonUserActionPerformed(null);
                if (!superuser) {
                    this.jCheckBoxDiscOnly.setEnabled(false);
                    this.jCheckBoxExport.setEnabled(false);
                }
            } else {
                if (!superuser) {
                    this.jRadioButtonUser.setEnabled(false);
                    this.jRadioButtonSuperUser.setEnabled(false);
                }
                this.jRadioButtonNonUser.setSelected(true);
                this.jRadioButtonNonUserActionPerformed(null);
            }
            this.setPriv();
        }
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void setPriv() {
        if ((this.user.getPriv() & 0x40) > 0) {
            this.jRadioButtonSuperUser.setSelected(true);
        } else if ((this.user.getPriv() & 2) > 0) {
            this.jRadioButtonUser.setSelected(true);
            if ((this.user.getPriv() & 4) > 0) {
                this.jCheckBoxDiscOnly.setSelected(true);
            }
            if ((this.user.getPriv() & 0x4000) > 0) {
                this.jCheckBoxExport.setSelected(false);
            }
        } else {
            this.jRadioButtonNonUser.setSelected(true);
        }
    }

    private int getPriv() {
        this.priv = 0;
        if (this.jRadioButtonSuperUser.isSelected()) {
            this.priv = 66;
        } else if (this.jRadioButtonUser.isSelected()) {
            this.priv = 2;
            if (this.jCheckBoxDiscOnly.isSelected()) {
                this.priv |= 4;
            }
            if (!this.jCheckBoxExport.isSelected()) {
                this.priv |= 0x4000;
            }
        }
        System.out.println("PRIVILEGES FOR USER: " + this.user);
        System.out.println("    Standard User : " + ((this.priv & 2) > 0));
        System.out.println("    Super User : " + ((this.priv & 0x40) > 0));
        System.out.println("    Discipline restricted : " + ((this.priv & 4) > 0));
        System.out.println("    Disallow export data : " + ((this.priv & 0x4000) > 0));
        return this.priv;
    }

    private void initComponents() {
        this.buttonGroupPriv = new ButtonGroup();
        this.jPanelName = new JPanel();
        this.jLabel1 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jTextFieldID = new JTextField();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jComboBoxDiscipline = new JComboBox();
        this.jPasswordField = new JPasswordField();
        this.jLabel5 = new JLabel();
        this.jButtonColour = new JButton();
        this.jLabel6 = new JLabel();
        this.jTextFieldChartColour = new JTextField();
        this.jCheckBoxDiscOnly = new JCheckBox();
        this.jCheckBoxExport = new JCheckBox();
        this.jPanelUserDetails = new JPanel();
        this.jLabel4 = new JLabel();
        this.jTextFieldSysName = new JTextField();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonOK = new JButton();
        this.jPanel1 = new JPanel();
        this.jRadioButtonUser = new JRadioButton();
        this.jRadioButtonSuperUser = new JRadioButton();
        this.jRadioButtonNonUser = new JRadioButton();
        this.jLabelPriv = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jPanelName.setBorder(BorderFactory.createTitledBorder(null, "Details", 0, 0, null, new Color(51, 102, 204)));
        this.jLabel1.setText("Full name:");
        this.jTextFieldName.setToolTipText("First name, initials and Family name");
        this.jTextFieldName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogUserdef.this.jTextFieldNameKeyTyped(evt);
            }
        });
        this.jTextFieldID.setToolTipText("User initials. Needs to be unique within StrataBugs");
        this.jTextFieldID.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogUserdef.this.jTextFieldIDKeyTyped(evt);
            }
        });
        this.jLabel2.setText("StrataBugs ID:");
        this.jLabel3.setText("Default discipline:");
        this.jComboBoxDiscipline.setModel(this.modelDiscipline);
        this.jPasswordField.setToolTipText("Only for non-Oracle databases");
        this.jPasswordField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogUserdef.this.jPasswordFieldKeyTyped(evt);
            }
        });
        this.jLabel5.setText("Password:");
        this.jButtonColour.setText("...");
        this.jButtonColour.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogUserdef.this.jButtonColourActionPerformed(evt);
            }
        });
        this.jLabel6.setText("Chart colour:");
        this.jTextFieldChartColour.setEditable(false);
        this.jTextFieldChartColour.setBackground(new Color(0, 0, 0));
        this.jTextFieldChartColour.setToolTipText("Colour displayed on multi-analyst sample charts");
        this.jCheckBoxDiscOnly.setText("Restricted to add/edit data within discipline only");
        this.jCheckBoxDiscOnly.setHorizontalTextPosition(10);
        this.jCheckBoxExport.setSelected(true);
        this.jCheckBoxExport.setText("Can export data");
        GroupLayout jPanelNameLayout = new GroupLayout((Container)this.jPanelName);
        this.jPanelName.setLayout((LayoutManager)jPanelNameLayout);
        jPanelNameLayout.setHorizontalGroup((GroupLayout.Group)jPanelNameLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelNameLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelNameLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelNameLayout.createSequentialGroup().add(13, 13, 13).add((GroupLayout.Group)jPanelNameLayout.createParallelGroup(2).add((Component)this.jLabel2).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)jPanelNameLayout.createParallelGroup(1).add(2, (Component)this.jTextFieldName).add((Component)this.jTextFieldID, -2, 62, -2))).add((GroupLayout.Group)jPanelNameLayout.createSequentialGroup().add((Component)this.jLabel3).addPreferredGap(0).add((Component)this.jComboBoxDiscipline, 0, -1, Short.MAX_VALUE)).add((Component)this.jCheckBoxDiscOnly, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)jPanelNameLayout.createSequentialGroup().add((GroupLayout.Group)jPanelNameLayout.createParallelGroup(1).add((Component)this.jCheckBoxExport).add((GroupLayout.Group)jPanelNameLayout.createSequentialGroup().add(34, 34, 34).add((Component)this.jLabel5).addPreferredGap(0).add((Component)this.jPasswordField, -2, 81, -2)).add((GroupLayout.Group)jPanelNameLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelNameLayout.createSequentialGroup().add((Component)this.jLabel6).add(71, 71, 71)).add(2, (GroupLayout.Group)jPanelNameLayout.createSequentialGroup().add((Component)this.jTextFieldChartColour, -2, 30, -2).addPreferredGap(0).add((Component)this.jButtonColour, -2, 31, -2)))).add(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanelNameLayout.setVerticalGroup((GroupLayout.Group)jPanelNameLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelNameLayout.createSequentialGroup().add((GroupLayout.Group)jPanelNameLayout.createParallelGroup(3).add((Component)this.jTextFieldName, -2, -1, -2).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)jPanelNameLayout.createParallelGroup(3).add((Component)this.jTextFieldID, -2, -1, -2).add((Component)this.jLabel2)).addPreferredGap(0).add((GroupLayout.Group)jPanelNameLayout.createParallelGroup(3).add((Component)this.jPasswordField, -2, -1, -2).add((Component)this.jLabel5)).addPreferredGap(0).add((GroupLayout.Group)jPanelNameLayout.createParallelGroup(3).add((Component)this.jComboBoxDiscipline, -2, -1, -2).add((Component)this.jLabel3)).addPreferredGap(1).add((Component)this.jCheckBoxDiscOnly).addPreferredGap(1).add((Component)this.jCheckBoxExport).addPreferredGap(0).add((GroupLayout.Group)jPanelNameLayout.createParallelGroup(3).add((Component)this.jButtonColour).add((Component)this.jLabel6).add((Component)this.jTextFieldChartColour, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanelUserDetails.setBorder(BorderFactory.createTitledBorder(null, "Database login", 0, 0, null, new Color(51, 102, 204)));
        this.jLabel4.setText("System name (optional):");
        this.jTextFieldSysName.setToolTipText("Leave blank if a separate user ID is not required for database login.");
        this.jTextFieldSysName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogUserdef.this.jTextFieldSysNameKeyTyped(evt);
            }
        });
        GroupLayout jPanelUserDetailsLayout = new GroupLayout((Container)this.jPanelUserDetails);
        this.jPanelUserDetails.setLayout((LayoutManager)jPanelUserDetailsLayout);
        jPanelUserDetailsLayout.setHorizontalGroup((GroupLayout.Group)jPanelUserDetailsLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelUserDetailsLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelUserDetailsLayout.createParallelGroup(1).add((Component)this.jLabel4, -1, 240, Short.MAX_VALUE).add(2, (Component)this.jTextFieldSysName, -1, 240, Short.MAX_VALUE)).addContainerGap()));
        jPanelUserDetailsLayout.setVerticalGroup((GroupLayout.Group)jPanelUserDetailsLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelUserDetailsLayout.createSequentialGroup().addContainerGap().add((Component)this.jLabel4).addPreferredGap(0).add((Component)this.jTextFieldSysName, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogUserdef.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogUserdef.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogUserdef.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Privileges", 0, 0, null, new Color(51, 102, 204)));
        this.buttonGroupPriv.add(this.jRadioButtonUser);
        this.jRadioButtonUser.setText("User");
        this.jRadioButtonUser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogUserdef.this.jRadioButtonUserActionPerformed(evt);
            }
        });
        this.buttonGroupPriv.add(this.jRadioButtonSuperUser);
        this.jRadioButtonSuperUser.setText("Super user");
        this.jRadioButtonSuperUser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogUserdef.this.jRadioButtonSuperUserActionPerformed(evt);
            }
        });
        this.buttonGroupPriv.add(this.jRadioButtonNonUser);
        this.jRadioButtonNonUser.setText("Non-user");
        this.jRadioButtonNonUser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogUserdef.this.jRadioButtonNonUserActionPerformed(evt);
            }
        });
        this.jLabelPriv.setForeground(new Color(51, 102, 204));
        this.jLabelPriv.setText("jLabel7");
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jRadioButtonUser).add((Component)this.jRadioButtonSuperUser).add((Component)this.jRadioButtonNonUser)).add(43, 43, 43).add((Component)this.jLabelPriv, -2, 124, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add(3, 3, 3).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jRadioButtonUser).addPreferredGap(0).add((Component)this.jRadioButtonSuperUser).addPreferredGap(0).add((Component)this.jRadioButtonNonUser)).add((Component)this.jLabelPriv, -2, 64, -2)).addContainerGap(9, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanelUserDetails, -2, -1, -2).add((GroupLayout.Group)layout.createSequentialGroup().add(65, 65, 65).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel)).add(2, (Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add(2, (GroupLayout.Group)layout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((Component)this.jPanelName, -2, -1, -2))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jPanelName, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanelUserDetails, -2, -1, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonHelp).add((Component)this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jButtonColourActionPerformed(ActionEvent evt) {
        Color colour = JColorChooser.showDialog(this, "Colour : Select", this.jTextFieldChartColour.getBackground());
        if (colour != null) {
            this.jTextFieldChartColour.setBackground(colour);
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        String usrID = this.jTextFieldID.getText();
        if (usrID.length() == 0) {
            JOptionPane.showMessageDialog(this, "Enter a user ID", this.getTitle(), 2);
            this.jTextFieldID.requestFocusInWindow();
            return;
        }
        String name = this.jTextFieldName.getText();
        if (name.length() == 0) {
            JOptionPane.showMessageDialog(this, "Enter full name", this.getTitle(), 2);
            this.jTextFieldName.requestFocusInWindow();
            return;
        }
        Discipline disc = (Discipline)this.jComboBoxDiscipline.getSelectedItem();
        if (disc == null) {
            JOptionPane.showMessageDialog(this, "Select a default discipline", this.getTitle(), 2);
            return;
        }
        this.priv = this.getPriv();
        Color colour = this.jTextFieldChartColour.getBackground();
        String sysName = this.jTextFieldSysName.getText();
        char[] pass = this.jPasswordField.getPassword();
        String pwd = "";
        for (int i = 0; i < pass.length; ++i) {
            pwd = pwd + pass[i];
        }
        pwd = pwd.toUpperCase();
        if (this.priv > 0 && sysName.length() == 0 && pwd.length() == 0) {
            JOptionPane.showMessageDialog(this, "Enter a password or system name", this.getTitle(), 2);
            this.jPasswordField.requestFocusInWindow();
            return;
        }
        try {
            if ((this.db.getUser().getPriv() & 0x40) == 0) {
                if (this.user != null && this.user.getUsrID() != this.db.getUserID() || this.user == null) {
                    if (this.priv > 0 || this.user != null && this.user.getPriv() > 0) {
                        JOptionPane.showMessageDialog(this, "You are not a super user: you can only add or edit details of non-users.", this.getTitle(), 0);
                        return;
                    }
                } else if (this.user != null && this.user.getUsrID() == this.db.getUserID() && (this.user.getPriv() & 4) > 0 && (this.priv & 4) == 0) {
                    JOptionPane.showMessageDialog(this, "You are not a super user: you cannot reset your discipline restriction.", this.getTitle(), 0);
                    this.jCheckBoxDiscOnly.setSelected(true);
                    return;
                }
                if (this.user != null && this.user.getUsrID() == this.db.getUserID() && (this.user.getPriv() & 0x4000) > 0 && (this.priv & 0x4000) == 0) {
                    JOptionPane.showMessageDialog(this, "You are not a super user: you cannot reset your export restriction.", this.getTitle(), 2);
                    return;
                }
            }
            if (this.user == null) {
                if (this.db.getUser(usrID) != null) {
                    JOptionPane.showMessageDialog(this, "A user or analyst with ID: " + usrID + " already exists.", this.getTitle(), 0);
                    return;
                }
                this.user = this.db.addUser(usrID, name, sysName, disc, colour, pwd, this.priv);
            } else {
                this.user.update(usrID, name, sysName, disc, colour, pwd, this.priv);
            }
            this.db.commit();
            this.setOK();
        }
        catch (SQLException sql) {
            this.db.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (SBException sbe) {
            this.db.doRollback();
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jPasswordFieldKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jPasswordField, (int)9, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldSysNameKeyTyped(KeyEvent evt) {
        if (SB.uCaseField((JTextField)this.jTextFieldSysName, (int)35, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldIDKeyTyped(KeyEvent evt) {
        if (SB.uCaseField((JTextField)this.jTextFieldID, (int)5, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldNameKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldName, (int)40, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialoguserdef.html");
    }

    private void jRadioButtonUserActionPerformed(ActionEvent evt) {
        this.jLabelPriv.setText(userText);
        this.jTextFieldSysName.setEnabled(true);
        this.jPasswordField.setEnabled(true);
        this.jCheckBoxDiscOnly.setEnabled(true);
        this.jCheckBoxExport.setEnabled(true);
    }

    private void jRadioButtonSuperUserActionPerformed(ActionEvent evt) {
        this.jLabelPriv.setText(superUserText);
        this.jTextFieldSysName.setEnabled(true);
        this.jPasswordField.setEnabled(true);
        this.jCheckBoxDiscOnly.setEnabled(false);
        this.jCheckBoxExport.setEnabled(false);
    }

    private void jRadioButtonNonUserActionPerformed(ActionEvent evt) {
        this.jLabelPriv.setText(nonUserText);
        this.jTextFieldSysName.setEnabled(false);
        this.jPasswordField.setEnabled(false);
        this.jCheckBoxDiscOnly.setEnabled(false);
        this.jCheckBoxExport.setEnabled(false);
    }
}

