/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import jsbugs.BlockProperties;
import jsbugs.ChartJPanel;
import jsbugs.ChartJPanelDepthAge;
import jsbugs.DialogChartFont;
import jsbugs.DialogSelectCmpStd;
import jsbugs.DialogSelectIGDType;
import jsbugs.DialogSelectScheme;
import jsbugs.FrameJsbugs;
import jsbugs.JPanelSchemeBlock;
import jsbugs.JPanelWellBlock;
import jsbugs.PanelCompositeStandard;
import jsbugs.PanelEvents;
import jsbugs.PanelIGDScheme;
import jsbugs.PanelSQPicks;
import jsbugs.PanelWellDepthAge;
import jsbugs.PanelWellDepthAgeProperties;
import jsbugs.PanelWirelineLog;
import jsbugs.SBDialog;
import jsbugs.SBPanel;
import jsbugs.SchemeBlock;
import jsbugs.WellBlock;
import model2.SBdb;
import model2.Sample;
import model2.WellInterp;
import org.jdesktop.layout.GroupLayout;
import util.AgeFormat;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.SbugsInputVerifier;

public class DialogWellDepthAge
extends SBDialog {
    private static final int DEPTHLEN = 8;
    private static final int AGELEN = 6;
    char units;
    SBdb db;
    DefaultComboBoxModel scaleModel = new DefaultComboBoxModel();
    DefaultComboBoxModel ageScaleModel = new DefaultComboBoxModel();
    DefaultListModel panelModel = new DefaultListModel();
    JPanelSchemeBlock panelSchemeBlockHeader;
    JPanelSchemeBlock panelSchemeBlock;
    JPanelWellBlock panelWellBlock;
    ChartJPanelDepthAge chartJPanel;
    PanelWellDepthAgeProperties prop;
    private ButtonGroup buttonGroupAgeAxis;
    private ButtonGroup buttonGroupAgeScaleType;
    private ButtonGroup buttonGroupScaleType;
    private ButtonGroup buttonGroupUnits;
    private JButton jButtonCancel;
    private JButton jButtonFonts;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonResetCmp;
    private JButton jButtonResetScheme;
    private JButton jButtonSelectCmpStd;
    private JButton jButtonSelectScheme;
    private JCheckBox jCheckBoxCatColours;
    private JCheckBox jCheckBoxDrawEventLines;
    private JCheckBox jCheckBoxDrawEventQuals;
    private JCheckBox jCheckBoxDrawEvents;
    private JCheckBox jCheckBoxDrawLOC;
    private JCheckBox jCheckBoxDrawOcc;
    private JCheckBox jCheckBoxDrawRates;
    private JCheckBox jCheckBoxDrawSampleAges;
    private JCheckBox jCheckBoxDrawShading;
    private JCheckBox jCheckBoxDrawZones;
    private JCheckBox jCheckBoxErrorBars;
    private JCheckBox jCheckBoxIncludeCvRw;
    private JCheckBox jCheckBoxLOCAlternatives;
    private JCheckBox jCheckBoxSQPicks;
    private JComboBox jComboBoxAgeScale;
    private JComboBox jComboBoxVerticalScale;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabelAgeScaleUnits;
    private JLabel jLabelBaseDepth;
    private JLabel jLabelMaxAgeUnits;
    private JLabel jLabelMinAgeUnits;
    private JLabel jLabelTopDepth;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel7;
    private JPanel jPanelEvents;
    private JPanel jPanelIGD;
    private JPanel jPanelInterps;
    private JPanel jPanelPanel;
    private JRadioButton jRadioButtonFeet;
    private JRadioButton jRadioButtonMD;
    private JRadioButton jRadioButtonMetres;
    private JRadioButton jRadioButtonTVD;
    private JRadioButton jRadioButtonXLeft;
    private JRadioButton jRadioButtonXRight;
    private JSeparator jSeparator1;
    private JTabbedPane jTabbedPaneMain;
    private JTabbedPane jTabbedPanePanel;
    private JTextField jTextFieldBaseDepth;
    private JTextField jTextFieldCmpStd;
    private JTextField jTextFieldMaxAge;
    private JTextField jTextFieldMinAge;
    private JTextField jTextFieldScheme;
    private JTextField jTextFieldTopDepth;

    public DialogWellDepthAge(Frame parent, boolean modal, SBdb db, ChartJPanelDepthAge chartJPanel) {
        super(parent, modal);
        this.db = db;
        this.chartJPanel = chartJPanel;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.prop = new PanelWellDepthAgeProperties(this.chartJPanel.getPanelProperties());
        WellBlock block = this.chartJPanel.getBlock();
        char blockUnits = block.prop.units;
        this.jTextFieldTopDepth.setText(SB.floatString((float)SB.convFromM((float)block.prop.min, (char)blockUnits, (char)block.well.getType()), (int)2));
        this.jTextFieldBaseDepth.setText(SB.floatString((float)SB.convFromM((float)block.prop.max, (char)blockUnits, (char)block.well.getType()), (int)2));
        ((JTextField)this.jComboBoxVerticalScale.getEditor().getEditorComponent()).setInputVerifier((InputVerifier)new SbugsInputVerifier(1.0f, 100000.0f, (float)((int)block.getScale())));
        try {
            this.db.getChartScales(this.scaleModel);
        }
        catch (SQLException sql) {
            SB.showStackError((String)"SQL Error loading scales: ", (SQLException)sql);
        }
        String sScale = Integer.toString((int)block.getScale());
        if (this.scaleModel.getIndexOf(sScale) < 0) {
            this.scaleModel.addElement(sScale);
        }
        this.scaleModel.setSelectedItem(sScale);
        if (blockUnits == 'F') {
            this.jRadioButtonFeet.setSelected(true);
            this.units = (char)70;
        } else {
            this.jRadioButtonMetres.setSelected(true);
            this.units = (char)77;
        }
        if (block.prop.scaleType == BlockProperties.ScaleType.MD) {
            this.jRadioButtonMD.setSelected(true);
        } else {
            this.jRadioButtonTVD.setSelected(true);
        }
        this.setScaleLabels();
        if (this.prop.getCmpStd() != null) {
            this.jTextFieldCmpStd.setText(this.prop.getCmpStd().toString());
        }
        if (this.prop.getScheme() != null) {
            this.jTextFieldScheme.setText(this.prop.getScheme().toString());
        }
        this.jTextFieldMinAge.setText("" + SB.roundToSignificantFigures((double)((double)this.prop.getMinAge() * this.chartJPanel.chart.chartProperties.ageFormat.getMultiplyer()), (int)3));
        this.jTextFieldMaxAge.setText("" + SB.roundToSignificantFigures((double)((double)this.prop.getMaxAge() * this.chartJPanel.chart.chartProperties.ageFormat.getMultiplyer()), (int)3));
        ((JTextField)this.jComboBoxAgeScale.getEditor().getEditorComponent()).setInputVerifier((InputVerifier)new SbugsInputVerifier((float)((double)0.1f / this.chartJPanel.chart.chartProperties.ageFormat.getMultiplyer()), (float)(1000.0 / this.chartJPanel.chart.chartProperties.ageFormat.getMultiplyer()), this.prop.getAgeScale()));
        SchemeBlock.fillScaleCombo(this.ageScaleModel);
        float ageScale = (float)((double)this.prop.getAgeScale() / this.chartJPanel.chart.chartProperties.ageFormat.getMultiplyer());
        if (this.ageScaleModel.getIndexOf(Float.valueOf(ageScale)) >= 0) {
            this.ageScaleModel.setSelectedItem(Float.valueOf(ageScale));
        } else {
            this.ageScaleModel.addElement(Float.valueOf(ageScale));
            this.ageScaleModel.setSelectedItem(Float.valueOf(ageScale));
        }
        this.refreshAgeLabels(null, this.chartJPanel.chart.chartProperties.ageFormat);
        this.jRadioButtonXLeft.setSelected(this.prop.isAgeLeftToRight());
        this.jRadioButtonXRight.setSelected(!this.prop.isAgeLeftToRight());
        this.jCheckBoxDrawOcc.setSelected(this.prop.drawOccs);
        this.jCheckBoxIncludeCvRw.setSelected(this.prop.includeCvRw);
        this.jCheckBoxDrawLOC.setSelected(this.prop.drawLOCs);
        this.jCheckBoxLOCAlternatives.setSelected(this.prop.drawLOCAlternatives);
        this.jCheckBoxDrawSampleAges.setSelected(this.prop.drawSampleAges);
        this.jCheckBoxDrawShading.setSelected(this.prop.drawShading);
        this.jCheckBoxDrawZones.setSelected(this.prop.drawZones);
        this.jCheckBoxDrawEvents.setSelected(this.prop.drawEvents);
        this.jCheckBoxDrawEventLines.setSelected(this.prop.drawEventLines);
        this.jCheckBoxSQPicks.setSelected(this.prop.drawSQPicks);
        this.jCheckBoxErrorBars.setSelected(this.prop.drawErrorBars);
        this.jCheckBoxDrawRates.setSelected(this.prop.drawRates);
        this.jCheckBoxDrawEventQuals.setSelected(this.prop.drawEventQualifiers);
        this.jCheckBoxCatColours.setSelected(this.prop.useCatColours);
        this.panelSchemeBlockHeader = new JPanelSchemeBlock(this.prop.sBlock, this.db, this);
        this.jTabbedPanePanel.insertTab("Scheme Header", null, this.panelSchemeBlockHeader, null, 2);
        this.panelWellBlock = new JPanelWellBlock(this.chartJPanel.getBlock(), this.db, this, this.chartJPanel.chart.chartProperties);
        this.jTabbedPaneMain.insertTab(this.chartJPanel.getBlock().well.getWellName(), null, this.panelWellBlock, null, 1);
        this.panelSchemeBlock = new JPanelSchemeBlock(this.chartJPanel.getSchemeBlock(), this.db, this);
        this.jTabbedPaneMain.insertTab("Scheme Block", null, this.panelSchemeBlock, null, 2);
        this.setTitle("Depth/Age Chart Properties");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.jComboBoxAgeScale.getEditor().getEditorComponent().addKeyListener(new CbKeyListener(this.jComboBoxAgeScale));
    }

    private void refreshAgeLabels(AgeFormat oldFormat, AgeFormat newFormat) {
        if (oldFormat != null) {
            if (oldFormat == newFormat) {
                return;
            }
            double minAge = Double.parseDouble(this.jTextFieldMinAge.getText());
            this.jTextFieldMinAge.setText("" + SB.roundToSignificantFigures((double)(minAge *= newFormat.getMultiplyer() / oldFormat.getMultiplyer()), (int)3));
            double maxAge = Double.parseDouble(this.jTextFieldMaxAge.getText());
            this.jTextFieldMaxAge.setText("" + SB.roundToSignificantFigures((double)(maxAge *= newFormat.getMultiplyer() / oldFormat.getMultiplyer()), (int)3));
            double ageScale = Double.parseDouble(this.jComboBoxAgeScale.getSelectedItem().toString());
            if (this.ageScaleModel.getIndexOf(ageScale /= newFormat.getMultiplyer() / oldFormat.getMultiplyer()) >= 0) {
                this.ageScaleModel.setSelectedItem(ageScale);
            } else {
                this.ageScaleModel.addElement(ageScale);
                this.ageScaleModel.setSelectedItem(ageScale);
            }
            ((JTextField)this.jComboBoxAgeScale.getEditor().getEditorComponent()).setInputVerifier((InputVerifier)new SbugsInputVerifier((float)((double)0.1f / this.chartJPanel.chart.chartProperties.ageFormat.getMultiplyer()), (float)(1000.0 / this.chartJPanel.chart.chartProperties.ageFormat.getMultiplyer()), this.prop.getAgeScale()));
        }
        this.jLabelMinAgeUnits.setText(newFormat.getDescr());
        this.jLabelMaxAgeUnits.setText(newFormat.getDescr());
        this.jLabelAgeScaleUnits.setText("mm/" + newFormat.getDescr());
    }

    private void initComponents() {
        this.buttonGroupUnits = new ButtonGroup();
        this.buttonGroupAgeAxis = new ButtonGroup();
        this.buttonGroupScaleType = new ButtonGroup();
        this.buttonGroupAgeScaleType = new ButtonGroup();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonHelp = new JButton();
        this.jLabelTopDepth = new JLabel();
        this.jTextFieldTopDepth = new JTextField();
        this.jLabelBaseDepth = new JLabel();
        this.jTextFieldBaseDepth = new JTextField();
        this.jLabel3 = new JLabel();
        this.jComboBoxVerticalScale = new JComboBox();
        this.jPanel4 = new JPanel();
        this.jRadioButtonMD = new JRadioButton();
        this.jRadioButtonTVD = new JRadioButton();
        this.jPanel1 = new JPanel();
        this.jRadioButtonMetres = new JRadioButton();
        this.jRadioButtonFeet = new JRadioButton();
        this.jButtonFonts = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jTabbedPaneMain = new JTabbedPane();
        this.jTabbedPanePanel = new JTabbedPane();
        this.jPanelPanel = new JPanel();
        this.jPanel7 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jRadioButtonXLeft = new JRadioButton();
        this.jRadioButtonXRight = new JRadioButton();
        this.jPanel5 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jComboBoxAgeScale = new JComboBox();
        this.jTextFieldMinAge = new JTextField();
        this.jLabelMinAgeUnits = new JLabel();
        this.jLabelMaxAgeUnits = new JLabel();
        this.jLabelAgeScaleUnits = new JLabel();
        this.jTextFieldMaxAge = new JTextField();
        this.jLabel5 = new JLabel();
        this.jButtonSelectCmpStd = new JButton();
        this.jTextFieldCmpStd = new JTextField();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jTextFieldScheme = new JTextField();
        this.jButtonSelectScheme = new JButton();
        this.jButtonResetCmp = new JButton();
        this.jButtonResetScheme = new JButton();
        this.jPanelInterps = new JPanel();
        this.jCheckBoxIncludeCvRw = new JCheckBox();
        this.jCheckBoxDrawOcc = new JCheckBox();
        this.jCheckBoxDrawLOC = new JCheckBox();
        this.jCheckBoxDrawSampleAges = new JCheckBox();
        this.jCheckBoxDrawRates = new JCheckBox();
        this.jPanelIGD = new JPanel();
        this.jCheckBoxDrawZones = new JCheckBox();
        this.jCheckBoxSQPicks = new JCheckBox();
        this.jCheckBoxDrawShading = new JCheckBox();
        this.jPanelEvents = new JPanel();
        this.jCheckBoxDrawEventLines = new JCheckBox();
        this.jCheckBoxDrawEvents = new JCheckBox();
        this.jCheckBoxErrorBars = new JCheckBox();
        this.jCheckBoxDrawEventQuals = new JCheckBox();
        this.jCheckBoxCatColours = new JCheckBox();
        this.jCheckBoxLOCAlternatives = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogWellDepthAge.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogWellDepthAge.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogWellDepthAge.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jLabelTopDepth.setHorizontalAlignment(11);
        this.jLabelTopDepth.setText("Top depth:");
        this.jTextFieldTopDepth.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogWellDepthAge.this.jTextFieldTopDepthKeyTyped(evt);
            }
        });
        this.jLabelBaseDepth.setHorizontalAlignment(11);
        this.jLabelBaseDepth.setText("Base depth:");
        this.jTextFieldBaseDepth.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogWellDepthAge.this.jTextFieldBaseDepthKeyTyped(evt);
            }
        });
        this.jLabel3.setHorizontalAlignment(11);
        this.jLabel3.setText("Scale:");
        this.jComboBoxVerticalScale.setEditable(true);
        this.jComboBoxVerticalScale.setModel(this.scaleModel);
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(null, "Scale type", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.buttonGroupScaleType.add(this.jRadioButtonMD);
        this.jRadioButtonMD.setText("Drilled depth");
        this.jRadioButtonMD.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogWellDepthAge.this.jRadioButtonMDActionPerformed(evt);
            }
        });
        this.buttonGroupScaleType.add(this.jRadioButtonTVD);
        this.jRadioButtonTVD.setText("TVD");
        this.jRadioButtonTVD.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogWellDepthAge.this.jRadioButtonTVDActionPerformed(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout((Container)this.jPanel4);
        this.jPanel4.setLayout((LayoutManager)jPanel4Layout);
        jPanel4Layout.setHorizontalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((Component)this.jRadioButtonMD)).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().add((Component)this.jRadioButtonTVD).add(0, 0, Short.MAX_VALUE)))));
        jPanel4Layout.setVerticalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().add((Component)this.jRadioButtonMD).addPreferredGap(0).add((Component)this.jRadioButtonTVD)));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Depth units", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.buttonGroupUnits.add(this.jRadioButtonMetres);
        this.jRadioButtonMetres.setText("Metres");
        this.jRadioButtonMetres.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogWellDepthAge.this.jRadioButtonMetresActionPerformed(evt);
            }
        });
        this.buttonGroupUnits.add(this.jRadioButtonFeet);
        this.jRadioButtonFeet.setText("Feet");
        this.jRadioButtonFeet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogWellDepthAge.this.jRadioButtonFeetActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.jRadioButtonMetres).addPreferredGap(0).add((Component)this.jRadioButtonFeet).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jRadioButtonMetres).add((Component)this.jRadioButtonFeet)));
        this.jButtonFonts.setText("Options...");
        this.jButtonFonts.setToolTipText("Chart display options, including fonts and core corrections");
        this.jButtonFonts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogWellDepthAge.this.jButtonFontsActionPerformed(evt);
            }
        });
        this.jPanel7.setBorder(BorderFactory.createTitledBorder(null, "Horizontal Axis (Age)", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Age increases:"));
        this.buttonGroupAgeAxis.add(this.jRadioButtonXLeft);
        this.jRadioButtonXLeft.setText("Left - Right");
        this.buttonGroupAgeAxis.add(this.jRadioButtonXRight);
        this.jRadioButtonXRight.setSelected(true);
        this.jRadioButtonXRight.setText("Right - Left");
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jRadioButtonXLeft).add((Component)this.jRadioButtonXRight)).addContainerGap(25, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jRadioButtonXLeft).addPreferredGap(0).add((Component)this.jRadioButtonXRight).add(0, 0, Short.MAX_VALUE)));
        this.jLabel4.setText("Min age:");
        this.jLabel6.setText("Age scale:");
        this.jComboBoxAgeScale.setEditable(true);
        this.jComboBoxAgeScale.setModel(this.ageScaleModel);
        this.jTextFieldMinAge.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogWellDepthAge.this.jTextFieldMinAgeKeyTyped(evt);
            }
        });
        this.jLabelMinAgeUnits.setText("Ma");
        this.jLabelMaxAgeUnits.setText("Ma");
        this.jLabelAgeScaleUnits.setText("mm/Ma");
        this.jTextFieldMaxAge.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogWellDepthAge.this.jTextFieldMaxAgeKeyTyped(evt);
            }
        });
        this.jLabel5.setText("Max age:");
        GroupLayout jPanel5Layout = new GroupLayout((Container)this.jPanel5);
        this.jPanel5.setLayout((LayoutManager)jPanel5Layout);
        jPanel5Layout.setHorizontalGroup((GroupLayout.Group)jPanel5Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel5Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel5Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel5Layout.createSequentialGroup().add((Component)this.jLabel6, -2, 50, -2).addPreferredGap(0).add((Component)this.jComboBoxAgeScale, -2, 91, -2).addPreferredGap(0).add((Component)this.jLabelAgeScaleUnits).add(0, 0, Short.MAX_VALUE)).add(2, (GroupLayout.Group)jPanel5Layout.createSequentialGroup().add(0, 5, Short.MAX_VALUE).add((GroupLayout.Group)jPanel5Layout.createParallelGroup(2).add((GroupLayout.Group)jPanel5Layout.createSequentialGroup().add((Component)this.jLabel4).addPreferredGap(0).add((Component)this.jTextFieldMinAge, -2, 91, -2)).add((GroupLayout.Group)jPanel5Layout.createSequentialGroup().add((Component)this.jLabel5).addPreferredGap(0).add((Component)this.jTextFieldMaxAge, -2, 91, -2))).addPreferredGap(0).add((GroupLayout.Group)jPanel5Layout.createParallelGroup(1).add((Component)this.jLabelMinAgeUnits).add((Component)this.jLabelMaxAgeUnits, -2, 14, -2)).add(30, 30, 30)))));
        jPanel5Layout.setVerticalGroup((GroupLayout.Group)jPanel5Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel5Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((GroupLayout.Group)jPanel5Layout.createParallelGroup(3).add((Component)this.jTextFieldMinAge, -2, -1, -2).add((Component)this.jLabel4).add((Component)this.jLabelMinAgeUnits)).addPreferredGap(0).add((GroupLayout.Group)jPanel5Layout.createParallelGroup(3).add((Component)this.jLabelMaxAgeUnits).add((Component)this.jTextFieldMaxAge, -2, -1, -2).add((Component)this.jLabel5)).addPreferredGap(0).add((GroupLayout.Group)jPanel5Layout.createParallelGroup(3).add((Component)this.jLabel6).add((Component)this.jComboBoxAgeScale, -2, -1, -2).add((Component)this.jLabelAgeScaleUnits)).add(30, 30, 30)));
        GroupLayout jPanel7Layout = new GroupLayout((Container)this.jPanel7);
        this.jPanel7.setLayout((LayoutManager)jPanel7Layout);
        jPanel7Layout.setHorizontalGroup((GroupLayout.Group)jPanel7Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel7Layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel5, -2, -1, -2).addPreferredGap(0, 29, Short.MAX_VALUE).add((Component)this.jPanel2, -2, -1, -2).addContainerGap()));
        jPanel7Layout.setVerticalGroup((GroupLayout.Group)jPanel7Layout.createParallelGroup(1).add((Component)this.jPanel2, -2, -1, -2).add((Component)this.jPanel5, -2, 96, -2));
        this.jButtonSelectCmpStd.setText("...");
        this.jButtonSelectCmpStd.setToolTipText("Select composite");
        this.jButtonSelectCmpStd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogWellDepthAge.this.jButtonSelectCmpStdActionPerformed(evt);
            }
        });
        this.jTextFieldCmpStd.setEditable(false);
        this.jTextFieldCmpStd.setBackground(new Color(255, 255, 204));
        this.jLabel7.setText("Composite:");
        this.jLabel8.setText("Scheme:");
        this.jTextFieldScheme.setEditable(false);
        this.jTextFieldScheme.setBackground(new Color(255, 255, 204));
        this.jTextFieldScheme.setToolTipText("Scheme for plotting intervals");
        this.jButtonSelectScheme.setText("...");
        this.jButtonSelectScheme.setToolTipText("Select scheme");
        this.jButtonSelectScheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogWellDepthAge.this.jButtonSelectSchemeActionPerformed(evt);
            }
        });
        this.jButtonResetCmp.setText("Clear");
        this.jButtonResetCmp.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonResetCmp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogWellDepthAge.this.jButtonResetCmpActionPerformed(evt);
            }
        });
        this.jButtonResetScheme.setText("Clear");
        this.jButtonResetScheme.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonResetScheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogWellDepthAge.this.jButtonResetSchemeActionPerformed(evt);
            }
        });
        GroupLayout jPanelPanelLayout = new GroupLayout((Container)this.jPanelPanel);
        this.jPanelPanel.setLayout((LayoutManager)jPanelPanelLayout);
        jPanelPanelLayout.setHorizontalGroup((GroupLayout.Group)jPanelPanelLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelPanelLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelPanelLayout.createSequentialGroup().add((GroupLayout.Group)jPanelPanelLayout.createParallelGroup(2).add((Component)this.jLabel8).add((Component)this.jLabel7)).addPreferredGap(0).add((GroupLayout.Group)jPanelPanelLayout.createParallelGroup(1).add((Component)this.jTextFieldCmpStd).add((Component)this.jTextFieldScheme)).addPreferredGap(0).add((GroupLayout.Group)jPanelPanelLayout.createParallelGroup(2, false).add((Component)this.jButtonSelectScheme, 0, 1, Short.MAX_VALUE).add((Component)this.jButtonSelectCmpStd, -2, 31, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanelPanelLayout.createParallelGroup(2, false).add((Component)this.jButtonResetScheme, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonResetCmp))).add((Component)this.jPanel7, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanelPanelLayout.setVerticalGroup((GroupLayout.Group)jPanelPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanelPanelLayout.createSequentialGroup().add(24, 24, 24).add((GroupLayout.Group)jPanelPanelLayout.createParallelGroup(3).add((Component)this.jLabel7).add((Component)this.jTextFieldCmpStd, -2, -1, -2).add((Component)this.jButtonResetCmp).add((Component)this.jButtonSelectCmpStd)).addPreferredGap(0).add((GroupLayout.Group)jPanelPanelLayout.createParallelGroup(3).add((Component)this.jLabel8).add((Component)this.jTextFieldScheme, -2, -1, -2).add((Component)this.jButtonResetScheme).add((Component)this.jButtonSelectScheme)).add(30, 30, 30).add((Component)this.jPanel7, -2, -1, -2).addContainerGap(34, Short.MAX_VALUE)));
        this.jTabbedPanePanel.addTab("Panel", this.jPanelPanel);
        this.jCheckBoxIncludeCvRw.setText("Include Caved & Reworked taxa in well occurrences");
        this.jCheckBoxDrawOcc.setText("Show well occurrences of composite standard taxa");
        this.jCheckBoxDrawLOC.setText("Show line of correlation (LOC)");
        this.jCheckBoxDrawSampleAges.setText("Show samples with ages");
        this.jCheckBoxDrawRates.setText("Show accumulation rates");
        this.jPanelIGD.setBorder(BorderFactory.createTitledBorder(null, "Interpretations", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.jPanelIGD.setPreferredSize(new Dimension(181, 142));
        this.jCheckBoxDrawZones.setText("Show interval outlines");
        this.jCheckBoxSQPicks.setText("Show sequence picks");
        this.jCheckBoxDrawShading.setText("Show interval shading");
        GroupLayout jPanelIGDLayout = new GroupLayout((Container)this.jPanelIGD);
        this.jPanelIGD.setLayout((LayoutManager)jPanelIGDLayout);
        jPanelIGDLayout.setHorizontalGroup((GroupLayout.Group)jPanelIGDLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelIGDLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelIGDLayout.createParallelGroup(1, false).add((Component)this.jCheckBoxDrawZones, -1, 140, Short.MAX_VALUE).add((Component)this.jCheckBoxDrawShading, -1, -1, Short.MAX_VALUE).add((Component)this.jCheckBoxSQPicks, -1, -1, Short.MAX_VALUE)).addContainerGap(23, Short.MAX_VALUE)));
        jPanelIGDLayout.setVerticalGroup((GroupLayout.Group)jPanelIGDLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelIGDLayout.createSequentialGroup().add((Component)this.jCheckBoxDrawZones).addPreferredGap(0).add((Component)this.jCheckBoxDrawShading).addPreferredGap(0).add((Component)this.jCheckBoxSQPicks).add(0, 46, Short.MAX_VALUE)));
        this.jPanelEvents.setBorder(BorderFactory.createTitledBorder(null, "Events", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.jCheckBoxDrawEventLines.setText("Show graph indicator lines");
        this.jCheckBoxDrawEvents.setText("Show events");
        this.jCheckBoxErrorBars.setText("Show event error bars");
        this.jCheckBoxDrawEventQuals.setText("Show event qualifiers");
        this.jCheckBoxCatColours.setText("Use taxon category colours");
        GroupLayout jPanelEventsLayout = new GroupLayout((Container)this.jPanelEvents);
        this.jPanelEvents.setLayout((LayoutManager)jPanelEventsLayout);
        jPanelEventsLayout.setHorizontalGroup((GroupLayout.Group)jPanelEventsLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelEventsLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelEventsLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelEventsLayout.createSequentialGroup().add((GroupLayout.Group)jPanelEventsLayout.createParallelGroup(1).add((Component)this.jCheckBoxDrawEvents, -2, 125, -2).add((Component)this.jCheckBoxErrorBars).add((Component)this.jCheckBoxDrawEventQuals).add((Component)this.jCheckBoxCatColours)).add(0, 18, Short.MAX_VALUE)).add((Component)this.jCheckBoxDrawEventLines, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanelEventsLayout.setVerticalGroup((GroupLayout.Group)jPanelEventsLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelEventsLayout.createSequentialGroup().add((Component)this.jCheckBoxDrawEvents).addPreferredGap(0).add((Component)this.jCheckBoxErrorBars).addPreferredGap(0).add((Component)this.jCheckBoxDrawEventQuals).addPreferredGap(0).add((Component)this.jCheckBoxCatColours).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jCheckBoxDrawEventLines)));
        this.jCheckBoxLOCAlternatives.setText("Show LOCs from other versions");
        GroupLayout jPanelInterpsLayout = new GroupLayout((Container)this.jPanelInterps);
        this.jPanelInterps.setLayout((LayoutManager)jPanelInterpsLayout);
        jPanelInterpsLayout.setHorizontalGroup((GroupLayout.Group)jPanelInterpsLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelInterpsLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelInterpsLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelInterpsLayout.createSequentialGroup().add((Component)this.jPanelEvents, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jPanelIGD, -2, -1, -2)).add((GroupLayout.Group)jPanelInterpsLayout.createSequentialGroup().add((GroupLayout.Group)jPanelInterpsLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelInterpsLayout.createSequentialGroup().add((Component)this.jCheckBoxDrawLOC, -2, 185, -2).addPreferredGap(0).add((Component)this.jCheckBoxLOCAlternatives)).add((Component)this.jCheckBoxDrawOcc).add((Component)this.jCheckBoxIncludeCvRw).add((GroupLayout.Group)jPanelInterpsLayout.createSequentialGroup().add((Component)this.jCheckBoxDrawSampleAges).addPreferredGap(0).add((Component)this.jCheckBoxDrawRates))).add(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanelInterpsLayout.linkSize(new Component[]{this.jCheckBoxDrawLOC, this.jCheckBoxDrawSampleAges}, 1);
        jPanelInterpsLayout.setVerticalGroup((GroupLayout.Group)jPanelInterpsLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelInterpsLayout.createSequentialGroup().add(15, 15, 15).add((GroupLayout.Group)jPanelInterpsLayout.createParallelGroup(3).add((Component)this.jCheckBoxDrawLOC).add((Component)this.jCheckBoxLOCAlternatives)).addPreferredGap(0).add((GroupLayout.Group)jPanelInterpsLayout.createParallelGroup(3).add((Component)this.jCheckBoxDrawSampleAges).add((Component)this.jCheckBoxDrawRates)).addPreferredGap(0).add((Component)this.jCheckBoxDrawOcc).addPreferredGap(0).add((Component)this.jCheckBoxIncludeCvRw).addPreferredGap(1).add((GroupLayout.Group)jPanelInterpsLayout.createParallelGroup(1).add((Component)this.jPanelIGD, -2, -1, -2).add((Component)this.jPanelEvents, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jTabbedPanePanel.addTab("Interpretations", this.jPanelInterps);
        this.jTabbedPaneMain.addTab("Depth/Age Panel", this.jTabbedPanePanel);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jSeparator1, -2, 416, -2).add(2, (Component)this.jTabbedPaneMain, -2, 416, -2).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jLabelTopDepth).add(2, (Component)this.jLabelBaseDepth).add(2, (Component)this.jLabel3)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2, false).add((Component)this.jTextFieldTopDepth).add((Component)this.jTextFieldBaseDepth).add((Component)this.jComboBoxVerticalScale, 0, 109, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.jPanel4, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add(2, (GroupLayout.Group)layout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((Component)this.jButtonFonts)))).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelTopDepth).add((Component)this.jTextFieldTopDepth, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelBaseDepth).add((Component)this.jTextFieldBaseDepth, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.jComboBoxVerticalScale, -2, -1, -2))).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(0).add((Component)this.jButtonFonts)).add((Component)this.jPanel4, -2, -1, -2)).addPreferredGap(1).add((Component)this.jSeparator1, -2, 11, -2).addPreferredGap(0).add((Component)this.jTabbedPaneMain, -2, 319, -2).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonOK).add((Component)this.jButtonHelp)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jTabbedPaneMain.getAccessibleContext().setAccessibleName("Depth/Age Panel");
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.panelWellBlock.cancel();
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonOKActionPerformed(ActionEvent evt) {
        PanelWellDepthAge panelWellDepthAge;
        float scale;
        float baseDepth;
        if (this.jTextFieldTopDepth.getText().length() == 0) {
            JOptionPane.showMessageDialog(this, "Enter a top depth", this.getTitle(), 2);
            return;
        }
        if (this.jTextFieldBaseDepth.getText().length() == 0) {
            JOptionPane.showMessageDialog(this, "Enter a base depth", this.getTitle(), 2);
            return;
        }
        this.units = (char)(this.jRadioButtonFeet.isSelected() ? 70 : 77);
        float topDepth = (float)SB.convToM((double)Float.parseFloat(this.jTextFieldTopDepth.getText()), (char)this.units, (char)this.chartJPanel.getBlock().well.getType());
        if (topDepth > (baseDepth = (float)SB.convToM((double)Float.parseFloat(this.jTextFieldBaseDepth.getText()), (char)this.units, (char)this.chartJPanel.getBlock().well.getType()))) {
            JOptionPane.showMessageDialog(this, "Top depth is greater than base depth", this.getTitle(), 2);
            return;
        }
        float minAge = Float.parseFloat(this.jTextFieldMinAge.getText());
        float maxAge = Float.parseFloat(this.jTextFieldMaxAge.getText());
        float ageScale = Float.parseFloat(this.jComboBoxAgeScale.getSelectedItem().toString());
        if (minAge > maxAge) {
            JOptionPane.showMessageDialog(this, "Minimum age is greater than maxiumum age", this.getTitle(), 2);
            return;
        }
        minAge = (float)((double)minAge / this.chartJPanel.chart.chartProperties.ageFormat.getMultiplyer());
        maxAge = (float)((double)maxAge / this.chartJPanel.chart.chartProperties.ageFormat.getMultiplyer());
        ageScale = (float)((double)ageScale * this.chartJPanel.chart.chartProperties.ageFormat.getMultiplyer());
        boolean blockChange = false;
        WellBlock block = this.chartJPanel.getBlock();
        try {
            if (this.jRadioButtonTVD.isSelected() && (block.well.getTVDlist(false) == null || block.well.getTVDlist(false).getList().isEmpty())) {
                JOptionPane.showMessageDialog(this, "This well has no deviation survey. Scale type reset to MD", this.getTitle(), 2);
                this.jRadioButtonMD.setSelected(true);
            }
        }
        catch (SQLException e) {
            SB.showStackError((String)"Error getting TVD list", (SQLException)e);
        }
        if (block.prop.setScaleType(this.jRadioButtonMD.isSelected() ? BlockProperties.ScaleType.MD : BlockProperties.ScaleType.TVD)) {
            blockChange = true;
        }
        if (block.prop.setLimits(topDepth, baseDepth)) {
            blockChange = true;
        }
        if (block.prop.setScale(scale = Float.parseFloat("" + this.jComboBoxVerticalScale.getSelectedItem()))) {
            blockChange = true;
        }
        if (block.prop.setUnits(this.units)) {
            blockChange = true;
        }
        if (block.well != null) {
            try {
                for (Sample sample : block.well.getSamples()) {
                    sample.displayUnits = this.units;
                }
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error setting display units for samples: ", sql, this.db);
            }
            catch (SBException sbe) {
                FrameJsbugs.showStackError("Error setting display units for samples: ", (Exception)((Object)sbe), this.db);
            }
        }
        if ((double)Math.abs(this.chartJPanel.getBlock().getTopDepth() - topDepth) > 0.001 || (double)Math.abs(this.chartJPanel.getBlock().getBaseDepth() - baseDepth) > 0.001) {
            this.chartJPanel.dialogDepthsSet = true;
        }
        this.prop.setSBlockAgeRange(minAge, maxAge);
        this.prop.sBlock.prop.scale = ageScale;
        this.prop.sBlock.prop.ageLeftToRight = this.jRadioButtonXLeft.isSelected();
        this.prop.drawEvents = this.jCheckBoxDrawEvents.isSelected();
        this.prop.drawEventLines = this.jCheckBoxDrawEventLines.isSelected();
        this.prop.drawLOCs = this.jCheckBoxDrawLOC.isSelected();
        this.prop.drawOccs = this.jCheckBoxDrawOcc.isSelected();
        this.prop.includeCvRw = this.jCheckBoxIncludeCvRw.isSelected();
        this.prop.drawSampleAges = this.jCheckBoxDrawSampleAges.isSelected();
        this.prop.drawShading = this.jCheckBoxDrawShading.isSelected();
        this.prop.drawZones = this.jCheckBoxDrawZones.isSelected();
        this.prop.drawSQPicks = this.jCheckBoxSQPicks.isSelected();
        this.prop.drawErrorBars = this.jCheckBoxErrorBars.isSelected();
        this.prop.drawRates = this.jCheckBoxDrawRates.isSelected();
        this.prop.drawEventQualifiers = this.jCheckBoxDrawEventQuals.isSelected();
        this.prop.useCatColours = this.jCheckBoxCatColours.isSelected();
        this.prop.drawLOCAlternatives = this.jCheckBoxLOCAlternatives.isSelected();
        if (this.prop.drawLOCAlternatives) {
            try {
                Iterator interpIterator = this.panelWellBlock.block.well.getInterpIterator();
                while (interpIterator.hasNext()) {
                    WellInterp interp = (WellInterp)interpIterator.next();
                    this.panelWellBlock.block.well.loadInterp(interp);
                }
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error", sql, this.db);
            }
            catch (SBException sbe) {
                SB.showStackError((String)"Error", (Exception)((Object)sbe));
            }
        }
        if ((panelWellDepthAge = this.chartJPanel.getPanelWellDepthAge()) != null) {
            panelWellDepthAge.setProperties(this.prop);
        }
        this.panelSchemeBlockHeader.confirm();
        try {
            if (this.prop.interp != null && block.well.getInterp(this.prop.interp.getInterpID()).getLOC() != null) {
                block.well.getInterp(this.prop.interp.getInterpID()).getLOC().setPrefStd(this.prop.getCmpStd(), this.panelWellBlock.block.well.getWellID(), this.prop.interp.getInterpID());
            }
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error setting preferred composite standard", sql, this.db);
        }
        this.panelWellBlock.confirm();
        this.panelSchemeBlock.confirm();
        for (SBPanel panel : this.prop.sBlock.panels) {
            if (!(panel instanceof PanelIGDScheme)) continue;
            ((PanelIGDScheme)panel).getProperties().includeMaScale = false;
        }
        if (panelWellDepthAge != null) {
            this.chartJPanel.chart.chartProperties.setPanelSubHeaderHeight(panelWellDepthAge.getHeaderHeight(this.chartJPanel.chart.chartProperties));
        }
        ChartJPanel.encodePanelTypes(this.chartJPanel.getBlock(), this.db, "DACHTPANS");
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (blockChange) {
                this.chartJPanel.chart.setData();
            } else {
                this.chartJPanel.chart.setData(panelWellDepthAge);
            }
            String prefKey = this.chartJPanel.chart.getWellBlock().getPrefKey(2);
            this.chartJPanel.chart.savePreference(this.db, prefKey);
            this.db.commit();
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error setting chart data", (Exception)((Object)sbe));
        }
        catch (IOException e) {
            SB.showStackError((String)"I/O Error setting chart data", (Exception)e);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error setting chart data", sql, this.db);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
        this.prop.encode(this.db, false);
        this.setOK();
    }

    boolean getSamplePanel() {
        return false;
    }

    boolean getSQPicksPanel() {
        return this.jCheckBoxSQPicks.isSelected();
    }

    private void jTextFieldTopDepthKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldTopDepth, (int)8, (KeyEvent)evt, (boolean)true)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldBaseDepthKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldBaseDepth, (int)8, (KeyEvent)evt, (boolean)true)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldMinAgeKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldMinAge, (int)6, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldMaxAgeKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldMaxAge, (int)6, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonSelectCmpStdActionPerformed(ActionEvent evt) {
        block8: {
            try {
                DialogSelectCmpStd dialog = new DialogSelectCmpStd(this, true, this.db);
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
                if (dialog.selection == null || dialog.selection == this.prop.getCmpStd()) break block8;
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.prop.setCmpStd(dialog.selection, this.db);
                this.prop.getCmpStd().loadEvents();
                this.jTextFieldCmpStd.setText(this.prop.getCmpStd().getName());
                try {
                    if (Float.parseFloat(this.jTextFieldMinAge.getText()) == 0.0f && Float.parseFloat(this.jTextFieldMaxAge.getText()) == 0.0f) {
                        this.jTextFieldMinAge.setText("" + this.prop.getCmpStd().getMinAge());
                        this.jTextFieldMaxAge.setText("" + this.prop.getCmpStd().getMaxAge());
                    }
                }
                catch (Exception e) {
                    this.jTextFieldMinAge.setText("" + this.prop.getCmpStd().getMinAge());
                    this.jTextFieldMaxAge.setText("" + this.prop.getCmpStd().getMaxAge());
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Error selecting composite std: " + e.getMessage(), this.getTitle(), 0);
                e.printStackTrace();
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private void jButtonResetCmpActionPerformed(ActionEvent evt) {
        for (SBPanel panel : this.prop.sBlock.panels) {
            if (!(panel instanceof PanelCompositeStandard) || ((PanelCompositeStandard)panel).getStd() != this.prop.getCmpStd()) continue;
            try {
                this.panelSchemeBlockHeader.removePanel(panel);
                this.panelSchemeBlockHeader.createPanelList(this.prop.sBlock);
            }
            catch (InvalidFieldException e) {
                e.printStackTrace();
            }
            break;
        }
        try {
            this.prop.setCmpStd(null, this.db);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        this.jTextFieldCmpStd.setText("");
    }

    private void jButtonResetSchemeActionPerformed(ActionEvent evt) {
        try {
            this.prop.setScheme(null);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        this.jTextFieldScheme.setText("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonSelectSchemeActionPerformed(ActionEvent evt) {
        try {
            DialogSelectIGDType dialog = new DialogSelectIGDType(this, true, false, false, false, false);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                if (dialog.igdType == 20) {
                    JOptionPane.showMessageDialog(this, "You can't select a composite Standard here", this.getTitle(), 2);
                    return;
                }
                DialogSelectScheme dialogScheme = new DialogSelectScheme(this, true, this.db, dialog.igdType, this.chartJPanel.getBlock().well.getInterp(this.prop.interp.getInterpID()));
                dialogScheme.setLocationRelativeTo(this);
                dialogScheme.setVisible(true);
                if (dialogScheme.selection != null && dialogScheme.selection != this.prop.getScheme()) {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this.prop.setScheme(dialogScheme.selection);
                    this.jTextFieldScheme.setText(this.prop.getScheme().toString());
                    this.prop.getScheme().loadUnits();
                }
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error selecting scheme: " + e.getMessage(), this.getTitle(), 0);
            e.printStackTrace();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jRadioButtonMetresActionPerformed(ActionEvent evt) {
        if (this.units == 'M') {
            return;
        }
        this.setUnits();
    }

    private void jRadioButtonFeetActionPerformed(ActionEvent evt) {
        if (this.units == 'F') {
            return;
        }
        this.setUnits();
    }

    private void jButtonFontsActionPerformed(ActionEvent evt) {
        AgeFormat orig = this.chartJPanel.chart.chartProperties.ageFormat;
        this.setCursor(Cursor.getPredefinedCursor(3));
        DialogChartFont dialog = new DialogChartFont(this, true, this.chartJPanel.chart.chartProperties);
        dialog.setLocationRelativeTo(this);
        this.setCursor(Cursor.getDefaultCursor());
        dialog.setVisible(true);
        this.refreshAgeLabels(orig, this.chartJPanel.chart.chartProperties.ageFormat);
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogwelldepthage.html");
    }

    private void jRadioButtonMDActionPerformed(ActionEvent evt) {
        this.setScaleLabels();
    }

    private void jRadioButtonTVDActionPerformed(ActionEvent evt) {
        this.setScaleLabels();
    }

    private boolean hasEventsPanel() {
        for (int i = 0; i < this.panelModel.size(); ++i) {
            SBPanel p = (SBPanel)this.panelModel.get(i);
            if (!(p instanceof PanelEvents)) continue;
            return true;
        }
        return false;
    }

    private boolean hasPicksPanel() {
        for (int i = 0; i < this.panelModel.size(); ++i) {
            SBPanel p = (SBPanel)this.panelModel.get(i);
            if (!(p instanceof PanelSQPicks)) continue;
            return true;
        }
        return false;
    }

    private boolean hasLogPanel() {
        for (int i = 0; i < this.panelModel.size(); ++i) {
            SBPanel p = (SBPanel)this.panelModel.get(i);
            if (!(p instanceof PanelWirelineLog)) continue;
            return true;
        }
        return false;
    }

    private void setScaleLabels() {
        this.jLabelTopDepth.setText(this.jRadioButtonMD.isSelected() ? "Top depth:" : "Top TVD:");
        this.jLabelBaseDepth.setText(this.jRadioButtonMD.isSelected() ? "Base depth:" : "Base TVD:");
    }

    private void setUnits() {
        if (this.jRadioButtonFeet.isSelected() && this.units != 'F') {
            this.units = (char)70;
            try {
                this.jTextFieldTopDepth.setText("" + SB.convFromM((double)Float.parseFloat(this.jTextFieldTopDepth.getText()), (char)'F'));
            }
            catch (Exception e) {
                this.jTextFieldTopDepth.setText("0.0");
            }
            try {
                this.jTextFieldBaseDepth.setText("" + SB.convFromM((double)Float.parseFloat(this.jTextFieldBaseDepth.getText()), (char)'F'));
            }
            catch (Exception e) {
                this.jTextFieldBaseDepth.setText("0.0");
            }
        } else {
            this.units = (char)77;
            try {
                this.jTextFieldTopDepth.setText("" + SB.convToM((float)Float.parseFloat(this.jTextFieldTopDepth.getText()), (char)'F'));
            }
            catch (Exception e) {
                this.jTextFieldTopDepth.setText("0.0");
            }
            try {
                this.jTextFieldBaseDepth.setText("" + SB.convToM((float)Float.parseFloat(this.jTextFieldBaseDepth.getText()), (char)'F'));
            }
            catch (Exception e) {
                this.jTextFieldBaseDepth.setText("0.0");
            }
        }
    }

    private class CbKeyListener
    implements KeyListener {
        JComboBox comboBox;

        public CbKeyListener(JComboBox box) {
            this.comboBox = box;
        }

        @Override
        public void keyReleased(KeyEvent evt) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent evt) {
            char c = evt.getKeyChar();
            if ((c < '0' || c > '9') && c != '.' && c != '-' && c != '+' && c != '\b' && c != '\u007f') {
                DialogWellDepthAge.this.getToolkit().beep();
                evt.consume();
            }
        }
    }
}

