/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import jsbugs.DialogSelectWell;
import model2.SBdb;
import model2.Well;
import org.jdesktop.layout.GroupLayout;
import util.SBException;

public class DialogWellDisc
extends JDialog {
    boolean isOK = false;
    SBdb db;
    LinkedList<Well> wells = new LinkedList();
    char discID;
    String analyst;
    DefaultComboBoxModel analystModel = new DefaultComboBoxModel();
    final String allString = "<All analyses>";
    private ButtonGroup buttonGroupDisc;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JButton jButtonSelectWell;
    private JComboBox jComboBoxAnalyst;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JRadioButton jRadioButtonMacro;
    private JRadioButton jRadioButtonMicro;
    private JRadioButton jRadioButtonNanno;
    private JRadioButton jRadioButtonPaly;
    private JSeparator jSeparator1;
    private JTextField jTextFieldWellName;

    public DialogWellDisc(Frame parent, boolean modal, SBdb db, Well well) {
        super(parent, modal);
        this.db = db;
        this.initComponents();
        this.init(well);
    }

    private void init(Well well) {
        this.analystModel.addElement("<All analyses>");
        this.jComboBoxAnalyst.repaint();
        this.setTitle("Well/Discipline : Select");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        if (well != null) {
            this.wells.add(well);
            this.setWell();
        }
    }

    private void initComponents() {
        this.buttonGroupDisc = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jTextFieldWellName = new JTextField();
        this.jButtonSelectWell = new JButton();
        this.jRadioButtonMicro = new JRadioButton();
        this.jRadioButtonNanno = new JRadioButton();
        this.jRadioButtonPaly = new JRadioButton();
        this.jRadioButtonMacro = new JRadioButton();
        this.jLabel2 = new JLabel();
        this.jComboBoxAnalyst = new JComboBox();
        this.jSeparator1 = new JSeparator();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jLabel1.setText("Wells/outcrops:");
        this.jTextFieldWellName.setBackground(new Color(255, 255, 204));
        this.jTextFieldWellName.setEditable(false);
        this.jButtonSelectWell.setText("...");
        this.jButtonSelectWell.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogWellDisc.this.jButtonSelectWellActionPerformed(evt);
            }
        });
        this.buttonGroupDisc.add(this.jRadioButtonMicro);
        this.jRadioButtonMicro.setText("Microfauna");
        this.jRadioButtonMicro.setEnabled(false);
        this.jRadioButtonMicro.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogWellDisc.this.jRadioButtonMicroActionPerformed(evt);
            }
        });
        this.buttonGroupDisc.add(this.jRadioButtonNanno);
        this.jRadioButtonNanno.setText("Nannoflora");
        this.jRadioButtonNanno.setEnabled(false);
        this.jRadioButtonNanno.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogWellDisc.this.jRadioButtonNannoActionPerformed(evt);
            }
        });
        this.buttonGroupDisc.add(this.jRadioButtonPaly);
        this.jRadioButtonPaly.setText("Palynoflora");
        this.jRadioButtonPaly.setEnabled(false);
        this.jRadioButtonPaly.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogWellDisc.this.jRadioButtonPalyActionPerformed(evt);
            }
        });
        this.buttonGroupDisc.add(this.jRadioButtonMacro);
        this.jRadioButtonMacro.setText("Macrofauna");
        this.jRadioButtonMacro.setEnabled(false);
        this.jRadioButtonMacro.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogWellDisc.this.jRadioButtonMacroActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Analyst:");
        this.jComboBoxAnalyst.setModel(this.analystModel);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogWellDisc.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogWellDisc.this.jButtonOKActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabel1).add((Component)this.jLabel2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jTextFieldWellName, -2, 183, -2).addPreferredGap(0).add((Component)this.jButtonSelectWell, -2, 30, -2)).add((Component)this.jRadioButtonMicro).add((Component)this.jRadioButtonNanno).add((Component)this.jRadioButtonPaly).add((Component)this.jRadioButtonMacro).add((Component)this.jComboBoxAnalyst, -2, 128, -2))).add((Component)this.jSeparator1, -1, 298, Short.MAX_VALUE).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonCancel))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jTextFieldWellName, -2, -1, -2).add((Component)this.jButtonSelectWell)).addPreferredGap(1).add((Component)this.jRadioButtonMicro).addPreferredGap(1).add((Component)this.jRadioButtonNanno).addPreferredGap(1).add((Component)this.jRadioButtonPaly).addPreferredGap(1).add((Component)this.jRadioButtonMacro).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jComboBoxAnalyst, -2, -1, -2)).addPreferredGap(1).add((Component)this.jSeparator1, -2, 8, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonOK)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonSelectWellActionPerformed(ActionEvent evt) {
        DialogSelectWell dialog = new DialogSelectWell(this, true, this.db, true, null);
        dialog.setVisible(true);
        if (dialog.selection != null) {
            for (Well well : dialog.selection) {
                this.wells.add(well);
            }
            this.setWell();
        }
    }

    private void setWell() {
        try {
            List analysts;
            String names = "";
            for (Well well : this.wells) {
                if (!names.isEmpty()) {
                    names = names + ", ";
                }
                names = names + well.getWellName();
            }
            this.jTextFieldWellName.setText(names);
            JRadioButton selection = null;
            int discID = 0;
            int nSelected = 0;
            for (Well well : this.wells) {
                analysts = well.getAnalysts('M');
                if (analysts.size() > 0) {
                    this.jRadioButtonMicro.setEnabled(true);
                    selection = this.jRadioButtonMicro;
                    discID = 77;
                    ++nSelected;
                    break;
                }
                this.jRadioButtonMicro.setEnabled(false);
            }
            for (Well well : this.wells) {
                analysts = well.getAnalysts('N');
                if (analysts.size() > 0) {
                    this.jRadioButtonNanno.setEnabled(true);
                    selection = this.jRadioButtonNanno;
                    discID = 78;
                    ++nSelected;
                    break;
                }
                this.jRadioButtonNanno.setEnabled(false);
            }
            for (Well well : this.wells) {
                analysts = well.getAnalysts('P');
                if (analysts.size() > 0) {
                    this.jRadioButtonPaly.setEnabled(true);
                    selection = this.jRadioButtonPaly;
                    discID = 80;
                    ++nSelected;
                    break;
                }
                this.jRadioButtonPaly.setEnabled(false);
            }
            for (Well well : this.wells) {
                analysts = well.getAnalysts('A');
                if (analysts.size() > 0) {
                    this.jRadioButtonMacro.setEnabled(true);
                    selection = this.jRadioButtonMacro;
                    discID = 65;
                    ++nSelected;
                    break;
                }
                this.jRadioButtonMacro.setEnabled(false);
            }
            if (nSelected == 1) {
                selection.setSelected(true);
                this.selectAnalysts((char)discID);
            }
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(this, "Problem getting discipline data: " + ex.getMessage(), this.getTitle(), 0);
            ex.printStackTrace();
        }
        catch (SBException ex) {
            JOptionPane.showMessageDialog(this, "Problem getting discipline data: " + ex.getMessage(), this.getTitle(), 0);
            ex.printStackTrace();
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.wells.isEmpty()) {
            JOptionPane.showMessageDialog(this, "No well(s) selected", this.getTitle(), 1);
            return;
        }
        if (this.buttonGroupDisc.getSelection() == null) {
            JOptionPane.showMessageDialog(this, "Select a discipline", this.getTitle(), 1);
            return;
        }
        if (this.jRadioButtonMacro.isSelected()) {
            this.discID = (char)65;
        } else if (this.jRadioButtonMicro.isSelected()) {
            this.discID = (char)77;
        } else if (this.jRadioButtonNanno.isSelected()) {
            this.discID = (char)78;
        } else if (this.jRadioButtonPaly.isSelected()) {
            this.discID = (char)80;
        }
        if (!this.jComboBoxAnalyst.getSelectedItem().equals("<All analyses>")) {
            this.analyst = (String)this.jComboBoxAnalyst.getSelectedItem();
        }
        this.isOK = true;
        this.dispose();
    }

    private void selectAnalysts(char discID) {
        try {
            for (Well well : this.wells) {
                List analysts = well.getAnalysts(discID);
                this.analystModel.removeAllElements();
                this.analystModel.addElement("<All analyses>");
                for (Object o : analysts) {
                    this.analystModel.addElement(o);
                }
            }
            this.jComboBoxAnalyst.updateUI();
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(this, "Problem getting discipline data: " + ex.getMessage(), this.getTitle(), 0);
            ex.printStackTrace();
        }
        catch (SBException ex) {
            JOptionPane.showMessageDialog(this, "Problem getting discipline data: " + ex.getMessage(), this.getTitle(), 0);
            ex.printStackTrace();
        }
    }

    private void jRadioButtonNannoActionPerformed(ActionEvent evt) {
        this.selectAnalysts('N');
    }

    private void jRadioButtonMicroActionPerformed(ActionEvent evt) {
        this.selectAnalysts('M');
    }

    private void jRadioButtonPalyActionPerformed(ActionEvent evt) {
        this.selectAnalysts('P');
    }

    private void jRadioButtonMacroActionPerformed(ActionEvent evt) {
        this.selectAnalysts('A');
    }
}

