/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import jsbugs.DialogSelectAnalyst;
import jsbugs.DialogSelectEvent;
import jsbugs.DialogSelectSample;
import jsbugs.FrameJsbugs;
import model2.Discipline;
import model2.SBEvent;
import model2.SBdb;
import model2.Sample;
import model2.Taxon;
import model2.Well;
import model2.WellEvent;
import model2.WellInterp;
import org.jdesktop.layout.GroupLayout;
import util.InvalidFieldException;
import util.SB;
import util.SBException;

public class DialogWellEvent
extends JDialog {
    private static final int NAMELEN = 100;
    private static final int SOURCELEN = 5;
    private static final int COMLEN = 240;
    private static final int QUALLEN = 16;
    private static final int COMPANYLEN = 20;
    private final SBdb db;
    private final Well well;
    private final WellInterp wellInterp;
    private final char units;
    private Sample sample;
    private SBEvent event;
    private SBEvent.EventType eventType;
    private WellEvent wellEvent;
    private DefaultComboBoxModel comboModelDiscipline = new DefaultComboBoxModel<Discipline>(Discipline.values());
    private ButtonGroup buttonGroupType;
    private JButton jButtonAnalyst;
    private JButton jButtonCancel;
    private JButton jButtonEvent;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonSample;
    private JComboBox jComboBoxDiscipline;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JRadioButton jRadioButtonBase;
    private JRadioButton jRadioButtonSingle;
    private JRadioButton jRadioButtonTop;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JTextArea jTextAreaComment;
    private JTextField jTextFieldAnalyst;
    private JTextField jTextFieldCompany;
    private JTextField jTextFieldDepth;
    private JTextField jTextFieldEventName;
    private JTextField jTextFieldQual;
    private JTextField jTextFieldSource;

    public DialogWellEvent(Frame parent, boolean modal, SBdb db, Well well, WellInterp wellInterp, char units, WellEvent wellEvent, Sample sample, SBEvent event, SBEvent.EventType eventType) {
        super(parent, modal);
        this.db = db;
        this.well = well;
        this.units = units;
        this.wellInterp = wellInterp;
        this.sample = sample;
        this.event = event;
        this.wellEvent = wellEvent;
        this.eventType = eventType;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.comboModelDiscipline.insertElementAt("", 0);
        this.getRootPane().setDefaultButton(this.jButtonOK);
        if (this.wellEvent == null) {
            this.setTitle("Event : Add to Well");
            this.jComboBoxDiscipline.setSelectedIndex(0);
        } else {
            this.sample = this.wellEvent.getSample();
            this.event = this.wellEvent.getEvent();
            this.eventType = this.wellEvent.getTypeObj();
            this.jTextAreaComment.setText(this.wellEvent.getComments());
            this.jTextFieldAnalyst.setText(this.wellEvent.getAnalystString());
            Discipline discID = this.wellEvent.getDiscipline();
            if (discID != null) {
                this.jComboBoxDiscipline.setSelectedItem(discID);
            } else {
                this.jComboBoxDiscipline.setSelectedIndex(0);
            }
            this.jTextFieldQual.setText(this.wellEvent.getQualifier());
            this.jTextFieldSource.setText(this.wellEvent.getSource());
            this.jTextFieldCompany.setText(this.wellEvent.getCompany());
            this.setTitle("Event : Edit in well");
        }
        this.jComboBoxDiscipline.repaint();
        if (this.sample != null) {
            this.jTextFieldDepth.setText(this.sample.toString(this.units, true, true));
        }
        if (this.event != null) {
            this.jTextFieldEventName.setText(this.event.toString());
            this.setEventType();
        }
        if (this.eventType != null) {
            switch (this.eventType) {
                case TOP: {
                    this.jRadioButtonTop.setSelected(true);
                    break;
                }
                case BASE: {
                    this.jRadioButtonBase.setSelected(true);
                    break;
                }
                case SINGLE: {
                    this.jRadioButtonSingle.setSelected(true);
                }
            }
        }
        this.jRadioButtonTop.setText(WellEvent.getPrefixF() + " event");
        this.jRadioButtonBase.setText(WellEvent.getPrefixL() + " event");
    }

    private void setEventType() {
        if (this.event.isSingle()) {
            this.jRadioButtonTop.setEnabled(false);
            this.jRadioButtonBase.setEnabled(false);
            this.jRadioButtonSingle.setEnabled(true);
            this.jRadioButtonSingle.setSelected(true);
        } else {
            this.jRadioButtonTop.setEnabled(true);
            this.jRadioButtonBase.setEnabled(true);
            this.jRadioButtonSingle.setEnabled(false);
            this.jRadioButtonSingle.setSelected(false);
        }
    }

    private void initComponents() {
        this.buttonGroupType = new ButtonGroup();
        this.jButtonSample = new JButton();
        this.jButtonEvent = new JButton();
        this.jTextFieldDepth = new JTextField();
        this.jTextFieldEventName = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jRadioButtonTop = new JRadioButton();
        this.jRadioButtonBase = new JRadioButton();
        this.jRadioButtonSingle = new JRadioButton();
        this.jSeparator1 = new JSeparator();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonOK = new JButton();
        this.jLabel3 = new JLabel();
        this.jComboBoxDiscipline = new JComboBox();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jTextFieldAnalyst = new JTextField();
        this.jButtonAnalyst = new JButton();
        this.jTextFieldQual = new JTextField();
        this.jTextFieldSource = new JTextField();
        this.jTextFieldCompany = new JTextField();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaComment = new JTextArea();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jButtonSample.setText("...");
        this.jButtonSample.setToolTipText("Select sample");
        this.jButtonSample.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogWellEvent.this.jButtonSampleActionPerformed(evt);
            }
        });
        this.jButtonEvent.setText("...");
        this.jButtonEvent.setToolTipText("Select event from event dictionary");
        this.jButtonEvent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogWellEvent.this.jButtonEventActionPerformed(evt);
            }
        });
        this.jTextFieldDepth.setBackground(new Color(255, 255, 204));
        this.jTextFieldDepth.setEditable(false);
        this.jTextFieldDepth.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                DialogWellEvent.this.jTextFieldDepthFocusGained(evt);
            }
        });
        this.jTextFieldEventName.setBackground(new Color(255, 255, 204));
        this.jTextFieldEventName.setEditable(false);
        this.jTextFieldEventName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogWellEvent.this.jTextFieldEventNameKeyTyped(evt);
            }
        });
        this.jLabel1.setText("Sample depth:");
        this.jLabel2.setText("Event name:");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Event Type", 0, 0, null, new Color(51, 102, 204)));
        this.buttonGroupType.add(this.jRadioButtonTop);
        this.jRadioButtonTop.setText("Top event");
        this.jRadioButtonTop.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonTop.setMargin(new Insets(0, 0, 0, 0));
        this.buttonGroupType.add(this.jRadioButtonBase);
        this.jRadioButtonBase.setText("Base event");
        this.jRadioButtonBase.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonBase.setMargin(new Insets(0, 0, 0, 0));
        this.buttonGroupType.add(this.jRadioButtonSingle);
        this.jRadioButtonSingle.setText("Single event");
        this.jRadioButtonSingle.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonSingle.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.jRadioButtonTop).addPreferredGap(1).add((Component)this.jRadioButtonBase).addPreferredGap(1).add((Component)this.jRadioButtonSingle).addContainerGap(113, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jRadioButtonBase).add((Component)this.jRadioButtonSingle).add((Component)this.jRadioButtonTop)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogWellEvent.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogWellEvent.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogWellEvent.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Comment:");
        this.jComboBoxDiscipline.setModel(this.comboModelDiscipline);
        this.jLabel4.setText("Discipline: ");
        this.jLabel5.setText("Analyst: ");
        this.jTextFieldAnalyst.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogWellEvent.this.jTextFieldAnalystKeyTyped(evt);
            }
        });
        this.jButtonAnalyst.setText("...");
        this.jButtonAnalyst.setToolTipText("Select analyst");
        this.jButtonAnalyst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogWellEvent.this.jButtonAnalystActionPerformed(evt);
            }
        });
        this.jTextFieldQual.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogWellEvent.this.jTextFieldQualKeyTyped(evt);
            }
        });
        this.jTextFieldSource.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogWellEvent.this.jTextFieldSourceKeyTyped(evt);
            }
        });
        this.jTextFieldCompany.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogWellEvent.this.jTextFieldCompanyKeyTyped(evt);
            }
        });
        this.jLabel6.setText("Qualifier:");
        this.jLabel7.setText("Source:");
        this.jLabel8.setText("Company:");
        this.jTextAreaComment.setColumns(20);
        this.jTextAreaComment.setFont(new Font("Tahoma", 0, 13));
        this.jTextAreaComment.setLineWrap(true);
        this.jTextAreaComment.setRows(3);
        this.jTextAreaComment.setWrapStyleWord(true);
        this.jTextAreaComment.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogWellEvent.this.jTextAreaCommentKeyTyped(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTextAreaComment);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jSeparator1, -1, 370, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabel2).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jTextFieldDepth, -1, 263, Short.MAX_VALUE).add((Component)this.jTextFieldEventName, -1, 263, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jButtonEvent, -2, 28, -2).add((Component)this.jButtonSample, -2, 27, -2))).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel4).addPreferredGap(0).add((Component)this.jComboBoxDiscipline, -2, 169, -2).add(19, 19, 19).add((Component)this.jLabel5).addPreferredGap(0).add((Component)this.jTextFieldAnalyst, -1, 47, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jButtonAnalyst, -2, 28, -2)).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabel7).add((Component)this.jLabel6).add((Component)this.jLabel3)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 317, Short.MAX_VALUE).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jTextFieldSource, -1, 107, Short.MAX_VALUE).addPreferredGap(1).add((Component)this.jLabel8).addPreferredGap(0).add((Component)this.jTextFieldCompany, -2, 147, -2)).add((Component)this.jTextFieldQual, -2, 149, -2))).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jButtonSample).add((Component)this.jTextFieldDepth, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jButtonEvent).add((Component)this.jTextFieldEventName, -2, -1, -2)).addPreferredGap(1).add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.jComboBoxDiscipline, -2, -1, -2).add((Component)this.jButtonAnalyst).add((Component)this.jLabel5).add((Component)this.jTextFieldAnalyst, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel3).add((Component)this.jScrollPane1, -2, 66, -2)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jTextFieldQual, -2, -1, -2).add((Component)this.jLabel6)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jTextFieldSource, -2, -1, -2).add((Component)this.jLabel7).add((Component)this.jTextFieldCompany, -2, -1, -2).add((Component)this.jLabel8)).addPreferredGap(1).add((Component)this.jSeparator1, -2, 12, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonHelp).add((Component)this.jButtonOK)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jTextFieldAnalystKeyTyped(KeyEvent evt) {
        if (SB.uCaseField((JTextField)this.jTextFieldAnalyst, (int)5, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonEventActionPerformed(ActionEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            DialogSelectEvent dialog = new DialogSelectEvent(this, true, this.db, this.event, null);
            dialog.setLocationRelativeTo(this);
            this.setCursor(Cursor.getDefaultCursor());
            dialog.setVisible(true);
            if (dialog.selection != null) {
                this.event = dialog.selection;
                this.jTextFieldEventName.setText(this.event.toString());
                this.setEventType();
                Taxon t = this.event.getTaxon();
                if (t != null) {
                    char discID = t.getDisc().getChar();
                    this.jComboBoxDiscipline.setSelectedItem(SBdb.getDiscNoun((char)discID));
                }
            }
        }
        catch (SBException e) {
            SB.showStackError((String)"Error opening Select Event dialog", (Exception)((Object)e));
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("Error opening Select Event dialog", sql, this.db);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jButtonSampleActionPerformed(ActionEvent evt) {
        DialogSelectSample dialog;
        try {
            dialog = new DialogSelectSample(this, true, this.db, this.well, this.sample, this.units, false);
        }
        catch (SBException ex) {
            SB.showStackError((String)"Error opening dialog", (Exception)((Object)ex));
            return;
        }
        catch (SQLException ex) {
            FrameJsbugs.showStackError("Error opening dialog", ex, this.db);
            return;
        }
        dialog.setLocation(this.jButtonSample.getLocationOnScreen());
        dialog.setVisible(true);
        if (dialog.isOK) {
            this.sample = dialog.selection;
            this.jTextFieldDepth.setText(this.sample.toString(this.units));
        }
    }

    private void jTextFieldDepthFocusGained(FocusEvent evt) {
        this.jTextFieldDepth.setSelectionStart(0);
        this.jTextFieldDepth.setSelectionEnd(this.jTextFieldDepth.getText().length());
    }

    private void jTextFieldEventNameKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldEventName, (int)100, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        String analyst;
        String comment;
        String company;
        String source;
        String qualifier;
        Discipline discID;
        block14: {
            if (this.buttonGroupType.getSelection() == null) {
                JOptionPane.showMessageDialog(this, "Select an event type", this.getTitle(), 0);
                return;
            }
            if (this.event == null) {
                JOptionPane.showMessageDialog(this, "Select an event", this.getTitle(), 0);
                return;
            }
            if (this.sample == null) {
                JOptionPane.showMessageDialog(this, "Select a sample", this.getTitle(), 0);
                return;
            }
            discID = null;
            if (this.jComboBoxDiscipline.getSelectedIndex() != 0) {
                discID = (Discipline)this.jComboBoxDiscipline.getSelectedItem();
            }
            qualifier = this.jTextFieldQual.getText();
            source = this.jTextFieldSource.getText();
            company = this.jTextFieldCompany.getText();
            comment = this.jTextAreaComment.getText();
            this.eventType = this.jRadioButtonTop.isSelected() ? SBEvent.EventType.TOP : (this.jRadioButtonBase.isSelected() ? SBEvent.EventType.BASE : SBEvent.EventType.SINGLE);
            analyst = this.jTextFieldAnalyst.getText();
            if (analyst != null && analyst.length() > 0) {
                try {
                    if (this.db.getUser(analyst) == null) {
                        JOptionPane.showMessageDialog(this, "Analyst not recognised.", this.getTitle(), 0);
                        return;
                    }
                    break block14;
                }
                catch (SQLException sql) {
                    FrameJsbugs.showStackError("Error checking analyst", sql, this.db);
                    return;
                }
            }
            analyst = null;
        }
        try {
            if (this.wellEvent != null) {
                WellEvent.Builder builder = new WellEvent.Builder().event(this.event).sample(this.sample).type(this.eventType);
                builder.analyst(this.db.getUserID(analyst)).qualifier(qualifier).source(source).comments(comment).company(company).audit(this.wellEvent.getAudit()).discID(discID);
                this.wellInterp.updateEvent(this.wellEvent, builder, this.well.getWellID());
            } else {
                this.wellEvent = this.wellInterp.addEvent(this.well, this.sample, this.event, this.eventType, discID, analyst, comment, qualifier, source, company);
            }
            this.db.commit();
            this.wellInterp.notifyObservers((Object)this.wellEvent);
            this.dispose();
        }
        catch (InvalidFieldException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Cannot save event", 2);
        }
        catch (SQLException e) {
            FrameJsbugs.showStackError("Error saving event", e, this.db);
            this.db.doRollback();
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error saving event", (Exception)((Object)sbe));
            this.db.doRollback();
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonAnalystActionPerformed(ActionEvent evt) {
        DialogSelectAnalyst dialog;
        try {
            dialog = new DialogSelectAnalyst(this, true, this.db);
        }
        catch (SQLException ex) {
            FrameJsbugs.showStackError("Error getting analyst", ex, this.db);
            return;
        }
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.selectedUser != null) {
            this.jTextFieldAnalyst.setText(dialog.selectedUser.getAbr());
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogwellevent.html");
    }

    private void jTextAreaCommentKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextArea)this.jTextAreaComment, (int)240, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldQualKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldQual, (int)16, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldSourceKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldSource, (int)5, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldCompanyKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldCompany, (int)20, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    void setSmpdtl(char discID, String analyst) {
        this.jComboBoxDiscipline.setSelectedItem(SBdb.getDiscNoun((char)discID));
        this.jTextFieldAnalyst.setText(analyst);
    }
}

