/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import jsbugs.DialogList;
import jsbugs.DialogLogDef;
import jsbugs.FrameJsbugs;
import jsbugs.PanelWirelineLog;
import jsbugs.PanelWirelineLogProperties;
import jsbugs.SBDialog;
import jsbugs.WellBlock;
import model2.Curve;
import model2.Curves;
import model2.LogDef;
import model2.SBdb;
import util.SB;

public class DialogWirelineLogPanel
extends SBDialog {
    PanelWirelineLog panel;
    PanelWirelineLogProperties p;
    DefaultListModel model = new DefaultListModel();
    DefaultComboBoxModel gridModel = new DefaultComboBoxModel();
    WellBlock block;
    SBdb db;
    private JButton jButtonAddTrace;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonMoveDown;
    private JButton jButtonMoveUp;
    private JButton jButtonOK;
    private JButton jButtonProps;
    private JButton jButtonRemoveTrace;
    private JCheckBox jCheckBoxDepthGuides;
    private JCheckBox jCheckBoxShowLith;
    private JCheckBox jCheckBoxVertGrid;
    private JComboBox jComboBoxVertGrid;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabelUnits;
    private JLabel jLabelUnits2;
    private JList jListTraces;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JTextField jTextFieldDepthGuides;
    private JTextField jTextFieldPanelWidth;
    private JTextField jTextFieldShift;

    public DialogWirelineLogPanel(Dialog parent, boolean modal, PanelWirelineLog panel, WellBlock block, SBdb db) {
        super(parent, modal);
        this.panel = panel;
        this.block = block;
        this.db = db;
        this.initComponents();
        this.init();
    }

    public DialogWirelineLogPanel(Frame parent, boolean modal, PanelWirelineLog panel, WellBlock block, SBdb db) {
        super(parent, modal);
        this.panel = panel;
        this.block = block;
        this.db = db;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setTitle("Wireline Log Panel Properties");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.p = new PanelWirelineLogProperties(this.panel.getProperties());
        this.jTextFieldPanelWidth.setText("" + this.p.columnWidth);
        this.jTextFieldShift.setText("" + this.p.logShift);
        this.jCheckBoxDepthGuides.setSelected(this.p.drawDepthGuides);
        this.jTextFieldDepthGuides.setEnabled(this.p.drawDepthGuides);
        this.jTextFieldDepthGuides.setText("" + this.p.depthGuideInterval);
        this.jCheckBoxVertGrid.setSelected(this.p.drawVerticalGrid);
        this.jComboBoxVertGrid.setEnabled(this.p.drawVerticalGrid);
        this.jCheckBoxShowLith.setSelected(this.p.drawLithology);
        this.jLabelUnits.setText(this.block.prop.units == 'M' ? "m" : "ft");
        this.jLabelUnits2.setText(this.block.prop.units == 'M' ? "m" : "ft");
        this.refreshList();
    }

    private void refreshList() {
        this.gridModel.removeAllElements();
        this.model.clear();
        for (LogDef def : this.p.defs.values()) {
            String string = def.getAbr();
            this.gridModel.addElement(string);
            string = string + " - " + def.getTitle();
            int nCurves = 0;
            double topDepth = 0.0;
            double baseDepth = 0.0;
            try {
                for (Curve curve : this.panel.getTraces()) {
                    if (!curve.getAbr().equals(def.getAbr())) continue;
                    if (nCurves == 0) {
                        topDepth = curve.getTopDepth();
                        baseDepth = curve.getBaseDepth();
                    } else {
                        if (curve.getBaseDepth() > baseDepth) {
                            baseDepth = curve.getBaseDepth();
                        }
                        if (curve.getTopDepth() < topDepth) {
                            topDepth = curve.getTopDepth();
                        }
                    }
                    ++nCurves;
                }
            }
            catch (SQLException sql) {
                sql.printStackTrace();
            }
            string = string + "  (" + nCurves + (nCurves == 1 ? " trace, " : " traces, ") + SB.getDepthString((double)topDepth, (char)this.block.prop.units, (int)2) + " - " + SB.getDepthString((double)baseDepth, (char)this.block.prop.units, (int)2) + ")";
            this.model.addElement(string);
        }
        this.jListTraces.repaint();
        this.jComboBoxVertGrid.repaint();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jListTraces = new JList();
        this.jLabel1 = new JLabel();
        this.jButtonAddTrace = new JButton();
        this.jButtonRemoveTrace = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonOK = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jTextFieldPanelWidth = new JTextField();
        this.jLabel2 = new JLabel();
        this.jCheckBoxDepthGuides = new JCheckBox();
        this.jTextFieldDepthGuides = new JTextField();
        this.jTextFieldShift = new JTextField();
        this.jLabel3 = new JLabel();
        this.jButtonProps = new JButton();
        this.jButtonMoveUp = new JButton();
        this.jButtonMoveDown = new JButton();
        this.jLabel4 = new JLabel();
        this.jComboBoxVertGrid = new JComboBox();
        this.jLabel5 = new JLabel();
        this.jLabelUnits = new JLabel();
        this.jCheckBoxVertGrid = new JCheckBox();
        this.jLabelUnits2 = new JLabel();
        this.jCheckBoxShowLith = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(500, 380));
        this.jListTraces.setModel(this.model);
        this.jListTraces.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.jListTraces);
        this.jLabel1.setText("Traces:");
        this.jButtonAddTrace.setText("Add..");
        this.jButtonAddTrace.setToolTipText("Select additional traces");
        this.jButtonAddTrace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogWirelineLogPanel.this.jButtonAddTraceActionPerformed(evt);
            }
        });
        this.jButtonRemoveTrace.setText("Remove");
        this.jButtonRemoveTrace.setToolTipText("Remove selected trace from panel");
        this.jButtonRemoveTrace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogWirelineLogPanel.this.jButtonRemoveTraceActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogWirelineLogPanel.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogWirelineLogPanel.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogWirelineLogPanel.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jTextFieldPanelWidth.setText("40");
        this.jTextFieldPanelWidth.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogWirelineLogPanel.this.jTextFieldPanelWidthKeyTyped(evt);
            }
        });
        this.jLabel2.setText("Panel width:");
        this.jCheckBoxDepthGuides.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogWirelineLogPanel.this.jCheckBoxDepthGuidesActionPerformed(evt);
            }
        });
        this.jTextFieldShift.setText("0.00");
        this.jTextFieldShift.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogWirelineLogPanel.this.jTextFieldShiftKeyTyped(evt);
            }
        });
        this.jLabel3.setText("Depth shift:");
        this.jButtonProps.setText("Properties...");
        this.jButtonProps.setToolTipText("Edit properties of selected trace");
        this.jButtonProps.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonProps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogWirelineLogPanel.this.jButtonPropsActionPerformed(evt);
            }
        });
        this.jButtonMoveUp.setText("Move up");
        this.jButtonMoveUp.setToolTipText("<html>Move selected trace up list<br>\n(top trace is plotted first)</html>");
        this.jButtonMoveUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogWirelineLogPanel.this.jButtonMoveUpActionPerformed(evt);
            }
        });
        this.jButtonMoveDown.setText("Move down");
        this.jButtonMoveDown.setToolTipText("<html>Move selected trace up list<br>\n(top trace is plotted first)</html>");
        this.jButtonMoveDown.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonMoveDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogWirelineLogPanel.this.jButtonMoveDownActionPerformed(evt);
            }
        });
        this.jLabel4.setText("Depth guides every:");
        this.jComboBoxVertGrid.setModel(this.gridModel);
        this.jLabel5.setText("Vertical grid based on:");
        this.jLabelUnits.setText("m");
        this.jCheckBoxVertGrid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogWirelineLogPanel.this.jCheckBoxVertGridActionPerformed(evt);
            }
        });
        this.jLabelUnits2.setText("m");
        this.jCheckBoxShowLith.setText("Show lithology");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1, GroupLayout.Alignment.TRAILING, -1, 446, Short.MAX_VALUE).addComponent(this.jLabel1).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(4, 4, 4).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel4).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jComboBoxVertGrid, 0, -1, Short.MAX_VALUE).addComponent(this.jTextFieldPanelWidth).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jTextFieldShift, GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldDepthGuides, GroupLayout.Alignment.LEADING, -1, 61, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelUnits2).addComponent(this.jLabelUnits)))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxDepthGuides).addComponent(this.jCheckBoxVertGrid)).addGap(144, 144, 144)).addComponent(this.jCheckBoxShowLith)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(2, 2, 2).addComponent(this.jScrollPane1, -1, 348, Short.MAX_VALUE).addGap(11, 11, 11))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jButtonAddTrace, -1, 85, Short.MAX_VALUE).addComponent(this.jButtonRemoveTrace, -1, 85, Short.MAX_VALUE).addComponent(this.jButtonProps, -1, 85, Short.MAX_VALUE).addComponent(this.jButtonMoveUp, -2, 85, -2).addComponent(this.jButtonMoveDown, GroupLayout.Alignment.LEADING, -1, 85, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel))).addContainerGap()));
        layout.linkSize(0, this.jButtonCancel, this.jButtonHelp, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldPanelWidth, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.jCheckBoxShowLith)).addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldDepthGuides, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.jLabelUnits)).addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldShift, -2, -1, -2).addComponent(this.jLabel3).addComponent(this.jLabelUnits2))).addComponent(this.jCheckBoxDepthGuides)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jComboBoxVertGrid, -2, -1, -2)).addGap(16, 16, 16).addComponent(this.jLabel1)).addComponent(this.jCheckBoxVertGrid)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jButtonAddTrace).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonRemoveTrace).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonMoveUp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonMoveDown).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonProps)).addComponent(this.jScrollPane1, -1, 140, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, 12, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonHelp).addComponent(this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonPropsActionPerformed(ActionEvent evt) {
        if (this.jListTraces.getSelectedIndex() < 0) {
            JOptionPane.showMessageDialog(this, "Select a trace", this.getTitle(), 1);
            return;
        }
        String selection = (String)this.jListTraces.getSelectedValue();
        String abr = selection.substring(0, selection.indexOf(45)).trim();
        LogDef def = this.p.defs.get(abr);
        if (def != null) {
            DialogLogDef dialog = new DialogLogDef((Dialog)this, true, def, null);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.p.setColumnWidth(Float.parseFloat(this.jTextFieldPanelWidth.getText()));
        String shiftString = this.jTextFieldShift.getText().trim();
        if (!shiftString.isEmpty()) {
            this.p.setShift(SB.convToM((double)Double.parseDouble(this.jTextFieldShift.getText()), (char)this.block.prop.units));
        } else {
            this.p.setShift(0.0);
        }
        this.p.drawDepthGuides = this.jCheckBoxDepthGuides.isSelected();
        this.p.depthGuideInterval = (int)SB.convToM((double)Double.parseDouble(this.jTextFieldDepthGuides.getText()), (char)this.block.prop.units);
        this.p.drawVerticalGrid = this.jCheckBoxVertGrid.isSelected();
        this.p.setGridAbr((String)this.jComboBoxVertGrid.getSelectedItem());
        this.p.drawLithology = this.jCheckBoxShowLith.isSelected();
        this.panel.setProperties(this.p);
        this.setOK();
    }

    private void jTextFieldPanelWidthKeyTyped(KeyEvent evt) {
        if (evt.getKeyChar() == '-') {
            this.getToolkit().beep();
            evt.consume();
            return;
        }
        if (SB.intFieldVal((JTextField)this.jTextFieldPanelWidth, (int)3, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonRemoveTraceActionPerformed(ActionEvent evt) {
        int index = this.jListTraces.getSelectedIndex();
        if (index < 0) {
            this.getToolkit().beep();
            return;
        }
        String selection = (String)this.jListTraces.getSelectedValue();
        String abr = selection.substring(0, selection.indexOf(45)).trim();
        this.p.defs.remove(abr);
        this.refreshList();
    }

    private void jButtonMoveUpActionPerformed(ActionEvent evt) {
        int index = this.jListTraces.getSelectedIndex();
        if (index <= 0) {
            this.getToolkit().beep();
            return;
        }
        this.movePanel(true, index);
    }

    private void jButtonMoveDownActionPerformed(ActionEvent evt) {
        int index = this.jListTraces.getSelectedIndex();
        if (index < 0 || index == this.model.getSize() - 1) {
            this.getToolkit().beep();
            return;
        }
        this.movePanel(false, index);
    }

    private void jButtonAddTraceActionPerformed(ActionEvent evt) {
        try {
            Curves curves = this.block.well.getCurves();
            List curveList = curves.getCurves();
            HashMap logList = new HashMap();
            for (Curve curve : curveList) {
                logList.put(curve.getAbr(), this.db.getLogDef().get(curve.getAbr()));
            }
            if (logList.size() == this.model.size()) {
                JOptionPane.showMessageDialog(this, "All traces are already displayed", "Add traces", 1);
                return;
            }
            logList = new HashMap();
            for (Curve curve : curveList) {
                if (this.p.defs.containsKey(curve.getAbr())) continue;
                logList.put(curve.getAbr(), this.db.getLogDef().get(curve.getAbr()));
            }
            LinkedList<String> stringList = new LinkedList<String>();
            for (LogDef def : logList.values()) {
                stringList.add(def.getAbr() + " - " + def.getTitle());
            }
            DialogList dialog = new DialogList(this, true, "Select trace", this.db, stringList, true, false);
            dialog.setVisible(true);
            if (dialog.selection != null) {
                String abr = ((String)dialog.selection).substring(0, ((String)dialog.selection).indexOf(45) - 1);
                for (Curve trace : curveList) {
                    if (!trace.getAbr().equals(abr)) continue;
                    Curve newTrace = new Curve(trace);
                    this.panel.getTraces().add(newTrace);
                }
                LogDef newDef = new LogDef((LogDef)this.db.getLogDef().get(abr));
                this.p.defs.put(abr, newDef);
            }
            this.refreshList();
        }
        catch (SQLException sql) {
            sql.printStackTrace();
        }
    }

    private void jTextFieldShiftKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldShift, (int)5, (KeyEvent)evt, (boolean)true)) {
            this.getToolkit().beep();
        }
    }

    private void jCheckBoxDepthGuidesActionPerformed(ActionEvent evt) {
        this.jTextFieldDepthGuides.setEnabled(this.jCheckBoxDepthGuides.isSelected());
    }

    private void jCheckBoxVertGridActionPerformed(ActionEvent evt) {
        this.jComboBoxVertGrid.setEnabled(this.jCheckBoxVertGrid.isSelected());
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogwirelinelogpanel.html");
    }

    private void movePanel(boolean up, int index) {
        String item = this.model.get(index).toString();
        this.model.remove(index);
        this.model.add(up ? index - 1 : index + 1, item);
        for (int i = 0; i < this.model.size(); ++i) {
            String strg = this.model.get(i).toString();
            String abr = strg.substring(0, strg.indexOf(45)).trim();
            this.p.defs.get(abr);
        }
        this.refreshList();
    }
}

