/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import javax.swing.table.AbstractTableModel;
import model2.EnvScheme;

class EnvSchemeTableModel
extends AbstractTableModel {
    EnvScheme scheme;
    static String[] colTitles = new String[]{"Environment", "Colour"};
    static int[] colWidths = new int[]{80, 20};
    static final int COL_ENV = 0;
    static final int COL_COLOUR = 1;

    EnvSchemeTableModel() {
    }

    @Override
    public int getColumnCount() {
        return colTitles.length;
    }

    @Override
    public int getRowCount() {
        if (this.scheme == null) {
            return 0;
        }
        return this.scheme.getNClasses();
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row < this.scheme.getNClasses()) {
            switch (col) {
                case 0: {
                    return this.scheme.getTerm(row + 1);
                }
                case 1: {
                    return this.scheme.getColour(row + 1);
                }
            }
            return "";
        }
        return "";
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
        try {
            switch (col) {
                case 0: {
                    this.scheme.setTerm(row + 1, (String)obj);
                    break;
                }
                case 1: {
                    this.scheme.setColour(row + 1, (Color)obj);
                    break;
                }
            }
        }
        catch (Exception pe) {
            System.out.println("Exception setting env table row: " + pe.getMessage());
            pe.printStackTrace();
        }
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Color.class;
            }
        }
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            default: {
                return false;
            }
            case 0: 
            case 1: 
        }
        return true;
    }
}

