/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.util.Date;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import jsbugs.TableModelSB;
import model2.EnvScheme;
import model2.IGDIntervalEnv;
import model2.SBdb;
import util.ColorRenderer;

public class EnvTableModel
extends TableModelSB {
    char units = (char)77;
    List<IGDIntervalEnv> envs = null;
    static String[] columnTitles = new String[]{"Top Sample", "Base Sample", "Scheme", "Palaeoenvironment", "Proximal", "Distal", "Mod. By", "Modified"};
    private static final int[] defaultColumnWidths = new int[]{55, 55, 30, 100, 15, 15, 20, 20};
    static final int COL_TOP = 0;
    static final int COL_BASE = 1;
    static final int COL_SCHEME = 2;
    static final int COL_ENV = 3;
    static final int COL_PCOLOUR = 4;
    static final int COL_DCOLOUR = 5;
    static final int COL_MODIFIER = 6;
    static final int COL_MODIFIED = 7;

    @Override
    public int getColumnCount() {
        return columnTitles.length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        IGDIntervalEnv env = this.envs.get(row);
        switch (col) {
            case 0: {
                return env.getTopSample().toString(this.units, false, false, true);
            }
            case 1: {
                if (env.getBaseSample() != null) {
                    return env.getBaseSample().toString(this.units, false, false, true);
                }
                return "";
            }
            case 2: {
                EnvScheme envScheme = env.getScheme();
                if (envScheme != null) {
                    return envScheme.toString();
                }
                return "";
            }
            case 3: {
                return env.toString();
            }
            case 4: {
                return env.getColour();
            }
            case 5: {
                return env.getColourDistal();
            }
            case 7: {
                return env.getModified();
            }
            case 6: {
                return env.getModifierAbr();
            }
        }
        return null;
    }

    @Override
    public int getRowCount() {
        if (this.envs == null) {
            return 0;
        }
        return this.envs.size();
    }

    public Class getColumnClass(int col) {
        switch (col) {
            default: {
                return String.class;
            }
            case 7: {
                return Date.class;
            }
            case 4: 
            case 5: 
        }
        return Color.class;
    }

    public void setupTable(JTable jTableEnv, SBdb sbdb) {
        this.init(jTableEnv, sbdb);
        jTableEnv.setDefaultRenderer(Color.class, (TableCellRenderer)new ColorRenderer(true));
    }

    @Override
    String[] getColumnTitles() {
        return columnTitles;
    }

    @Override
    int[] getDefaultColumnWidths() {
        return defaultColumnWidths;
    }

    @Override
    String getPrefString() {
        return "TMENVIRONM";
    }

    @Override
    String getPrefOrderString() {
        return "TOENVIRONM";
    }

    @Override
    final String getAutoResizeString() {
        return "TARENVIRO";
    }
}

